/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.lexer.api.CSSTokenId;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.gsf.api.BracketCompletion;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssBracketCompleter
implements BracketCompletion {
    private static final char[][] PAIRS = new char[][]{{'{', '}'}, {'\"', '\"'}, {'\'', '\''}};
    private char justAddedPair;

    private int pairIndex(char c) {
        for (int i = 0; i < PAIRS.length; ++i) {
            char c2 = PAIRS[i][0];
            if (c2 != c) continue;
            return i;
        }
        return -1;
    }

    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence tokenSequence;
        Caret caret = jTextComponent.getCaret();
        if (this.justAddedPair == c) {
            this.justAddedPair = '\u0000';
            caret.setDot(n + 1);
            return true;
        }
        this.justAddedPair = '\u0000';
        int n2 = this.pairIndex(c);
        if (n2 == -1) {
            return false;
        }
        if (jTextComponent.getSelectionStart() != n) {
            return false;
        }
        if ((c == '\'' || c == '\"') && (tokenSequence = LexerUtils.getCssTokenSequence(document, n)) != null) {
            Token token;
            int n3 = tokenSequence.move(n);
            if (tokenSequence.moveNext() && (token = tokenSequence.token()).id() == CSSTokenId.STRING) {
                char c2 = token.text().charAt(n3);
                if (c2 == c) {
                    caret.setDot(n + 1);
                    return true;
                }
                return false;
            }
            tokenSequence.move(n);
            while (tokenSequence.movePrevious()) {
                token = tokenSequence.token();
                if (token.text().charAt(0) == c) {
                    if (token.id() == CSSTokenId.STRING || token.id() == CSSTokenId.STRING1 || token.id() == CSSTokenId.STRING2) break;
                    return false;
                }
                if (token.id() != CSSTokenId.LBRACE && token.id() != CSSTokenId.RBRACE && token.id() != CSSTokenId.SEMICOLON) continue;
                break;
            }
        }
        this.justAddedPair = PAIRS[n2][1];
        document.insertString(n, String.valueOf(PAIRS[n2][0]), null);
        document.insertString(n + 1, String.valueOf(this.justAddedPair), null);
        caret.setDot(n + 1);
        return true;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        if (n == 0 || n == document.getLength()) {
            return -1;
        }
        String string = document.getText(n - 1, 2);
        if ("{}".equals(string)) {
            Reformat reformat = Reformat.get((Document)document);
            BaseDocument baseDocument = (BaseDocument)document;
            reformat.lock();
            try {
                baseDocument.atomicLock();
                document.insertString(n, "\n", null);
                jTextComponent.getCaret().setDot(n);
                try {
                    reformat.reformat(n - 1, n + 2);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            finally {
                reformat.unlock();
            }
        }
        return -1;
    }

    public OffsetRange findMatching(Document document, int n) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(CompilationInfo compilationInfo, int n) {
        return Collections.emptyList();
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        return -1;
    }
}

