/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.spi.DefaultError;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssAnalyser {
    private static final String UNKNOWN_PROPERTY = "unknown_property";
    private CSSParserResult result;

    public CssAnalyser(CSSParserResult cSSParserResult) {
        this.result = cSSParserResult;
    }

    public List<Error> checkForErrors(SimpleNode simpleNode) {
        final ArrayList<Error> arrayList = new ArrayList<Error>();
        final PropertyModel propertyModel = PropertyModel.instance();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                String string;
                if (simpleNode.kind() == 17 && !CssAnalyser.isVendorSpecificProperty(string = simpleNode.image().trim()) && propertyModel.getProperty(string) == null) {
                    DefaultError defaultError = new DefaultError(CssAnalyser.UNKNOWN_PROPERTY, NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.UNKNOWN_PROPERTY, (Object)string), null, CssAnalyser.this.result.getFile().getFileObject(), simpleNode.startOffset(), simpleNode.endOffset(), Severity.WARNING);
                    arrayList.add(defaultError);
                }
            }
        };
        SimpleNodeUtil.visitChildren(simpleNode, nodeVisitor);
        return arrayList;
    }

    public static boolean isVendorSpecificProperty(String string) {
        return string.startsWith("_") || string.startsWith("-");
    }
}

