/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.css.editor.model.CssRule;

public final class CssRuleItem {
    Item key;
    Item value;
    private Position colon_offset = null;
    private Position semicolon_offset = null;

    public CssRuleItem(String string, int n, String string2, int n2) throws BadLocationException {
        this(null, string, n, string2, n2, -1, -1);
    }

    CssRuleItem(Document document, String string, int n, String string2, int n2, int n3, int n4) throws BadLocationException {
        this.key = new Item(document, string, n);
        this.value = new Item(document, string2, n2);
        this.colon_offset = document == null ? new CssRule.SimplePosition(n3) : document.createPosition(n3);
        this.semicolon_offset = document == null ? new CssRule.SimplePosition(n4) : document.createPosition(n4);
    }

    public Item key() {
        return this.key;
    }

    public Item value() {
        return this.value;
    }

    public String toString() {
        return "CssRuleItem[" + this.key + "; " + this.value + "]";
    }

    public int colonOffset() {
        return this.colon_offset.getOffset();
    }

    public int semicolonOffset() {
        return this.semicolon_offset.getOffset();
    }

    public boolean equals(Object object) {
        if (object instanceof CssRuleItem) {
            CssRuleItem cssRuleItem = (CssRuleItem)object;
            return this.key().equals(cssRuleItem.key()) && this.value().equals(cssRuleItem.value());
        }
        return false;
    }

    public static final class Item {
        private String name;
        private Position offset = null;

        Item(String string, int n) throws BadLocationException {
            this(null, string, n);
        }

        Item(Document document, String string, int n) throws BadLocationException {
            this.name = string;
            this.offset = document == null ? new CssRule.SimplePosition(n) : document.createPosition(n);
        }

        public String name() {
            return this.name;
        }

        public int offset() {
            return this.offset != null ? this.offset.getOffset() : -1;
        }

        public String toString() {
            return "Item[" + this.name + "; " + this.offset.getOffset() + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                Item item = (Item)object;
                return this.name().equals(item.name()) && this.offset() == item.offset();
            }
            return false;
        }
    }
}

