/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.RequiredProjectsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.CompilerSetNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.RequiredProjectsNodeProp;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class MakeConfiguration
extends Configuration {
    public static final String MAKEFILE_IMPL = "Makefile-impl.mk";
    public static final String BUILD_FOLDER = "build";
    public static final String DIST_FOLDER = "dist";
    public static final String EXT_FOLDER = "_ext";
    public static final String OBJECTDIR_MACRO_NAME = "OBJECTDIR";
    public static final String OBJECTDIR_MACRO = "${OBJECTDIR}";
    private static String[] TYPE_NAMES = new String[]{MakeConfiguration.getString("MakefileName"), MakeConfiguration.getString("ApplicationName"), MakeConfiguration.getString("DynamicLibraryName"), MakeConfiguration.getString("StaticLibraryName")};
    public static final int TYPE_MAKEFILE = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    private IntConfiguration configurationType;
    private MakefileConfiguration makefileConfiguration;
    private CompilerSet2Configuration compilerSet;
    private LanguageBooleanConfiguration cRequired;
    private LanguageBooleanConfiguration cppRequired;
    private LanguageBooleanConfiguration fortranRequired;
    private IntConfiguration platform;
    private BooleanConfiguration dependencyChecking;
    private CCompilerConfiguration cCompilerConfiguration;
    private CCCompilerConfiguration ccCompilerConfiguration;
    private FortranCompilerConfiguration fortranCompilerConfiguration;
    private LinkerConfiguration linkerConfiguration;
    private ArchiverConfiguration archiverConfiguration;
    private RequiredProjectsConfiguration requiredProjectsConfiguration;
    private boolean languagesDirty = true;

    public MakeConfiguration(MakeConfigurationDescriptor makeConfigurationDescriptor, String string, int n) {
        this(makeConfigurationDescriptor.getBaseDir(), string, n);
    }

    public MakeConfiguration(String string, String string2, int n) {
        super(string, string2);
        this.configurationType = new IntConfiguration(null, n, TYPE_NAMES, null);
        this.compilerSet = new CompilerSet2Configuration();
        this.cRequired = new LanguageBooleanConfiguration();
        this.cppRequired = new LanguageBooleanConfiguration();
        this.fortranRequired = new LanguageBooleanConfiguration();
        this.platform = new IntConfiguration(null, MakeOptions.getInstance().getPlatform(), Platforms.getPlatformDisplayNames(), null);
        this.makefileConfiguration = new MakefileConfiguration(this);
        this.dependencyChecking = new BooleanConfiguration(null, this.isMakefileConfiguration() ? false : MakeOptions.getInstance().getDepencyChecking());
        this.cCompilerConfiguration = new CCompilerConfiguration(string, null);
        this.ccCompilerConfiguration = new CCCompilerConfiguration(string, null);
        this.fortranCompilerConfiguration = new FortranCompilerConfiguration(string, null);
        this.linkerConfiguration = new LinkerConfiguration(this);
        this.archiverConfiguration = new ArchiverConfiguration(this);
        this.requiredProjectsConfiguration = new RequiredProjectsConfiguration();
    }

    public void setMakefileConfiguration(MakefileConfiguration makefileConfiguration) {
        this.makefileConfiguration = makefileConfiguration;
    }

    public MakefileConfiguration getMakefileConfiguration() {
        return this.makefileConfiguration;
    }

    public IntConfiguration getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(IntConfiguration intConfiguration) {
        this.configurationType = intConfiguration;
    }

    public BooleanConfiguration getDependencyChecking() {
        return this.dependencyChecking;
    }

    public void setDependencyChecking(BooleanConfiguration booleanConfiguration) {
        this.dependencyChecking = booleanConfiguration;
    }

    public CompilerSet2Configuration getCompilerSet() {
        return this.compilerSet;
    }

    public void setCompilerSet(CompilerSet2Configuration compilerSet2Configuration) {
        this.compilerSet = compilerSet2Configuration;
    }

    public LanguageBooleanConfiguration getCRequired() {
        return this.cRequired;
    }

    public LanguageBooleanConfiguration getCppRequired() {
        return this.cppRequired;
    }

    public LanguageBooleanConfiguration getFortranRequired() {
        return this.fortranRequired;
    }

    public void setCRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.cRequired = languageBooleanConfiguration;
    }

    public void setCppRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.cppRequired = languageBooleanConfiguration;
    }

    public void setFortranRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.fortranRequired = languageBooleanConfiguration;
    }

    public IntConfiguration getPlatform() {
        return this.platform;
    }

    public void setPlatform(IntConfiguration intConfiguration) {
        this.platform = intConfiguration;
    }

    public boolean isApplicationConfiguration() {
        return this.getConfigurationType().getValue() == 1;
    }

    public boolean isCompileConfiguration() {
        return this.getConfigurationType().getValue() == 1 || this.getConfigurationType().getValue() == 2 || this.getConfigurationType().getValue() == 3;
    }

    public boolean isLibraryConfiguration() {
        return this.getConfigurationType().getValue() == 2 || this.getConfigurationType().getValue() == 3;
    }

    public boolean isLinkerConfiguration() {
        return this.getConfigurationType().getValue() == 1 || this.getConfigurationType().getValue() == 2;
    }

    public boolean isMakefileConfiguration() {
        return this.getConfigurationType().getValue() == 0;
    }

    public boolean isDynamicLibraryConfiguration() {
        return this.getConfigurationType().getValue() == 2;
    }

    public boolean isArchiverConfiguration() {
        return this.getConfigurationType().getValue() == 3;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.cCompilerConfiguration = cCompilerConfiguration;
    }

    public CCompilerConfiguration getCCompilerConfiguration() {
        return this.cCompilerConfiguration;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration cCCompilerConfiguration) {
        this.ccCompilerConfiguration = cCCompilerConfiguration;
    }

    public CCCompilerConfiguration getCCCompilerConfiguration() {
        return this.ccCompilerConfiguration;
    }

    public void setFortranCompilerConfiguration(FortranCompilerConfiguration fortranCompilerConfiguration) {
        this.fortranCompilerConfiguration = fortranCompilerConfiguration;
    }

    public FortranCompilerConfiguration getFortranCompilerConfiguration() {
        return this.fortranCompilerConfiguration;
    }

    public void setLinkerConfiguration(LinkerConfiguration linkerConfiguration) {
        this.linkerConfiguration = linkerConfiguration;
    }

    public LinkerConfiguration getLinkerConfiguration() {
        return this.linkerConfiguration;
    }

    public void setArchiverConfiguration(ArchiverConfiguration archiverConfiguration) {
        this.archiverConfiguration = archiverConfiguration;
    }

    public ArchiverConfiguration getArchiverConfiguration() {
        return this.archiverConfiguration;
    }

    public RequiredProjectsConfiguration getRequiredProjectsConfiguration() {
        return this.requiredProjectsConfiguration;
    }

    public void setRequiredProjectsConfiguration(RequiredProjectsConfiguration requiredProjectsConfiguration) {
        this.requiredProjectsConfiguration = requiredProjectsConfiguration;
    }

    public void assign(Configuration configuration) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
        this.setName(makeConfiguration.getName());
        this.setBaseDir(makeConfiguration.getBaseDir());
        this.getConfigurationType().assign(makeConfiguration.getConfigurationType());
        this.getCompilerSet().assign(makeConfiguration.getCompilerSet());
        this.getCRequired().assign(makeConfiguration.getCRequired());
        this.getCppRequired().assign(makeConfiguration.getCppRequired());
        this.getFortranRequired().assign(makeConfiguration.getFortranRequired());
        this.getPlatform().assign(makeConfiguration.getPlatform());
        this.getDependencyChecking().assign(makeConfiguration.getDependencyChecking());
        this.getMakefileConfiguration().assign(makeConfiguration.getMakefileConfiguration());
        this.getCCompilerConfiguration().assign(makeConfiguration.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(makeConfiguration.getCCCompilerConfiguration());
        this.getFortranCompilerConfiguration().assign(makeConfiguration.getFortranCompilerConfiguration());
        this.getLinkerConfiguration().assign(makeConfiguration.getLinkerConfiguration());
        this.getArchiverConfiguration().assign(makeConfiguration.getArchiverConfiguration());
        this.getRequiredProjectsConfiguration().assign(makeConfiguration.getRequiredProjectsConfiguration());
        ConfigurationAuxObject[] configurationAuxObjectArray = this.getAuxObjects();
        for (int i = 0; i < configurationAuxObjectArray.length; ++i) {
            String string = configurationAuxObjectArray[i].getId();
            ConfigurationAuxObject configurationAuxObject = configuration.getAuxObject(string);
            if (configurationAuxObject != null) {
                configurationAuxObjectArray[i].assign(configurationAuxObject);
                continue;
            }
            System.err.println("Configuration - assign: Object ID " + string + " do not found");
        }
    }

    public Configuration cloneConf() {
        return (Configuration)this.clone();
    }

    public Configuration copy() {
        MakeConfiguration makeConfiguration = new MakeConfiguration(this.getBaseDir(), this.getName(), this.getConfigurationType().getValue());
        makeConfiguration.assign(this);
        ConfigurationAuxObject[] configurationAuxObjectArray = this.getAuxObjects();
        Vector<ConfigurationAuxObject> vector = new Vector<ConfigurationAuxObject>();
        for (int i = 0; i < configurationAuxObjectArray.length; ++i) {
            if (configurationAuxObjectArray[i] instanceof ItemConfiguration) {
                vector.add(((ItemConfiguration)configurationAuxObjectArray[i]).copy(makeConfiguration));
                continue;
            }
            vector.add(configurationAuxObjectArray[i]);
        }
        makeConfiguration.setAuxObjects(vector);
        return makeConfiguration;
    }

    public Object clone() {
        MakeConfiguration makeConfiguration = new MakeConfiguration(this.getBaseDir(), this.getName(), this.getConfigurationType().getValue());
        super.cloneConf(makeConfiguration);
        makeConfiguration.setCloneOf(this);
        makeConfiguration.setCompilerSet((CompilerSet2Configuration)this.getCompilerSet().clone());
        makeConfiguration.setCRequired((LanguageBooleanConfiguration)this.getCRequired().clone());
        makeConfiguration.setCppRequired((LanguageBooleanConfiguration)this.getCppRequired().clone());
        makeConfiguration.setFortranRequired((LanguageBooleanConfiguration)this.getFortranRequired().clone());
        makeConfiguration.setPlatform((IntConfiguration)this.getPlatform().clone());
        makeConfiguration.setMakefileConfiguration((MakefileConfiguration)this.getMakefileConfiguration().clone());
        makeConfiguration.setDependencyChecking((BooleanConfiguration)this.getDependencyChecking().clone());
        makeConfiguration.setCCompilerConfiguration((CCompilerConfiguration)this.getCCompilerConfiguration().clone());
        makeConfiguration.setCCCompilerConfiguration((CCCompilerConfiguration)this.getCCCompilerConfiguration().clone());
        makeConfiguration.setFortranCompilerConfiguration((FortranCompilerConfiguration)this.getFortranCompilerConfiguration().clone());
        makeConfiguration.setLinkerConfiguration((LinkerConfiguration)this.getLinkerConfiguration().clone());
        makeConfiguration.setArchiverConfiguration((ArchiverConfiguration)this.getArchiverConfiguration().clone());
        makeConfiguration.setRequiredProjectsConfiguration((RequiredProjectsConfiguration)this.getRequiredProjectsConfiguration().clone());
        ConfigurationAuxObject[] configurationAuxObjectArray = this.getAuxObjects();
        ArrayList<ConfigurationAuxObject> arrayList = new ArrayList<ConfigurationAuxObject>();
        for (int i = 0; i < configurationAuxObjectArray.length; ++i) {
            arrayList.add((ConfigurationAuxObject)configurationAuxObjectArray[i].clone());
        }
        makeConfiguration.setAuxObjects(arrayList);
        return makeConfiguration;
    }

    public Sheet getGeneralSheet(Project project) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("ProjectDefaults");
        set.setDisplayName(MakeConfiguration.getString("ProjectDefaultsTxt"));
        set.setShortDescription(MakeConfiguration.getString("ProjectDefaultsHint"));
        set.put((Node.Property)new CompilerSetNodeProp(this.getCompilerSet(), true, "CompilerSCollection2", MakeConfiguration.getString("CompilerCollectionTxt"), MakeConfiguration.getString("CompilerCollectionHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getCRequired(), true, "cRequired", MakeConfiguration.getString("CRequiredTxt"), MakeConfiguration.getString("CRequiredHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getCppRequired(), true, "cppRequired", MakeConfiguration.getString("CppRequiredTxt"), MakeConfiguration.getString("CppRequiredHint")));
        if (CppSettings.getDefault().isFortranEnabled()) {
            set.put((Node.Property)new BooleanNodeProp(this.getFortranRequired(), true, "fortranRequired", MakeConfiguration.getString("FortranRequiredTxt"), MakeConfiguration.getString("FortranRequiredHint")));
        }
        set.put((Node.Property)new IntNodeProp(this.getPlatform(), true, "Platform", MakeConfiguration.getString("PlatformTxt"), MakeConfiguration.getString("PlatformHint")));
        set.put((Node.Property)new IntNodeProp(this.getConfigurationType(), true, "ConfigurationType", MakeConfiguration.getString("ConfigurationTypeTxt"), MakeConfiguration.getString("ConfigurationTypeHint")));
        sheet.put(set);
        if (this.isCompileConfiguration()) {
            set = Sheet.createExpertSet();
            set.put((Node.Property)new BooleanNodeProp(this.getDependencyChecking(), true, "DependencyChecking", MakeConfiguration.getString("DependencyCheckingTxt"), MakeConfiguration.getString("DependencyCheckingHint")));
            sheet.put(set);
        }
        return sheet;
    }

    public Sheet getRequiredProjectsSheet(Project project, MakeConfiguration makeConfiguration) {
        Sheet sheet = new Sheet();
        String[] stringArray = new String[]{MakeConfiguration.getString("ProjectsTxt1"), MakeConfiguration.getString("ProjectsHint"), MakeConfiguration.getString("ProjectsTxt2"), MakeConfiguration.getString("AllOptionsTxt2")};
        Sheet.Set set = new Sheet.Set();
        set.setName("Projects");
        set.setDisplayName(MakeConfiguration.getString("ProjectsTxt1"));
        set.setShortDescription(MakeConfiguration.getString("ProjectsHint"));
        set.put((Node.Property)new RequiredProjectsNodeProp(this.getRequiredProjectsConfiguration(), project, makeConfiguration, this.getBaseDir(), stringArray));
        sheet.put(set);
        return sheet;
    }

    public void setRequiredLanguagesDirty(boolean bl) {
        this.languagesDirty = bl;
    }

    public boolean getRequiredLanguagesDirty() {
        return this.languagesDirty;
    }

    public boolean hasCFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.cRequired.getValue();
    }

    public boolean hasCPPFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.cppRequired.getValue();
    }

    public boolean hasFortranFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.fortranRequired.getValue();
    }

    public void reCountLanguages(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this.getRequiredLanguagesDirty()) {
            return;
        }
        Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
        if (itemArray.length == 0 && this.isMakefileConfiguration()) {
            bl = true;
            bl2 = true;
        } else {
            for (int i = 0; i < itemArray.length; ++i) {
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(this);
                if (itemConfiguration.getExcluded().getValue()) continue;
                if (itemConfiguration.getTool() == Tool.CCompiler) {
                    bl = true;
                }
                if (itemConfiguration.getTool() == Tool.CCCompiler) {
                    bl2 = true;
                }
                if (itemConfiguration.getTool() != Tool.FortranCompiler) continue;
                bl3 = true;
            }
        }
        this.cRequired.setDefault(bl);
        this.cppRequired.setDefault(bl2);
        this.fortranRequired.setDefault(bl3);
        this.languagesDirty = false;
    }

    public String getVariant() {
        String string = "";
        string = string + CompilerSetManager.getDefault().getCompilerSet(this.getCompilerSet().getValue()).getName() + "-";
        string = string + Platforms.getPlatform(this.getPlatform().getValue()).getName();
        return string;
    }

    public Set getSubProjects() {
        HashSet<Project> hashSet = new HashSet<Project>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        LibraryItem[] libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
        for (int i = 0; i < libraryItemArray.length; ++i) {
            LibraryItem.ProjectItem projectItem;
            Project project;
            if (!(libraryItemArray[i] instanceof LibraryItem.ProjectItem) || (project = (projectItem = (LibraryItem.ProjectItem)libraryItemArray[i]).getProject(this.getBaseDir())) == null) continue;
            hashSet.add(project);
        }
        for (LibraryItem.ProjectItem projectItem : this.getRequiredProjectsConfiguration().getRequiredProjectItemsAsArray()) {
            Project project = projectItem.getProject(this.getBaseDir());
            if (project == null) continue;
            hashSet.add(project);
        }
        return hashSet;
    }

    public Set getSubProjectLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        LibraryItem[] libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
        for (int i = 0; i < libraryItemArray.length; ++i) {
            if (!(libraryItemArray[i] instanceof LibraryItem.ProjectItem)) continue;
            LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)libraryItemArray[i];
            hashSet.add(projectItem.getMakeArtifact().getProjectLocation());
        }
        return hashSet;
    }

    public Set getSubProjectOutputLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        LibraryItem[] libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
        for (int i = 0; i < libraryItemArray.length; ++i) {
            if (!(libraryItemArray[i] instanceof LibraryItem.ProjectItem)) continue;
            LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)libraryItemArray[i];
            String string = IpeUtils.getDirName((String)projectItem.getMakeArtifact().getOutput());
            if (IpeUtils.isPathAbsolute((String)string)) {
                hashSet.add(string);
                continue;
            }
            hashSet.add(projectItem.getMakeArtifact().getProjectLocation() + "/" + string);
        }
        return hashSet;
    }

    public String getAbsoluteOutputValue() {
        String string = this.isLinkerConfiguration() ? this.getLinkerConfiguration().getOutputValue() : (this.isArchiverConfiguration() ? this.getArchiverConfiguration().getOutputValue() : (this.isMakefileConfiguration() ? this.getMakefileConfiguration().getOutput().getValue() : null));
        if (string == null || IpeUtils.isPathAbsolute((String)string)) {
            return string;
        }
        string = this.getBaseDir() + "/" + string;
        string = FilePathAdaptor.normalize(string);
        return string;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeConfiguration.class, (String)string);
    }

    public class LanguageBooleanConfiguration
    extends BooleanConfiguration {
        private boolean notYetSet;

        LanguageBooleanConfiguration() {
            super(null, false);
            this.notYetSet = true;
        }

        public void setValue(boolean bl) {
            if (this.notYetSet) {
                this.setValue(bl, bl);
            } else {
                super.setValue(bl);
            }
            this.notYetSet = false;
        }

        public void setDefault(boolean bl) {
            if (this.getValue() == this.getDefault()) {
                this.setValue(bl, bl);
            } else {
                super.setDefault(bl);
            }
            this.notYetSet = false;
        }

        public void setValue(boolean bl, boolean bl2) {
            super.setValue(bl);
            super.setDefault(bl2);
            this.notYetSet = false;
        }

        public Object clone() {
            LanguageBooleanConfiguration languageBooleanConfiguration = new LanguageBooleanConfiguration();
            languageBooleanConfiguration.setValue(this.getValue(), this.getDefault());
            languageBooleanConfiguration.setModified(this.getModified());
            return languageBooleanConfiguration;
        }

        public void assign(LanguageBooleanConfiguration languageBooleanConfiguration) {
            this.setValue(languageBooleanConfiguration.getValue(), languageBooleanConfiguration.getDefault());
            this.setModified(languageBooleanConfiguration.getModified());
        }
    }
}

