/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.LibrariesNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.VectorNodeProp;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LinkerConfiguration
implements AllOptionsProvider {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private VectorConfiguration additionalLibs;
    private VectorConfiguration dynamicSearch;
    private BooleanConfiguration stripOption;
    private BooleanConfiguration picOption;
    private BooleanConfiguration norunpathOption;
    private BooleanConfiguration nameassignOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private LibrariesConfiguration librariesConfiguration;
    private StringConfiguration tool;

    public LinkerConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.additionalLibs = new VectorConfiguration(null);
        this.dynamicSearch = new VectorConfiguration(null);
        this.stripOption = new BooleanConfiguration(null, false, "", "-s");
        this.picOption = new BooleanConfiguration(null, true, "", "-Kpic");
        this.norunpathOption = new BooleanConfiguration(null, true, "", "-norunpath");
        this.nameassignOption = new BooleanConfiguration(null, true);
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.additionalDependencies.setPreDefined(this.getAdditionalDependenciesPredefined());
        this.librariesConfiguration = new LibrariesConfiguration();
        this.tool = new StringConfiguration(null, "");
    }

    private String getAdditionalDependenciesPredefined() {
        String string = "${BUILD_SUBPROJECTS} ${OBJECTFILES}";
        return string;
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = this.makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration stringConfiguration) {
        this.output = stringConfiguration;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public VectorConfiguration getAdditionalLibs() {
        return this.additionalLibs;
    }

    public void setAdditionalLibs(VectorConfiguration vectorConfiguration) {
        this.additionalLibs = vectorConfiguration;
    }

    public VectorConfiguration getDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(VectorConfiguration vectorConfiguration) {
        this.dynamicSearch = vectorConfiguration;
    }

    public void setStripOption(BooleanConfiguration booleanConfiguration) {
        this.stripOption = booleanConfiguration;
    }

    public BooleanConfiguration getStripOption() {
        return this.stripOption;
    }

    public void setPICOption(BooleanConfiguration booleanConfiguration) {
        this.picOption = booleanConfiguration;
    }

    public BooleanConfiguration getPICOption() {
        return this.picOption;
    }

    public void setNorunpathOption(BooleanConfiguration booleanConfiguration) {
        this.norunpathOption = booleanConfiguration;
    }

    public BooleanConfiguration getNorunpathOption() {
        return this.norunpathOption;
    }

    public void setNameassignOption(BooleanConfiguration booleanConfiguration) {
        this.nameassignOption = booleanConfiguration;
    }

    public BooleanConfiguration getNameassignOption() {
        return this.nameassignOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration optionsConfiguration) {
        this.commandLineConfiguration = optionsConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration optionsConfiguration) {
        this.additionalDependencies = optionsConfiguration;
    }

    public LibrariesConfiguration getLibrariesConfiguration() {
        return this.librariesConfiguration;
    }

    public void setLibrariesConfiguration(LibrariesConfiguration librariesConfiguration) {
        this.librariesConfiguration = librariesConfiguration;
    }

    public void setTool(StringConfiguration stringConfiguration) {
        this.tool = stringConfiguration;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void assign(LinkerConfiguration linkerConfiguration) {
        this.setMakeConfiguration(linkerConfiguration.getMakeConfiguration());
        this.getOutput().assign(linkerConfiguration.getOutput());
        this.getAdditionalLibs().assign(linkerConfiguration.getAdditionalLibs());
        this.getDynamicSearch().assign(linkerConfiguration.getDynamicSearch());
        this.getCommandLineConfiguration().assign(linkerConfiguration.getCommandLineConfiguration());
        this.getAdditionalDependencies().assign(linkerConfiguration.getAdditionalDependencies());
        this.getStripOption().assign(linkerConfiguration.getStripOption());
        this.getPICOption().assign(linkerConfiguration.getPICOption());
        this.getNorunpathOption().assign(linkerConfiguration.getNorunpathOption());
        this.getNameassignOption().assign(linkerConfiguration.getNameassignOption());
        this.getLibrariesConfiguration().assign(linkerConfiguration.getLibrariesConfiguration());
        this.getTool().assign(linkerConfiguration.getTool());
    }

    public Object clone() {
        LinkerConfiguration linkerConfiguration = new LinkerConfiguration(this.getMakeConfiguration());
        linkerConfiguration.setOutput((StringConfiguration)this.getOutput().clone());
        linkerConfiguration.setAdditionalLibs((VectorConfiguration)this.getAdditionalLibs().clone());
        linkerConfiguration.setDynamicSearch((VectorConfiguration)this.getDynamicSearch().clone());
        linkerConfiguration.setCommandLineConfiguration((OptionsConfiguration)this.getCommandLineConfiguration().clone());
        linkerConfiguration.setAdditionalDependencies((OptionsConfiguration)this.getAdditionalDependencies().clone());
        linkerConfiguration.setStripOption((BooleanConfiguration)this.getStripOption().clone());
        linkerConfiguration.setPICOption((BooleanConfiguration)this.getPICOption().clone());
        linkerConfiguration.setNorunpathOption((BooleanConfiguration)this.getNorunpathOption().clone());
        linkerConfiguration.setNameassignOption((BooleanConfiguration)this.getNameassignOption().clone());
        linkerConfiguration.setLibrariesConfiguration((LibrariesConfiguration)this.getLibrariesConfiguration().clone());
        linkerConfiguration.setTool((StringConfiguration)this.getTool().clone());
        return linkerConfiguration;
    }

    public String getOptions() {
        String string = this.getCommandLineConfiguration().getValue() + " ";
        string = string + this.getBasicOptions() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getBasicOptions() {
        String string = "";
        CompilerSet compilerSet = CompilerSetManager.getDefault().getCompilerSet(this.getMakeConfiguration().getCompilerSet().getValue());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            String string2 = this.getOutputValue();
            int n = string2.lastIndexOf(47);
            if (n >= 0 && string2.length() > 1) {
                string2 = string2.substring(n + 1);
            }
            if (compilerSet.isSunCompiler()) {
                string = string + "-G ";
            } else if (compilerSet.isGnuCompiler() && (this.getMakeConfiguration().getPlatform().getValue() == 1 || this.getMakeConfiguration().getPlatform().getValue() == 0)) {
                string = string + "-G ";
            } else if (compilerSet.isGnuCompiler() && this.getMakeConfiguration().getPlatform().getValue() == 4) {
                string = string + "-dynamiclib -install_name " + string2 + " ";
            } else if (compilerSet.isGnuCompiler()) {
                if (compilerSet.getCompilerFlavor() == CompilerSet.CompilerFlavor.Cygwin) {
                    string = string + "-mno-cygwin ";
                }
                string = string + "-shared ";
            } else assert (false);
        }
        string = string + this.getOutputOptions() + " ";
        string = string + this.getStripOption().getOption() + " ";
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            if (this.getPICOption().getValue()) {
                string = string + this.getPICOption(compilerSet);
            }
            if (compilerSet.isSunCompiler()) {
                string = string + this.getNorunpathOption().getOption() + " ";
                string = string + this.getNameassignOption(this.getNameassignOption().getValue()) + " ";
            }
        }
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getPICOption(CompilerSet compilerSet) {
        String string = null;
        if (compilerSet.isSunCompiler()) {
            string = "-Kpic ";
        } else if (compilerSet.isGnuCompiler()) {
            string = "-fPIC ";
        } else assert (false);
        return string;
    }

    public String getLibraryItems() {
        String string = "-L";
        String string2 = "";
        CompilerSet compilerSet = CompilerSetManager.getDefault().getCompilerSet(this.getMakeConfiguration().getCompilerSet().getValue());
        if (compilerSet.isSunCompiler()) {
            string2 = "-R";
        } else if (compilerSet.isGnuCompiler() && (this.getMakeConfiguration().getPlatform().getValue() == 1 || this.getMakeConfiguration().getPlatform().getValue() == 0)) {
            string2 = "-R";
        } else if (compilerSet.isGnuCompiler()) {
            string2 = "-Wl,-rpath ";
        } else {
            return "";
        }
        String string3 = "";
        string3 = string3 + this.getAdditionalLibs().getOption(string) + " ";
        string3 = string3 + this.getDynamicSearch().getOption(string2) + " ";
        string3 = string3 + this.getLibrariesConfiguration().getOptions(this.getMakeConfiguration()) + " ";
        return CppUtils.reformatWhitespaces((String)string3);
    }

    public String getAllOptions(BasicCompiler basicCompiler) {
        String string = this.getBasicOptions() + " ";
        string = string + this.getLibraryItems() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public Sheet getGeneralSheet(Project project, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        String string;
        BasicCompiler basicCompiler;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = CompilerSetManager.getDefault().getCompilerSet(makeConfiguration.getCompilerSet().getValue());
        if (makeConfiguration.hasCPPFiles(makeConfigurationDescriptor)) {
            basicCompiler = (BasicCompiler)compilerSet.getTool(Tool.CCCompiler);
            string = basicCompiler.getName();
        } else {
            basicCompiler = (BasicCompiler)compilerSet.getTool(Tool.CCompiler);
            string = basicCompiler.getName();
        }
        basicCompiler = new Sheet.Set();
        basicCompiler.setName("General");
        basicCompiler.setDisplayName(LinkerConfiguration.getString("GeneralTxt"));
        basicCompiler.setShortDescription(LinkerConfiguration.getString("GeneralHint"));
        basicCompiler.put((Node.Property)new OutputNodeProp(this.getOutput(), this.getOutputDefault(), "Output", LinkerConfiguration.getString("OutputTxt"), LinkerConfiguration.getString("OutputHint")));
        basicCompiler.put((Node.Property)new VectorNodeProp(this.getAdditionalLibs(), null, this.getMakeConfiguration().getBaseDir(), new String[]{"AdditionalLibraryDirectories", LinkerConfiguration.getString("AdditionalLibraryDirectoriesTxt"), LinkerConfiguration.getString("AdditionalLibraryDirectoriesHint")}, true, new HelpCtx("AddtlLibraryDirectories")));
        basicCompiler.put((Node.Property)new VectorNodeProp(this.getDynamicSearch(), null, this.getMakeConfiguration().getBaseDir(), new String[]{"RuntimeSearchDirectories", LinkerConfiguration.getString("RuntimeSearchDirectoriesTxt"), LinkerConfiguration.getString("RuntimeSearchDirectoriesHint")}, false, new HelpCtx("RuntimeSearchDirectories")));
        sheet.put((Sheet.Set)basicCompiler);
        Sheet.Set set = new Sheet.Set();
        set.setName("Options");
        set.setDisplayName(LinkerConfiguration.getString("OptionsTxt"));
        set.setShortDescription(LinkerConfiguration.getString("OptionsHint"));
        set.put((Node.Property)new BooleanNodeProp(this.getStripOption(), true, "StripSymbols", LinkerConfiguration.getString("StripSymbolsTxt"), LinkerConfiguration.getString("StripSymbolsHint")));
        if (makeConfiguration.getConfigurationType().getValue() == 2) {
            set.put((Node.Property)new BooleanNodeProp(this.getPICOption(), true, "PositionIndependantCode", LinkerConfiguration.getString("PositionIndependantCodeTxt"), LinkerConfiguration.getString("PositionIndependantCodeHint")));
            if (compilerSet.isSunCompiler()) {
                set.put((Node.Property)new BooleanNodeProp(this.getNorunpathOption(), true, "NoRunPath", LinkerConfiguration.getString("NoRunPathTxt"), LinkerConfiguration.getString("NoRunPathHint")));
                set.put((Node.Property)new BooleanNodeProp(this.getNameassignOption(), true, "AssignName", LinkerConfiguration.getString("AssignNameTxt"), LinkerConfiguration.getString("AssignNameHint")));
            }
        }
        sheet.put(set);
        Sheet.Set set2 = new Sheet.Set();
        String[] stringArray = new String[]{LinkerConfiguration.getString("AdditionalDependenciesTxt1"), LinkerConfiguration.getString("AdditionalDependenciesHint"), LinkerConfiguration.getString("AdditionalDependenciesTxt2"), LinkerConfiguration.getString("InheritedValuesTxt")};
        set2.setName("Input");
        set2.setDisplayName(LinkerConfiguration.getString("InputTxt"));
        set2.setShortDescription(LinkerConfiguration.getString("InputHint"));
        set2.put((Node.Property)new OptionsNodeProp(this.getAdditionalDependencies(), null, new AdditionalDependenciesOptions(), null, ",", stringArray));
        sheet.put(set2);
        Sheet.Set set3 = new Sheet.Set();
        set3.setName("Tool");
        set3.setDisplayName(LinkerConfiguration.getString("ToolTxt1"));
        set3.setShortDescription(LinkerConfiguration.getString("ToolHint1"));
        set3.put((Node.Property)new StringNodeProp(this.getTool(), string, "Tool", LinkerConfiguration.getString("ToolTxt1"), LinkerConfiguration.getString("ToolHint1")));
        sheet.put(set3);
        stringArray = new String[]{LinkerConfiguration.getString("LibrariesTxt1"), LinkerConfiguration.getString("LibrariesHint"), LinkerConfiguration.getString("LibrariesTxt2"), LinkerConfiguration.getString("AllOptionsTxt2")};
        set = new Sheet.Set();
        set.setName("Libraries");
        set.setDisplayName(LinkerConfiguration.getString("LibrariesTxt1"));
        set.setShortDescription(LinkerConfiguration.getString("LibrariesHint"));
        set.put((Node.Property)new LibrariesNodeProp(this.getLibrariesConfiguration(), project, makeConfiguration, this.getMakeConfiguration().getBaseDir(), stringArray));
        sheet.put(set);
        stringArray = new String[]{LinkerConfiguration.getString("AdditionalOptionsTxt1"), LinkerConfiguration.getString("AdditionalOptionsHint"), LinkerConfiguration.getString("AdditionalOptionsTxt2"), LinkerConfiguration.getString("AllOptionsTxt")};
        set = new Sheet.Set();
        set.setName("CommandLine");
        set.setDisplayName(LinkerConfiguration.getString("CommandLineTxt"));
        set.setShortDescription(LinkerConfiguration.getString("CommandLineHint"));
        set.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, null, null, stringArray));
        sheet.put(set);
        return sheet;
    }

    private String getNameassignOption(boolean bl) {
        if (bl) {
            return "-h " + IpeUtils.getBaseName((String)this.getOutputValue());
        }
        return "";
    }

    private String getOutputOptions() {
        return "-o " + this.getOutputValue() + " ";
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1) {
            string = string.toLowerCase();
        } else if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            Platform platform = Platforms.getPlatform(this.getMakeConfiguration().getPlatform().getValue());
            string = platform.getLibraryName(string);
        }
        string = ConfigurationSupport.makeNameLegal(string);
        return "dist/" + this.getMakeConfiguration().getName() + "/" + this.getMakeConfiguration().getVariant() + "/" + string;
    }

    public String getOutputDefault27() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1) {
            string = string.toLowerCase();
        } else if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            string = "lib" + string + ".so";
        }
        return "dist/" + this.getMakeConfiguration().getName() + "/" + string;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(LinkerConfiguration.class, (String)string);
    }

    private class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3, String string4) {
            super(stringConfiguration, string, string2, string3, string4);
        }

        public void setValue(Object object) {
            if (IpeUtils.hasMakeSpecialCharacters((String)((String)object))) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)LinkerConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(object);
        }
    }

    class AdditionalDependenciesOptions
    implements AllOptionsProvider {
        AdditionalDependenciesOptions() {
        }

        public String getAllOptions(BasicCompiler basicCompiler) {
            String string = "";
            string = string + LinkerConfiguration.this.additionalDependencies.getPreDefined();
            return CppUtils.reformatWhitespaces((String)string);
        }
    }
}

