/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLReader;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ConfigurationDescriptorProvider {
    private FileObject projectDirectory;
    private ConfigurationDescriptor projectDescriptor = null;
    boolean hasTried = false;
    private String relativeOffset = null;
    private Object readLock = new Object();

    public ConfigurationDescriptorProvider(FileObject fileObject) {
        this.projectDirectory = fileObject;
    }

    public void setRelativeOffset(String string) {
        this.relativeOffset = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationDescriptor getConfigurationDescriptor() {
        if (this.projectDescriptor == null && !this.hasTried) {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.hasTried) {
                    ConfigurationXMLReader configurationXMLReader = new ConfigurationXMLReader(this.projectDirectory);
                    if (SwingUtilities.isEventDispatchThread()) {
                        ProjectReader projectReader = new ProjectReader(configurationXMLReader, this.relativeOffset);
                        RequestProcessor.Task task = RequestProcessor.getDefault().post((Runnable)projectReader);
                        task.waitFinished();
                        this.projectDescriptor = projectReader.projectDescriptor;
                    } else {
                        try {
                            this.projectDescriptor = configurationXMLReader.read(this.relativeOffset);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.hasTried = true;
                }
            }
        }
        return this.projectDescriptor;
    }

    public boolean gotDescriptor() {
        return this.projectDescriptor != null;
    }

    public static ConfigurationAuxObjectProvider[] getAuxObjectProviders() {
        HashSet hashSet = new HashSet();
        Lookup.Template template = new Lookup.Template(ConfigurationAuxObjectProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        for (Object e : collection) {
            if (!(e instanceof ConfigurationAuxObjectProvider)) continue;
            hashSet.add(e);
        }
        return hashSet.toArray(new ConfigurationAuxObjectProvider[hashSet.size()]);
    }

    private class ProjectReader
    implements Runnable {
        public ConfigurationDescriptor projectDescriptor = null;
        private ConfigurationXMLReader reader;
        private String relativeOffset;

        public ProjectReader(ConfigurationXMLReader configurationXMLReader, String string) {
            this.reader = configurationXMLReader;
            this.relativeOffset = string;
        }

        public void run() {
            try {
                this.projectDescriptor = this.reader.read(this.relativeOffset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

