/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.compilers.SunCCCCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.openide.ErrorManager;

public class SunCCompiler
extends SunCCCCompiler {
    private static final String compilerStderrCommand = " -xdryrun -E";
    private static final String[] DEVELOPMENT_MODE_OPTIONS = new String[]{"", "-g", "-g -xO3 -xhwcprof", "-xprofile=tcov -xinline=", "-g -xO2", "-xO3 -xstrconst", "-xO5 -xipo=1 -xdepend -fsimple=1 -xlibmil -xlibmopt -xvector -xbuiltin -xalias_level=basic"};
    private static final String[] WARNING_LEVEL_OPTIONS = new String[]{"-w", "", "+w", "-errwarn=%all"};
    private static final String[] MT_LEVEL_OPTIONS = new String[]{"", "-mt", "-xautopar -xvector -xreduction -xloopinfo", "-xopenmp"};
    private static final String[] STANDARD_OPTIONS = new String[]{"-xc99=none", "-xc99=none", "", "-xstrconst -xc99"};
    private static final String[] LANGUAGE_EXT_OPTIONS = new String[]{"-Xc", "", ""};

    public SunCCompiler(CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        super(compilerFlavor, n, string, string2, string3);
    }

    public SunCCompiler createCopy() {
        SunCCompiler sunCCompiler = new SunCCompiler(this.getFlavor(), this.getKind(), "", this.getDisplayName(), this.getPath());
        sunCCompiler.setName(this.getName());
        return sunCCompiler;
    }

    public String getDevelopmentModeOptions(int n) {
        return DEVELOPMENT_MODE_OPTIONS[n];
    }

    public String getWarningLevelOptions(int n) {
        if (n < WARNING_LEVEL_OPTIONS.length) {
            return WARNING_LEVEL_OPTIONS[n];
        }
        return "";
    }

    public String getSixtyfourBitsOption(int n) {
        if (this.getFlavor() == CompilerSet.CompilerFlavor.Sun12) {
            if (n == BasicCompilerConfiguration.BITS_DEFAULT) {
                return "";
            }
            if (n == BasicCompilerConfiguration.BITS_32) {
                return "-m32";
            }
            if (n == BasicCompilerConfiguration.BITS_64) {
                return "-m64";
            }
            return "";
        }
        if (n == BasicCompilerConfiguration.BITS_DEFAULT) {
            return "";
        }
        if (n == BasicCompilerConfiguration.BITS_32) {
            return "";
        }
        if (n == BasicCompilerConfiguration.BITS_64) {
            return "-xarch=generic64";
        }
        return "";
    }

    public String getStripOption(boolean bl) {
        return bl ? "-s" : "";
    }

    public String getMTLevelOptions(int n) {
        return MT_LEVEL_OPTIONS[n];
    }

    public String getStandardsEvolutionOptions(int n) {
        return STANDARD_OPTIONS[n];
    }

    public String getLanguageExtOptions(int n) {
        return LANGUAGE_EXT_OPTIONS[n];
    }

    protected void parseCompilerOutput(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("-I");
                while (n > 0) {
                    String string2;
                    int n2 = string.indexOf(" ", n + 1);
                    if (n2 > 0) {
                        string2 = string.substring(n + 2, n2);
                        this.systemIncludeDirectoriesList.addUnique(this.normalizePath(string2));
                        n = string.indexOf("-I", n2);
                        continue;
                    }
                    string2 = string.substring(n + 2);
                    this.systemIncludeDirectoriesList.addUnique(this.normalizePath(string2));
                    break;
                }
                this.parseUserMacros(string, this.systemPreprocessorSymbolsList);
            }
            this.systemPreprocessorSymbolsList.add("__STDC__=0");
            inputStream.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
    }

    private void dumpLists() {
        int n;
        System.out.println("==================================" + this.getDisplayName());
        for (n = 0; n < this.systemIncludeDirectoriesList.size(); ++n) {
            System.out.println("-I" + this.systemIncludeDirectoriesList.get(n));
        }
        for (n = 0; n < this.systemPreprocessorSymbolsList.size(); ++n) {
            System.out.println("-D" + this.systemPreprocessorSymbolsList.get(n));
        }
    }

    protected String getDefaultPath() {
        return "cc";
    }

    protected String getCompilerStderrCommand() {
        return compilerStderrCommand;
    }

    protected String getCompilerStderrCommand2() {
        return null;
    }
}

