/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;

public class MakeArtifact {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    private String projectLocation;
    private int configurationType;
    private String configurationName;
    private boolean active;
    private boolean build;
    private String workingDirectory;
    private String buildCommand;
    private String cleanCommand;
    private String output;

    public MakeArtifact(String string, int n, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, String string6) {
        this.projectLocation = string;
        this.configurationType = n;
        this.configurationName = string2;
        this.active = bl;
        this.build = bl2;
        this.workingDirectory = string3;
        this.buildCommand = string4;
        this.cleanCommand = string5;
        this.output = string6;
    }

    public MakeArtifact(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        this.projectLocation = makeConfiguration.getBaseDir();
        this.configurationName = makeConfiguration.getName();
        this.active = makeConfiguration.isDefault();
        this.build = true;
        this.workingDirectory = this.projectLocation;
        this.buildCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f " + makeConfigurationDescriptor.getProjectMakefileName() + " CONF=" + this.configurationName;
        this.cleanCommand = "${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f " + makeConfigurationDescriptor.getProjectMakefileName() + " CONF=" + this.configurationName + " clean";
        if (makeConfiguration.getConfigurationType().getValue() == 0) {
            this.configurationType = 0;
            this.output = makeConfiguration.getMakefileConfiguration().getOutput().getValue();
        } else if (makeConfiguration.getConfigurationType().getValue() == 1) {
            this.configurationType = 1;
            this.output = makeConfiguration.getLinkerConfiguration().getOutputValue();
        } else if (makeConfiguration.getConfigurationType().getValue() == 2) {
            this.configurationType = 2;
            this.output = makeConfiguration.getLinkerConfiguration().getOutputValue();
        } else if (makeConfiguration.getConfigurationType().getValue() == 3) {
            this.configurationType = 3;
            this.output = makeConfiguration.getArchiverConfiguration().getOutputValue();
        } else assert (false);
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public void setProjectLocation(String string) {
        this.projectLocation = string;
    }

    public int getConfigurationType() {
        return this.configurationType;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getBuild() {
        return this.build;
    }

    public void setBuild(boolean bl) {
        this.build = bl;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    public String getBuildCommand(String string, String string2) {
        String string3 = this.getBuildCommand();
        int n = string3.indexOf("${MAKE}");
        if (n == 0) {
            string3 = string + string3.substring(n + 7);
        } else if (n > 0) {
            string3 = string3.substring(0, n) + string + string3.substring(n + 7);
        }
        n = string3.indexOf("${MAKEFLAGS}");
        string3 = n == 0 ? string2 + string3.substring(n + 12) : (n > 0 ? string3.substring(0, n) + string2 + string3.substring(n + 12) : string2 + string3);
        return string3;
    }

    public String getCleanCommand() {
        return this.cleanCommand;
    }

    public String getCleanCommand(String string, String string2) {
        String string3 = this.getCleanCommand();
        int n = string3.indexOf("${MAKE}");
        if (n == 0) {
            string3 = string + string3.substring(n + 7);
        } else if (n > 0) {
            string3 = string3.substring(0, n) + string + string3.substring(n + 7);
        }
        n = string3.indexOf("${MAKEFLAGS}");
        string3 = n == 0 ? string2 + string3.substring(n + 12) : (n > 0 ? string3.substring(0, n) + string2 + string3.substring(n + 12) : string2 + string3);
        return string3;
    }

    public String getOutput() {
        return this.output;
    }

    public String toString() {
        String string = this.getConfigurationName();
        if (this.getOutput() != null && this.getOutput().length() > 0) {
            string = string + " (" + this.getOutput() + ")";
        }
        return string;
    }

    public static MakeArtifact[] getMakeArtifacts(Project project) {
        MakeArtifactProvider makeArtifactProvider = (MakeArtifactProvider)project.getLookup().lookup(MakeArtifactProvider.class);
        if (makeArtifactProvider != null) {
            return makeArtifactProvider.getBuildArtifacts();
        }
        return null;
    }

    public Object clone() {
        return new MakeArtifact(this.projectLocation, this.configurationType, this.configurationName, this.active, this.build, this.workingDirectory, this.buildCommand, this.cleanCommand, this.output);
    }
}

