/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;

public class MakeOptions
extends SharedClassObject
implements PropertyChangeListener {
    private static MakeOptions instance = null;
    static final String MAKE_OPTIONS = "makeOptions";
    private static String defaultMakeOptions = "";
    static final String PLATFORM = "platform";
    public static final int PATH_REL_OR_ABS = 0;
    public static final int PATH_REL = 1;
    public static final int PATH_ABS = 2;
    public static String[] PathModeNames = new String[]{MakeOptions.getString("TXT_Auto"), MakeOptions.getString("TXT_AlwaysRelative"), MakeOptions.getString("TXT_AlwaysAbsolute")};
    static final String PATH_MODE = "pathMode";
    static final String DEPENDENCY_CHECKING = "dependencyChecking";
    static final String SAVE = "save";
    static final String REUSE = "reuse";

    public static MakeOptions getInstance() {
        if (instance == null) {
            instance = (MakeOptions)SharedClassObject.findObject(MakeOptions.class, (boolean)true);
        }
        return instance;
    }

    public static void setDefaultMakeOptions(String string) {
        defaultMakeOptions = string;
    }

    public static String getDefaultMakeOptions() {
        return defaultMakeOptions;
    }

    public MakeOptions() {
        this.addPropertyChangeListener(this);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(MakeOptions.class);
    }

    public String getMakeOptions() {
        return this.getPreferences().get(MAKE_OPTIONS, MakeOptions.getDefaultMakeOptions());
    }

    public void setMakeOptions(String string) {
        String string2 = this.getMakeOptions();
        this.getPreferences().put(MAKE_OPTIONS, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(MAKE_OPTIONS, string2, string);
        }
    }

    public int getPlatform() {
        return this.getPreferences().getInt(PLATFORM, Platform.getDefaultPlatform());
    }

    public void setPlatform(int n) {
        int n2 = this.getPlatform();
        this.getPreferences().putInt(PLATFORM, n);
        if (n2 != n) {
            this.firePropertyChange(PLATFORM, "" + n2, "" + n);
        }
    }

    public int getPathMode() {
        return this.getPreferences().getInt(PATH_MODE, 1);
    }

    public void setPathMode(int n) {
        int n2 = this.getPathMode();
        this.getPreferences().putInt(PATH_MODE, n);
        if (n2 != n) {
            this.firePropertyChange(PATH_MODE, new Integer(n2), new Integer(n));
        }
    }

    public boolean getDepencyChecking() {
        return this.getPreferences().getBoolean(DEPENDENCY_CHECKING, false);
    }

    public void setDepencyChecking(boolean bl) {
        boolean bl2 = this.getDepencyChecking();
        this.getPreferences().putBoolean(DEPENDENCY_CHECKING, bl);
        if (bl2 != bl) {
            this.firePropertyChange(DEPENDENCY_CHECKING, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getSave() {
        return this.getPreferences().getBoolean(SAVE, true);
    }

    public void setSave(boolean bl) {
        boolean bl2 = this.getSave();
        this.getPreferences().putBoolean(SAVE, bl);
        if (bl2 != bl) {
            this.firePropertyChange(SAVE, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getReuse() {
        return this.getPreferences().getBoolean(REUSE, true);
    }

    public void setReuse(boolean bl) {
        boolean bl2 = this.getReuse();
        this.getPreferences().putBoolean(REUSE, bl);
        if (bl2 != bl) {
            this.firePropertyChange(REUSE, new Boolean(bl2), new Boolean(bl));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeOptions.class, (String)string);
    }
}

