/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.IntStack;
import org.jvyamlb.Parser;
import org.jvyamlb.ParserException;
import org.jvyamlb.Scanner;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.DocumentEndEvent;
import org.jvyamlb.events.DocumentStartEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.tokens.AliasToken;
import org.jvyamlb.tokens.AnchorToken;
import org.jvyamlb.tokens.BlockEndToken;
import org.jvyamlb.tokens.BlockEntryToken;
import org.jvyamlb.tokens.BlockMappingStartToken;
import org.jvyamlb.tokens.BlockSequenceStartToken;
import org.jvyamlb.tokens.DirectiveToken;
import org.jvyamlb.tokens.DocumentEndToken;
import org.jvyamlb.tokens.DocumentStartToken;
import org.jvyamlb.tokens.FlowEntryToken;
import org.jvyamlb.tokens.FlowMappingEndToken;
import org.jvyamlb.tokens.FlowMappingStartToken;
import org.jvyamlb.tokens.FlowSequenceEndToken;
import org.jvyamlb.tokens.FlowSequenceStartToken;
import org.jvyamlb.tokens.KeyToken;
import org.jvyamlb.tokens.ScalarToken;
import org.jvyamlb.tokens.StreamEndToken;
import org.jvyamlb.tokens.TagToken;
import org.jvyamlb.tokens.Token;
import org.jvyamlb.tokens.ValueToken;

public class ParserImpl
implements Parser {
    private static final int P_STREAM = 0;
    private static final int P_STREAM_START = 1;
    private static final int P_STREAM_END = 2;
    private static final int P_IMPLICIT_DOCUMENT = 3;
    private static final int P_EXPLICIT_DOCUMENT = 4;
    private static final int P_DOCUMENT_START = 5;
    private static final int P_DOCUMENT_START_IMPLICIT = 6;
    private static final int P_DOCUMENT_END = 7;
    private static final int P_BLOCK_NODE = 8;
    private static final int P_BLOCK_CONTENT = 9;
    private static final int P_PROPERTIES = 10;
    private static final int P_PROPERTIES_END = 11;
    private static final int P_FLOW_CONTENT = 12;
    private static final int P_BLOCK_SEQUENCE = 13;
    private static final int P_BLOCK_MAPPING = 14;
    private static final int P_FLOW_SEQUENCE = 15;
    private static final int P_FLOW_MAPPING = 16;
    private static final int P_SCALAR = 17;
    private static final int P_BLOCK_SEQUENCE_ENTRY = 18;
    private static final int P_BLOCK_MAPPING_ENTRY = 19;
    private static final int P_BLOCK_MAPPING_ENTRY_VALUE = 20;
    private static final int P_BLOCK_NODE_OR_INDENTLESS_SEQUENCE = 21;
    private static final int P_BLOCK_SEQUENCE_START = 22;
    private static final int P_BLOCK_SEQUENCE_END = 23;
    private static final int P_BLOCK_MAPPING_START = 24;
    private static final int P_BLOCK_MAPPING_END = 25;
    private static final int P_INDENTLESS_BLOCK_SEQUENCE = 26;
    private static final int P_BLOCK_INDENTLESS_SEQUENCE_START = 27;
    private static final int P_INDENTLESS_BLOCK_SEQUENCE_ENTRY = 28;
    private static final int P_BLOCK_INDENTLESS_SEQUENCE_END = 29;
    private static final int P_FLOW_SEQUENCE_START = 30;
    private static final int P_FLOW_SEQUENCE_ENTRY = 31;
    private static final int P_FLOW_SEQUENCE_END = 32;
    private static final int P_FLOW_MAPPING_START = 33;
    private static final int P_FLOW_MAPPING_ENTRY = 34;
    private static final int P_FLOW_MAPPING_END = 35;
    private static final int P_FLOW_INTERNAL_MAPPING_START = 36;
    private static final int P_FLOW_INTERNAL_CONTENT = 37;
    private static final int P_FLOW_INTERNAL_VALUE = 38;
    private static final int P_FLOW_INTERNAL_MAPPING_END = 39;
    private static final int P_FLOW_ENTRY_MARKER = 40;
    private static final int P_FLOW_NODE = 41;
    private static final int P_FLOW_MAPPING_INTERNAL_CONTENT = 42;
    private static final int P_FLOW_MAPPING_INTERNAL_VALUE = 43;
    private static final int P_ALIAS = 44;
    private static final int P_EMPTY_SCALAR = 45;
    private static final String[] productionNames = new String[46];
    private static final Event DOCUMENT_END_TRUE;
    private static final Event DOCUMENT_END_FALSE;
    private static final Event MAPPING_END;
    private static final Event SEQUENCE_END;
    private static final Event STREAM_END;
    private static final Event STREAM_START;
    private static final Map DEFAULT_TAGS_1_0;
    private static final Map DEFAULT_TAGS_1_1;
    private static final Pattern ONLY_WORD;
    private Scanner scanner = null;
    private YAMLConfig cfg = null;
    private Event currentEvent = null;
    private IntStack parseStack = null;
    private ProductionEnvironment pEnv = null;

    private static Event processEmptyScalar() {
        return new ScalarEvent(null, null, new boolean[]{true, false}, new ByteList(ByteList.NULL_ARRAY), '\u0000');
    }

    private static Object[] processDirectives(ProductionEnvironment productionEnvironment, Scanner scanner) {
        Object object;
        while (scanner.peekToken() instanceof DirectiveToken) {
            object = (DirectiveToken)scanner.getToken();
            if (((DirectiveToken)object).getName().equals("YAML")) {
                if (productionEnvironment.getYamlVersion() != null) {
                    throw new ParserException(null, "found duplicate YAML directive", null);
                }
                int n = Integer.parseInt(((DirectiveToken)object).getValue()[0]);
                int n2 = Integer.parseInt(((DirectiveToken)object).getValue()[1]);
                if (n != 1) {
                    throw new ParserException(null, "found incompatible YAML document (version 1.* is required)", null);
                }
                productionEnvironment.setYamlVersion(new int[]{n, n2});
                continue;
            }
            if (!((DirectiveToken)object).getName().equals("TAG")) continue;
            String string = ((DirectiveToken)object).getValue()[0];
            String string2 = ((DirectiveToken)object).getValue()[1];
            if (productionEnvironment.getTagHandles().containsKey(string)) {
                throw new ParserException(null, "duplicate tag handle " + string, null);
            }
            productionEnvironment.getTagHandles().put(string, string2);
        }
        object = new Object[2];
        object[0] = productionEnvironment.getFinalYamlVersion();
        if (!productionEnvironment.getTagHandles().isEmpty()) {
            object[1] = new HashMap(productionEnvironment.getTagHandles());
        }
        Map map = ((int[])object[0])[1] == 0 ? DEFAULT_TAGS_1_0 : DEFAULT_TAGS_1_1;
        for (Object k : map.keySet()) {
            if (productionEnvironment.getTagHandles().containsKey(k)) continue;
            productionEnvironment.getTagHandles().put(k, map.get(k));
        }
        return object;
    }

    public ParserImpl(Scanner scanner) {
        this(scanner, YAML.config());
    }

    public ParserImpl(Scanner scanner, YAMLConfig yAMLConfig) {
        this.scanner = scanner;
        this.cfg = yAMLConfig;
    }

    public boolean checkEvent(Class[] classArray) {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        if (this.currentEvent != null) {
            if (classArray.length == 0) {
                return true;
            }
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                if (!classArray[i].isInstance(this.currentEvent)) continue;
                return true;
            }
        }
        return false;
    }

    public Event peekEvent() {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        return this.currentEvent;
    }

    public Event getEvent() {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        Event event = this.currentEvent;
        this.currentEvent = null;
        return event;
    }

    public Iterator eachEvent() {
        return new EventIterator();
    }

    public Iterator iterator() {
        return this.eachEvent();
    }

    public void parseStream() {
        if (null == this.parseStack) {
            this.parseStack = new IntStack();
            this.parseStack.push(0);
            this.pEnv = new ProductionEnvironment(this.cfg);
        }
    }

    public Event parseStreamNext() {
        while (!this.parseStack.isEmpty()) {
            Event event = this.pEnv.produce(this.parseStack.pop(), this.parseStack, this.scanner);
            if (null == event) continue;
            return event;
        }
        this.pEnv = null;
        return null;
    }

    public static void tmainx(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        ByteList byteList = new ByteList(1024);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        do {
            n = ((InputStream)fileInputStream).read(byArray);
            byteList.append(byArray, 0, n);
        } while (n >= 1024);
        ((InputStream)fileInputStream).close();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ParserImpl parserImpl = new ParserImpl(new ScannerImpl(byteList));
            Iterator iterator = parserImpl.eachEvent();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the events for the file: " + string + " took " + l3 + "ms, or " + d + " seconds");
    }

    public static void tmain(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        FileInputStream fileInputStream = new FileInputStream(string);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ParserImpl parserImpl = new ParserImpl(new ScannerImpl(fileInputStream));
            Iterator iterator = parserImpl.eachEvent();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        ((InputStream)fileInputStream).close();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the events for the file: " + string + " took " + l3 + "ms, or " + d + " seconds");
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        ParserImpl parserImpl = new ParserImpl(new ScannerImpl(new FileInputStream(string)));
        Iterator iterator = parserImpl.eachEvent();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    static {
        ParserImpl.productionNames[0] = "P_STREAM";
        ParserImpl.productionNames[1] = "P_STREAM_START";
        ParserImpl.productionNames[2] = "P_STREAM_END";
        ParserImpl.productionNames[3] = "P_IMPLICIT_DOCUMENT";
        ParserImpl.productionNames[4] = "P_EXPLICIT_DOCUMENT";
        ParserImpl.productionNames[5] = "P_DOCUMENT_START";
        ParserImpl.productionNames[6] = "P_DOCUMENT_START_IMPLICIT";
        ParserImpl.productionNames[7] = "P_DOCUMENT_END";
        ParserImpl.productionNames[8] = "P_BLOCK_NODE";
        ParserImpl.productionNames[9] = "P_BLOCK_CONTENT";
        ParserImpl.productionNames[10] = "P_PROPERTIES";
        ParserImpl.productionNames[11] = "P_PROPERTIES_END";
        ParserImpl.productionNames[12] = "P_FLOW_CONTENT";
        ParserImpl.productionNames[13] = "P_BLOCK_SEQUENCE";
        ParserImpl.productionNames[14] = "P_BLOCK_MAPPING";
        ParserImpl.productionNames[15] = "P_FLOW_SEQUENCE";
        ParserImpl.productionNames[16] = "P_FLOW_MAPPING";
        ParserImpl.productionNames[17] = "P_SCALAR";
        ParserImpl.productionNames[18] = "P_BLOCK_SEQUENCE_ENTRY";
        ParserImpl.productionNames[19] = "P_BLOCK_MAPPING_ENTRY";
        ParserImpl.productionNames[20] = "P_BLOCK_MAPPING_ENTRY_VALUE";
        ParserImpl.productionNames[21] = "P_BLOCK_NODE_OR_INDENTLESS_SEQUENCE";
        ParserImpl.productionNames[22] = "P_BLOCK_SEQUENCE_START";
        ParserImpl.productionNames[23] = "P_BLOCK_SEQUENCE_END";
        ParserImpl.productionNames[24] = "P_BLOCK_MAPPING_START";
        ParserImpl.productionNames[25] = "P_BLOCK_MAPPING_END";
        ParserImpl.productionNames[26] = "P_INDENTLESS_BLOCK_SEQUENCE";
        ParserImpl.productionNames[27] = "P_BLOCK_INDENTLESS_SEQUENCE_START";
        ParserImpl.productionNames[28] = "P_INDENTLESS_BLOCK_SEQUENCE_ENTRY";
        ParserImpl.productionNames[29] = "P_BLOCK_INDENTLESS_SEQUENCE_END";
        ParserImpl.productionNames[30] = "P_FLOW_SEQUENCE_START";
        ParserImpl.productionNames[31] = "P_FLOW_SEQUENCE_ENTRY";
        ParserImpl.productionNames[32] = "P_FLOW_SEQUENCE_END";
        ParserImpl.productionNames[33] = "P_FLOW_MAPPING_START";
        ParserImpl.productionNames[34] = "P_FLOW_MAPPING_ENTRY";
        ParserImpl.productionNames[35] = "P_FLOW_MAPPING_END";
        ParserImpl.productionNames[36] = "P_FLOW_INTERNAL_MAPPING_START";
        ParserImpl.productionNames[37] = "P_FLOW_INTERNAL_CONTENT";
        ParserImpl.productionNames[38] = "P_FLOW_INTERNAL_VALUE";
        ParserImpl.productionNames[39] = "P_FLOW_INTERNAL_MAPPING_END";
        ParserImpl.productionNames[40] = "P_FLOW_ENTRY_MARKER";
        ParserImpl.productionNames[41] = "P_FLOW_NODE";
        ParserImpl.productionNames[42] = "P_FLOW_MAPPING_INTERNAL_CONTENT";
        ParserImpl.productionNames[43] = "P_FLOW_MAPPING_INTERNAL_VALUE";
        ParserImpl.productionNames[44] = "P_ALIAS";
        ParserImpl.productionNames[45] = "P_EMPTY_SCALAR";
        DOCUMENT_END_TRUE = new DocumentEndEvent(true);
        DOCUMENT_END_FALSE = new DocumentEndEvent(false);
        MAPPING_END = new MappingEndEvent();
        SEQUENCE_END = new SequenceEndEvent();
        STREAM_END = new StreamEndEvent();
        STREAM_START = new StreamStartEvent();
        DEFAULT_TAGS_1_0 = new HashMap();
        DEFAULT_TAGS_1_1 = new HashMap();
        DEFAULT_TAGS_1_0.put("!", "tag:yaml.org,2002:");
        DEFAULT_TAGS_1_0.put("!!", "");
        DEFAULT_TAGS_1_1.put("!", "!");
        DEFAULT_TAGS_1_1.put("!!", "tag:yaml.org,2002:");
        ONLY_WORD = Pattern.compile("^\\w+$");
    }

    private class EventIterator
    implements Iterator {
        private EventIterator() {
        }

        public boolean hasNext() {
            return null != ParserImpl.this.peekEvent();
        }

        public Object next() {
            return ParserImpl.this.getEvent();
        }

        public void remove() {
        }
    }

    private static class ProductionEnvironment {
        private List tags = new LinkedList();
        private List anchors = new LinkedList();
        private Map tagHandles = new HashMap();
        private int[] yamlVersion = null;
        private int[] defaultYamlVersion = new int[2];

        public ProductionEnvironment(YAMLConfig yAMLConfig) {
            this.defaultYamlVersion[0] = Integer.parseInt(yAMLConfig.version().substring(0, yAMLConfig.version().indexOf(46)));
            this.defaultYamlVersion[1] = Integer.parseInt(yAMLConfig.version().substring(yAMLConfig.version().indexOf(46) + 1));
        }

        public List getTags() {
            return this.tags;
        }

        public List getAnchors() {
            return this.anchors;
        }

        public Map getTagHandles() {
            return this.tagHandles;
        }

        public int[] getYamlVersion() {
            return this.yamlVersion;
        }

        public int[] getFinalYamlVersion() {
            if (null == this.yamlVersion) {
                return this.defaultYamlVersion;
            }
            return this.yamlVersion;
        }

        public void setYamlVersion(int[] nArray) {
            this.yamlVersion = nArray;
        }

        public Event produce(int n, IntStack intStack, Scanner scanner) {
            switch (n) {
                case 0: {
                    intStack.push(2);
                    intStack.push(4);
                    intStack.push(3);
                    intStack.push(1);
                    return null;
                }
                case 1: {
                    scanner.getToken();
                    return STREAM_START;
                }
                case 2: {
                    scanner.getToken();
                    return STREAM_END;
                }
                case 3: {
                    Token token = scanner.peekToken();
                    if (!(token instanceof DirectiveToken || token instanceof DocumentStartToken || token instanceof StreamEndToken)) {
                        intStack.push(7);
                        intStack.push(8);
                        intStack.push(6);
                    }
                    return null;
                }
                case 4: {
                    if (!(scanner.peekToken() instanceof StreamEndToken)) {
                        intStack.push(4);
                        intStack.push(7);
                        intStack.push(8);
                        intStack.push(5);
                    }
                    return null;
                }
                case 5: {
                    Token token = scanner.peekToken();
                    Object[] objectArray = ParserImpl.processDirectives(this, scanner);
                    if (!(scanner.peekToken() instanceof DocumentStartToken)) {
                        throw new ParserException(null, "expected '<document start>', but found " + token.getClass().getName(), null);
                    }
                    scanner.getToken();
                    return new DocumentStartEvent(true, (int[])objectArray[0], (Map)objectArray[1]);
                }
                case 6: {
                    Object[] objectArray = ParserImpl.processDirectives(this, scanner);
                    return new DocumentStartEvent(false, (int[])objectArray[0], (Map)objectArray[1]);
                }
                case 7: {
                    Token token = scanner.peekToken();
                    boolean bl = false;
                    while (scanner.peekToken() instanceof DocumentEndToken) {
                        scanner.getToken();
                        bl = true;
                    }
                    return bl ? DOCUMENT_END_TRUE : DOCUMENT_END_FALSE;
                }
                case 8: {
                    Token token = scanner.peekToken();
                    if (token instanceof DirectiveToken || token instanceof DocumentStartToken || token instanceof DocumentEndToken || token instanceof StreamEndToken) {
                        intStack.push(45);
                    } else if (token instanceof AliasToken) {
                        intStack.push(44);
                    } else {
                        intStack.push(11);
                        intStack.push(9);
                        intStack.push(10);
                    }
                    return null;
                }
                case 9: {
                    Token token = scanner.peekToken();
                    if (token instanceof BlockSequenceStartToken) {
                        intStack.push(13);
                    } else if (token instanceof BlockMappingStartToken) {
                        intStack.push(14);
                    } else if (token instanceof FlowSequenceStartToken) {
                        intStack.push(15);
                    } else if (token instanceof FlowMappingStartToken) {
                        intStack.push(16);
                    } else if (token instanceof ScalarToken) {
                        intStack.push(17);
                    } else {
                        boolean[] blArray = new boolean[]{false, false};
                        return new ScalarEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), blArray, new ByteList(new byte[0], false), '\'');
                    }
                    return null;
                }
                case 10: {
                    String string = null;
                    Object object = null;
                    if (scanner.peekToken() instanceof AnchorToken) {
                        string = ((AnchorToken)scanner.getToken()).getValue();
                        if (scanner.peekToken() instanceof TagToken) {
                            object = ((TagToken)scanner.getToken()).getValue();
                        }
                    } else if (scanner.peekToken() instanceof TagToken) {
                        object = ((TagToken)scanner.getToken()).getValue();
                        if (scanner.peekToken() instanceof AnchorToken) {
                            string = ((AnchorToken)scanner.getToken()).getValue();
                        }
                    }
                    if (object != null && !object.equals("!")) {
                        String string2 = ScannerImpl.into(object[0]);
                        String string3 = ScannerImpl.into(object[1]);
                        int n2 = -1;
                        n2 = string3.indexOf("^");
                        if (n2 != -1) {
                            string3 = string3.substring(0, n2) + string3.substring(n2 + 1);
                        }
                        if (string2 != null) {
                            if (!this.getTagHandles().containsKey(string2)) {
                                throw new ParserException("while parsing a node", "found undefined tag handle " + string2, null);
                            }
                            n2 = string3.indexOf("/");
                            if (n2 != -1) {
                                String string4 = string3.substring(0, n2);
                                String string5 = string3.substring(n2 + 1);
                                object = ONLY_WORD.matcher(string4).matches() ? "tag:" + string4 + ".yaml.org,2002:" + string5 : (string4.startsWith("tag:") ? string4 + ":" + string5 : "tag:" + string4 + ":" + string5);
                            } else {
                                object = (String)this.getTagHandles().get(string2) + string3;
                            }
                        } else {
                            object = string3;
                        }
                    }
                    this.getAnchors().add(0, string);
                    this.getTags().add(0, object);
                    return null;
                }
                case 11: {
                    this.getAnchors().remove(0);
                    this.getTags().remove(0);
                    return null;
                }
                case 12: {
                    Token token = scanner.peekToken();
                    if (token instanceof FlowSequenceStartToken) {
                        intStack.push(15);
                    } else if (token instanceof FlowMappingStartToken) {
                        intStack.push(16);
                    } else if (token instanceof ScalarToken) {
                        intStack.push(17);
                    } else {
                        throw new ParserException("while scanning a flow node", "expected the node content, but found " + token.getClass().getName(), null);
                    }
                    return null;
                }
                case 13: {
                    intStack.push(23);
                    intStack.push(18);
                    intStack.push(22);
                    return null;
                }
                case 14: {
                    intStack.push(25);
                    intStack.push(19);
                    intStack.push(24);
                    return null;
                }
                case 15: {
                    intStack.push(32);
                    intStack.push(31);
                    intStack.push(30);
                    return null;
                }
                case 16: {
                    intStack.push(35);
                    intStack.push(34);
                    intStack.push(33);
                    return null;
                }
                case 17: {
                    ScalarToken scalarToken = (ScalarToken)scanner.getToken();
                    boolean[] blArray = null;
                    blArray = scalarToken.getPlain() && this.getTags().get(0) == null || "!".equals(this.getTags().get(0)) ? new boolean[]{true, false} : (this.getTags().get(0) == null ? new boolean[]{false, true} : new boolean[]{false, false});
                    return new ScalarEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), blArray, scalarToken.getValue(), scalarToken.getStyle());
                }
                case 18: {
                    if (scanner.peekToken() instanceof BlockEntryToken) {
                        scanner.getToken();
                        if (!(scanner.peekToken() instanceof BlockEntryToken) && !(scanner.peekToken() instanceof BlockEndToken)) {
                            intStack.push(18);
                            intStack.push(8);
                        } else {
                            intStack.push(18);
                            intStack.push(45);
                        }
                    }
                    return null;
                }
                case 19: {
                    if (scanner.peekToken() instanceof KeyToken || scanner.peekToken() instanceof ValueToken) {
                        if (scanner.peekToken() instanceof KeyToken) {
                            scanner.getToken();
                            Token token = scanner.peekToken();
                            if (!(token instanceof KeyToken || token instanceof ValueToken || token instanceof BlockEndToken)) {
                                intStack.push(19);
                                intStack.push(20);
                                intStack.push(21);
                            } else {
                                intStack.push(19);
                                intStack.push(20);
                                intStack.push(45);
                            }
                        } else {
                            intStack.push(19);
                            intStack.push(20);
                            intStack.push(45);
                        }
                    }
                    return null;
                }
                case 20: {
                    if (scanner.peekToken() instanceof KeyToken || scanner.peekToken() instanceof ValueToken) {
                        if (scanner.peekToken() instanceof ValueToken) {
                            scanner.getToken();
                            Token token = scanner.peekToken();
                            if (!(token instanceof KeyToken || token instanceof ValueToken || token instanceof BlockEndToken)) {
                                if (token instanceof ScalarToken && scanner.peekToken(1) instanceof BlockEntryToken) {
                                    scanner.getToken();
                                }
                                intStack.push(21);
                            } else {
                                intStack.push(45);
                            }
                        } else {
                            intStack.push(45);
                        }
                    }
                    return null;
                }
                case 21: {
                    if (scanner.peekToken() instanceof AliasToken) {
                        intStack.push(44);
                    } else if (scanner.peekToken() instanceof BlockEntryToken) {
                        intStack.push(26);
                        intStack.push(10);
                    } else {
                        intStack.push(9);
                        intStack.push(10);
                    }
                    return null;
                }
                case 22: {
                    boolean bl = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new SequenceStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), bl, false);
                }
                case 23: {
                    Token token = null;
                    if (!(scanner.peekToken() instanceof BlockEndToken)) {
                        token = scanner.peekToken();
                        throw new ParserException("while scanning a block collection", "expected <block end>, but found " + token.getClass().getName(), null);
                    }
                    scanner.getToken();
                    return SEQUENCE_END;
                }
                case 24: {
                    boolean bl = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new MappingStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), bl, false);
                }
                case 25: {
                    Token token = null;
                    if (!(scanner.peekToken() instanceof BlockEndToken)) {
                        token = scanner.peekToken();
                        throw new ParserException("while scanning a block mapping", "expected <block end>, but found " + token.getClass().getName(), null);
                    }
                    scanner.getToken();
                    return MAPPING_END;
                }
                case 26: {
                    intStack.push(29);
                    intStack.push(28);
                    intStack.push(27);
                    return null;
                }
                case 27: {
                    boolean bl = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    return new SequenceStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), bl, false);
                }
                case 28: {
                    if (scanner.peekToken() instanceof BlockEntryToken) {
                        scanner.getToken();
                        Token token = scanner.peekToken();
                        if (!(token instanceof BlockEntryToken || token instanceof KeyToken || token instanceof ValueToken || token instanceof BlockEndToken)) {
                            intStack.push(28);
                            intStack.push(8);
                        } else {
                            intStack.push(28);
                            intStack.push(45);
                        }
                    }
                    return null;
                }
                case 29: {
                    return SEQUENCE_END;
                }
                case 30: {
                    boolean bl = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new SequenceStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), bl, true);
                }
                case 31: {
                    if (!(scanner.peekToken() instanceof FlowSequenceEndToken)) {
                        if (scanner.peekToken() instanceof KeyToken) {
                            intStack.push(31);
                            intStack.push(40);
                            intStack.push(39);
                            intStack.push(38);
                            intStack.push(37);
                            intStack.push(36);
                        } else {
                            intStack.push(31);
                            intStack.push(41);
                            intStack.push(40);
                        }
                    }
                    return null;
                }
                case 32: {
                    scanner.getToken();
                    return SEQUENCE_END;
                }
                case 33: {
                    boolean bl = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new MappingStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), bl, true);
                }
                case 34: {
                    if (!(scanner.peekToken() instanceof FlowMappingEndToken)) {
                        if (scanner.peekToken() instanceof KeyToken) {
                            intStack.push(34);
                            intStack.push(40);
                            intStack.push(43);
                            intStack.push(42);
                        } else {
                            intStack.push(34);
                            intStack.push(45);
                            intStack.push(41);
                            intStack.push(40);
                        }
                    }
                    return null;
                }
                case 35: {
                    scanner.getToken();
                    return MAPPING_END;
                }
                case 36: {
                    scanner.getToken();
                    return new MappingStartEvent(null, null, true, true);
                }
                case 37: {
                    Token token = scanner.peekToken();
                    if (!(token instanceof ValueToken || token instanceof FlowEntryToken || token instanceof FlowSequenceEndToken)) {
                        intStack.push(41);
                    } else {
                        intStack.push(45);
                    }
                    return null;
                }
                case 38: {
                    if (scanner.peekToken() instanceof ValueToken) {
                        scanner.getToken();
                        if (!(scanner.peekToken() instanceof FlowEntryToken) && !(scanner.peekToken() instanceof FlowSequenceEndToken)) {
                            intStack.push(41);
                        } else {
                            intStack.push(45);
                        }
                    } else {
                        intStack.push(45);
                    }
                    return null;
                }
                case 39: {
                    return MAPPING_END;
                }
                case 40: {
                    if (scanner.peekToken() instanceof FlowEntryToken) {
                        scanner.getToken();
                    }
                    return null;
                }
                case 41: {
                    if (scanner.peekToken() instanceof AliasToken) {
                        intStack.push(44);
                    } else {
                        intStack.push(11);
                        intStack.push(12);
                        intStack.push(10);
                    }
                    return null;
                }
                case 42: {
                    Token token = scanner.peekToken();
                    if (!(token instanceof ValueToken || token instanceof FlowEntryToken || token instanceof FlowMappingEndToken)) {
                        scanner.getToken();
                        intStack.push(41);
                    } else {
                        intStack.push(45);
                    }
                    return null;
                }
                case 43: {
                    if (scanner.peekToken() instanceof ValueToken) {
                        scanner.getToken();
                        if (!(scanner.peekToken() instanceof FlowEntryToken) && !(scanner.peekToken() instanceof FlowMappingEndToken)) {
                            intStack.push(41);
                        } else {
                            intStack.push(45);
                        }
                    } else {
                        intStack.push(45);
                    }
                    return null;
                }
                case 44: {
                    AliasToken aliasToken = (AliasToken)scanner.getToken();
                    return new AliasEvent(aliasToken.getValue());
                }
                case 45: {
                    return ParserImpl.processEmptyScalar();
                }
            }
            return null;
        }
    }
}

