/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

public class IntStack {
    private int[] values;
    private int capacity;
    private int index;

    public IntStack() {
        this(27);
    }

    public IntStack(int n) {
        this.values = new int[n];
        this.capacity = n - 1;
        this.index = -1;
    }

    public boolean isEmpty() {
        return this.index == -1;
    }

    public int size() {
        return this.index + 1;
    }

    public int get(int n) {
        if (n < 0 || n > this.index) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n);
        }
        return this.values[n];
    }

    public int pop() {
        if (this.index == -1) {
            throw new IllegalStateException("Can't pop from an empty stack");
        }
        return this.values[this.index--];
    }

    public void push(int n) {
        this.values[++this.index] = n;
        if (this.index == this.capacity) {
            int[] nArray = new int[this.values.length * 2];
            System.arraycopy(this.values, 0, nArray, 0, this.values.length);
            this.capacity = nArray.length - 1;
            this.values = nArray;
        }
    }
}

