/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.yaml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Representer;
import org.jvyamlb.SafeRepresenterImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLNodeCreator;
import org.jvyamlb.nodes.Node;

public class JRubyRepresenter
extends SafeRepresenterImpl {
    public JRubyRepresenter(Serializer serializer, YAMLConfig yAMLConfig) {
        super(serializer, yAMLConfig);
    }

    protected YAMLNodeCreator getNodeCreatorFor(Object object) {
        if (object instanceof YAMLNodeCreator) {
            return (YAMLNodeCreator)object;
        }
        if (object instanceof IRubyObject) {
            return new IRubyObjectYAMLNodeCreator(object);
        }
        return super.getNodeCreatorFor(object);
    }

    public Node map(String string, Map map, Object object) throws IOException {
        if (null == object) {
            return this.map(string, map, false);
        }
        return this.map(string, map, true);
    }

    public Node seq(String string, List list, Object object) throws IOException {
        if (list instanceof RubyArray) {
            list = ((RubyArray)list).getList();
        }
        if (null == object) {
            return this.seq(string, list, false);
        }
        return this.seq(string, list, true);
    }

    public Node scalar(String string, String string2, String string3) throws IOException {
        return this.scalar(string, ByteList.create(string2), string3);
    }

    public Node scalar(String string, ByteList byteList, String string2) throws IOException {
        if (null == string2 || string2.length() == 0) {
            return this.scalar(string, byteList, '\u0000');
        }
        return this.scalar(string, byteList, string2.charAt(0));
    }

    protected boolean ignoreAliases(Object object) {
        return object instanceof IRubyObject && ((IRubyObject)object).isNil() || super.ignoreAliases(object);
    }

    public static class IRubyObjectYAMLNodeCreator
    implements YAMLNodeCreator {
        private final IRubyObject data;
        private final RubyClass outClass;

        public IRubyObjectYAMLNodeCreator(Object object) {
            this.data = (IRubyObject)object;
            this.outClass = (RubyClass)((RubyModule)this.data.getRuntime().getModule("YAML").getConstant("JvYAML")).getConstant("Node");
        }

        public String taguri() {
            return this.data.callMethod(this.data.getRuntime().getCurrentContext(), "taguri").toString();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            if (this.data.getMetaClass().searchMethod("to_yaml") == this.data.getRuntime().getObjectToYamlMethod() || this.data.getMetaClass().searchMethod("to_yaml").isUndefined()) {
                IRubyObject iRubyObject = this.data.callMethod(this.data.getRuntime().getCurrentContext(), "to_yaml_node", JavaEmbedUtils.javaToRuby(this.data.getRuntime(), representer));
                if (iRubyObject instanceof Node) {
                    return (Node)((Object)iRubyObject);
                }
                if (iRubyObject instanceof IRubyObject) {
                    return (Node)JavaEmbedUtils.rubyToJava(this.data.getRuntime(), iRubyObject, Node.class);
                }
            } else {
                IRubyObject iRubyObject = this.data.callMethod(this.data.getRuntime().getCurrentContext(), "to_yaml", JavaEmbedUtils.javaToRuby(this.data.getRuntime(), representer));
                if (!this.outClass.isInstance(iRubyObject)) {
                    throw iRubyObject.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass().getRealClass() + " (expected YAML::JvYAML::Node)");
                }
                IRubyObject iRubyObject2 = iRubyObject.callMethod(this.data.getRuntime().getCurrentContext(), "value");
                IRubyObject iRubyObject3 = iRubyObject.callMethod(this.data.getRuntime().getCurrentContext(), "style");
                IRubyObject iRubyObject4 = iRubyObject.callMethod(this.data.getRuntime().getCurrentContext(), "type_id");
                String string = null;
                if (!iRubyObject3.isNil()) {
                    string = iRubyObject3.toString();
                }
                String string2 = iRubyObject4.toString();
                if (iRubyObject2 instanceof RubyHash) {
                    return ((JRubyRepresenter)representer).map(string2, (Map)((RubyHash)iRubyObject2), string);
                }
                if (iRubyObject2 instanceof RubyArray) {
                    return ((JRubyRepresenter)representer).seq(string2, (List)((RubyArray)iRubyObject2), string);
                }
                return ((JRubyRepresenter)representer).scalar(string2, ((RubyString)iRubyObject2).getByteList(), string);
            }
            return null;
        }
    }
}

