/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ZlibDeflate {
    private Deflater flater;
    private ByteList collected;
    private Ruby runtime;
    public static final int BASE_SIZE = 100;
    public static final int DEF_MEM_LEVEL = 8;
    public static final int MAX_MEM_LEVEL = 9;
    public static final int MAX_WBITS = 15;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    public static final int FINISH = 4;

    public ZlibDeflate(IRubyObject iRubyObject, int n, int n2, int n3, int n4) {
        this.flater = new Deflater(n, n2 < 0);
        this.flater.setStrategy(n4);
        this.collected = new ByteList(100);
        this.runtime = iRubyObject.getRuntime();
    }

    public static IRubyObject s_deflate(IRubyObject iRubyObject, ByteList byteList, int n) throws DataFormatException, IOException {
        ZlibDeflate zlibDeflate = new ZlibDeflate(iRubyObject, n, 15, 8, 0);
        IRubyObject iRubyObject2 = zlibDeflate.deflate(byteList, 4);
        zlibDeflate.close();
        return iRubyObject2;
    }

    public Deflater getDeflater() {
        return this.flater;
    }

    public void append(IRubyObject iRubyObject) throws IOException, UnsupportedEncodingException {
        this.append(iRubyObject.convertToString().getByteList());
    }

    public void append(ByteList byteList) throws IOException {
        this.collected.append(byteList);
    }

    public void params(int n, int n2) {
        this.flater.setLevel(n);
        this.flater.setStrategy(n2);
    }

    public IRubyObject set_dictionary(IRubyObject iRubyObject) throws UnsupportedEncodingException {
        this.flater.setDictionary(iRubyObject.convertToString().getBytes());
        return iRubyObject;
    }

    public IRubyObject flush(int n) throws IOException {
        return this.deflate(new ByteList(0), n);
    }

    public IRubyObject deflate(ByteList byteList, int n) throws IOException {
        if (null == byteList) {
            return this.finish();
        }
        this.append(byteList);
        if (n == 4) {
            return this.finish();
        }
        return this.runtime.newString("");
    }

    public IRubyObject finish() throws IOException {
        ByteList byteList = new ByteList(this.collected.realSize);
        byte[] byArray = new byte[1024];
        ByteList byteList2 = this.collected;
        this.collected = new ByteList(100);
        this.flater.setInput(byteList2.bytes, byteList2.begin, byteList2.realSize);
        this.flater.finish();
        int n = -1;
        while (!this.flater.finished() && n != 0) {
            n = this.flater.deflate(byArray);
            byteList.append(byArray, 0, n);
        }
        return RubyString.newString(this.runtime, byteList);
    }

    public void close() {
    }
}

