/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static String[] getCurrentEnv(Ruby ruby) {
        RubyHash rubyHash = (RubyHash)ruby.getObject().fastGetConstant("ENV");
        String[] stringArray = new String[rubyHash.size()];
        int n = 0;
        for (Map.Entry entry : rubyHash.directEntrySet()) {
            stringArray[n] = entry.getKey().toString() + "=" + entry.getValue().toString();
            ++n;
        }
        return stringArray;
    }

    public static int runAndWait(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        return ShellLauncher.runAndWait(ruby, iRubyObjectArray, ruby.getOutputStream());
    }

    public static int execAndWait(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        String[] stringArray = ShellLauncher.parseCommandLine(ruby, iRubyObjectArray);
        if (ShellLauncher.shouldRunInProcess(ruby, stringArray)) {
            try {
                int n;
                File file = new File(ruby.getCurrentDirectory());
                String string = stringArray[0];
                int n2 = n = string.endsWith(".rb") ? 0 : 1;
                if (string.trim().endsWith("irb")) {
                    n = 0;
                    stringArray[0] = ruby.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
                }
                String[] stringArray2 = new String[stringArray.length - n];
                System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
                ScriptThreadProcess scriptThreadProcess = new ScriptThreadProcess(stringArray2, ShellLauncher.getCurrentEnv(ruby), file, false);
                scriptThreadProcess.start();
                return scriptThreadProcess.waitFor();
            }
            catch (IOException iOException) {
                throw ruby.newIOErrorFromException(iOException);
            }
            catch (InterruptedException interruptedException) {
                throw ruby.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runAndWait(ruby, iRubyObjectArray);
    }

    public static int runAndWait(Ruby ruby, IRubyObject[] iRubyObjectArray, OutputStream outputStream) {
        PrintStream printStream = ruby.getErrorStream();
        InputStream inputStream = ruby.getInputStream();
        try {
            Process process = ShellLauncher.run(ruby, iRubyObjectArray);
            ShellLauncher.handleStreams(process, inputStream, outputStream, printStream);
            return process.waitFor();
        }
        catch (IOException iOException) {
            throw ruby.newIOErrorFromException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw ruby.newThreadError("unexpected interrupt");
        }
    }

    public static Process run(Ruby ruby, IRubyObject iRubyObject) throws IOException {
        return ShellLauncher.run(ruby, new IRubyObject[]{iRubyObject});
    }

    public static Process popen(Ruby ruby, IRubyObject iRubyObject, ModeFlags modeFlags) throws IOException {
        String string = ShellLauncher.getShell(ruby);
        Process process = null;
        File file = new File(ruby.getCurrentDirectory());
        String[] stringArray = ShellLauncher.parseCommandLine(ruby, new IRubyObject[]{iRubyObject});
        if (ShellLauncher.shouldRunInShell(string, stringArray)) {
            String[] stringArray2 = new String[3];
            String string2 = iRubyObject.toString();
            stringArray2[0] = string;
            stringArray2[1] = string.endsWith("sh") ? "-c" : "/c";
            stringArray2[2] = string2;
            process = Runtime.getRuntime().exec(stringArray2, ShellLauncher.getCurrentEnv(ruby), file);
        } else {
            process = Runtime.getRuntime().exec(stringArray, ShellLauncher.getCurrentEnv(ruby), file);
        }
        process = new POpenProcess(process, ruby, modeFlags);
        return process;
    }

    public static Process run(Ruby ruby, IRubyObject[] iRubyObjectArray) throws IOException {
        String string = ShellLauncher.getShell(ruby);
        Process process = null;
        File file = new File(ruby.getCurrentDirectory());
        String[] stringArray = ShellLauncher.parseCommandLine(ruby, iRubyObjectArray);
        if (ShellLauncher.shouldRunInProcess(ruby, stringArray)) {
            int n;
            String string2 = stringArray[0];
            int n2 = n = string2.endsWith(".rb") ? 0 : 1;
            if (string2.trim().endsWith("irb")) {
                n = 0;
                stringArray[0] = ruby.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            String[] stringArray2 = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
            ScriptThreadProcess scriptThreadProcess = new ScriptThreadProcess(stringArray2, ShellLauncher.getCurrentEnv(ruby), file);
            scriptThreadProcess.start();
            process = scriptThreadProcess;
        } else if (iRubyObjectArray.length == 1 && ShellLauncher.shouldRunInShell(string, stringArray)) {
            String[] stringArray3 = new String[3];
            String string3 = iRubyObjectArray[0].toString();
            stringArray3[0] = string;
            stringArray3[1] = string.endsWith("sh") ? "-c" : "/c";
            stringArray3[2] = string3;
            process = Runtime.getRuntime().exec(stringArray3, ShellLauncher.getCurrentEnv(ruby), file);
        } else {
            process = Runtime.getRuntime().exec(stringArray, ShellLauncher.getCurrentEnv(ruby), file);
        }
        return process;
    }

    private static void handleStreams(Process process, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        InputStream inputStream2 = process.getInputStream();
        InputStream inputStream3 = process.getErrorStream();
        OutputStream outputStream3 = process.getOutputStream();
        StreamPumper streamPumper = new StreamPumper(inputStream2, outputStream, false);
        StreamPumper streamPumper2 = new StreamPumper(inputStream3, outputStream2, false);
        StreamPumper streamPumper3 = new StreamPumper(inputStream, outputStream3, true);
        streamPumper.start();
        streamPumper2.start();
        streamPumper3.start();
        try {
            streamPumper.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            streamPumper2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        streamPumper3.quit();
        try {
            outputStream2.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            outputStream3.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream3.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            streamPumper3.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static String[] parseCommandLine(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        String[] stringArray;
        if (iRubyObjectArray.length == 1) {
            RubyArray rubyArray = (RubyArray)ruby.evalScriptlet("require 'jruby/path_helper'; JRuby::PathHelper").callMethod(ruby.getCurrentContext(), "smart_split_command", iRubyObjectArray);
            stringArray = new String[rubyArray.getLength()];
            for (int i = 0; i < rubyArray.getLength(); ++i) {
                stringArray[i] = rubyArray.entry(i).toString();
            }
        } else {
            stringArray = new String[iRubyObjectArray.length];
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                stringArray[i] = iRubyObjectArray[i].toString();
            }
        }
        return stringArray;
    }

    private static boolean shouldRunInProcess(Ruby ruby, String[] stringArray) {
        int n;
        Object object;
        String[] stringArray2;
        if (!ruby.getInstanceConfig().isRunRubyInProcess()) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = stringArray[i];
            if (stringArray2.trim().length() == 0) continue;
            object = new char[]{stringArray2.charAt(0), stringArray2.charAt(stringArray2.length() - 1)};
            for (n = 0; n < ((Object)object).length; ++n) {
                switch (object[n]) {
                    case 60: 
                    case 62: 
                    case 124: {
                        return false;
                    }
                }
            }
        }
        String string = stringArray[0];
        stringArray2 = string.split("/");
        object = stringArray2[stringArray2.length - 1];
        n = ((String)object).indexOf("ruby");
        return n != -1 && n == ((String)object).length() - 4 || ((String)object).endsWith(".rb") || ((String)object).endsWith("irb");
    }

    private static boolean shouldRunInShell(String string, String[] stringArray) {
        return !Platform.IS_WINDOWS || string != null && stringArray.length > 1 && !new File(stringArray[0]).exists();
    }

    private static String getShell(Ruby ruby) {
        return ruby.evalScriptlet("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
    }

    private static class StreamPumper
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private boolean onlyIfAvailable;
        private volatile boolean quit;
        private final Object waitLock = new Object();

        StreamPumper(InputStream inputStream, OutputStream outputStream, boolean bl) {
            this.in = inputStream;
            this.out = outputStream;
            this.onlyIfAvailable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            byte[] byArray = new byte[1024];
            boolean bl = false;
            while (!this.quit) {
                int n;
                if (this.onlyIfAvailable && !bl) {
                    if (this.in.available() == 0) {
                        Object object = this.waitLock;
                        synchronized (object) {
                            this.waitLock.wait(10L);
                            continue;
                        }
                    }
                    bl = true;
                }
                if ((n = this.in.read(byArray)) == -1) break;
                this.out.write(byArray, 0, n);
            }
            Object var7_7 = null;
            if (!this.onlyIfAvailable) return;
            try {
                this.out.close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    if (!this.onlyIfAvailable) return;
                    try {
                        this.out.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!this.onlyIfAvailable) throw throwable;
                try {
                    this.out.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    public static class POpenProcess
    extends Process {
        private Process child;
        private Ruby runtime;
        private ModeFlags modes;
        private InputStream in;
        private OutputStream out;
        private StreamPumper pumper;

        public POpenProcess(Process process, Ruby ruby, ModeFlags modeFlags) {
            this.child = process;
            this.runtime = ruby;
            this.modes = modeFlags;
            if (modeFlags.isWritable()) {
                this.out = process.getOutputStream();
            } else {
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {
                    throw ruby.newIOErrorFromException(iOException);
                }
                this.out = new OutputStream(){

                    public void write(int n) throws IOException {
                    }
                };
            }
            if (modeFlags.isReadable()) {
                this.in = process.getInputStream();
            } else {
                this.pumper = new StreamPumper(process.getInputStream(), ruby.getOut(), false);
                this.pumper.setDaemon(true);
                this.pumper.start();
                this.in = new InputStream(){

                    public int read() throws IOException {
                        return -1;
                    }
                };
            }
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public InputStream getErrorStream() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int waitFor() throws InterruptedException {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = this.child.waitFor();
            if (this.pumper != null) {
                this.pumper.quit();
            }
            return n;
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        public void destroy() {
            if (this.pumper != null) {
                this.pumper.quit();
            }
            try {
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.child.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private String[] argArray;
        private int result;
        private RubyInstanceConfig config;
        private Thread processThread;
        private PipedInputStream processOutput;
        private PipedInputStream processError;
        private PipedOutputStream processInput;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;

        public ScriptThreadProcess(String[] stringArray, String[] stringArray2, File file) {
            this(stringArray, stringArray2, file, true);
        }

        public ScriptThreadProcess(String[] stringArray, String[] stringArray2, File file, boolean bl) {
            this.argArray = stringArray;
            this.env = stringArray2;
            this.pwd = file;
            this.pipedStreams = bl;
            if (bl) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    this.result = new Main(this.config).run(this.argArray);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(this.config.getError());
                    this.result = -1;
                    Object var3_2 = null;
                    this.config.getOutput().close();
                    this.config.getError().close();
                }
                Object var3_1 = null;
                this.config.getOutput().close();
                this.config.getError().close();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.config.getOutput().close();
                this.config.getError().close();
                throw throwable;
            }
        }

        private Map<String, String> environmentMap(String[] stringArray) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=", 2);
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
            return hashMap;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String string = "piped";
            if (this.argArray.length > 0) {
                string = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + string);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

