/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.Reader;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOReader
extends Reader {
    private IRubyObject io;

    public IOReader(IRubyObject iRubyObject) {
        if (!iRubyObject.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + iRubyObject + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = iRubyObject;
    }

    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.io.callMethod(this.io.getRuntime().getCurrentContext(), "close");
        }
    }

    public int read(char[] cArray, int n, int n2) {
        IRubyObject iRubyObject = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "read", this.io.getRuntime().newFixnum(n2));
        if (iRubyObject.isNil() || ((RubyString)iRubyObject).getByteList().realSize == 0) {
            return -1;
        }
        RubyString rubyString = (RubyString)iRubyObject;
        ByteList byteList = rubyString.getByteList();
        System.arraycopy(ByteList.plain(byteList.bytes, byteList.begin, byteList.realSize), 0, cArray, n, byteList.realSize);
        return byteList.realSize;
    }
}

