/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class TwoVarDynamicScope
extends DynamicScope {
    private IRubyObject variableValueZero;
    private IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 2) {
            throw new RuntimeException("TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    public IRubyObject getValue(int n, int n2) {
        if (n2 > 0) {
            return this.parent.getValue(n, n2 - 1);
        }
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject getValueOrNil(int n, int n2, IRubyObject iRubyObject) {
        if (n2 > 0) {
            return this.parent.getValueOrNil(n, n2 - 1, iRubyObject);
        }
        return this.getValueDepthZeroOrNil(n, iRubyObject);
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = iRubyObject;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = iRubyObject;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject iRubyObject) {
        if (this.variableValueZero == null) {
            this.variableValueZero = iRubyObject;
            return this.variableValueZero;
        }
        return this.variableValueZero;
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject iRubyObject) {
        if (this.variableValueOne == null) {
            this.variableValueOne = iRubyObject;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    public void setValue(int n, IRubyObject iRubyObject, int n2) {
        if (n2 > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
        } else {
            assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
            switch (n) {
                case 0: {
                    this.variableValueZero = iRubyObject;
                }
                case 1: {
                    this.variableValueOne = iRubyObject;
                }
            }
            throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
        }
        this.parent.setValue(n, iRubyObject, n2 - 1);
    }

    public void setValueDepthZero(IRubyObject iRubyObject, int n) {
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                this.variableValueZero = iRubyObject;
            }
            case 1: {
                this.variableValueOne = iRubyObject;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public void setValueZeroDepthZero(IRubyObject iRubyObject) {
        this.variableValueZero = iRubyObject;
    }

    public void setValueOneDepthZero(IRubyObject iRubyObject) {
        this.variableValueOne = iRubyObject;
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        assert (iRubyObjectArray.length == 2) : "TwoVarDynamicScope only supports scopes with two variables";
        this.variableValueZero = iRubyObjectArray[0];
        this.variableValueZero = iRubyObjectArray[1];
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (n <= 2) : "TwoVarDynamicScope only supports scopes with two variables";
        if (this.staticScope.getRestArg() < 0) {
            if (n == 1) {
                return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
            }
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject iRubyObject = this.getValue(this.staticScope.getRestArg(), 0);
        assert (iRubyObject != null);
        RubyArray rubyArray = ASTInterpreter.splatValue(iRubyObject.getRuntime(), iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n + rubyArray.size()];
        System.arraycopy(rubyArray.toJavaArray(), 0, iRubyObjectArray, n, rubyArray.size());
        return iRubyObjectArray;
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] stringArray = this.staticScope.getVariables();
        stringBuffer.append(stringArray[0]).append("=");
        if (this.variableValueZero == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueZero);
        }
        stringBuffer.append(",");
        if (this.variableValueOne == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueOne);
        }
        stringBuffer.append("]");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

