/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class ReflectionCallback
implements Callback {
    private Method method;
    private Class type;
    private String methodName;
    private Class[] argumentTypes;
    private boolean isRestArgs;
    private Arity arity;
    private boolean isStaticMethod;
    private boolean fast;

    public ReflectionCallback(Class clazz, String string, Class[] classArray, boolean bl, boolean bl2, Arity arity, boolean bl3) {
        this.type = clazz;
        this.methodName = string;
        this.argumentTypes = classArray;
        this.isRestArgs = bl;
        this.isStaticMethod = bl2;
        this.arity = arity;
        this.fast = bl3;
        assert (clazz != null);
        assert (string != null);
        assert (arity != null);
        this.loadMethod(bl3);
    }

    private void loadMethod(boolean bl) {
        Class[] classArray;
        Class[] classArray2;
        if (this.isStaticMethod) {
            classArray2 = new Class[this.argumentTypes.length + 1];
            System.arraycopy(this.argumentTypes, 0, classArray2, 1, this.argumentTypes.length);
            classArray2[0] = IRubyObject.class;
            classArray = classArray2;
        } else {
            classArray = this.argumentTypes;
        }
        if (!bl) {
            classArray2 = new Class[classArray.length + 1];
            System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
            classArray2[classArray.length] = Block.class;
            classArray = classArray2;
        }
        try {
            this.method = this.type.getMethod(this.methodName, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("NoSuchMethodException: Cannot get method \"" + this.methodName + "\" in class \"" + this.type.getName() + "\" by Reflection.");
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("SecurityException: Cannot get method \"" + this.methodName + "\" in class \"" + this.type.getName() + "\" by Reflection.");
        }
    }

    protected final Object[] packageRestArgumentsForReflection(Object[] objectArray) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[objectArray.length - (this.argumentTypes.length - 1)];
        Object[] objectArray2 = new Object[this.argumentTypes.length];
        try {
            System.arraycopy(objectArray, this.argumentTypes.length - 1, iRubyObjectArray, 0, objectArray.length - (this.argumentTypes.length - 1));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            assert (false) : arrayIndexOutOfBoundsException;
            return null;
        }
        System.arraycopy(objectArray, 0, objectArray2, 0, this.argumentTypes.length - 1);
        objectArray2[this.argumentTypes.length - 1] = iRubyObjectArray;
        return objectArray2;
    }

    public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        this.arity.checkArity(iRubyObject.getRuntime(), iRubyObjectArray);
        Object[] objectArray = iRubyObjectArray;
        if (this.isRestArgs) {
            objectArray = this.packageRestArgumentsForReflection(objectArray);
        }
        try {
            IRubyObject iRubyObject2 = iRubyObject;
            if (this.isStaticMethod) {
                Object[] objectArray2 = new Object[objectArray.length + (this.fast ? 1 : 2)];
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                objectArray2[0] = iRubyObject;
                if (!this.fast) {
                    objectArray2[objectArray.length + 1] = block;
                }
                iRubyObject2 = null;
                objectArray = objectArray2;
            } else {
                Object[] objectArray3 = new Object[objectArray.length + (this.fast ? 0 : 1)];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                if (!this.fast) {
                    objectArray3[objectArray.length] = block;
                }
                objectArray = objectArray3;
            }
            return (IRubyObject)this.method.invoke((Object)iRubyObject2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof RaiseException) {
                throw (RaiseException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof JumpException) {
                throw (JumpException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof ThreadKill) {
                throw (ThreadKill)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Exception) {
                if (invocationTargetException.getTargetException() instanceof MainExitException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                iRubyObject.getRuntime().getJavaSupport().handleNativeException(invocationTargetException.getTargetException());
                return iRubyObject.getRuntime().getNil();
            }
            throw (Error)invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(illegalAccessException.getMessage());
            stringBuffer.append(':');
            stringBuffer.append(" methodName=").append(this.methodName);
            stringBuffer.append(" recv=").append(iRubyObject.toString());
            stringBuffer.append(" type=").append(this.type.getName());
            stringBuffer.append(" methodArgs=[");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]);
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            assert (false) : stringBuffer.toString();
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assert (false) : illegalArgumentException;
            return null;
        }
    }

    public Arity getArity() {
        return this.arity;
    }
}

