/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedBlock
extends BlockBody {
    private final IterNode iterNode;
    protected final Arity arity;

    public static Block newInterpretedClosure(ThreadContext threadContext, IterNode iterNode, IRubyObject iRubyObject) {
        Frame frame = threadContext.getCurrentFrame();
        return InterpretedBlock.newInterpretedClosure(iterNode, iRubyObject, Arity.procArityOf(iterNode.getVarNode()), frame, frame.getVisibility(), threadContext.getRubyClass(), threadContext.getCurrentScope());
    }

    public static Block newInterpretedClosure(ThreadContext threadContext, InterpretedBlock interpretedBlock, IRubyObject iRubyObject) {
        Frame frame = threadContext.getCurrentFrame();
        Binding binding = new Binding(iRubyObject, frame, frame.getVisibility(), threadContext.getRubyClass(), threadContext.getCurrentScope());
        return new Block(interpretedBlock, binding);
    }

    public static Block newInterpretedClosure(IterNode iterNode, IRubyObject iRubyObject, Arity arity, Frame frame, Visibility visibility, RubyModule rubyModule, DynamicScope dynamicScope) {
        NodeType nodeType = InterpretedBlock.getArgumentTypeWackyHack(iterNode);
        return new Block(new InterpretedBlock(iterNode, arity, InterpretedBlock.asArgumentType(nodeType)), new Binding(iRubyObject, frame, visibility, rubyModule, dynamicScope));
    }

    public InterpretedBlock(IterNode iterNode, int n) {
        this(iterNode, Arity.procArityOf(iterNode == null ? null : iterNode.getVarNode()), n);
    }

    public InterpretedBlock(IterNode iterNode, Arity arity, int n) {
        super(n);
        this.iterNode = iterNode;
        this.arity = arity;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
        iRubyObjectArray = this.prepareArgumentsForCall(threadContext, iRubyObjectArray, type);
        return this.yield(threadContext, threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray), null, null, true, binding, type);
    }

    protected void pre(ThreadContext threadContext, RubyModule rubyModule, Binding binding) {
        threadContext.preYieldSpecificBlock(binding, this.iterNode.getScope(), rubyModule);
    }

    protected void post(ThreadContext threadContext, Binding binding) {
        threadContext.postYield(binding);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        return this.yield(threadContext, iRubyObject, null, null, false, binding, type);
    }

    /*
     * Exception decompiling
     */
    public IRubyObject yield(ThreadContext var1_1, IRubyObject var2_2, IRubyObject var3_3, RubyModule var4_4, boolean var5_5, Binding var6_6, Block.Type var7_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupBlockArgs(ThreadContext threadContext, Node node, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject2.getRuntime();
        switch (node.nodeId) {
            case ZEROARGNODE: {
                break;
            }
            case MULTIPLEASGNNODE: {
                iRubyObject = AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject2, (MultipleAsgnNode)node, (RubyArray)iRubyObject, false);
                break;
            }
            default: {
                int n = this.arrayLength(iRubyObject);
                switch (n) {
                    case 0: {
                        iRubyObject = ruby.getNil();
                        break;
                    }
                    case 1: {
                        iRubyObject = ((RubyArray)iRubyObject).eltInternal(0);
                        break;
                    }
                    default: {
                        ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + n + " for 1)", new Object[0]);
                    }
                }
                AssignmentVisitor.assign(ruby, threadContext, iRubyObject2, node, iRubyObject, Block.NULL_BLOCK, false);
            }
        }
    }

    private void setupBlockArg(ThreadContext threadContext, Node node, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject2.getRuntime();
        switch (node.nodeId) {
            case ZEROARGNODE: {
                return;
            }
            case MULTIPLEASGNNODE: {
                iRubyObject = AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject2, (MultipleAsgnNode)node, ArgsUtil.convertToRubyArray(ruby, iRubyObject, ((MultipleAsgnNode)node).getHeadNode() != null), false);
                break;
            }
            default: {
                if (iRubyObject == null) {
                    ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
                }
                AssignmentVisitor.assign(ruby, threadContext, iRubyObject2, node, iRubyObject, Block.NULL_BLOCK, false);
            }
        }
    }

    protected int arrayLength(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubyArray ? ((RubyArray)iRubyObject).getLength() : 0;
    }

    public StaticScope getStaticScope() {
        return this.iterNode.getScope();
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public IterNode getIterNode() {
        return this.iterNode;
    }

    public Arity arity() {
        return this.arity;
    }

    public boolean isGiven() {
        return true;
    }
}

