/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private Arity arity;
    private BlockCallback callback;
    private RubyModule imClass;
    private ThreadContext context;

    public static Block newCallClosure(IRubyObject iRubyObject, RubyModule rubyModule, Arity arity, BlockCallback blockCallback, ThreadContext threadContext) {
        Binding binding = new Binding(iRubyObject, threadContext.getCurrentFrame(), Visibility.PUBLIC, threadContext.getRubyClass(), threadContext.getCurrentScope());
        CallBlock callBlock = new CallBlock(rubyModule, arity, blockCallback, threadContext);
        return new Block(callBlock, binding);
    }

    private CallBlock(RubyModule rubyModule, Arity arity, BlockCallback blockCallback, ThreadContext threadContext) {
        super(3);
        this.arity = arity;
        this.callback = blockCallback;
        this.imClass = rubyModule;
        this.context = threadContext;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
        return this.callback.call(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        return this.yield(threadContext, iRubyObject, null, null, false, binding, type);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
        if (rubyModule == null) {
            iRubyObject2 = binding.getSelf();
            binding.getFrame().setSelf(iRubyObject2);
        }
        return this.callback.call(threadContext, new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
    }

    public StaticScope getStaticScope() {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), this.context.getCurrentFrame().duplicate(), Visibility.PUBLIC, this.context.getRubyClass(), this.context.getCurrentScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

