/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Serializable;
import org.jruby.RubyModule;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;

public abstract class StaticScope
implements Serializable {
    private static final long serialVersionUID = 4843861446986961013L;
    protected final StaticScope enclosingScope;
    private transient RubyModule cref = null;
    private StaticScope previousCRefScope = null;
    private String[] variableNames;
    private boolean[] variableCaptured;
    private int requiredArgs = 0;
    private int optionalArgs = 0;
    private int restArg = -1;
    private boolean isArgumentScope = false;

    protected StaticScope(StaticScope staticScope) {
        this.enclosingScope = staticScope;
    }

    protected StaticScope(StaticScope staticScope, String[] stringArray) {
        this.enclosingScope = staticScope;
        this.variableNames = stringArray;
        this.variableCaptured = new boolean[this.variableNames.length];
    }

    public int addVariable(String string) {
        int n = this.isDefined(string);
        if (n >= 0) {
            return n;
        }
        if (this.variableNames == null) {
            this.variableNames = new String[1];
            this.variableCaptured = new boolean[1];
            this.variableNames[0] = string;
        } else {
            String[] stringArray = new String[this.variableNames.length + 1];
            System.arraycopy(this.variableNames, 0, stringArray, 0, this.variableNames.length);
            this.variableNames = stringArray;
            this.variableNames[this.variableNames.length - 1] = string;
            boolean[] blArray = new boolean[this.variableCaptured.length + 1];
            System.arraycopy(this.variableCaptured, 0, blArray, 0, this.variableCaptured.length);
            this.variableCaptured = blArray;
        }
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames == null ? 0 : this.variableNames.length;
    }

    public void setVariables(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.variableNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.variableNames, 0, stringArray.length);
        this.variableCaptured = new boolean[this.variableNames.length];
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String string) {
        if (this.variableNames != null) {
            for (int i = 0; i < this.variableNames.length; ++i) {
                if (string != this.variableNames[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public int isDefined(String string) {
        return this.isDefined(string, 0);
    }

    public AssignableNode assign(ISourcePosition iSourcePosition, String string, Node node) {
        return this.assign(iSourcePosition, string, node, this, 0);
    }

    public abstract String[] getAllNamesInScope();

    protected abstract int isDefined(String var1, int var2);

    protected abstract AssignableNode assign(ISourcePosition var1, String var2, Node var3, StaticScope var4, int var5);

    protected abstract Node declare(ISourcePosition var1, String var2, int var3);

    public Node declare(ISourcePosition iSourcePosition, String string) {
        return this.declare(iSourcePosition, string, 0);
    }

    public void capture(int n) {
        this.variableCaptured[n] = true;
    }

    public boolean isCaptured(int n) {
        return this.variableCaptured[n];
    }

    public abstract StaticScope getLocalScope();

    public RubyModule getModule() {
        return this.cref;
    }

    public StaticScope getPreviousCRefScope() {
        return this.previousCRefScope;
    }

    public void setModule(RubyModule rubyModule) {
        this.cref = rubyModule;
        if (this.previousCRefScope == null) {
            for (StaticScope staticScope = this.getEnclosingScope(); staticScope != null; staticScope = staticScope.getEnclosingScope()) {
                if (staticScope.cref == null) continue;
                this.previousCRefScope = staticScope;
                return;
            }
        }
    }

    public RubyModule determineModule() {
        if (this.cref == null) {
            this.cref = this.getEnclosingScope().determineModule();
            assert (this.cref != null) : "CRef is always created before determine happens";
            this.previousCRefScope = this.getEnclosingScope().previousCRefScope;
        }
        return this.cref;
    }

    public int getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOptionalArgs(int n) {
        this.optionalArgs = n;
    }

    public int getRequiredArgs() {
        return this.requiredArgs;
    }

    public void setRequiredArgs(int n) {
        this.requiredArgs = n;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public void setRestArg(int n) {
        this.restArg = n;
    }

    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    public void setArgumentScope(boolean bl) {
        this.isArgumentScope = bl;
    }

    public Arity getArity() {
        if (this.optionalArgs > 0) {
            if (this.restArg >= 0) {
                return Arity.optional();
            }
            return Arity.required(this.requiredArgs);
        }
        if (this.restArg >= 0) {
            return Arity.optional();
        }
        return Arity.fixed(this.requiredArgs);
    }

    public void setArities(int n, int n2, int n3) {
        this.requiredArgs = n;
        this.optionalArgs = n2;
        this.restArg = n3;
    }
}

