/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) {
        RubyClass rubyClass = ruby.getIO();
        CallbackFactory callbackFactory = ruby.callbackFactory(IOWaitLibrary.class);
        rubyClass.defineFastMethod("ready?", callbackFactory.getFastSingletonMethod("ready"));
        rubyClass.defineFastMethod("wait", callbackFactory.getFastSingletonMethod("io_wait"));
    }

    public static IRubyObject ready(IRubyObject iRubyObject) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        try {
            OpenFile openFile = rubyIO.getOpenFile();
            ChannelDescriptor channelDescriptor = openFile.getMainStream().getDescriptor();
            if (!channelDescriptor.isOpen() || !openFile.getMainStream().getModes().isReadable() || openFile.getMainStream().feof()) {
                return iRubyObject.getRuntime().getFalse();
            }
            int n = openFile.getMainStream().ready();
            if (n > 0) {
                return iRubyObject.getRuntime().newFixnum(n);
            }
        }
        catch (Exception exception) {
            return iRubyObject.getRuntime().getFalse();
        }
        return iRubyObject.getRuntime().getNil();
    }

    public static IRubyObject io_wait(IRubyObject iRubyObject) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        try {
            OpenFile openFile = rubyIO.getOpenFile();
            ChannelDescriptor channelDescriptor = openFile.getMainStream().getDescriptor();
            if (openFile.getMainStream().feof()) {
                return iRubyObject.getRuntime().getNil();
            }
            openFile.getMainStream().waitUntilReady();
        }
        catch (Exception exception) {
            return iRubyObject.getRuntime().getNil();
        }
        return iRubyObject;
    }
}

