/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaArray
extends JavaObject {
    public JavaArray(Ruby ruby, Object object) {
        super(ruby, ruby.getJavaSupport().getJavaArrayClass(), object);
        assert (object.getClass().isArray());
    }

    public static RubyClass createJavaArrayClass(Ruby ruby, RubyModule rubyModule) {
        return rubyModule.defineClassUnder("JavaArray", rubyModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    private int getLength() {
        return Array.getLength(this.getValue());
    }

    public boolean equals(Object object) {
        return object instanceof JavaArray && this.getValue() == ((JavaArray)object).getValue();
    }

    public IRubyObject aref(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getInteger());
        }
        int n = (int)((RubyInteger)iRubyObject).getLongValue();
        if (n < 0 || n >= this.getLength()) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + n + " for length " + this.getLength() + ")");
        }
        Object object = Array.get(this.getValue(), n);
        if (object == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), object);
    }

    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getInteger());
        }
        int n = (int)((RubyInteger)iRubyObject).getLongValue();
        if (!(iRubyObject2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject2);
        }
        Object object = ((JavaObject)iRubyObject2).getValue();
        try {
            Array.set(this.getValue(), n, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + n + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException arrayStoreException) {
            throw this.getRuntime().newArgumentError("wrong element type " + object.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
        return iRubyObject2;
    }

    public IRubyObject afill(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n;
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getInteger());
        }
        if (!(iRubyObject2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(iRubyObject2, this.getRuntime().getInteger());
        }
        int n2 = (int)((RubyInteger)iRubyObject2).getLongValue();
        if (!(iRubyObject3 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject3);
        }
        Object object = ((JavaObject)iRubyObject3).getValue();
        Object object2 = this.getValue();
        try {
            for (n = (int)((RubyInteger)iRubyObject).getLongValue(); n < n2; ++n) {
                Array.set(object2, n, object);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + n + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException arrayStoreException) {
            throw this.getRuntime().newArgumentError("wrong element type " + object.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
        return iRubyObject3;
    }
}

