/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject
extends RubyObject {
    protected JavaAccessibleObject(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static void registerRubyMethods(Ruby ruby, RubyClass rubyClass) {
        CallbackFactory callbackFactory = ruby.callbackFactory(JavaAccessibleObject.class);
        rubyClass.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        rubyClass.defineFastMethod("eql?", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        rubyClass.defineFastMethod("equal?", callbackFactory.getFastMethod("same", IRubyObject.class));
        rubyClass.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        rubyClass.defineFastMethod("accessible?", callbackFactory.getFastMethod("isAccessible"));
        rubyClass.defineFastMethod("accessible=", callbackFactory.getFastMethod("setAccessible", IRubyObject.class));
        rubyClass.defineFastMethod("annotations", callbackFactory.getFastMethod("annotations"));
        rubyClass.defineFastMethod("annotations?", callbackFactory.getFastMethod("annotations_p"));
        rubyClass.defineFastMethod("declared_annotations?", callbackFactory.getFastMethod("declared_annotations_p"));
        rubyClass.defineFastMethod("annotation", callbackFactory.getFastMethod("annotation", IRubyObject.class));
        rubyClass.defineFastMethod("annotation_present?", callbackFactory.getFastMethod("annotation_present_p", IRubyObject.class));
        rubyClass.defineFastMethod("declaring_class", callbackFactory.getFastMethod("declaring_class"));
        rubyClass.defineFastMethod("modifiers", callbackFactory.getFastMethod("modifiers"));
        rubyClass.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        rubyClass.defineFastMethod("synthetic?", callbackFactory.getFastMethod("synthetic_p"));
        rubyClass.defineFastMethod("to_string", callbackFactory.getFastMethod("to_string"));
        rubyClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_string"));
    }

    protected abstract AccessibleObject accessibleObject();

    public boolean equals(Object object) {
        return object instanceof JavaAccessibleObject && this.accessibleObject() == ((JavaAccessibleObject)object).accessibleObject();
    }

    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public IRubyObject op_equal(IRubyObject iRubyObject) {
        return iRubyObject instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)iRubyObject).accessibleObject()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject same(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.equals(iRubyObject));
    }

    public RubyBoolean isAccessible() {
        return new RubyBoolean(this.getRuntime(), this.accessibleObject().isAccessible());
    }

    public IRubyObject setAccessible(IRubyObject iRubyObject) {
        this.accessibleObject().setAccessible(iRubyObject.isTrue());
        return iRubyObject;
    }

    public IRubyObject annotation(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotation(((JavaClass)iRubyObject).javaClass()));
    }

    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotations());
    }

    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getAnnotations().length > 0);
    }

    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getDeclaredAnnotations());
    }

    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getDeclaredAnnotations().length > 0);
    }

    public IRubyObject annotation_present_p(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.accessibleObject().isAnnotationPresent(((JavaClass)iRubyObject).javaClass()));
    }

    public IRubyObject declaring_class() {
        Class<?> clazz = ((Member)((Object)this.accessibleObject())).getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(((Member)((Object)this.accessibleObject())).getModifiers());
    }

    public IRubyObject name() {
        return this.getRuntime().newString(((Member)((Object)this.accessibleObject())).getName());
    }

    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(((Member)((Object)this.accessibleObject())).isSynthetic());
    }

    public RubyString to_string() {
        return this.getRuntime().newString(this.accessibleObject().toString());
    }
}

