/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaArrayUtilities;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.ClassProvider;

public class Java
implements Library {
    private static final ClassProvider JAVA_PACKAGE_CLASS_PROVIDER;
    private static final Map<String, Boolean> JAVA_PRIMITIVES;
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER;

    public void load(Ruby ruby, boolean bl) throws IOException {
        Java.createJavaModule(ruby);
        ruby.getLoadService().smartLoad("builtin/javasupport");
        RubyClassPathVariable.createClassPathVariable(ruby);
    }

    public static RubyModule createJavaModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Java");
        CallbackFactory callbackFactory = ruby.callbackFactory(Java.class);
        rubyModule.defineModuleFunction("define_exception_handler", callbackFactory.getOptSingletonMethod("define_exception_handler"));
        rubyModule.defineModuleFunction("primitive_to_java", callbackFactory.getSingletonMethod("primitive_to_java", IRubyObject.class));
        rubyModule.defineModuleFunction("java_to_primitive", callbackFactory.getSingletonMethod("java_to_primitive", IRubyObject.class));
        rubyModule.defineModuleFunction("java_to_ruby", callbackFactory.getSingletonMethod("java_to_ruby", IRubyObject.class));
        rubyModule.defineModuleFunction("ruby_to_java", callbackFactory.getSingletonMethod("ruby_to_java", IRubyObject.class));
        rubyModule.defineModuleFunction("new_proxy_instance", callbackFactory.getOptSingletonMethod("new_proxy_instance"));
        JavaObject.createJavaObjectClass(ruby, rubyModule);
        JavaArray.createJavaArrayClass(ruby, rubyModule);
        JavaClass.createJavaClassClass(ruby, rubyModule);
        JavaMethod.createJavaMethodClass(ruby, rubyModule);
        JavaConstructor.createJavaConstructorClass(ruby, rubyModule);
        JavaField.createJavaFieldClass(ruby, rubyModule);
        JavaProxyClass.createJavaProxyModule(ruby);
        RubyModule rubyModule2 = ruby.defineModule("JavaUtilities");
        rubyModule2.defineFastModuleFunction("wrap", callbackFactory.getFastSingletonMethod("wrap", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("valid_constant_name?", callbackFactory.getFastSingletonMethod("valid_constant_name_p", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("primitive_match", callbackFactory.getFastSingletonMethod("primitive_match", IRubyObject.class, IRubyObject.class));
        rubyModule2.defineFastModuleFunction("access", callbackFactory.getFastSingletonMethod("access", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("matching_method", callbackFactory.getFastSingletonMethod("matching_method", IRubyObject.class, IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_deprecated_interface_proxy", callbackFactory.getFastSingletonMethod("get_deprecated_interface_proxy", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_interface_module", callbackFactory.getFastSingletonMethod("get_interface_module", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_package_module", callbackFactory.getFastSingletonMethod("get_package_module", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_package_module_dot_format", callbackFactory.getFastSingletonMethod("get_package_module_dot_format", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_proxy_class", callbackFactory.getFastSingletonMethod("get_proxy_class", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("is_primitive_type", callbackFactory.getFastSingletonMethod("is_primitive_type", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("create_proxy_class", callbackFactory.getFastSingletonMethod("create_proxy_class", IRubyObject.class, IRubyObject.class, IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_java_class", callbackFactory.getFastSingletonMethod("get_java_class", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_top_level_proxy_or_package", callbackFactory.getFastSingletonMethod("get_top_level_proxy_or_package", IRubyObject.class));
        rubyModule2.defineFastModuleFunction("get_proxy_or_package_under_package", callbackFactory.getFastSingletonMethod("get_proxy_or_package_under_package", IRubyObject.class, IRubyObject.class));
        rubyModule2.defineFastModuleFunction("add_proxy_extender", callbackFactory.getFastSingletonMethod("add_proxy_extender", IRubyObject.class));
        ruby.getJavaSupport().setConcreteProxyCallback(callbackFactory.getFastSingletonMethod("concrete_proxy_inherited", IRubyObject.class));
        JavaArrayUtilities.createJavaArrayUtilitiesModule(ruby);
        RubyClass rubyClass = ruby.defineClass("JavaProxy", ruby.getObject(), ruby.getObject().getAllocator());
        rubyClass.getMetaClass().defineFastMethod("new_instance_for", callbackFactory.getFastSingletonMethod("new_instance_for", IRubyObject.class));
        rubyClass.getMetaClass().defineFastMethod("to_java_object", callbackFactory.getFastSingletonMethod("to_java_object"));
        return rubyModule;
    }

    public static IRubyObject is_primitive_type(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newBoolean(JAVA_PRIMITIVES.containsKey(iRubyObject2.asJavaString()));
    }

    public static IRubyObject create_proxy_class(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        if (!(iRubyObject4 instanceof RubyModule)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject4, iRubyObject.getRuntime().getModule());
        }
        return ((RubyModule)iRubyObject4).const_set(iRubyObject2, Java.get_proxy_class(iRubyObject, iRubyObject3));
    }

    public static IRubyObject get_java_class(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            return JavaClass.for_name(iRubyObject, iRubyObject2);
        }
        catch (Exception exception) {
            return iRubyObject.getRuntime().getNil();
        }
    }

    public static IRubyObject new_instance_for(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof JavaObject) {
            return Java.getInstance(((JavaObject)iRubyObject2).getValue(), (RubyClass)iRubyObject);
        }
        IRubyObject iRubyObject3 = ((RubyClass)iRubyObject).allocate();
        iRubyObject3.getInstanceVariables().fastSetInstanceVariable("@java_object", iRubyObject2);
        return iRubyObject3;
    }

    public static IRubyObject getInstance(Object object, RubyClass rubyClass) {
        return rubyClass.getRuntime().getJavaSupport().getObjectProxyCache().getOrCreate(object, rubyClass);
    }

    public static IRubyObject getInstance(Ruby ruby, Object object) {
        if (object != null) {
            return ruby.getJavaSupport().getObjectProxyCache().getOrCreate(object, (RubyClass)Java.getProxyClass(ruby, JavaClass.get(ruby, object.getClass())));
        }
        return ruby.getNil();
    }

    public static IRubyObject to_java_object(IRubyObject iRubyObject) {
        return iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_class");
    }

    @Deprecated
    public static IRubyObject add_proxy_extender(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "JavaUtilities.add_proxy_extender is deprecated - use JavaUtilities.extend_proxy instead", "add_proxy_extender", "JavaUtilities.extend_proxy");
        IRubyObject iRubyObject3 = iRubyObject2.getInstanceVariables().fastGetInstanceVariable("@java_class");
        if (!(iRubyObject3 instanceof JavaClass)) {
            throw iRubyObject.getRuntime().newArgumentError("extender does not have a valid @java_class");
        }
        ((JavaClass)iRubyObject3).addProxyExtender(iRubyObject2);
        return iRubyObject.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getInterfaceModule(Ruby ruby, JavaClass javaClass) {
        if (!javaClass.javaClass().isInterface()) {
            throw ruby.newArgumentError(javaClass.toString() + " is not an interface");
        }
        RubyModule rubyModule = javaClass.getProxyModule();
        if (rubyModule != null) {
            return rubyModule;
        }
        javaClass.lockProxy();
        try {
            rubyModule = javaClass.getProxyModule();
            if (rubyModule == null) {
                rubyModule = (RubyModule)ruby.getJavaSupport().getJavaInterfaceTemplate().dup();
                rubyModule.fastSetInstanceVariable("@java_class", javaClass);
                Java.addToJavaPackageModule(rubyModule, javaClass);
                javaClass.setupInterfaceModule(rubyModule);
                Class<?>[] classArray = javaClass.javaClass().getInterfaces();
                int n = classArray.length;
                while (--n >= 0) {
                    JavaClass javaClass2 = JavaClass.get(ruby, classArray[n]);
                    RubyModule rubyModule2 = Java.getInterfaceModule(ruby, javaClass2);
                    rubyModule.includeModule(rubyModule2);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return rubyModule;
    }

    public static IRubyObject get_interface_module(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject2 instanceof RubyString) {
            javaClass = JavaClass.for_name(iRubyObject, iRubyObject2);
        } else if (iRubyObject2 instanceof JavaClass) {
            javaClass = (JavaClass)iRubyObject2;
        } else {
            throw ruby.newArgumentError("expected JavaClass, got " + iRubyObject2);
        }
        return Java.getInterfaceModule(ruby, javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject get_deprecated_interface_proxy(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject2 instanceof RubyString) {
            javaClass = JavaClass.for_name(iRubyObject, iRubyObject2);
        } else if (iRubyObject2 instanceof JavaClass) {
            javaClass = (JavaClass)iRubyObject2;
        } else {
            throw ruby.newArgumentError("expected JavaClass, got " + iRubyObject2);
        }
        if (!javaClass.javaClass().isInterface()) {
            throw ruby.newArgumentError("expected Java interface class, got " + iRubyObject2);
        }
        RubyClass rubyClass = javaClass.getProxyClass();
        if (rubyClass != null) {
            return rubyClass;
        }
        javaClass.lockProxy();
        try {
            rubyClass = javaClass.getProxyClass();
            if (rubyClass == null) {
                RubyModule rubyModule = Java.getInterfaceModule(ruby, javaClass);
                RubyClass rubyClass2 = ruby.fastGetClass("InterfaceJavaProxy");
                rubyClass = RubyClass.newClass(ruby, rubyClass2);
                rubyClass.setAllocator(rubyClass2.getAllocator());
                rubyClass.makeMetaClass(rubyClass2.getMetaClass());
                rubyClass.inherit(rubyClass2);
                rubyClass.callMethod(iRubyObject.getRuntime().getCurrentContext(), "java_class=", javaClass);
                rubyClass.includeModule(rubyModule);
                javaClass.setupProxy(rubyClass);
                if (rubyClass.fastGetConstantAt("Includable") == null) {
                    rubyClass.fastSetConstant("Includable", rubyModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getProxyClass(Ruby ruby, JavaClass javaClass) {
        Class clazz = javaClass.javaClass();
        if (clazz.isInterface()) {
            return Java.getInterfaceModule(ruby, javaClass);
        }
        RubyClass rubyClass = javaClass.getProxyClass();
        if (rubyClass != null) {
            return rubyClass;
        }
        javaClass.lockProxy();
        try {
            rubyClass = javaClass.getProxyClass();
            if (rubyClass == null) {
                if (clazz.isArray()) {
                    rubyClass = Java.createProxyClass(ruby, ruby.getJavaSupport().getArrayProxyClass(), javaClass, true);
                } else if (clazz.isPrimitive()) {
                    rubyClass = Java.createProxyClass(ruby, ruby.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                } else if (clazz == Object.class) {
                    rubyClass = Java.createProxyClass(ruby, ruby.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                    rubyClass.getMetaClass().defineFastMethod("inherited", ruby.getJavaSupport().getConcreteProxyCallback());
                    Java.addToJavaPackageModule(rubyClass, javaClass);
                } else {
                    rubyClass = Java.createProxyClass(ruby, (RubyClass)Java.getProxyClass(ruby, JavaClass.get(ruby, clazz.getSuperclass())), javaClass, false);
                    Class<?>[] classArray = clazz.getInterfaces();
                    int n = classArray.length;
                    while (--n >= 0) {
                        JavaClass javaClass2 = JavaClass.get(ruby, classArray[n]);
                        rubyClass.includeModule(Java.getInterfaceModule(ruby, javaClass2));
                    }
                    if (Modifier.isPublic(clazz.getModifiers())) {
                        Java.addToJavaPackageModule(rubyClass, javaClass);
                    }
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return rubyClass;
    }

    public static IRubyObject get_proxy_class(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject2 instanceof RubyString) {
            javaClass = JavaClass.for_name(iRubyObject, iRubyObject2);
        } else if (iRubyObject2 instanceof JavaClass) {
            javaClass = (JavaClass)iRubyObject2;
        } else {
            throw ruby.newTypeError(iRubyObject2, ruby.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(ruby, javaClass);
    }

    private static RubyClass createProxyClass(Ruby ruby, RubyClass rubyClass, JavaClass javaClass, boolean bl) {
        RubyClass.checkInheritable(rubyClass);
        RubyClass rubyClass2 = rubyClass;
        RubyClass rubyClass3 = RubyClass.newClass(ruby, rubyClass2);
        rubyClass3.makeMetaClass(rubyClass2.getMetaClass());
        rubyClass3.setAllocator(rubyClass2.getAllocator());
        if (bl) {
            rubyClass3.inherit(rubyClass2);
        }
        rubyClass3.callMethod(ruby.getCurrentContext(), "java_class=", javaClass);
        javaClass.setupProxy(rubyClass3);
        return rubyClass3;
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        JavaSupport javaSupport = ruby.getJavaSupport();
        RubyClass rubyClass = javaSupport.getJavaProxyClass().getMetaClass();
        RuntimeHelpers.invokeAs(threadContext, rubyClass, iRubyObject, "inherited", new IRubyObject[]{iRubyObject2}, CallType.SUPER, Block.NULL_BLOCK);
        return javaSupport.getJavaUtilitiesModule().callMethod(threadContext, "setup_java_subclass", new IRubyObject[]{iRubyObject2, iRubyObject.callMethod(threadContext, "java_class")});
    }

    private static void addToJavaPackageModule(RubyModule rubyModule, JavaClass javaClass) {
        String string;
        String string2;
        Class clazz = javaClass.javaClass();
        String string3 = clazz.getName();
        if (string3 == null) {
            return;
        }
        int n = string3.lastIndexOf(46);
        if (string3.indexOf(36) != -1 || !Character.isUpperCase(string3.charAt(n + 1))) {
            return;
        }
        Ruby ruby = rubyModule.getRuntime();
        RubyModule rubyModule2 = Java.getJavaPackageModule(ruby, string2 = n < 0 ? "" : string3.substring(0, n));
        if (rubyModule2 != null && rubyModule2.getConstantAt(string = string3.substring(n + 1)) == null) {
            rubyModule2.const_set(ruby.newSymbol(string), rubyModule);
        }
    }

    private static RubyModule getJavaPackageModule(Ruby ruby, String string) {
        Serializable serializable;
        String string2;
        int n = string.length();
        if (n == 0) {
            string2 = "Default";
        } else {
            serializable = new StringBuffer();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                n3 = string.indexOf(46, n2);
                if (n3 == -1) {
                    n3 = n;
                }
                ((StringBuffer)serializable).append(Character.toUpperCase(string.charAt(n2))).append(string.substring(n2 + 1, n3));
                n2 = n3 + 1;
            }
            string2 = ((StringBuffer)serializable).toString();
        }
        serializable = ruby.getJavaSupport().getJavaModule();
        IRubyObject iRubyObject = ((RubyModule)serializable).getConstantAt(string2);
        if (iRubyObject == null) {
            return Java.createPackageModule((RubyModule)serializable, string2, string);
        }
        if (iRubyObject instanceof RubyModule) {
            return (RubyModule)iRubyObject;
        }
        return null;
    }

    private static RubyModule createPackageModule(RubyModule rubyModule, String string, String string2) {
        Ruby ruby = rubyModule.getRuntime();
        RubyModule rubyModule2 = (RubyModule)ruby.getJavaSupport().getPackageModuleTemplate().dup();
        rubyModule2.fastSetInstanceVariable("@package_name", ruby.newString(string2.length() > 0 ? string2 + '.' : string2));
        rubyModule2.addClassProvider(JAVA_PACKAGE_CLASS_PROVIDER);
        rubyModule.const_set(ruby.newSymbol(string), rubyModule2);
        MetaClass metaClass = (MetaClass)rubyModule2.getMetaClass();
        metaClass.setAttached(rubyModule2);
        return rubyModule2;
    }

    public static RubyModule getPackageModule(Ruby ruby, String string) {
        String string2;
        RubyModule rubyModule = ruby.getJavaSupport().getJavaModule();
        IRubyObject iRubyObject = rubyModule.getConstantAt(string);
        if (iRubyObject instanceof RubyModule) {
            return (RubyModule)iRubyObject;
        }
        if ("Default".equals(string)) {
            string2 = "";
        } else {
            Matcher matcher = CAMEL_CASE_PACKAGE_SPLITTER.matcher(string);
            string2 = matcher.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(rubyModule, string, string2);
    }

    public static IRubyObject get_package_module(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.getPackageModule(iRubyObject.getRuntime(), iRubyObject2.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyModule rubyModule = Java.getJavaPackageModule(ruby, iRubyObject2.asJavaString());
        return rubyModule == null ? ruby.getNil() : rubyModule;
    }

    public static RubyModule getProxyOrPackageUnderPackage(final Ruby ruby, RubyModule rubyModule, String string) {
        IRubyObject iRubyObject = rubyModule.fastGetInstanceVariable("@package_name");
        if (iRubyObject == null) {
            throw ruby.newArgumentError("invalid package module");
        }
        String string2 = iRubyObject.asJavaString();
        String string3 = string.trim().intern();
        if (string3.length() == 0) {
            throw ruby.newArgumentError("empty class or package name");
        }
        String string4 = string2 + string3;
        if (Character.isLowerCase(string3.charAt(0))) {
            Object object;
            if (JAVA_PRIMITIVES.containsKey(string3)) {
                throw ruby.newArgumentError("illegal package name component: " + string3);
            }
            try {
                return Java.getProxyClass(ruby, JavaClass.forNameQuiet(ruby, string4));
            }
            catch (RaiseException raiseException) {
                object = raiseException.getException();
                if (((RubyObject)object).kind_of_p(ruby.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(ruby, ruby.getNil());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            RubyModule rubyModule2 = Java.getJavaPackageModule(ruby, string4);
            if (rubyModule2 == null) {
                return null;
            }
            object = ("@__pkg__" + string3).intern();
            rubyModule.fastSetInstanceVariable((String)object, rubyModule2);
            RubyClass rubyClass = rubyModule.getSingletonClass();
            rubyClass.addMethod(string3, new org.jruby.internal.runtime.methods.JavaMethod(rubyClass, Visibility.PUBLIC, (String)object){
                final /* synthetic */ String val$ivarName;
                {
                    this.val$ivarName = string;
                    super(rubyModule, visibility);
                }

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    IRubyObject iRubyObject2;
                    if (iRubyObjectArray.length != 0) {
                        Arity.raiseArgumentError(ruby, iRubyObjectArray.length, 0, 0);
                    }
                    if ((iRubyObject2 = ((RubyModule)iRubyObject).fastGetInstanceVariable(this.val$ivarName)) != null) {
                        return iRubyObject2;
                    }
                    return ruby.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return rubyModule2;
        }
        return Java.getProxyClass(ruby, JavaClass.forNameVerbose(ruby, string4));
    }

    public static IRubyObject get_proxy_or_package_under_package(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        if (!(iRubyObject2 instanceof RubyModule)) {
            throw ruby.newTypeError(iRubyObject2, ruby.getModule());
        }
        RubyModule rubyModule = Java.getProxyOrPackageUnderPackage(ruby, (RubyModule)iRubyObject2, iRubyObject3.asJavaString());
        if (rubyModule != null) {
            return rubyModule;
        }
        return ruby.getNil();
    }

    public static RubyModule getTopLevelProxyOrPackage(final Ruby ruby, String string) {
        String string2 = string.trim().intern();
        if (string2.length() == 0) {
            throw ruby.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(string2.charAt(0))) {
            RubyObject rubyObject;
            try {
                return Java.getProxyClass(ruby, JavaClass.forNameQuiet(ruby, string2));
            }
            catch (RaiseException raiseException) {
                rubyObject = raiseException.getException();
                if (rubyObject.kind_of_p(ruby.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(ruby, ruby.getNil());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            RubyModule rubyModule = Java.getJavaPackageModule(ruby, string2);
            if (rubyModule == null) {
                return null;
            }
            rubyObject = ruby.getJavaSupport().getJavaModule();
            if (rubyObject.getMetaClass().isMethodBound(string2, false)) {
                return rubyModule;
            }
            final String string3 = ("@__pkg__" + string2).intern();
            rubyObject.fastSetInstanceVariable(string3, rubyModule);
            RubyClass rubyClass = rubyObject.getSingletonClass();
            rubyClass.addMethod(string2, new org.jruby.internal.runtime.methods.JavaMethod(rubyClass, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    IRubyObject iRubyObject2;
                    if (iRubyObjectArray.length != 0) {
                        Arity.raiseArgumentError(ruby, iRubyObjectArray.length, 0, 0);
                    }
                    if ((iRubyObject2 = ((RubyModule)iRubyObject).fastGetInstanceVariable(string3)) != null) {
                        return iRubyObject2;
                    }
                    return ruby.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return rubyModule;
        }
        try {
            return Java.getProxyClass(ruby, JavaClass.forNameQuiet(ruby, string2));
        }
        catch (RaiseException raiseException) {
            RubyException rubyException = raiseException.getException();
            if (rubyException.kind_of_p(ruby.getStandardError()).isTrue()) {
                RuntimeHelpers.setErrorInfo(ruby, ruby.getNil());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Java.getPackageModule(ruby, string2);
    }

    public static IRubyObject get_top_level_proxy_or_package(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyModule rubyModule = Java.getTopLevelProxyOrPackage(ruby, iRubyObject2.asJavaString());
        if (rubyModule != null) {
            return rubyModule;
        }
        return ruby.getNil();
    }

    public static IRubyObject matching_method(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Map map = iRubyObject.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arrayList = new ArrayList();
        int n = ((RubyArray)iRubyObject3).getLength();
        IRubyObject[] iRubyObjectArray = ((RubyArray)iRubyObject3).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < n; ++i) {
            if (iRubyObjectArray[i] instanceof JavaObject) {
                arrayList.add(((JavaClass)((JavaObject)iRubyObjectArray[i]).java_class()).javaClass());
                continue;
            }
            arrayList.add(iRubyObjectArray[i].getClass());
        }
        HashMap hashMap = (HashMap)map.get(iRubyObject2);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(iRubyObject2, hashMap);
        } else {
            IRubyObject iRubyObject4 = (IRubyObject)hashMap.get(arrayList);
            if (iRubyObject4 != null) {
                return iRubyObject4;
            }
        }
        int n2 = ((RubyArray)iRubyObject2).getLength();
        IRubyObject[] iRubyObjectArray2 = ((RubyArray)iRubyObject2).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < n2; ++j) {
                IRubyObject iRubyObject5 = iRubyObjectArray2[j];
                List<Class<?>> list = Arrays.asList(((ParameterTypes)((Object)iRubyObject5)).getParameterTypes());
                if (arrayList.size() != list.size()) continue;
                if (((Object)list).equals(arrayList)) {
                    hashMap.put(arrayList, iRubyObject5);
                    return iRubyObject5;
                }
                boolean bl = true;
                for (int k = 0; k < list.size(); ++k) {
                    if (JavaClass.assignable(list.get(k), (Class)arrayList.get(k)) && (i > 0 || Java.primitive_match(list.get(k), arrayList.get(k))) || JavaUtil.isDuckTypeConvertable((Class)arrayList.get(k), list.get(k))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                hashMap.put(arrayList, iRubyObject5);
                return iRubyObject5;
            }
        }
        IRubyObject iRubyObject6 = iRubyObjectArray2[0];
        if (iRubyObject6 instanceof JavaConstructor || iRubyObject6 instanceof JavaProxyConstructor) {
            throw iRubyObject.getRuntime().newNameError("no constructor with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
        }
        throw iRubyObject.getRuntime().newNameError("no " + ((JavaMethod)iRubyObject6).name() + " with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
    }

    public static IRubyObject matching_method_internal(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject[] iRubyObjectArray, int n, int n2) {
        int n3;
        int n4;
        Class<?>[] classArray;
        IRubyObject iRubyObject3;
        int n5;
        Map map = iRubyObject.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arrayList = new ArrayList();
        int n6 = n + n2;
        for (int i = n; i < n6; ++i) {
            if (iRubyObjectArray[i] instanceof JavaObject) {
                arrayList.add(((JavaClass)((JavaObject)iRubyObjectArray[i]).java_class()).javaClass());
                continue;
            }
            arrayList.add(iRubyObjectArray[i].getClass());
        }
        HashMap hashMap = (HashMap)map.get(iRubyObject2);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(iRubyObject2, hashMap);
        } else {
            IRubyObject iRubyObject4 = (IRubyObject)hashMap.get(arrayList);
            if (iRubyObject4 != null) {
                return iRubyObject4;
            }
        }
        int n7 = ((RubyArray)iRubyObject2).getLength();
        IRubyObject[] iRubyObjectArray2 = ((RubyArray)iRubyObject2).toJavaArrayMaybeUnsafe();
        block1: for (n5 = 0; n5 < n7; ++n5) {
            iRubyObject3 = iRubyObjectArray2[n5];
            classArray = ((ParameterTypes)((Object)iRubyObject3)).getParameterTypes();
            if (n2 != classArray.length) continue;
            n4 = 1;
            int n8 = n2;
            for (n3 = 0; n3 < n8; ++n3) {
                if (classArray[n3].equals(arrayList.get(n3))) continue;
                n4 = 0;
                break;
            }
            if (n4 != 0) {
                hashMap.put(arrayList, iRubyObject3);
                return iRubyObject3;
            }
            n8 = n2;
            for (n3 = 0; n3 < n8; ++n3) {
                if (!JavaClass.assignable(classArray[n3], (Class)arrayList.get(n3)) || !Java.primitive_match(classArray[n3], arrayList.get(n3))) continue block1;
            }
            hashMap.put(arrayList, iRubyObject3);
            return iRubyObject3;
        }
        block4: for (n5 = 0; n5 < n7; ++n5) {
            iRubyObject3 = iRubyObjectArray2[n5];
            classArray = ((ParameterTypes)((Object)iRubyObject3)).getParameterTypes();
            if (n2 != classArray.length) continue;
            n3 = n2;
            for (n4 = 0; n4 < n3; ++n4) {
                if (!JavaClass.assignable(classArray[n4], (Class)arrayList.get(n4)) && !JavaUtil.isDuckTypeConvertable((Class)arrayList.get(n4), classArray[n4])) continue block4;
            }
            hashMap.put(arrayList, iRubyObject3);
            return iRubyObject3;
        }
        IRubyObject iRubyObject5 = iRubyObjectArray2[0];
        if (iRubyObject5 instanceof JavaConstructor || iRubyObject5 instanceof JavaProxyConstructor) {
            throw iRubyObject.getRuntime().newNameError("no constructor with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
        }
        throw iRubyObject.getRuntime().newNameError("no " + ((JavaMethod)iRubyObject5).name() + " with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
    }

    public static IRubyObject access(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = ((JavaClass)iRubyObject2).javaClass().getModifiers();
        return iRubyObject.getRuntime().newString(Modifier.isPublic(n) ? "public" : (Modifier.isProtected(n) ? "protected" : "private"));
    }

    public static IRubyObject valid_constant_name_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getByteList().length() == 0) {
            return iRubyObject.getRuntime().getFalse();
        }
        return Character.isUpperCase(rubyString.getByteList().charAt(0)) ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
    }

    public static boolean primitive_match(Object object, Object object2) {
        if (((Class)object).isPrimitive()) {
            if (object == Integer.TYPE || object == Long.TYPE || object == Short.TYPE || object == Character.TYPE) {
                return object2 == Integer.class || object2 == Long.class || object2 == Short.class || object2 == Character.class;
            }
            if (object == Float.TYPE || object == Double.TYPE) {
                return object2 == Float.class || object2 == Double.class;
            }
            if (object == Boolean.TYPE) {
                return object2 == Boolean.class;
            }
            return false;
        }
        return true;
    }

    public static IRubyObject primitive_match(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (((JavaClass)iRubyObject2).primitive_p().isTrue()) {
            Object object;
            Object object2 = ((JavaObject)iRubyObject2).getValue();
            return Java.primitive_match(object2, object = ((JavaObject)iRubyObject3).getValue()) ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
        }
        return iRubyObject.getRuntime().getTrue();
    }

    public static IRubyObject wrap(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.getInstance(iRubyObject.getRuntime(), ((JavaObject)iRubyObject2).getValue());
    }

    public static IRubyObject wrap(Ruby ruby, IRubyObject iRubyObject) {
        return Java.getInstance(ruby, ((JavaObject)iRubyObject).getValue());
    }

    public static IRubyObject define_exception_handler(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string = iRubyObjectArray[0].toString();
        RubyProc rubyProc = null;
        rubyProc = iRubyObjectArray.length > 1 ? (RubyProc)iRubyObjectArray[1] : iRubyObject.getRuntime().newProc(Block.Type.PROC, block);
        iRubyObject.getRuntime().getJavaSupport().defineExceptionHandler(string, rubyProc);
        return iRubyObject;
    }

    public static IRubyObject primitive_to_java(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Object object;
        if (iRubyObject2 instanceof JavaObject) {
            return iRubyObject2;
        }
        Ruby ruby = iRubyObject.getRuntime();
        switch (iRubyObject2.getMetaClass().index) {
            case 5: {
                object = null;
                break;
            }
            case 1: {
                object = new Long(((RubyFixnum)iRubyObject2).getLongValue());
                break;
            }
            case 2: {
                object = ((RubyBignum)iRubyObject2).getValue();
                break;
            }
            case 11: {
                object = new Double(((RubyFloat)iRubyObject2).getValue());
                break;
            }
            case 4: {
                try {
                    ByteList byteList = ((RubyString)iRubyObject2).getByteList();
                    object = new String(byteList.unsafeBytes(), byteList.begin(), byteList.length(), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = iRubyObject2.toString();
                }
                break;
            }
            case 6: {
                object = Boolean.TRUE;
                break;
            }
            case 7: {
                object = Boolean.FALSE;
                break;
            }
            default: {
                object = iRubyObject2 instanceof RubyTime ? ((RubyTime)iRubyObject2).getJavaDate() : iRubyObject2;
            }
        }
        return JavaObject.wrap(ruby, object);
    }

    public static IRubyObject java_to_ruby(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2 instanceof JavaObject) {
            return JavaUtil.convertJavaToUsableRubyObject(iRubyObject.getRuntime(), ((JavaObject)iRubyObject2).getValue());
        }
        return iRubyObject2;
    }

    public static IRubyObject ruby_to_java(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2.respondsTo("to_java_object")) {
            IRubyObject iRubyObject3 = iRubyObject2.getInstanceVariables().fastGetInstanceVariable("@java_object");
            if (iRubyObject3 == null) {
                iRubyObject3 = iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "to_java_object");
            }
            if (iRubyObject3 instanceof JavaObject) {
                iRubyObject.getRuntime().getJavaSupport().getObjectProxyCache().put(((JavaObject)iRubyObject3).getValue(), iRubyObject2);
            }
            return iRubyObject3;
        }
        return Java.primitive_to_java(iRubyObject, iRubyObject2, block);
    }

    public static IRubyObject java_to_primitive(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2 instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(iRubyObject.getRuntime(), ((JavaObject)iRubyObject2).getValue());
        }
        return iRubyObject2;
    }

    public static IRubyObject new_proxy_instance(final IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyProc rubyProc;
        int n = Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, -1) - 1;
        if (iRubyObjectArray[n] instanceof RubyProc) {
            rubyProc = (RubyProc)iRubyObjectArray[n];
        } else {
            rubyProc = iRubyObject.getRuntime().newProc(Block.Type.PROC, block);
            ++n;
        }
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            if (!(iRubyObjectArray[i] instanceof JavaClass) || !((JavaClass)iRubyObjectArray[i]).interface_p().isTrue()) {
                throw iRubyObject.getRuntime().newArgumentError("Java interface expected. got: " + iRubyObjectArray[i]);
            }
            classArray[i] = ((JavaClass)iRubyObjectArray[i]).javaClass();
        }
        return JavaObject.wrap(iRubyObject.getRuntime(), Proxy.newProxyInstance(iRubyObject.getRuntime().getJRubyClassLoader(), classArray, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                Class[] classArray = (Class[])this.parameterTypeCache.get(method);
                if (classArray == null) {
                    classArray = method.getParameterTypes();
                    this.parameterTypeCache.put(method, classArray);
                }
                int n = classArray.length;
                String string = method.getName();
                if (string.equals("toString") && n == 0) {
                    return object.getClass().getName();
                }
                if (string.equals("hashCode") && n == 0) {
                    return new Integer(object.getClass().hashCode());
                }
                if (string.equals("equals") && n == 1 && classArray[0].equals(Object.class)) {
                    return object == objectArray[0];
                }
                Ruby ruby = iRubyObject.getRuntime();
                int n2 = objectArray == null ? 0 : objectArray.length;
                IRubyObject[] iRubyObjectArray = new IRubyObject[n2 + 2];
                iRubyObjectArray[0] = JavaObject.wrap(ruby, object);
                iRubyObjectArray[1] = new JavaMethod(ruby, method);
                for (int i = 0; i < n2; ++i) {
                    iRubyObjectArray[i + 2] = JavaObject.wrap(ruby, objectArray[i]);
                }
                return JavaUtil.convertArgument(ruby, rubyProc.call(ruby.getCurrentContext(), iRubyObjectArray), method.getReturnType());
            }
        }));
    }

    static {
        String[] stringArray;
        JAVA_PACKAGE_CLASS_PROVIDER = new ClassProvider(){

            public RubyClass defineClassUnder(RubyModule rubyModule, String string, RubyClass rubyClass) {
                if (rubyClass != null) {
                    return null;
                }
                IRubyObject iRubyObject = rubyModule.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (iRubyObject == null) {
                    return null;
                }
                Ruby ruby = rubyModule.getRuntime();
                return (RubyClass)Java.get_proxy_class(ruby.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(ruby, iRubyObject.asJavaString() + string));
            }

            public RubyModule defineModuleUnder(RubyModule rubyModule, String string) {
                IRubyObject iRubyObject = rubyModule.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (iRubyObject == null) {
                    return null;
                }
                Ruby ruby = rubyModule.getRuntime();
                return (RubyModule)Java.get_interface_module(ruby.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(ruby, iRubyObject.asJavaString() + string));
            }
        };
        JAVA_PRIMITIVES = new HashMap<String, Boolean>();
        for (String string : stringArray = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"}) {
            JAVA_PRIMITIVES.put(string, Boolean.TRUE);
        }
        CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
    }
}

