/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Visibility;

public class ReflectionMethodFactory
extends MethodFactory {
    public DynamicMethod getCompiledMethod(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        try {
            Method method = object.getClass().getMethod(string, COMPILED_METHOD_PARAMS);
            return new ReflectedCompiledMethod(rubyModule, arity, visibility, staticScope, object, method, callConfiguration);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("No method with name " + string + " found in " + object.getClass());
        }
    }

    public DynamicMethod getAnnotatedMethod(RubyModule rubyModule, Method method) {
        JRubyMethod jRubyMethod = method.getAnnotation(JRubyMethod.class);
        ReflectedJavaMethod reflectedJavaMethod = new ReflectedJavaMethod(rubyModule, method, jRubyMethod);
        reflectedJavaMethod.setJavaName(method.getName());
        reflectedJavaMethod.setArgumentTypes(method.getParameterTypes());
        reflectedJavaMethod.setSingleton(Modifier.isStatic(method.getModifiers()));
        reflectedJavaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(jRubyMethod));
        return reflectedJavaMethod;
    }

    public void defineIndexedAnnotatedMethods(RubyModule rubyModule, Class clazz, MethodFactory.MethodDefiningCallback methodDefiningCallback) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            JRubyMethod jRubyMethod = method.getAnnotation(JRubyMethod.class);
            if (jRubyMethod == null) continue;
            methodDefiningCallback.define(rubyModule, method, this.getAnnotatedMethod(rubyModule, method));
        }
    }
}

