/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule rubyModule, Arity arity, Visibility visibility, StaticScope staticScope, Object object, Method method, CallConfiguration callConfiguration) {
        super(rubyModule, arity, visibility, staticScope, object, callConfiguration);
        this.method = method;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, boolean bl, Block block) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        this.callConfig.pre(threadContext, iRubyObject, this.getImplementationClass(), this.arity, string, iRubyObjectArray, block, this.staticScope, this);
        Ruby ruby = threadContext.getRuntime();
        try {
            try {
                IRubyObject iRubyObject2;
                block12: {
                    boolean bl = ruby.hasEventHooks();
                    try {
                        if (bl) {
                            ruby.callEventHooks(threadContext, 3, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                        }
                        iRubyObject2 = (IRubyObject)this.method.invoke(this.$scriptObject, threadContext, iRubyObject, iRubyObjectArray, block);
                        Object var11_14 = null;
                        if (!bl) break block12;
                        Frame frame = threadContext.getPreviousFrame();
                        ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (!bl) throw throwable;
                        Frame frame = threadContext.getPreviousFrame();
                        ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
                        throw throwable;
                    }
                }
                Object var14_19 = null;
                this.callConfig.post(threadContext);
                return iRubyObject2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw RaiseException.createNativeRaiseException(ruby, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw RaiseException.createNativeRaiseException(ruby, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof JumpException.ReturnJump) {
                    JumpException.FlowControlException flowControlException = (JumpException.FlowControlException)throwable;
                    if (flowControlException.getTarget() != this) throw flowControlException;
                    IRubyObject iRubyObject3 = (IRubyObject)flowControlException.getValue();
                    Object var14_20 = null;
                    this.callConfig.post(threadContext);
                    return iRubyObject3;
                }
                if (throwable instanceof JumpException.RedoJump) {
                    throw ruby.newLocalJumpError("redo", ruby.getNil(), "unexpected redo");
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof Error)) throw RaiseException.createNativeRaiseException(ruby, throwable);
                throw (Error)throwable;
            }
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            this.callConfig.post(threadContext);
            throw throwable;
        }
    }
}

