/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaMethod
extends DynamicMethod
implements JumpTarget,
Cloneable {
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes;
    private String javaName;
    private boolean isSingleton;
    protected final int methodIndex;
    protected final StaticScope staticScope;

    public JavaMethod(RubyModule rubyModule, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_ONLY);
        this.methodIndex = -1;
        this.staticScope = null;
    }

    public JavaMethod(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
        super(rubyModule, visibility, callConfiguration);
        this.methodIndex = -1;
        this.staticScope = staticScope;
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    public JavaMethod(RubyModule rubyModule, Visibility visibility, int n) {
        super(rubyModule, visibility, CallConfiguration.FRAME_ONLY);
        this.methodIndex = n;
        this.staticScope = null;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public DynamicMethod dup() {
        try {
            JavaMethod javaMethod = (JavaMethod)this.clone();
            return javaMethod;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void pre(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, Block block) {
        this.callConfig.pre(threadContext, iRubyObject, this.getImplementationClass(), this.arity, string, iRubyObjectArray, block, this.staticScope, this);
    }

    protected void post(ThreadContext threadContext) {
        this.callConfig.post(threadContext);
    }

    protected IRubyObject handleReturnJump(JumpException.ReturnJump returnJump) {
        if (returnJump.getTarget() == this) {
            return (IRubyObject)returnJump.getValue();
        }
        throw returnJump;
    }

    public void setArity(Arity arity) {
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    public Arity getArity() {
        return this.arity;
    }

    public void setArgumentTypes(Class[] classArray) {
        this.argumentTypes = classArray;
    }

    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean bl) {
        this.isSingleton = bl;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isNative() {
        return true;
    }

    public static abstract class JavaMethodThreeBlock
    extends JavaMethod {
        public JavaMethodThreeBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodThreeBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodThreeBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 3) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
        }
    }

    public static abstract class JavaMethodThree
    extends JavaMethod {
        public JavaMethodThree(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodThree(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodThree(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 3) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
        }
    }

    public static abstract class JavaMethodTwoBlock
    extends JavaMethod {
        public JavaMethodTwoBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodTwoBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodTwoBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 2) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], block);
        }
    }

    public static abstract class JavaMethodTwo
    extends JavaMethod {
        public JavaMethodTwo(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodTwo(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodTwo(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 2) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
        }
    }

    public static abstract class JavaMethodOneBlock
    extends JavaMethod {
        public JavaMethodOneBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOneBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOneBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 1) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
        }
    }

    public static abstract class JavaMethodOne
    extends JavaMethod {
        public JavaMethodOne(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOne(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOne(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 1) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
        }
    }

    public static abstract class JavaMethodZeroBlock
    extends JavaMethod {
        public JavaMethodZeroBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 0) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, block);
        }
    }

    public static abstract class JavaMethodZero
    extends JavaMethod {
        public JavaMethodZero(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZero(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZero(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 0) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string);
        }
    }

    public static abstract class JavaMethodNoBlock
    extends JavaMethod {
        public JavaMethodNoBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodNoBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodNoBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray);
        }
    }
}

