/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import org.jruby.ext.posix.BaseNativeFileStat;
import org.jruby.ext.posix.POSIX;

public class WindowsFileStat
extends BaseNativeFileStat {
    public int st_dev;
    public short st_ino;
    public short st_mode;
    public short st_nlink;
    public short st_uid;
    public short st_gid;
    public int st_rdev;
    public int st_size;
    public int st_atime;
    public int st_mtime;
    public int st_ctime;
    public int nothing6;
    public int nothing7;

    public WindowsFileStat(POSIX pOSIX) {
        super(pOSIX);
    }

    public long atime() {
        return this.st_atime;
    }

    public long blockSize() {
        return 0L;
    }

    public long blocks() {
        return 0L;
    }

    public long ctime() {
        return this.st_ctime;
    }

    public long dev() {
        return this.st_dev;
    }

    public int gid() {
        return this.st_gid;
    }

    public int ino() {
        return this.st_ino;
    }

    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    public long mtime() {
        return this.st_mtime;
    }

    public int nlink() {
        return this.st_nlink;
    }

    public long rdev() {
        return this.st_rdev;
    }

    public long st_size() {
        return this.st_size;
    }

    public int uid() {
        return this.st_uid;
    }

    public boolean groupMember(int n) {
        return true;
    }

    public boolean isExecutable() {
        if (this.isOwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) == 0;
    }

    public boolean isExecutableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) == 0;
    }

    public boolean isOwned() {
        return true;
    }

    public boolean isROwned() {
        return true;
    }

    public boolean isReadable() {
        if (this.isOwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) == 0;
    }

    public boolean isReadableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) == 0;
    }

    public boolean isWritable() {
        if (this.isOwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) == 0;
    }

    public boolean isWritableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) == 0;
    }

    public String toString() {
        return "st_dev: " + this.st_dev + ", st_mode: " + Integer.toOctalString(this.st_mode) + ", st_nlink: " + this.st_nlink + ", st_rdev: " + this.st_rdev + ", st_size: " + this.st_size + ", st_uid: " + this.st_uid + ", st_gid: " + this.st_gid + ", st_atime: " + this.st_atime + ", st_ctime: " + this.st_ctime + ", st_mtime: " + this.st_mtime + ", st_ino: " + this.st_ino;
    }
}

