/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.Native;
import java.util.HashMap;
import org.jruby.ext.posix.JavaPOSIX;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.LinuxPOSIX;
import org.jruby.ext.posix.MacOSPOSIX;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.SolarisPOSIX;
import org.jruby.ext.posix.WindowsLibCFunctionMapper;
import org.jruby.ext.posix.WindowsPOSIX;
import org.jruby.ext.posix.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSIXFactory {
    static final String LIBC = "c";
    static LibC libc = null;

    public static POSIX getPOSIX(POSIXHandler pOSIXHandler, boolean bl) {
        POSIX pOSIX;
        block14: {
            pOSIX = null;
            if (bl && Platform.IS_32_BIT) {
                try {
                    if (Platform.IS_MAC) {
                        pOSIX = POSIXFactory.loadMacOSPOSIX(pOSIXHandler);
                    } else if (Platform.IS_LINUX) {
                        pOSIX = POSIXFactory.loadLinuxPOSIX(pOSIXHandler);
                    } else if (Platform.IS_WINDOWS) {
                        pOSIX = POSIXFactory.loadWindowsPOSIX(pOSIXHandler);
                    } else if (Platform.IS_SOLARIS) {
                        pOSIX = POSIXFactory.loadSolarisPOSIX(pOSIXHandler);
                    }
                    if (pOSIXHandler.isVerbose()) {
                        if (pOSIX != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!pOSIXHandler.isVerbose()) break block14;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    throwable.printStackTrace();
                }
            }
        }
        if (pOSIX == null) {
            pOSIX = POSIXFactory.getJavaPOSIX(pOSIXHandler);
        }
        return pOSIX;
    }

    public static POSIX getJavaPOSIX(POSIXHandler pOSIXHandler) {
        return new JavaPOSIX(pOSIXHandler);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler pOSIXHandler) {
        return new LinuxPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LinuxLibC.class, new HashMap<Object, Object>()), pOSIXHandler);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler pOSIXHandler) {
        return new MacOSPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, new HashMap<Object, Object>()), pOSIXHandler);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler pOSIXHandler) {
        return new SolarisPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, new HashMap<Object, Object>()), pOSIXHandler);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler pOSIXHandler) {
        String string = "msvcrt";
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("function-mapper", new WindowsLibCFunctionMapper());
        return new WindowsPOSIX(string, POSIXFactory.loadLibC(string, LibC.class, hashMap), pOSIXHandler);
    }

    public static LibC loadLibC(String string, Class<?> clazz, HashMap<Object, Object> hashMap) {
        if (libc != null) {
            return libc;
        }
        libc = (LibC)Native.loadLibrary((String)string, clazz, hashMap);
        return libc;
    }
}

