/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import org.jruby.ext.posix.BaseNativeFileStat;
import org.jruby.ext.posix.POSIX;

public class MacOSFileStat
extends BaseNativeFileStat {
    public volatile int st_dev;
    public volatile int st_ino;
    public volatile short st_mode;
    public volatile short st_nlink;
    public volatile int st_uid;
    public volatile int st_gid;
    public volatile int st_rdev;
    public volatile int st_atime;
    public volatile int st_atimensec;
    public volatile int st_mtime;
    public volatile int st_mtimensec;
    public volatile int st_ctime;
    public volatile int st_ctimensec;
    public volatile long st_size;
    public volatile long st_blocks;
    public volatile int st_blksize;
    public volatile int st_flags;
    public volatile int st_gen;
    public volatile int st_lspare;
    public volatile long[] st_qspare = new long[2];

    public MacOSFileStat(POSIX pOSIX) {
        super(pOSIX);
    }

    public long atime() {
        return this.st_atime;
    }

    public long blocks() {
        return this.st_blocks;
    }

    public long blockSize() {
        return this.st_blksize;
    }

    public long ctime() {
        return this.st_ctime;
    }

    public long dev() {
        return this.st_dev;
    }

    public int gid() {
        return this.st_gid;
    }

    public int ino() {
        return this.st_ino;
    }

    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    public long mtime() {
        return this.st_mtime;
    }

    public int nlink() {
        return this.st_nlink;
    }

    public long rdev() {
        return this.st_rdev;
    }

    public long st_size() {
        return this.st_size;
    }

    public int uid() {
        return this.st_uid;
    }

    public String toString() {
        return "Stat {DEV: " + this.st_dev + ", INO: " + this.st_ino + ", MODE: " + this.st_mode + ", NLINK: " + this.st_nlink + ", UID: " + this.st_uid + ", GID: " + this.st_gid + ", RDEV: " + this.st_rdev + ", BLOCKS: " + this.st_blocks + ", SIZE: " + this.st_size + ", BLKSIZE: " + this.st_blksize + ", FLAGS: " + this.st_flags + ", GEN: " + this.st_gen + ", ATIME: " + this.st_atime + ", MTIME: " + this.st_mtime + ", CTIME: " + this.st_ctime;
    }
}

