/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LinuxFileStat;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class LinuxPOSIX
extends BaseNativePOSIX {
    private static int STAT_VERSION = 3;
    private boolean hasFxstat = this.hasMethod("__fxstat");
    private boolean hasLxstat = this.hasMethod("__lxstat");
    private boolean hasXstat = this.hasMethod("__xstat");
    private boolean hasFstat = false;
    private boolean hasLstat = false;
    private boolean hasStat = false;

    public LinuxPOSIX(String string, LibC libC, POSIXHandler pOSIXHandler) {
        super(string, libC, pOSIXHandler);
        if (!this.hasFxstat) {
            this.hasFstat = this.hasMethod("fstat");
        }
        if (!this.hasLxstat) {
            this.hasLstat = this.hasMethod("lstat");
        }
        if (!this.hasXstat) {
            this.hasStat = this.hasMethod("stat");
        }
    }

    public FileStat allocateStat() {
        return new LinuxFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        if (!this.hasFxstat) {
            if (this.hasFstat) {
                return super.fstat(fileDescriptor);
            }
            this.handler.unimplementedError("fstat");
        }
        FileStat fileStat = this.allocateStat();
        int n = this.helper.getfd(fileDescriptor);
        if (((LinuxLibC)this.libc).__fxstat(STAT_VERSION, n, fileStat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + n);
        }
        return fileStat;
    }

    public FileStat lstat(String string) {
        FileStat fileStat;
        if (!this.hasLxstat) {
            if (this.hasLstat) {
                return super.lstat(string);
            }
            this.handler.unimplementedError("lstat");
        }
        if (((LinuxLibC)this.libc).__lxstat(STAT_VERSION, string, fileStat = this.allocateStat()) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        return fileStat;
    }

    public FileStat stat(String string) {
        FileStat fileStat;
        if (!this.hasXstat) {
            if (this.hasStat) {
                return super.stat(string);
            }
            this.handler.unimplementedError("stat");
        }
        if (((LinuxLibC)this.libc).__xstat(STAT_VERSION, string, fileStat = this.allocateStat()) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        return fileStat;
    }
}

