/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class Readline {
    public static void createReadline(Ruby ruby) throws IOException {
        ConsoleHolder consoleHolder = new ConsoleHolder();
        consoleHolder.history = new History();
        consoleHolder.currentCompletor = null;
        RubyModule rubyModule = ruby.defineModule("Readline");
        rubyModule.dataWrapStruct(consoleHolder);
        CallbackFactory callbackFactory = ruby.callbackFactory(Readline.class);
        rubyModule.defineMethod("readline", callbackFactory.getFastSingletonMethod("s_readline", IRubyObject.class, IRubyObject.class));
        rubyModule.module_function(new IRubyObject[]{ruby.newSymbol("readline")});
        rubyModule.defineMethod("completion_append_character=", callbackFactory.getFastSingletonMethod("s_set_completion_append_character", IRubyObject.class));
        rubyModule.module_function(new IRubyObject[]{ruby.newSymbol("completion_append_character=")});
        rubyModule.defineMethod("completion_proc=", callbackFactory.getFastSingletonMethod("s_set_completion_proc", IRubyObject.class));
        rubyModule.module_function(new IRubyObject[]{ruby.newSymbol("completion_proc=")});
        IRubyObject iRubyObject = ruby.getObject().callMethod(ruby.getCurrentContext(), "new");
        rubyModule.fastSetConstant("HISTORY", iRubyObject);
        iRubyObject.getSingletonClass().includeModule(ruby.getEnumerable());
        iRubyObject.getSingletonClass().defineMethod("push", callbackFactory.getFastOptSingletonMethod("s_push"));
        iRubyObject.getSingletonClass().defineMethod("pop", callbackFactory.getFastSingletonMethod("s_pop"));
        iRubyObject.getSingletonClass().defineMethod("to_a", callbackFactory.getFastSingletonMethod("s_hist_to_a"));
        iRubyObject.getSingletonClass().defineMethod("to_s", callbackFactory.getFastSingletonMethod("s_hist_to_s"));
        iRubyObject.getSingletonClass().defineMethod("[]", callbackFactory.getFastSingletonMethod("s_hist_get", IRubyObject.class));
        iRubyObject.getSingletonClass().defineMethod("[]=", callbackFactory.getFastSingletonMethod("s_hist_set", IRubyObject.class, IRubyObject.class));
        iRubyObject.getSingletonClass().defineMethod("<<", callbackFactory.getFastOptSingletonMethod("s_push"));
        iRubyObject.getSingletonClass().defineMethod("shift", callbackFactory.getFastSingletonMethod("s_hist_shift"));
        iRubyObject.getSingletonClass().defineMethod("each", callbackFactory.getSingletonMethod("s_hist_each"));
        iRubyObject.getSingletonClass().defineMethod("length", callbackFactory.getFastSingletonMethod("s_hist_length"));
        iRubyObject.getSingletonClass().defineMethod("size", callbackFactory.getFastSingletonMethod("s_hist_length"));
        iRubyObject.getSingletonClass().defineMethod("empty?", callbackFactory.getFastSingletonMethod("s_hist_empty_p"));
        iRubyObject.getSingletonClass().defineMethod("delete_at", callbackFactory.getFastSingletonMethod("s_hist_delete_at", IRubyObject.class));
    }

    protected static void initReadline(Ruby ruby, ConsoleHolder consoleHolder) throws IOException {
        consoleHolder.readline = new ConsoleReader();
        consoleHolder.readline.setUseHistory(false);
        consoleHolder.readline.setUsePagination(true);
        consoleHolder.readline.setBellEnabled(false);
        ((CandidateListCompletionHandler)consoleHolder.readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (consoleHolder.currentCompletor == null) {
            consoleHolder.currentCompletor = new RubyFileNameCompletor();
        }
        consoleHolder.readline.addCompletor(consoleHolder.currentCompletor);
        consoleHolder.readline.setHistory(consoleHolder.history);
    }

    public static History getHistory(ConsoleHolder consoleHolder) {
        return consoleHolder.history;
    }

    public static ConsoleHolder getHolder(Ruby ruby) {
        return (ConsoleHolder)ruby.fastGetModule("Readline").dataGetStruct();
    }

    public static void setCompletor(ConsoleHolder consoleHolder, Completor completor) {
        if (consoleHolder.readline != null) {
            consoleHolder.readline.removeCompletor(consoleHolder.currentCompletor);
        }
        consoleHolder.currentCompletor = completor;
        if (consoleHolder.readline != null) {
            consoleHolder.readline.addCompletor(consoleHolder.currentCompletor);
        }
    }

    public static Completor getCompletor(ConsoleHolder consoleHolder) {
        return consoleHolder.currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) throws IOException {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        if (consoleHolder.readline == null) {
            Readline.initReadline(iRubyObject.getRuntime(), consoleHolder);
        }
        IRubyObject iRubyObject4 = iRubyObject.getRuntime().getNil();
        consoleHolder.readline.getTerminal().disableEcho();
        String string = consoleHolder.readline.readLine(iRubyObject2.toString());
        consoleHolder.readline.getTerminal().enableEcho();
        if (null != string) {
            if (iRubyObject3.isTrue()) {
                consoleHolder.readline.getHistory().addToHistory(string);
            }
            iRubyObject4 = iRubyObject.getRuntime().newString(string);
        }
        return iRubyObject4;
    }

    public static IRubyObject s_push(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws Exception {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            consoleHolder.history.addToHistory(((RubyString)iRubyObjectArray[i]).getUnicodeValue());
        }
        return iRubyObject.getRuntime().getNil();
    }

    public static IRubyObject s_pop(IRubyObject iRubyObject) throws Exception {
        return iRubyObject.getRuntime().getNil();
    }

    public static IRubyObject s_hist_to_a(IRubyObject iRubyObject) throws Exception {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        Iterator iterator = consoleHolder.history.getHistoryList().iterator();
        while (iterator.hasNext()) {
            rubyArray.append(iRubyObject.getRuntime().newString((String)iterator.next()));
        }
        return rubyArray;
    }

    public static IRubyObject s_hist_to_s(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newString("HISTORY");
    }

    public static IRubyObject s_hist_get(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        int n = (int)iRubyObject2.convertToInteger().getLongValue();
        return iRubyObject.getRuntime().newString((String)consoleHolder.history.getHistoryList().get(n));
    }

    public static IRubyObject s_hist_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        throw iRubyObject.getRuntime().newNotImplementedError("the []=() function is unimplemented on this machine");
    }

    public static IRubyObject s_hist_shift(IRubyObject iRubyObject) {
        throw iRubyObject.getRuntime().newNotImplementedError("the shift function is unimplemented on this machine");
    }

    public static IRubyObject s_hist_length(IRubyObject iRubyObject) {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        return iRubyObject.getRuntime().newFixnum(consoleHolder.history.size());
    }

    public static IRubyObject s_hist_empty_p(IRubyObject iRubyObject) {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        return iRubyObject.getRuntime().newBoolean(consoleHolder.history.size() == 0);
    }

    public static IRubyObject s_hist_delete_at(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        throw iRubyObject.getRuntime().newNotImplementedError("the delete_at function is unimplemented on this machine");
    }

    public static IRubyObject s_hist_each(IRubyObject iRubyObject, Block block) {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        Iterator iterator = consoleHolder.history.getHistoryList().iterator();
        while (iterator.hasNext()) {
            block.yield(iRubyObject.getRuntime().getCurrentContext(), iRubyObject.getRuntime().newString((String)iterator.next()));
        }
        return iRubyObject;
    }

    public static IRubyObject s_set_completion_append_character(IRubyObject iRubyObject, IRubyObject iRubyObject2) throws Exception {
        return iRubyObject.getRuntime().getNil();
    }

    public static IRubyObject s_set_completion_proc(IRubyObject iRubyObject, IRubyObject iRubyObject2) throws Exception {
        if (!iRubyObject2.respondsTo("call")) {
            throw iRubyObject.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(iRubyObject.getRuntime()), new ProcCompletor(iRubyObject2));
        return iRubyObject.getRuntime().getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String string, int n, List list) {
            int n2 = (string = string.substring(0, n)).lastIndexOf(" ");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            return n2 + 1 + super.complete(string, n, list);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;

        public ProcCompletor(IRubyObject iRubyObject) {
            this.procCompletor = iRubyObject;
        }

        public int complete(String string, int n, List list) {
            int n2 = (string = string.substring(0, n)).lastIndexOf(" ");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            ThreadContext threadContext = this.procCompletor.getRuntime().getCurrentContext();
            IRubyObject iRubyObject = this.procCompletor.callMethod(threadContext, "call", new IRubyObject[]{this.procCompletor.getRuntime().newString(string)}).callMethod(threadContext, MethodIndex.TO_A, "to_a");
            if (iRubyObject instanceof List) {
                for (Object e : (List)((Object)iRubyObject)) {
                    if (e == null) continue;
                    list.add(e.toString());
                }
                Collections.sort(list);
            }
            return n - string.length();
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completor currentCompletor;
        public History history;
    }

    public static class Service
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            Readline.createReadline(ruby);
        }
    }
}

