/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;

    public RaiseException(RubyException rubyException) {
        this(rubyException, false);
    }

    public RaiseException(Ruby ruby, RubyClass rubyClass, String string, boolean bl) {
        super(string);
        if (string == null) {
            string = "No message available";
        }
        this.setException((RubyException)rubyClass.callMethod(ruby.getCurrentContext(), "new", new IRubyObject[]{rubyClass.getRuntime().newString(string)}, Block.NULL_BLOCK), bl);
    }

    public RaiseException(RubyException rubyException, boolean bl) {
        this.setException(rubyException, bl);
    }

    public static RaiseException createNativeRaiseException(Ruby ruby, Throwable throwable) {
        NativeException nativeException = new NativeException(ruby, ruby.getClass("NativeException"), throwable);
        return new RaiseException(throwable, nativeException);
    }

    private static String buildMessage(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringBuffer.append("Native Exception: '").append(throwable.getClass()).append("'; ");
        stringBuffer.append("Message: ").append(throwable.getMessage()).append("; ");
        stringBuffer.append("StackTrace: ").append(stringWriter.getBuffer().toString());
        return stringBuffer.toString();
    }

    public RaiseException(Throwable throwable, NativeException nativeException) {
        super(RaiseException.buildMessage(throwable), throwable);
        this.setException(nativeException, false);
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException rubyException, boolean bl) {
        Ruby ruby = rubyException.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        if (!threadContext.isWithinDefined()) {
            ruby.getGlobalVariables().set("$!", rubyException);
        }
        if (ruby.hasEventHooks()) {
            ruby.callEventHooks(threadContext, 7, threadContext.getFile(), threadContext.getLine(), threadContext.getFrameName(), threadContext.getFrameKlazz());
        }
        this.exception = rubyException;
        if (ruby.getStackTraces() > 5) {
            return;
        }
        ruby.setStackTraces(ruby.getStackTraces() + 1);
        rubyException.setBacktraceFrames(threadContext.createBacktrace(0, bl));
        rubyException.getBacktrace();
        ruby.setStackTraces(ruby.getStackTraces() - 1);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        int n = 0;
        int n2 = stackTraceElementArray.length - 1;
        while (n2 > 0 && stackTraceElementArray[n2].getClassName().indexOf("org.jruby.evaluator") < 0) {
            n = n2--;
        }
        IRubyObject iRubyObject = this.exception.backtrace();
        Ruby ruby = iRubyObject.getRuntime();
        if (ruby.getNil() != iRubyObject) {
            String string = iRubyObject.callMethod(ruby.getCurrentContext(), "first").callMethod(ruby.getCurrentContext(), MethodIndex.TO_S, "to_s").toString();
            printStream.print(string + ": ");
        }
        printStream.println(this.exception.message + " (" + this.exception.getMetaClass().toString() + ")");
        this.exception.printBacktrace(printStream);
        printStream.println("\t...internal jruby stack elided...");
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            printStream.println("\tfrom " + stackTraceElementArray[i].toString());
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(byteArrayOutputStream));
        printWriter.print(byteArrayOutputStream.toString());
    }
}

