/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.Readline;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class TextAreaReadline
extends OutputStream
implements KeyListener {
    JTextComponent area;
    private int startPos;
    private String currentLine;
    private Object amEditing = new Object();
    public MutableAttributeSet promptStyle;
    public MutableAttributeSet inputStyle;
    public MutableAttributeSet outputStyle;
    public MutableAttributeSet resultStyle;
    private JComboBox completeCombo;
    private BasicComboPopup completePopup;
    private int start;
    private int end;
    private volatile boolean finished = false;
    private Ruby runtime;

    public TextAreaReadline(JTextComponent jTextComponent) {
        this(jTextComponent, null);
    }

    public TextAreaReadline(JTextComponent jTextComponent, String string) {
        this.area = jTextComponent;
        jTextComponent.addKeyListener(this);
        if (jTextComponent.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)jTextComponent.getDocument()).setDocumentFilter(new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (n >= TextAreaReadline.this.startPos) {
                        super.insertString(filterBypass, n, string, attributeSet);
                    }
                }

                public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                    if (n >= TextAreaReadline.this.startPos) {
                        super.remove(filterBypass, n, n2);
                    }
                }

                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (n >= TextAreaReadline.this.startPos) {
                        super.replace(filterBypass, n, n2, string, attributeSet);
                    }
                }
            });
        }
        this.promptStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptStyle, new Color(164, 0, 0));
        this.inputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.inputStyle, new Color(32, 74, 135));
        this.outputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.outputStyle, Color.darkGray);
        this.resultStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(this.resultStyle, true);
        StyleConstants.setForeground(this.resultStyle, new Color(32, 74, 135));
        this.completeCombo = new JComboBox();
        this.completeCombo.setRenderer(new DefaultListCellRenderer());
        this.completePopup = new BasicComboPopup(this.completeCombo);
        if (string != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBackground(simpleAttributeSet, jTextComponent.getForeground());
            StyleConstants.setForeground(simpleAttributeSet, jTextComponent.getBackground());
            this.append(string, simpleAttributeSet);
        }
    }

    public void hookIntoRuntime(final Ruby ruby) {
        this.runtime = ruby;
        ruby.getLoadService().require("readline");
        RubyModule rubyModule = ruby.fastGetModule("Readline");
        RubyIO rubyIO = new RubyIO(ruby, this);
        ruby.getGlobalVariables().set("$stdout", rubyIO);
        ruby.getGlobalVariables().set("$stderr", rubyIO);
        rubyModule.defineModuleFunction("readline", new Callback(){

            public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
                return RubyString.newUnicodeString(ruby, TextAreaReadline.this.readLine(iRubyObjectArray[0].toString()));
            }

            public Arity getArity() {
                return Arity.twoArguments();
            }
        });
    }

    protected void completeAction(KeyEvent keyEvent) {
        if (Readline.getCompletor(Readline.getHolder(this.runtime)) == null) {
            return;
        }
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        String string = null;
        try {
            string = this.area.getText(this.startPos, this.area.getCaretPosition() - this.startPos);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int n = this.area.getCaretPosition() - this.startPos;
        int n2 = Readline.getCompletor(Readline.getHolder(this.runtime)).complete(string, n, linkedList);
        if (linkedList.isEmpty()) {
            return;
        }
        if (linkedList.size() == 1) {
            this.replaceText(this.startPos + n2, this.area.getCaretPosition(), (String)linkedList.get(0));
            return;
        }
        this.start = this.startPos + n2;
        this.end = this.area.getCaretPosition();
        Point point = this.area.getCaret().getMagicCaretPosition();
        int n3 = string.substring(n2).lastIndexOf(46) + 1;
        this.start += n3;
        if (linkedList.size() < 10) {
            this.completePopup.getList().setVisibleRowCount(linkedList.size());
        } else {
            this.completePopup.getList().setVisibleRowCount(10);
        }
        this.completeCombo.removeAllItems();
        for (String string2 : linkedList) {
            if (n3 != 0) {
                string2 = string2.substring(n3);
            }
            this.completeCombo.addItem(string2);
        }
        this.completePopup.show(this.area, point.x, point.y + this.area.getFontMetrics(this.area.getFont()).getHeight());
    }

    protected void backAction(KeyEvent keyEvent) {
        if (this.area.getCaretPosition() <= this.startPos) {
            keyEvent.consume();
        }
    }

    protected void upAction(KeyEvent keyEvent) {
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            int n = this.completeCombo.getSelectedIndex() - 1;
            if (n < 0) {
                return;
            }
            this.completeCombo.setSelectedIndex(n);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            this.currentLine = this.getLine();
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).previous()) {
            return;
        }
        String string = Readline.getHistory(Readline.getHolder(this.runtime)).current().trim();
        this.replaceText(this.startPos, this.area.getDocument().getLength(), string);
    }

    protected void downAction(KeyEvent keyEvent) {
        String string;
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            int n = this.completeCombo.getSelectedIndex() + 1;
            if (n == this.completeCombo.getItemCount()) {
                return;
            }
            this.completeCombo.setSelectedIndex(n);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            string = this.currentLine;
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
            string = Readline.getHistory(Readline.getHolder(this.runtime)).current().trim();
        }
        this.replaceText(this.startPos, this.area.getDocument().getLength(), string);
    }

    protected void replaceText(int n, int n2, String string) {
        try {
            this.area.getDocument().remove(n, n2 - n);
            this.area.getDocument().insertString(n, string, this.inputStyle);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected String getLine() {
        try {
            return this.area.getText(this.startPos, this.area.getDocument().getLength() - this.startPos);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterAction(KeyEvent keyEvent) {
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            if (this.completeCombo.getSelectedItem() != null) {
                this.replaceText(this.start, this.end, (String)this.completeCombo.getSelectedItem());
            }
            this.completePopup.setVisible(false);
            return;
        }
        this.append("\n", null);
        Object object = this.amEditing;
        synchronized (object) {
            this.amEditing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFinished() {
        Object object = this.amEditing;
        synchronized (object) {
            this.finished = true;
            this.amEditing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String string) {
        this.append(string.trim(), this.promptStyle);
        this.append(" ", this.inputStyle);
        this.area.setCaretPosition(this.area.getDocument().getLength());
        this.startPos = this.area.getDocument().getLength();
        Readline.getHistory(Readline.getHolder(this.runtime)).moveToEnd();
        Object object = this.amEditing;
        synchronized (object) {
            if (this.finished) {
                return "exit";
            }
            try {
                this.amEditing.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = this.finished ? "exit" : this.getLine().trim();
        return object;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 9: {
                this.completeAction(keyEvent);
                break;
            }
            case 8: 
            case 37: {
                this.backAction(keyEvent);
                break;
            }
            case 38: {
                this.upAction(keyEvent);
                break;
            }
            case 40: {
                this.downAction(keyEvent);
                break;
            }
            case 10: {
                this.enterAction(keyEvent);
                break;
            }
            case 36: {
                keyEvent.consume();
                this.area.setCaretPosition(this.startPos);
            }
        }
        if (this.completePopup.isVisible() && n != 9 && n != 38 && n != 40) {
            this.completePopup.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void append(String string, AttributeSet attributeSet) {
        try {
            this.area.getDocument().insertString(this.area.getDocument().getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void writeLine(String string) {
        if (string.startsWith("=>")) {
            this.append(string, this.resultStyle);
        } else {
            this.append(string, this.outputStyle);
        }
    }

    public void write(int n) throws IOException {
        this.writeLine("" + n);
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            this.writeLine(new String(byArray, n, n2, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.writeLine(new String(byArray, n, n2));
        }
    }

    public void write(byte[] byArray) {
        try {
            this.writeLine(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.writeLine(new String(byArray));
        }
    }
}

