/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.demo.TextAreaReadline;

public class IRBApplet
extends Applet {
    private static final long serialVersionUID = 3746242973444417387L;

    public void start() {
        super.start();
        final PipedInputStream pipedInputStream = new PipedInputStream();
        this.setLayout(new BorderLayout());
        JTextPane jTextPane = new JTextPane();
        jTextPane.setMargin(new Insets(8, 8, 8, 8));
        jTextPane.setCaretColor(new Color(164, 0, 0));
        jTextPane.setBackground(new Color(242, 242, 242));
        jTextPane.setForeground(new Color(164, 0, 0));
        Font font = this.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
        jTextPane.setFont(font);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setDoubleBuffered(true);
        jScrollPane.setViewportView(jTextPane);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add(jScrollPane);
        this.validate();
        final TextAreaReadline textAreaReadline = new TextAreaReadline(jTextPane, " Welcome to JRuby for the Web! \n\n");
        RubyInstanceConfig rubyInstanceConfig = new RubyInstanceConfig(){
            {
                this.setInput(pipedInputStream);
                this.setOutput(new PrintStream(textAreaReadline));
                this.setError(new PrintStream(textAreaReadline));
                this.setObjectSpaceEnabled(true);
                this.setArgv(new String[]{"-f"});
            }
        };
        Ruby.setSecurityRestricted(true);
        final Ruby ruby = Ruby.newInstance(rubyInstanceConfig);
        ruby.getLoadService().init(new ArrayList(0));
        textAreaReadline.hookIntoRuntime(ruby);
        Thread thread = new Thread(){

            public void run() {
                ruby.evalScriptlet("require 'irb'; require 'irb/completion'; IRB.start");
            }
        };
        thread.start();
    }

    private Font findFont(String string, int n, int n2, String[] stringArray) {
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(objectArray);
        Font font = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Arrays.binarySearch(objectArray, stringArray[i]) < 0) continue;
            font = new Font(stringArray[i], n, n2);
            break;
        }
        if (font == null) {
            font = new Font(string, n, n2);
        }
        return font;
    }
}

