/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.BoxedVariableCompiler;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StackBasedVariableCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    private static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    private static final String RUBY = CodegenUtils.p(Ruby.class);
    private static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    private static final String METHOD_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
    private static final String CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class);
    public static final int THIS = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int ARGS_INDEX = 3;
    public static final int CLOSURE_INDEX = 4;
    public static final int DYNAMIC_SCOPE_INDEX = 5;
    public static final int RUNTIME_INDEX = 6;
    public static final int VARS_ARRAY_INDEX = 7;
    public static final int NIL_INDEX = 8;
    public static final int EXCEPTION_INDEX = 9;
    public static final int PREVIOUS_EXCEPTION_INDEX = 10;
    public static final int FIRST_TEMP_INDEX = 11;
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    int methodIndex = -1;
    int innerIndex = -1;
    int fieldIndex = 0;
    int rescueNumber = 1;
    int ensureNumber = 1;
    StaticScope topLevelScope;
    CacheCompiler cacheCompiler;
    static boolean USE_INHERITED_CACHE_FIELDS = true;
    private int constants = 0;

    public StandardASMCompiler(String string, String string2) {
        this.classname = string;
        this.sourcename = string2;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader jRubyClassLoader) throws ClassNotFoundException {
        jRubyClassLoader.defineClass(CodegenUtils.c(this.classname), this.classWriter.toByteArray());
        return jRubyClassLoader.loadClass(CodegenUtils.c(this.classname));
    }

    public void writeClass(File file) throws IOException {
        this.writeClass(this.classname, file, this.classWriter);
    }

    private void writeClass(String string, File file, ClassWriter classWriter) throws IOException {
        String string2 = string + ".class";
        String string3 = null;
        String string4 = null;
        byte[] byArray = classWriter.toByteArray();
        CheckClassAdapter.verify((ClassReader)new ClassReader(byArray), (boolean)false, (PrintWriter)new PrintWriter(System.err));
        if (string2.lastIndexOf("/") == -1) {
            string3 = string2;
            string4 = "";
        } else {
            string3 = string2.substring(string2.lastIndexOf("/") + 1);
            string4 = string2.substring(0, string2.lastIndexOf("/"));
        }
        File file2 = new File(file, string4);
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, string3));
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope staticScope) {
        this.classWriter = new ClassWriter(1);
        this.classWriter.visit(48, 33, this.classname, null, CodegenUtils.p(AbstractScript.class), null);
        this.classWriter.visitSource(this.sourcename, null);
        this.topLevelScope = staticScope;
        this.beginInit();
        this.beginClassInit();
        this.cacheCompiler = new InheritedCacheCompiler(this);
    }

    @Override
    public void endScript(boolean bl, boolean bl2, boolean bl3) {
        SkinnyMethodAdapter skinnyMethodAdapter;
        String string = "__file__";
        if (bl) {
            skinnyMethodAdapter = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "run", METHOD_SIGNATURE, null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.aload(3);
            skinnyMethodAdapter.aload(4);
            skinnyMethodAdapter.invokevirtual(this.classname, string, METHOD_SIGNATURE);
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.end();
        }
        if (bl2 || bl3) {
            skinnyMethodAdapter = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "load", METHOD_SIGNATURE, null, null));
            skinnyMethodAdapter.start();
            Label label = new Label();
            Label label2 = new Label();
            skinnyMethodAdapter.label(label);
            skinnyMethodAdapter.aload(1);
            this.buildStaticScopeNames(skinnyMethodAdapter, this.topLevelScope);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "preLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String[].class));
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.aload(3);
            skinnyMethodAdapter.aload(4);
            skinnyMethodAdapter.invokevirtual(this.classname, string, METHOD_SIGNATURE);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.label(label2);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            skinnyMethodAdapter.athrow();
            skinnyMethodAdapter.trycatch(label, label2, label2, null);
            skinnyMethodAdapter.end();
        }
        if (bl3) {
            skinnyMethodAdapter = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.newobj(this.classname);
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokespecial(this.classname, "<init>", CodegenUtils.sig(Void.TYPE));
            skinnyMethodAdapter.newobj(CodegenUtils.p(RubyInstanceConfig.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokespecial(CodegenUtils.p(RubyInstanceConfig.class), "<init>", "()V");
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setArgv", CodegenUtils.sig(Void.TYPE, String[].class));
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(Ruby.class), "newInstance", CodegenUtils.sig(Ruby.class, RubyInstanceConfig.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class));
            skinnyMethodAdapter.swap();
            skinnyMethodAdapter.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class));
            skinnyMethodAdapter.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            skinnyMethodAdapter.invokevirtual(this.classname, "load", METHOD_SIGNATURE);
            skinnyMethodAdapter.voidreturn();
            skinnyMethodAdapter.end();
        }
        this.endInit();
        this.endClassInit();
    }

    public void buildStaticScopeNames(SkinnyMethodAdapter skinnyMethodAdapter, StaticScope staticScope) {
        skinnyMethodAdapter.ldc(new Integer(staticScope.getNumberOfVariables()));
        skinnyMethodAdapter.anewarray(CodegenUtils.p(String.class));
        for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.ldc(new Integer(i));
            skinnyMethodAdapter.ldc(staticScope.getVariables()[i]);
            skinnyMethodAdapter.arraystore();
        }
    }

    private void beginInit() {
        ClassVisitor classVisitor = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(classVisitor.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE), null, null));
        this.initMethod.start();
        this.initMethod.aload(0);
        if (USE_INHERITED_CACHE_FIELDS) {
            this.initMethod.invokespecial(CodegenUtils.p(AbstractScript.class), "<init>", CodegenUtils.sig(Void.TYPE));
        } else {
            this.initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE));
        }
        classVisitor.visitField(18, "$class", CodegenUtils.ci(Class.class), null, null);
        this.initMethod.aload(0);
        this.initMethod.ldc(CodegenUtils.c(this.classname));
        this.initMethod.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        this.initMethod.putfield(this.classname, "$class", CodegenUtils.ci(Class.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor classVisitor = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(classVisitor.visitMethod(9, "<clinit>", CodegenUtils.sig(Void.TYPE), null, null));
        this.clinitMethod.start();
    }

    private void endClassInit() {
        this.clinitMethod.voidreturn();
        this.clinitMethod.end();
    }

    public SkinnyMethodAdapter getInitMethod() {
        return this.initMethod;
    }

    public SkinnyMethodAdapter getClassInitMethod() {
        return this.clinitMethod;
    }

    public CacheCompiler getCacheCompiler() {
        return this.cacheCompiler;
    }

    @Override
    public MethodCompiler startMethod(String string, CompilerCallback compilerCallback, StaticScope staticScope, ASTInspector aSTInspector) {
        ASMMethodCompiler aSMMethodCompiler = new ASMMethodCompiler(string, aSTInspector);
        aSMMethodCompiler.beginMethod(compilerCallback, staticScope);
        return aSMMethodCompiler;
    }

    public String getNewConstant(String string, String string2) {
        return this.getNewConstant(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewConstant(String string, String string2, Object object) {
        String string3;
        ClassVisitor classVisitor = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            string3 = "_" + this.constants++;
        }
        classVisitor.visitField(2, string3, string, null, null).visitEnd();
        if (object != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(object);
            this.initMethod.putfield(this.classname, string3, string);
        }
        return string3;
    }

    public String getNewField(String string, String string2, Object object) {
        ClassVisitor classVisitor = this.getClassVisitor();
        classVisitor.visitField(2, string2, string, null, null).visitEnd();
        if (object != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(object);
            this.initMethod.putfield(this.classname, string2, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String string, String string2) {
        String string3;
        ClassVisitor classVisitor = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            string3 = "__" + this.constants++;
        }
        classVisitor.visitField(10, string3, string, null, null).visitEnd();
        return string3;
    }

    public class ASMMethodCompiler
    extends AbstractMethodCompiler {
        private String friendlyName;

        public ASMMethodCompiler(String string, ASTInspector aSTInspector) {
            this.friendlyName = string;
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(1, string, METHOD_SIGNATURE, null, null));
            this.variableCompiler = aSTInspector == null ? new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : (aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !aSTInspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11)) : new StackBasedVariableCompiler(this, this.method, 5, 3, 4, 11));
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        public void beginChainedMethod() {
            this.method.start();
            this.method.aload(1);
            this.method.dup();
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class));
            this.method.dup();
            this.method.astore(5);
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
            this.method.astore(7);
        }

        public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginMethod(compilerCallback, staticScope);
            Label label = new Label();
            this.method.label(label);
            this.scopeStart = label;
        }

        public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginClass(compilerCallback, staticScope);
            Label label = new Label();
            this.method.label(label);
            this.scopeStart = label;
        }

        public void endMethod() {
            this.method.areturn();
            Label label = new Label();
            this.method.label(label);
            this.method.end();
        }

        public void performReturn() {
            if (this.withinProtection) {
                this.loadThreadContext();
                this.invokeUtilityMethod("returnJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
            } else {
                this.method.areturn();
            }
        }

        public void issueBreakEvent(CompilerCallback compilerCallback) {
            if (this.withinProtection) {
                compilerCallback.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                compilerCallback.call(this);
                this.issueLoopBreak();
            } else {
                this.loadRuntime();
                compilerCallback.call(this);
                this.invokeUtilityMethod("breakLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        public void issueNextEvent(CompilerCallback compilerCallback) {
            if (this.withinProtection) {
                compilerCallback.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                compilerCallback.call(this);
                this.issueLoopNext();
            } else {
                this.loadRuntime();
                compilerCallback.call(this);
                this.invokeUtilityMethod("nextLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        public void issueRedoEvent() {
            if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else {
                this.loadRuntime();
                this.invokeUtilityMethod("redoLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class));
            }
        }
    }

    public class ASMClosureCompiler
    extends AbstractMethodCompiler {
        private String closureMethodName;

        public ASMClosureCompiler(String string, String string2, ASTInspector aSTInspector) {
            this.closureMethodName = string;
            StandardASMCompiler.this.getClassVisitor().visitField(2, string2, CodegenUtils.ci(CompiledBlockCallback.class), null, null);
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, CLOSURE_SIGNATURE, null, null));
            this.variableCompiler = aSTInspector == null ? new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : (aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !aSTInspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11)) : new StackBasedVariableCompiler(this, this.method, 5, 3, 4, 11));
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginClosure(compilerCallback, staticScope);
            this.scopeStart = new Label();
            this.scopeEnd = new Label();
            this.redoJump = new Label();
            this.method.label(this.scopeStart);
        }

        public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
            throw new NotCompilableException("ERROR: closure compiler should not be used for class bodies");
        }

        public void endMethod() {
            this.scopeEnd = new Label();
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.method.pop();
            this.method.go_to(this.scopeStart);
            this.method.trycatch(this.scopeStart, this.scopeEnd, this.scopeEnd, CodegenUtils.p(JumpException.RedoJump.class));
            this.method.end();
        }

        public void loadBlock() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameBlock", CodegenUtils.sig(Block.class));
        }

        protected String getNewRescueName() {
            return this.closureMethodName + "_" + super.getNewRescueName();
        }

        protected String getNewEnsureName() {
            return this.closureMethodName + "_" + super.getNewEnsureName();
        }

        public void performReturn() {
            this.loadThreadContext();
            this.invokeUtilityMethod("returnJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        public void processRequiredArgs(Arity arity, int n, int n2, int n3) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void assignOptionalArgs(Object object, int n, int n2, ArrayCallback arrayCallback) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processRestArg(int n, int n2) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processBlockArgument(int n) {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadBlock();
            this.method.ldc(new Integer(n));
            this.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, Integer.TYPE)));
        }

        public void issueBreakEvent(CompilerCallback compilerCallback) {
            if (this.withinProtection || this.currentLoopLabels == null) {
                compilerCallback.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else {
                compilerCallback.call(this);
                this.issueLoopBreak();
            }
        }

        public void issueNextEvent(CompilerCallback compilerCallback) {
            if (this.withinProtection || this.currentLoopLabels == null) {
                compilerCallback.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else {
                compilerCallback.call(this);
                this.issueLoopNext();
            }
        }

        public void issueRedoEvent() {
            if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else {
                this.method.go_to(this.scopeStart);
            }
        }
    }

    public abstract class AbstractMethodCompiler
    implements MethodCompiler {
        protected SkinnyMethodAdapter method;
        protected VariableCompiler variableCompiler;
        protected InvocationCompiler invocationCompiler;
        protected Label[] currentLoopLabels;
        protected Label scopeStart;
        protected Label scopeEnd;
        protected Label redoJump;
        protected boolean withinProtection = false;
        private int lastLine = -1;

        public abstract void beginMethod(CompilerCallback var1, StaticScope var2);

        public abstract void endMethod();

        public MethodCompiler chainToMethod(String string, ASTInspector aSTInspector) {
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
            this.endMethod();
            ASMMethodCompiler aSMMethodCompiler = new ASMMethodCompiler(string, aSTInspector);
            aSMMethodCompiler.beginChainedMethod();
            return aSMMethodCompiler;
        }

        public StandardASMCompiler getScriptCompiler() {
            return StandardASMCompiler.this;
        }

        public void lineNumber(ISourcePosition iSourcePosition) {
            int n = iSourcePosition.getStartLine();
            if (n == this.lastLine) {
                return;
            }
            this.lastLine = n;
            Label label = new Label();
            this.method.label(label);
            this.method.visitLineNumber(n + 1, label);
        }

        public void loadThreadContext() {
            this.method.aload(1);
        }

        public void loadSelf() {
            this.method.aload(2);
        }

        public void loadRuntime() {
            this.method.aload(6);
        }

        public void loadBlock() {
            this.method.aload(4);
        }

        public void loadNil() {
            this.method.aload(8);
        }

        public void loadNull() {
            this.method.aconst_null();
        }

        public void loadSymbol(String string) {
            this.loadRuntime();
            this.method.ldc(string);
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        public void loadObject() {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
        }

        public void invokeUtilityMethod(String string, String string2) {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), string, string2);
        }

        public void invokeThreadContext(String string, String string2) {
            this.method.invokevirtual(THREADCONTEXT, string, string2);
        }

        public void invokeIRuby(String string, String string2) {
            this.method.invokevirtual(RUBY, string, string2);
        }

        public void invokeIRubyObject(String string, String string2) {
            this.method.invokeinterface(IRUBYOBJECT, string, string2);
        }

        public void consumeCurrentValue() {
            this.method.pop();
        }

        public void duplicateCurrentValue() {
            this.method.dup();
        }

        public void swapValues() {
            this.method.swap();
        }

        public void retrieveSelf() {
            this.loadSelf();
        }

        public void retrieveSelfClass() {
            this.loadSelf();
            this.metaclass();
        }

        public VariableCompiler getVariableCompiler() {
            return this.variableCompiler;
        }

        public InvocationCompiler getInvocationCompiler() {
            return this.invocationCompiler;
        }

        public void assignConstantInCurrent(String string) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.method.dup2_x1();
            this.method.pop2();
            this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void assignConstantInModule(String string) {
            this.method.ldc(string);
            this.loadThreadContext();
            this.invokeUtilityMethod("setConstantInModule", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
        }

        public void assignConstantInObject(String string) {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
            this.method.swap();
            this.assignConstantInModule(string);
        }

        public void retrieveConstant(String string) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.invokeThreadContext("getConstant", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void retrieveConstantFromModule(String string) {
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantFrom", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void retrieveClassVariable(String string) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(string);
            this.invokeUtilityMethod("fastFetchClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
        }

        public void assignClassVariable(String string) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void declareClassVariable(String string) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void createNewFloat(double d) {
            this.loadRuntime();
            this.method.ldc(new Double(d));
            this.invokeIRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
        }

        public void createNewFixnum(long l) {
            this.loadRuntime();
            this.method.ldc(new Long(l));
            this.invokeIRuby("newFixnum", CodegenUtils.sig(RubyFixnum.class, CodegenUtils.params(Long.TYPE)));
        }

        public void createNewBignum(BigInteger bigInteger) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheBigInteger(this.method, bigInteger);
            this.method.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, BigInteger.class)));
        }

        public void createNewString(ArrayCallback arrayCallback, int n) {
            this.loadRuntime();
            this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
            for (int i = 0; i < n; ++i) {
                arrayCallback.nextValue(this, null, i);
                this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
            }
        }

        public void createNewSymbol(ArrayCallback arrayCallback, int n) {
            this.loadRuntime();
            this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
            for (int i = 0; i < n; ++i) {
                arrayCallback.nextValue(this, null, i);
                this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
            }
            this.toJavaString();
            this.loadRuntime();
            this.method.swap();
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        public void createNewString(ByteList byteList) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheByteList(this.method, byteList.toString());
            this.invokeIRuby("newStringShared", CodegenUtils.sig(RubyString.class, CodegenUtils.params(ByteList.class)));
        }

        public void createNewSymbol(String string) {
            StandardASMCompiler.this.getCacheCompiler().cacheSymbol(this.method, string);
        }

        public void createNewArray(boolean bl) {
            this.loadRuntime();
            this.method.swap();
            if (bl) {
                this.invokeIRuby("newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject[].class)));
            } else {
                this.invokeIRuby("newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject[].class)));
            }
        }

        public void createEmptyArray() {
            this.loadRuntime();
            this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(new Class[0])));
        }

        public void createObjectArray(Object[] objectArray, ArrayCallback arrayCallback) {
            this.buildObjectArray(IRUBYOBJECT, objectArray, arrayCallback);
        }

        public void createObjectArray(int n) {
            if (n >= 6) {
                throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
            }
            Object[] objectArray = new Class[n];
            Arrays.fill(objectArray, IRubyObject.class);
            this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, (Class[])objectArray));
        }

        private void buildObjectArray(String string, Object[] objectArray, ArrayCallback arrayCallback) {
            if (objectArray.length == 0) {
                this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            } else if (objectArray.length <= 5) {
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayCallback.nextValue(this, objectArray, i);
                }
                this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class, objectArray.length)));
            } else {
                this.method.ldc(new Integer(objectArray.length));
                this.method.anewarray(string);
                for (int i = 0; i < objectArray.length; ++i) {
                    this.method.dup();
                    this.method.ldc(new Integer(i));
                    arrayCallback.nextValue(this, objectArray, i);
                    this.method.arraystore();
                }
            }
        }

        public void createEmptyHash() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
        }

        public void createNewHash(Object object, ArrayCallback arrayCallback, int n) {
            this.loadRuntime();
            if (n <= 3) {
                for (int i = 0; i < n; ++i) {
                    arrayCallback.nextValue(this, object, i);
                }
                this.invokeUtilityMethod("constructHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, IRubyObject.class, n * 2)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
                for (int i = 0; i < n; ++i) {
                    this.method.dup();
                    arrayCallback.nextValue(this, object, i);
                    this.method.invokevirtual(CodegenUtils.p(RubyHash.class), "fastASet", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, IRubyObject.class)));
                }
            }
        }

        public void createNewRange(boolean bl) {
            this.loadRuntime();
            this.loadThreadContext();
            this.method.dup2_x2();
            this.method.pop2();
            this.method.ldc(bl);
            this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Boolean.TYPE)));
        }

        private void isTrue() {
            this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
        }

        public void performBooleanBranch(BranchCallback branchCallback, BranchCallback branchCallback2) {
            Label label = new Label();
            Label label2 = new Label();
            this.isTrue();
            this.method.ifeq(label2);
            branchCallback.branch(this);
            this.method.go_to(label);
            this.method.label(label2);
            branchCallback2.branch(this);
            this.method.label(label);
        }

        public void performLogicalAnd(BranchCallback branchCallback) {
            Label label = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifeq(label);
            this.method.pop();
            branchCallback.branch(this);
            this.method.label(label);
        }

        public void performLogicalOr(BranchCallback branchCallback) {
            Label label = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifne(label);
            this.method.pop();
            branchCallback.branch(this);
            this.method.label(label);
        }

        public void performBooleanLoop(BranchCallback branchCallback, BranchCallback branchCallback2, boolean bl) {
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            Label label5 = new Label();
            Label label6 = new Label();
            Label label7 = new Label();
            Label label8 = new Label();
            Label label9 = new Label();
            Label label10 = new Label();
            Label label11 = new Label();
            this.method.trycatch(label, label2, label3, CodegenUtils.p(JumpException.RedoJump.class));
            this.method.trycatch(label, label2, label4, CodegenUtils.p(JumpException.NextJump.class));
            this.method.trycatch(label, label2, label5, CodegenUtils.p(JumpException.BreakJump.class));
            if (bl) {
                this.method.trycatch(label, label2, label6, CodegenUtils.p(RaiseException.class));
            }
            this.method.label(label);
            Object object = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{label7, label9, label10};
            if (bl) {
                this.method.go_to(label8);
            }
            this.method.label(label9);
            branchCallback2.branch(this);
            this.method.label(label7);
            this.method.pop();
            this.method.label(label8);
            branchCallback.branch(this);
            this.isTrue();
            this.method.ifne(label9);
            this.currentLoopLabels = object;
            this.method.label(label2);
            this.method.go_to(label11);
            this.method.label(label3);
            this.method.pop();
            this.method.go_to(label9);
            this.method.label(label4);
            this.method.pop();
            this.method.go_to(label8);
            this.method.label(label5);
            this.loadBlock();
            this.invokeUtilityMethod("breakJumpInWhile", CodegenUtils.sig(IRubyObject.class, JumpException.BreakJump.class, Block.class));
            this.method.go_to(label10);
            if (bl) {
                this.method.label(label6);
                object = new Label();
                Label label12 = new Label();
                Label label13 = new Label();
                this.method.dup();
                this.invokeUtilityMethod("getLocalJumpTypeOrRethrow", CodegenUtils.sig(String.class, CodegenUtils.params(RaiseException.class)));
                this.method.dup();
                this.method.ldc("break");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq((Label)object);
                this.method.pop();
                this.invokeUtilityMethod("unwrapLocalJumpErrorValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(RaiseException.class)));
                this.method.go_to(label10);
                this.method.label((Label)object);
                this.method.dup();
                this.method.ldc("next");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(label12);
                this.method.pop2();
                this.method.go_to(label8);
                this.method.label(label12);
                this.method.dup();
                this.method.ldc("redo");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(label13);
                this.method.pop2();
                this.method.go_to(label9);
                this.method.label(label13);
                this.method.pop();
                this.method.athrow();
            }
            this.method.label(label11);
            this.loadNil();
            this.method.label(label10);
        }

        public void createNewClosure(int n, StaticScope staticScope, int n2, CompilerCallback compilerCallback, CompilerCallback compilerCallback2, boolean bl, NodeType nodeType, ASTInspector aSTInspector) {
            String string = "closure_" + n + "_" + ++StandardASMCompiler.this.innerIndex;
            String string2 = "_" + string;
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, string2, aSTInspector);
            aSMClosureCompiler.beginMethod(compilerCallback2, staticScope);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            Label label = new Label();
            this.method.ifnonnull(label);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(string);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(label);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(n2));
            StandardASMCompiler.this.buildStaticScopeNames(this.method, staticScope);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.ldc(bl);
            this.method.ldc(BlockBody.asArgumentType(nodeType));
            this.method.ldc(!aSTInspector.hasClosure() && !aSTInspector.hasScopeAwareMethods());
            this.invokeUtilityMethod("createBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, String[].class, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE)));
        }

        public void runBeginBlock(StaticScope staticScope, CompilerCallback compilerCallback) {
            String string = "closure" + ++StandardASMCompiler.this.innerIndex;
            String string2 = "_" + string;
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, string2, null);
            aSMClosureCompiler.beginMethod(null, staticScope);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            Label label = new Label();
            this.method.ifnonnull(label);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(string);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(label);
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.this.buildStaticScopeNames(this.method, staticScope);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.invokeUtilityMethod("runBeginBlock", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
        }

        public void createNewForLoop(int n, CompilerCallback compilerCallback, CompilerCallback compilerCallback2, boolean bl, NodeType nodeType) {
            String string = "closure" + ++StandardASMCompiler.this.innerIndex;
            String string2 = "_" + string;
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, string2, null);
            aSMClosureCompiler.beginMethod(compilerCallback2, null);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            Label label = new Label();
            this.method.ifnonnull(label);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(string);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(label);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(n));
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.ldc(bl);
            this.method.ldc(BlockBody.asArgumentType(nodeType));
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        }

        public void createNewEndBlock(CompilerCallback compilerCallback) {
            String string = "END_closure" + ++StandardASMCompiler.this.innerIndex;
            String string2 = "_" + string;
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, string2, null);
            aSMClosureCompiler.beginMethod(null, null);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            Label label = new Label();
            this.method.ifnonnull(label);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(string);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(label);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(0));
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string2, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.ldc(false);
            this.method.ldc(0);
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
            this.loadRuntime();
            this.invokeUtilityMethod("registerEndBlock", CodegenUtils.sig(Void.TYPE, Block.class, Ruby.class));
            this.loadNil();
        }

        private void getCallbackFactory() {
            this.loadRuntime();
            this.getCompiledClass();
            this.method.dup();
            this.method.invokevirtual(CodegenUtils.p(Class.class), "getClassLoader", CodegenUtils.sig(ClassLoader.class));
            this.method.invokestatic(CodegenUtils.p(CallbackFactory.class), "createFactory", CodegenUtils.sig(CallbackFactory.class, CodegenUtils.params(Ruby.class, Class.class, ClassLoader.class)));
        }

        public void getCompiledClass() {
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, "$class", CodegenUtils.ci(Class.class));
        }

        private void getRubyClass() {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class));
        }

        public void println() {
            this.method.dup();
            this.method.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        }

        public void defineAlias(String string, String string2) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.method.ldc(string2);
            this.invokeUtilityMethod("defineAlias", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, String.class));
        }

        public void loadFalse() {
            this.loadRuntime();
            this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class));
        }

        public void loadTrue() {
            this.loadRuntime();
            this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class));
        }

        public void loadCurrentModule() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getStaticScope", CodegenUtils.sig(StaticScope.class));
            this.method.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class));
        }

        public void retrieveInstanceVariable(String string) {
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(string);
            this.invokeUtilityMethod("fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class, String.class));
        }

        public void assignInstanceVariable(String string) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class));
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastSetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void retrieveGlobalVariable(String string) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "get", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void assignGlobalVariable(String string) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void negateCurrentValue() {
            this.loadRuntime();
            this.invokeUtilityMethod("negate", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
        }

        public void splatCurrentValue() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(ASTInterpreter.class), "splatValue", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class, Ruby.class)));
        }

        public void singlifySplattedValue() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(ASTInterpreter.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, Ruby.class)));
        }

        public void aryToAry() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(ASTInterpreter.class), "aryToAry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, Ruby.class)));
        }

        public void ensureRubyArray() {
            this.invokeUtilityMethod("ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void ensureMultipleAssignableRubyArray(boolean bl) {
            this.loadRuntime();
            this.method.swap();
            this.method.ldc(new Boolean(bl));
            this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject.class, Boolean.TYPE)));
        }

        public void forEachInValueArray(int n, int n2, Object object, ArrayCallback arrayCallback, ArrayCallback arrayCallback2, CompilerCallback compilerCallback) {
            Label label;
            Label label2;
            while (n < n2) {
                label2 = new Label();
                label = new Label();
                this.method.dup();
                this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "getLength", CodegenUtils.sig(Integer.TYPE));
                this.method.ldc(new Integer(n));
                this.method.if_icmple(label2);
                this.method.dup();
                this.method.ldc(new Integer(n));
                this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "entry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE)));
                arrayCallback.nextValue(this, object, n);
                this.method.go_to(label);
                this.method.label(label2);
                arrayCallback2.nextValue(this, object, n);
                this.method.label(label);
                this.method.pop();
                ++n;
            }
            if (compilerCallback != null) {
                label2 = new Label();
                label = new Label();
                this.method.dup();
                this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "getLength", CodegenUtils.sig(Integer.TYPE));
                this.method.ldc(new Integer(n));
                this.method.if_icmple(label2);
                this.method.dup();
                this.method.ldc(n);
                this.invokeUtilityMethod("createSubarray", CodegenUtils.sig(RubyArray.class, RubyArray.class, Integer.TYPE));
                this.method.go_to(label);
                this.method.label(label2);
                this.createEmptyArray();
                this.method.label(label);
                compilerCallback.call(this);
                this.method.pop();
            }
        }

        public void asString() {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
        }

        public void toJavaString() {
            this.method.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class));
        }

        public void nthRef(int n) {
            this.method.ldc(new Integer(n));
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
        }

        public void match() {
            this.loadThreadContext();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match2", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
        }

        public void match2() {
            this.loadThreadContext();
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
        }

        public void match3() {
            this.loadThreadContext();
            this.invokeUtilityMethod("match3", CodegenUtils.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
        }

        public void createNewRegexp(ByteList byteList, int n) {
            String string = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
            Label label = new Label();
            this.method.ifnonnull(label);
            String string2 = byteList.toString();
            this.loadRuntime();
            this.method.ldc(string2);
            this.method.ldc(new Integer(n));
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, String.class, Integer.TYPE)));
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
            this.method.label(label);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
        }

        public void createNewRegexp(CompilerCallback compilerCallback, int n) {
            boolean bl = (n & 0x80) != 0;
            Label label = null;
            String string = null;
            if (bl) {
                string = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
                label = new Label();
                this.method.ifnonnull(label);
            }
            this.loadRuntime();
            compilerCallback.call(this);
            this.method.invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class));
            this.method.ldc(new Integer(n));
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, ByteList.class, Integer.TYPE)));
            if (bl) {
                this.method.aload(0);
                this.method.swap();
                this.method.putfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
                this.method.label(label);
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
            }
        }

        public void pollThreadEvents() {
            if (!RubyInstanceConfig.THREADLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.invokeThreadContext("pollThreadEvents", CodegenUtils.sig(Void.TYPE));
            }
        }

        public void nullToNil() {
            Label label = new Label();
            this.method.dup();
            this.method.ifnonnull(label);
            this.method.pop();
            this.method.aload(8);
            this.method.label(label);
        }

        public void isInstanceOf(Class clazz, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.method.instance_of(CodegenUtils.p(clazz));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isCaptured(final int n, final BranchCallback branchCallback, final BranchCallback branchCallback2) {
            this.backref();
            this.method.dup();
            this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyMatchData.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "use", CodegenUtils.sig(Void.TYPE));
                    AbstractMethodCompiler.this.method.ldc(new Long(n));
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "group", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Long.TYPE)));
                    AbstractMethodCompiler.this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE));
                    Label label = new Label();
                    Label label2 = new Label();
                    AbstractMethodCompiler.this.method.ifne(label);
                    branchCallback.branch(methodCompiler);
                    AbstractMethodCompiler.this.method.go_to(label2);
                    AbstractMethodCompiler.this.method.label(label);
                    branchCallback2.branch(methodCompiler);
                    AbstractMethodCompiler.this.method.label(label2);
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    AbstractMethodCompiler.this.method.pop();
                    branchCallback2.branch(methodCompiler);
                }
            });
        }

        public void branchIfModule(CompilerCallback compilerCallback, BranchCallback branchCallback, BranchCallback branchCallback2) {
            compilerCallback.call(this);
            this.isInstanceOf(RubyModule.class, branchCallback, branchCallback2);
        }

        public void backref() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentFrame", CodegenUtils.sig(Frame.class));
            this.method.invokevirtual(CodegenUtils.p(Frame.class), "getBackRef", CodegenUtils.sig(IRubyObject.class));
        }

        public void backrefMethod(String string) {
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), string, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void issueLoopBreak() {
            this.method.go_to(this.currentLoopLabels[2]);
        }

        public void issueLoopNext() {
            this.method.go_to(this.currentLoopLabels[0]);
        }

        public void issueLoopRedo() {
            this.method.go_to(this.currentLoopLabels[1]);
        }

        protected String getNewEnsureName() {
            return "__ensure_" + StandardASMCompiler.this.ensureNumber++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void protect(BranchCallback branchCallback, BranchCallback branchCallback2, Class clazz) {
            String string = this.getNewEnsureName();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, CodegenUtils.sig(clazz, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class), null, null));
            SkinnyMethodAdapter skinnyMethodAdapter2 = null;
            SkinnyMethodAdapter skinnyMethodAdapter3 = null;
            SkinnyMethodAdapter skinnyMethodAdapter4 = null;
            boolean bl = this.withinProtection;
            this.withinProtection = true;
            try {
                skinnyMethodAdapter2 = this.method;
                skinnyMethodAdapter3 = this.getVariableCompiler().getMethodAdapter();
                skinnyMethodAdapter4 = this.getInvocationCompiler().getMethodAdapter();
                this.method = skinnyMethodAdapter;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter);
                skinnyMethodAdapter.visitCode();
                skinnyMethodAdapter.aload(1);
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(6);
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class));
                skinnyMethodAdapter.astore(8);
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(5);
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
                skinnyMethodAdapter.astore(7);
                Label label = new Label();
                Label label2 = new Label();
                Label label3 = new Label();
                Label label4 = new Label();
                this.method.label(label);
                branchCallback.branch(this);
                this.method.label(label2);
                branchCallback2.branch(this);
                skinnyMethodAdapter.areturn();
                this.method.label(label3);
                this.method.astore(9);
                this.method.label(label4);
                branchCallback2.branch(this);
                this.method.aload(9);
                this.method.athrow();
                this.method.trycatch(label, label2, label3, null);
                this.method.trycatch(label3, label4, label3, null);
                skinnyMethodAdapter.visitMaxs(1, 1);
                skinnyMethodAdapter.visitEnd();
                Object var15_14 = null;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.withinProtection = bl;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.withinProtection = bl;
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, CodegenUtils.sig(clazz, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }

        protected String getNewRescueName() {
            return "__rescue_" + StandardASMCompiler.this.rescueNumber++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rescue(BranchCallback branchCallback, Class clazz, BranchCallback branchCallback2, Class clazz2) {
            String string = this.getNewRescueName();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, CodegenUtils.sig(clazz2, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class), null, null));
            SkinnyMethodAdapter skinnyMethodAdapter2 = null;
            SkinnyMethodAdapter skinnyMethodAdapter3 = null;
            SkinnyMethodAdapter skinnyMethodAdapter4 = null;
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            Label label5 = new Label();
            boolean bl = this.withinProtection;
            this.withinProtection = true;
            try {
                skinnyMethodAdapter2 = this.method;
                skinnyMethodAdapter3 = this.getVariableCompiler().getMethodAdapter();
                skinnyMethodAdapter4 = this.getInvocationCompiler().getMethodAdapter();
                this.method = skinnyMethodAdapter;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter);
                skinnyMethodAdapter.visitCode();
                skinnyMethodAdapter.aload(1);
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(6);
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                skinnyMethodAdapter.astore(10);
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class));
                skinnyMethodAdapter.astore(8);
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(5);
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
                skinnyMethodAdapter.astore(7);
                Label label6 = new Label();
                Label label7 = new Label();
                Label label8 = new Label();
                skinnyMethodAdapter.visitTryCatchBlock(label6, label7, label8, CodegenUtils.p(clazz));
                skinnyMethodAdapter.visitLabel(label6);
                branchCallback.branch(this);
                skinnyMethodAdapter.label(label7);
                skinnyMethodAdapter.go_to(label5);
                skinnyMethodAdapter.label(label8);
                skinnyMethodAdapter.astore(9);
                branchCallback2.branch(this);
                skinnyMethodAdapter.label(label);
                skinnyMethodAdapter.go_to(label5);
                skinnyMethodAdapter.trycatch(label8, label, label2, CodegenUtils.p(JumpException.RetryJump.class));
                skinnyMethodAdapter.label(label2);
                skinnyMethodAdapter.pop();
                skinnyMethodAdapter.go_to(label6);
                skinnyMethodAdapter.trycatch(label6, label, label3, CodegenUtils.p(RaiseException.class));
                skinnyMethodAdapter.label(label3);
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.trycatch(label6, label, label4, CodegenUtils.p(JumpException.class));
                skinnyMethodAdapter.label(label4);
                this.loadRuntime();
                skinnyMethodAdapter.aload(10);
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.label(label5);
                this.loadRuntime();
                skinnyMethodAdapter.aload(10);
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.areturn();
                skinnyMethodAdapter.visitMaxs(1, 1);
                skinnyMethodAdapter.visitEnd();
                Object var20_19 = null;
                this.withinProtection = bl;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                this.withinProtection = bl;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, CodegenUtils.sig(clazz2, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }

        public void inDefined() {
            this.method.aload(1);
            this.method.iconst_1();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        public void outDefined() {
            this.method.aload(1);
            this.method.iconst_0();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        public void stringOrNil() {
            this.loadRuntime();
            this.loadNil();
            this.invokeUtilityMethod("stringOrNil", CodegenUtils.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
        }

        public void pushNull() {
            this.method.aconst_null();
        }

        public void pushString(String string) {
            this.method.ldc(string);
        }

        public void isMethodBound(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.metaclass();
            this.method.ldc(string);
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void hasBlock(BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadBlock();
            this.method.invokevirtual(CodegenUtils.p(Block.class), "isGiven", CodegenUtils.sig(Boolean.TYPE));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isGlobalDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "isDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isConstantDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.invokeThreadContext("getConstantDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isInstanceVariableDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class));
            this.method.ldc(string);
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastHasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifne(label);
            branchCallback2.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback.branch(this);
            this.method.label(label2);
        }

        public void isClassVarDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifne(label);
            branchCallback2.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback.branch(this);
            this.method.label(label2);
        }

        public Object getNewEnding() {
            return new Label();
        }

        public void isNil(BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isNull(BranchCallback branchCallback, BranchCallback branchCallback2) {
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifnonnull(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void ifNull(Object object) {
            this.method.ifnull((Label)object);
        }

        public void ifNotNull(Object object) {
            this.method.ifnonnull((Label)object);
        }

        public void setEnding(Object object) {
            this.method.label((Label)object);
        }

        public void go(Object object) {
            this.method.go_to((Label)object);
        }

        public void isConstantBranch(final BranchCallback branchCallback, final BranchCallback branchCallback2, final BranchCallback branchCallback3, final BranchCallback branchCallback4, final String string) {
            this.rescue(new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    branchCallback.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.instance_of(CodegenUtils.p(RubyModule.class));
                    Label label = new Label();
                    Label label2 = new Label();
                    Label label3 = new Label();
                    Label label4 = new Label();
                    AbstractMethodCompiler.this.method.ifeq(label3);
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ldc(string);
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantAt", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ifnull(label4);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.pop();
                    branchCallback2.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(label2);
                    AbstractMethodCompiler.this.method.label(label4);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.label(label3);
                    AbstractMethodCompiler.this.metaclass();
                    AbstractMethodCompiler.this.method.ldc(string);
                    AbstractMethodCompiler.this.method.iconst_1();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
                    AbstractMethodCompiler.this.method.ifeq(label);
                    branchCallback3.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(label2);
                    AbstractMethodCompiler.this.method.label(label);
                    branchCallback4.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.label(label2);
                }
            }, JumpException.class, branchCallback4, String.class);
        }

        public void metaclass() {
            this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class));
        }

        public void getVisibilityFor(String string) {
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
            this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "getVisibility", CodegenUtils.sig(Visibility.class));
        }

        public void isPrivate(Object object, int n) {
            this.method.invokevirtual(CodegenUtils.p(Visibility.class), "isPrivate", CodegenUtils.sig(Boolean.TYPE));
            Label label = new Label();
            this.method.ifeq(label);
            while (n-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)object);
            this.method.label(label);
        }

        public void isNotProtected(Object object, int n) {
            this.method.invokevirtual(CodegenUtils.p(Visibility.class), "isProtected", CodegenUtils.sig(Boolean.TYPE));
            Label label = new Label();
            this.method.ifne(label);
            while (n-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)object);
            this.method.label(label);
        }

        public void selfIsKindOf(Object object) {
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "getRealClass", CodegenUtils.sig(RubyClass.class));
            this.loadSelf();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.ifne((Label)object);
        }

        public void notIsModuleAndClassVarDefined(String string, Object object) {
            this.method.dup();
            this.method.instance_of(CodegenUtils.p(RubyModule.class));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            this.method.ifeq((Label)object);
            this.method.go_to(label2);
            this.method.label(label);
            this.method.pop();
            this.method.go_to((Label)object);
            this.method.label(label2);
        }

        public void ifSingleton(Object object) {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isSingleton", CodegenUtils.sig(Boolean.TYPE));
            this.method.ifne((Label)object);
        }

        public void getInstanceVariable(String string) {
            this.method.ldc(string);
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class));
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void getFrameName() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameName", CodegenUtils.sig(String.class));
        }

        public void getFrameKlazz() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameKlazz", CodegenUtils.sig(RubyModule.class));
        }

        public void superClass() {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "getSuperClass", CodegenUtils.sig(RubyClass.class));
        }

        public void attached() {
            this.method.visitTypeInsn(192, CodegenUtils.p(MetaClass.class));
            this.method.invokevirtual(CodegenUtils.p(MetaClass.class), "getAttached", CodegenUtils.sig(IRubyObject.class));
        }

        public void ifNotSuperMethodBound(Object object) {
            this.method.swap();
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            this.method.ifeq((Label)object);
        }

        public void concatArrays() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "concat", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void concatObjectArrays() {
            this.invokeUtilityMethod("concatObjectArrays", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject[].class)));
        }

        public void appendToArray() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "append", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void appendToObjectArray() {
            this.invokeUtilityMethod("appendToObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class)));
        }

        public void convertToJavaArray() {
            this.method.invokestatic(CodegenUtils.p(ArgsUtil.class), "convertToJavaArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class)));
        }

        public void aliasGlobal(String string, String string2) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.ldc(string);
            this.method.ldc(string2);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
            this.loadNil();
        }

        public void undefMethod(String string) {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class));
            Label label = new Label();
            this.method.dup();
            this.method.ifnonnull(label);
            this.method.pop();
            this.loadRuntime();
            this.method.ldc("No class to undef method '" + string + "'.");
            this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
            this.method.athrow();
            this.method.label(label);
            this.loadThreadContext();
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "undef", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            this.loadNil();
        }

        public void defineClass(final String string, final StaticScope staticScope, final CompilerCallback compilerCallback, final CompilerCallback compilerCallback2, CompilerCallback compilerCallback3, final CompilerCallback compilerCallback4) {
            String string2 = "rubyclass__" + JavaNameMangler.mangleStringForCleanJavaIdentifier(string) + "__" + ++StandardASMCompiler.this.methodIndex;
            final ASMMethodCompiler aSMMethodCompiler = new ASMMethodCompiler(string2, null);
            CompilerCallback compilerCallback5 = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    if (compilerCallback4 == null) {
                        if (compilerCallback != null) {
                            aSMMethodCompiler.loadRuntime();
                            compilerCallback.call(aSMMethodCompiler);
                            aSMMethodCompiler.invokeUtilityMethod("prepareSuperClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                        } else {
                            aSMMethodCompiler.method.aconst_null();
                        }
                        aSMMethodCompiler.loadThreadContext();
                        compilerCallback2.call(aSMMethodCompiler);
                        aSMMethodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                        aSMMethodCompiler.method.swap();
                        aSMMethodCompiler.method.ldc(string);
                        aSMMethodCompiler.method.swap();
                        aSMMethodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetClassUnder", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(String.class, RubyClass.class)));
                    } else {
                        aSMMethodCompiler.loadRuntime();
                        aSMMethodCompiler.method.aload(3);
                        aSMMethodCompiler.method.iconst_0();
                        aSMMethodCompiler.method.arrayload();
                        aSMMethodCompiler.invokeUtilityMethod("getSingletonClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                    }
                    aSMMethodCompiler.method.dup();
                    aSMMethodCompiler.method.astore(2);
                    aSMMethodCompiler.loadThreadContext();
                    aSMMethodCompiler.method.swap();
                    StandardASMCompiler.this.buildStaticScopeNames(aSMMethodCompiler.method, staticScope);
                    aSMMethodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            aSMMethodCompiler.method.trycatch(label, label2, label3, null);
            aSMMethodCompiler.beginClass(compilerCallback5, staticScope);
            aSMMethodCompiler.method.label(label);
            compilerCallback3.call(aSMMethodCompiler);
            aSMMethodCompiler.method.label(label2);
            aSMMethodCompiler.loadThreadContext();
            aSMMethodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            aSMMethodCompiler.method.go_to(label4);
            aSMMethodCompiler.method.label(label3);
            aSMMethodCompiler.loadThreadContext();
            aSMMethodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            aSMMethodCompiler.method.athrow();
            aSMMethodCompiler.method.label(label4);
            aSMMethodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (compilerCallback4 == null) {
                this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            } else {
                compilerCallback4.call(this);
                this.createObjectArray(1);
            }
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, string2, METHOD_SIGNATURE);
        }

        public void defineModule(final String string, final StaticScope staticScope, final CompilerCallback compilerCallback, CompilerCallback compilerCallback2) {
            String string2 = "rubyclass__" + JavaNameMangler.mangleStringForCleanJavaIdentifier(string) + "__" + ++StandardASMCompiler.this.methodIndex;
            final ASMMethodCompiler aSMMethodCompiler = new ASMMethodCompiler(string2, null);
            CompilerCallback compilerCallback3 = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    aSMMethodCompiler.loadThreadContext();
                    compilerCallback.call(aSMMethodCompiler);
                    aSMMethodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                    aSMMethodCompiler.method.ldc(string);
                    aSMMethodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(String.class)));
                    aSMMethodCompiler.method.dup();
                    aSMMethodCompiler.method.astore(2);
                    aSMMethodCompiler.loadThreadContext();
                    aSMMethodCompiler.method.swap();
                    StandardASMCompiler.this.buildStaticScopeNames(aSMMethodCompiler.method, staticScope);
                    aSMMethodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            aSMMethodCompiler.method.trycatch(label, label2, label3, null);
            aSMMethodCompiler.beginClass(compilerCallback3, staticScope);
            aSMMethodCompiler.method.label(label);
            compilerCallback2.call(aSMMethodCompiler);
            aSMMethodCompiler.method.label(label2);
            aSMMethodCompiler.method.go_to(label4);
            aSMMethodCompiler.method.label(label3);
            aSMMethodCompiler.loadThreadContext();
            aSMMethodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            aSMMethodCompiler.method.athrow();
            aSMMethodCompiler.method.label(label4);
            aSMMethodCompiler.loadThreadContext();
            aSMMethodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            aSMMethodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, string2, METHOD_SIGNATURE);
        }

        public void unwrapPassedBlock() {
            this.loadBlock();
            this.invokeUtilityMethod("getBlockFromBlockPassBody", CodegenUtils.sig(Block.class, CodegenUtils.params(IRubyObject.class, Block.class)));
        }

        public void performBackref(char c) {
            this.loadThreadContext();
            switch (c) {
                case '~': {
                    this.invokeUtilityMethod("backref", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '&': {
                    this.invokeUtilityMethod("backrefLastMatch", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '`': {
                    this.invokeUtilityMethod("backrefMatchPre", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '\'': {
                    this.invokeUtilityMethod("backrefMatchPost", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '+': {
                    this.invokeUtilityMethod("backrefMatchLast", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                default: {
                    throw new NotCompilableException("ERROR: backref with invalid type");
                }
            }
        }

        public void callZSuper(CompilerCallback compilerCallback) {
            this.loadRuntime();
            this.loadThreadContext();
            if (compilerCallback != null) {
                compilerCallback.call(this);
            } else {
                this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
            this.loadSelf();
            this.invokeUtilityMethod("callZSuper", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, IRubyObject.class)));
        }

        public void checkIsExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, RubyException.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        public void rethrowException() {
            this.loadException();
            this.method.athrow();
        }

        public void loadClass(String string) {
            this.loadRuntime();
            this.method.ldc(string);
            this.invokeIRuby("getClass", CodegenUtils.sig(RubyClass.class, String.class));
        }

        public void unwrapRaiseException() {
            this.method.invokevirtual(CodegenUtils.p(RaiseException.class), "getException", CodegenUtils.sig(RubyException.class));
        }

        public void loadException() {
            this.method.aload(9);
        }

        public void setFilePosition(ISourcePosition iSourcePosition) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.method.ldc(iSourcePosition.getFile());
                this.invokeThreadContext("setFile", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class)));
            }
        }

        public void setLinePosition(ISourcePosition iSourcePosition) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                this.setFilePosition(iSourcePosition);
                this.loadThreadContext();
                this.method.ldc(iSourcePosition.getStartLine());
                this.invokeThreadContext("setLine", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
            }
        }

        public void checkWhenWithSplat() {
            this.loadThreadContext();
            this.invokeUtilityMethod("isWhenTriggered", CodegenUtils.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        public void issueRetryEvent() {
            this.invokeUtilityMethod("retryJump", CodegenUtils.sig(IRubyObject.class));
        }

        public void defineNewMethod(String string, int n, StaticScope staticScope, CompilerCallback compilerCallback, CompilerCallback compilerCallback2, CompilerCallback compilerCallback3, ASTInspector aSTInspector, boolean bl) {
            ++StandardASMCompiler.this.methodIndex;
            String string2 = bl && Boolean.getBoolean("jruby.compile.toplevel") ? string : JavaNameMangler.mangleStringForCleanJavaIdentifier(string) + "__" + StandardASMCompiler.this.methodIndex;
            MethodCompiler methodCompiler = StandardASMCompiler.this.startMethod(string2, compilerCallback2, staticScope, aSTInspector);
            compilerCallback.call(methodCompiler);
            methodCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            if (compilerCallback3 != null) {
                compilerCallback3.call(this);
            }
            this.method.aload(0);
            this.method.ldc(string);
            this.method.ldc(string2);
            StandardASMCompiler.this.buildStaticScopeNames(this.method, staticScope);
            this.method.ldc(n);
            this.method.ldc(staticScope.getRequiredArgs());
            this.method.ldc(staticScope.getOptionalArgs());
            this.method.ldc(staticScope.getRestArg());
            if (aSTInspector.hasFrameAwareMethods() || !RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED) {
                if (aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods()) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods()) {
                if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.SCOPE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.NO_FRAME_NO_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
            }
            if (compilerCallback3 != null) {
                this.invokeUtilityMethod("defs", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            } else {
                this.invokeUtilityMethod("def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            }
        }

        public void rethrowIfSystemExit() {
            this.loadRuntime();
            this.method.ldc("SystemExit");
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "fastGetClass", CodegenUtils.sig(RubyClass.class, String.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.iconst_0();
            Label label = new Label();
            this.method.if_icmpeq(label);
            this.loadException();
            this.method.athrow();
            this.method.label(label);
        }
    }
}

