/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;

public class FieldBasedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    Map<String, String> sourcePositions = new HashMap<String, String>();
    Map<String, String> byteLists = new HashMap<String, String>();
    Map<BigInteger, String> bigIntegers = new HashMap<BigInteger, String>();
    Map<String, String> symbols = new HashMap<String, String>();

    public FieldBasedCacheCompiler(StandardASMCompiler standardASMCompiler) {
        this.scriptCompiler = standardASMCompiler;
    }

    public void cacheCallSite(SkinnyMethodAdapter skinnyMethodAdapter, String string, CallType callType) {
        String string2 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CallSite.class), JavaNameMangler.mangleStringForCleanJavaIdentifier(string));
        SkinnyMethodAdapter skinnyMethodAdapter2 = this.scriptCompiler.getInitMethod();
        skinnyMethodAdapter2.aload(0);
        skinnyMethodAdapter2.ldc(string);
        if (callType.equals(CallType.NORMAL)) {
            skinnyMethodAdapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            skinnyMethodAdapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            skinnyMethodAdapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        skinnyMethodAdapter2.putfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CallSite.class));
        skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CallSite.class));
    }

    public void cachePosition(SkinnyMethodAdapter skinnyMethodAdapter, String string, int n) {
        String string2 = JavaNameMangler.mangleStringForCleanJavaIdentifier(string + "$" + n);
        String string3 = this.sourcePositions.get(string2);
        if (string3 == null) {
            SkinnyMethodAdapter skinnyMethodAdapter2 = this.scriptCompiler.getClassInitMethod();
            string3 = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ISourcePosition.class), string2);
            this.sourcePositions.put(JavaNameMangler.mangleStringForCleanJavaIdentifier(string + "$" + n), string3);
            skinnyMethodAdapter2.ldc(string);
            skinnyMethodAdapter2.ldc(n);
            skinnyMethodAdapter2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructPosition", CodegenUtils.sig(ISourcePosition.class, String.class, Integer.TYPE));
            skinnyMethodAdapter2.putstatic(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(ISourcePosition.class));
        }
        skinnyMethodAdapter.getstatic(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(ISourcePosition.class));
    }

    public void cacheByteList(SkinnyMethodAdapter skinnyMethodAdapter, String string) {
        String string2 = this.byteLists.get(string);
        if (string2 == null) {
            SkinnyMethodAdapter skinnyMethodAdapter2 = this.scriptCompiler.getClassInitMethod();
            string2 = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ByteList.class), "byteList");
            this.byteLists.put(string, string2);
            skinnyMethodAdapter2.ldc(string);
            skinnyMethodAdapter2.invokestatic(CodegenUtils.p(ByteList.class), "create", CodegenUtils.sig(ByteList.class, CharSequence.class));
            skinnyMethodAdapter2.putstatic(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(ByteList.class));
        }
        skinnyMethodAdapter.getstatic(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(ByteList.class));
    }

    public void cacheBigInteger(SkinnyMethodAdapter skinnyMethodAdapter, BigInteger bigInteger) {
        String string = this.bigIntegers.get(bigInteger);
        if (string == null) {
            SkinnyMethodAdapter skinnyMethodAdapter2 = this.scriptCompiler.getClassInitMethod();
            string = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(BigInteger.class), "bigInt");
            this.bigIntegers.put(bigInteger, string);
            skinnyMethodAdapter2.newobj(CodegenUtils.p(BigInteger.class));
            skinnyMethodAdapter2.dup();
            skinnyMethodAdapter2.ldc(bigInteger.toString());
            skinnyMethodAdapter2.invokespecial(CodegenUtils.p(BigInteger.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
            skinnyMethodAdapter2.putstatic(this.scriptCompiler.getClassname(), string, CodegenUtils.ci(BigInteger.class));
        }
        skinnyMethodAdapter.getstatic(this.scriptCompiler.getClassname(), string, CodegenUtils.ci(BigInteger.class));
    }

    public void cacheSymbol(SkinnyMethodAdapter skinnyMethodAdapter, String string) {
        String string2 = this.symbols.get(string);
        if (string2 == null) {
            String string3 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubySymbol.class), "symbol");
            string2 = "getSymbol" + string3;
            this.symbols.put(string, string2);
            ClassVisitor classVisitor = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter skinnyMethodAdapter2 = new SkinnyMethodAdapter(classVisitor.visitMethod(4098, string2, CodegenUtils.sig(RubySymbol.class, Ruby.class), null, null));
            skinnyMethodAdapter2.start();
            skinnyMethodAdapter2.aload(0);
            skinnyMethodAdapter2.getfield(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(RubySymbol.class));
            skinnyMethodAdapter2.dup();
            skinnyMethodAdapter2.astore(2);
            Label label = new Label();
            skinnyMethodAdapter2.ifnull(label);
            skinnyMethodAdapter2.aload(2);
            skinnyMethodAdapter2.areturn();
            skinnyMethodAdapter2.label(label);
            skinnyMethodAdapter2.aload(0);
            skinnyMethodAdapter2.aload(1);
            skinnyMethodAdapter2.ldc(string);
            skinnyMethodAdapter2.invokevirtual(CodegenUtils.p(Ruby.class), "fastNewSymbol", CodegenUtils.sig(RubySymbol.class, String.class));
            skinnyMethodAdapter2.dup_x1();
            skinnyMethodAdapter2.putfield(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(RubySymbol.class));
            skinnyMethodAdapter2.areturn();
            skinnyMethodAdapter2.end();
        }
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(6);
        skinnyMethodAdapter.invokevirtual(this.scriptCompiler.getClassname(), string2, CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(Ruby.class)));
    }
}

