/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ClassCache;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class JITCompiler {
    public static final boolean USE_CACHE = true;

    public static void runJIT(DefaultMethod defaultMethod, Ruby ruby, ThreadContext threadContext, String string) {
        Set<Script> set = ruby.getJittedMethods();
        RubyInstanceConfig rubyInstanceConfig = ruby.getInstanceConfig();
        ClassCache classCache = rubyInstanceConfig.getClassCache();
        if (defaultMethod.getCallCount() < 0) {
            return;
        }
        try {
            defaultMethod.setCallCount(defaultMethod.getCallCount() + 1);
            if (defaultMethod.getCallCount() >= rubyInstanceConfig.getJitThreshold()) {
                int n;
                if (classCache.isFull()) {
                    defaultMethod.setCallCount(-1);
                    return;
                }
                JITClassGenerator jITClassGenerator = new JITClassGenerator(string, defaultMethod, threadContext);
                String string2 = SexpMaker.create(string, defaultMethod.getArgsNode(), defaultMethod.getBodyNode());
                Class clazz = rubyInstanceConfig.getClassCache().cacheClassByKey(string2, jITClassGenerator);
                if (clazz == null) {
                    defaultMethod.setCallCount(-1);
                    return;
                }
                Script script = (Script)clazz.newInstance();
                set.add(script);
                if (rubyInstanceConfig.getJitLogEvery() > 0 && (n = set.size()) % rubyInstanceConfig.getJitLogEvery() == 0) {
                    JITCompiler.log(defaultMethod, string, "live compiled methods: " + n, new String[0]);
                }
                if (rubyInstanceConfig.isJitLogging()) {
                    JITCompiler.log(defaultMethod, string, "done jitting", new String[0]);
                }
                defaultMethod.setJITCallConfig(jITClassGenerator.callConfig());
                defaultMethod.setJITCompiledScript(script);
                defaultMethod.setCallCount(-1);
            }
        }
        catch (Throwable throwable) {
            if (rubyInstanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(defaultMethod, string, "could not compile", throwable.getMessage());
            }
            defaultMethod.setCallCount(-1);
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node node) {
        if (node != null) {
            return node.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod defaultMethod, String string, String string2, String ... stringArray) {
        String string3 = defaultMethod.getImplementationClass().getBaseName();
        if (string3 == null) {
            string3 = "<anon class>";
        }
        System.err.print(string2 + ":" + string3 + "." + string);
        if (stringArray.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.print(stringArray[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    public static class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private StandardASMCompiler asmCompiler;
        private DefaultMethod method;
        private StaticScope staticScope;
        private Node bodyNode;
        private ArgsNode argsNode;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String string, DefaultMethod defaultMethod, ThreadContext threadContext) {
            this.method = defaultMethod;
            String string2 = "ruby/jit/" + JavaNameMangler.mangleFilenameForClasspath(defaultMethod.getPosition().getFile());
            String string3 = string2 + "/" + JavaNameMangler.mangleStringForCleanJavaIdentifier(string);
            this.bodyNode = defaultMethod.getBodyNode();
            this.argsNode = defaultMethod.getArgsNode();
            String string4 = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = defaultMethod.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(string3 + defaultMethod.hashCode() + "_" + threadContext.hashCode(), string4);
        }

        protected void compile() {
            MethodCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler aSTCompiler = new ASTCompiler();
            CompilerCallback compilerCallback = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    aSTCompiler.compileArgs(JITClassGenerator.this.argsNode, methodCompiler);
                }
            };
            ASTInspector aSTInspector = new ASTInspector();
            aSTInspector.inspect(this.bodyNode);
            aSTInspector.inspect(this.argsNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startMethod("__file__", compilerCallback, this.staticScope, aSTInspector);
                aSTCompiler.compile(this.bodyNode, methodCompiler);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startMethod("__file__", compilerCallback, this.staticScope, aSTInspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startMethod("__file__", null, this.staticScope, aSTInspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.NO_FRAME_NO_SCOPE;
            }
            methodCompiler.endMethod();
            this.asmCompiler.endScript(false, false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods() ? CallConfiguration.FRAME_AND_SCOPE : CallConfiguration.FRAME_ONLY;
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            this.name = CodegenUtils.c(this.asmCompiler.getClassname());
        }

        public byte[] bytecode() {
            this.compile();
            return this.bytecode;
        }

        public String name() {
            this.compile();
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }
    }
}

