/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.InterpretedBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterNode
extends Node {
    private final Node varNode;
    private final Node bodyNode;
    private StaticScope scope;
    private InterpretedBlock blockBody;

    public IterNode(ISourcePosition iSourcePosition, Node node, StaticScope staticScope, Node node2) {
        this(iSourcePosition, node, staticScope, node2, NodeType.ITERNODE);
    }

    public IterNode(ISourcePosition iSourcePosition, Node node, StaticScope staticScope, Node node2, NodeType nodeType) {
        super(iSourcePosition, nodeType);
        this.varNode = node;
        this.scope = staticScope;
        this.bodyNode = node2;
        NodeType nodeType2 = BlockBody.getArgumentTypeWackyHack(this);
        this.blockBody = new InterpretedBlock(this, Arity.procArityOf(node), BlockBody.asArgumentType(nodeType2));
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    public InterpretedBlock getBlockBody() {
        return this.blockBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }
}

