/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixnumNode
extends Node
implements ILiteralNode {
    private long value;
    private RubyFixnum fixnum;

    public FixnumNode(ISourcePosition iSourcePosition, long l) {
        super(iSourcePosition, NodeType.FIXNUMNODE);
        this.value = l;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFixnumNode(this);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        if (this.fixnum != null) {
            this.fixnum = null;
        }
        this.value = l;
    }

    public RubyFixnum getFixnum(Ruby ruby) {
        if (this.fixnum == null) {
            this.fixnum = RubyFixnum.newFixnum(ruby, this.value);
            return this.fixnum;
        }
        return this.fixnum;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

