/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    public CallNode(ISourcePosition iSourcePosition, Node node, String string, Node node2) {
        this(iSourcePosition, node, string, node2, null);
    }

    public CallNode(ISourcePosition iSourcePosition, Node node, String string, Node node2, Node node3) {
        super(iSourcePosition, NodeType.CALLNODE);
        this.receiverNode = node;
        this.setArgsNode(node2);
        this.iterNode = node3;
        this.callAdapter = new CallSite.InlineCachingCallSite(string, CallType.NORMAL);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public void setIterNode(Node node) {
        this.iterNode = node;
        this.callAdapter = new CallSite.InlineCachingCallSite(this.callAdapter.methodName, CallType.NORMAL);
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public void setArgsNode(Node node) {
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "CallNode: " + this.getName();
    }
}

