/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.IdUtil;

public class RubyStruct
extends RubyObject {
    private IRubyObject[] values;
    private static ObjectAllocator STRUCT_INSTANCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyStruct rubyStruct = new RubyStruct(ruby, rubyClass);
            rubyStruct.setMetaClass(rubyClass);
            return rubyStruct;
        }
    };

    public RubyStruct(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createStructClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Struct", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setStructClass(rubyClass);
        rubyClass.index = 15;
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyStruct.class);
        return rubyClass;
    }

    public int getNativeTypeIndex() {
        return 15;
    }

    private static IRubyObject getInternalVariable(RubyClass rubyClass, String string) {
        RubyClass rubyClass2 = rubyClass.getRuntime().getStructClass();
        while (rubyClass != null && rubyClass != rubyClass2) {
            IRubyObject iRubyObject = rubyClass.fastGetInternalVariable(string);
            if (iRubyObject != null) {
                return iRubyObject;
            }
            rubyClass = rubyClass.getSuperClass();
        }
        return rubyClass.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen("Struct is frozen");
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify struct");
        }
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext threadContext) {
        Ruby ruby = this.getRuntime();
        int n = this.getMetaClass().getRealClass().hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            n = n << 1 | (n < 0 ? 1 : 0);
            n = (int)((long)n ^ RubyNumeric.num2long(this.values[i].callMethod(threadContext, MethodIndex.HASH, "hash")));
        }
        return ruby.newFixnum(n);
    }

    private IRubyObject setByName(String string, IRubyObject iRubyObject) {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        this.modify();
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            if (!rubyArray.eltInternal(i).asJavaString().equals(string)) continue;
            this.values[i] = iRubyObject;
            return this.values[i];
        }
        throw this.notStructMemberError(string);
    }

    private IRubyObject getByName(String string) {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            if (!rubyArray.eltInternal(i).asJavaString().equals(string)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(string);
    }

    @JRubyMethod(name={"new"}, required=1, rest=true, frame=true, meta=true)
    public static RubyClass newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        int n;
        Object object;
        RubyClass rubyClass;
        int n2;
        IRubyObject iRubyObject2;
        String string = null;
        boolean bl = false;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray.length > 0) {
            iRubyObject2 = iRubyObjectArray[0].checkStringType();
            if (!iRubyObject2.isNil()) {
                string = ((RubyString)iRubyObject2).getByteList().toString();
            } else if (iRubyObjectArray[0].isNil()) {
                bl = true;
            }
        }
        iRubyObject2 = ruby.newArray();
        int n3 = n2 = string == null && !bl ? 0 : 1;
        while (n2 < iRubyObjectArray.length) {
            ((RubyArray)iRubyObject2).append(ruby.newSymbol(iRubyObjectArray[n2].asJavaString()));
            ++n2;
        }
        RubyClass rubyClass2 = (RubyClass)iRubyObject;
        if (string == null || bl) {
            rubyClass = RubyClass.newClass(ruby, rubyClass2);
            rubyClass.setAllocator(STRUCT_INSTANCE_ALLOCATOR);
            rubyClass.makeMetaClass(rubyClass2.getMetaClass());
            rubyClass.inherit(rubyClass2);
        } else {
            if (!IdUtil.isConstant(string)) {
                throw ruby.newNameError("identifier " + string + " needs to be constant", string);
            }
            object = rubyClass2.getConstantAt(string);
            if (object != null) {
                Frame frame = ruby.getCurrentContext().getCurrentFrame();
                ruby.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, frame.getFile(), frame.getLine(), "redefining constant Struct::" + string, string);
                rubyClass2.remove_const(ruby.newString(string));
            }
            rubyClass = rubyClass2.defineClassUnder(string, rubyClass2, STRUCT_INSTANCE_ALLOCATOR);
        }
        rubyClass.index = 15;
        rubyClass.fastSetInternalVariable("__size__", ((RubyArray)iRubyObject2).length());
        rubyClass.fastSetInternalVariable("__member__", iRubyObject2);
        object = ruby.callbackFactory(RubyStruct.class);
        rubyClass.getSingletonClass().defineMethod("new", ((CallbackFactory)object).getOptSingletonMethod("newStruct"));
        rubyClass.getSingletonClass().defineMethod("[]", ((CallbackFactory)object).getOptSingletonMethod("newStruct"));
        rubyClass.getSingletonClass().defineMethod("members", ((CallbackFactory)object).getSingletonMethod("members"));
        int n4 = n = string == null && !bl ? 0 : 1;
        while (n < iRubyObjectArray.length) {
            String string2 = iRubyObjectArray[n].asJavaString();
            final int n5 = string == null && !bl ? n : n - 1;
            rubyClass.addMethod(string2, new DynamicMethod(rubyClass, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 0);
                    return ((RubyStruct)iRubyObject).get(n5);
                }

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                    return ((RubyStruct)iRubyObject).get(n5);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
            rubyClass.addMethod(string2 + "=", new DynamicMethod(rubyClass, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, 1);
                    return ((RubyStruct)iRubyObject).set(iRubyObjectArray[0], n5);
                }

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
                    return ((RubyStruct)iRubyObject).set(iRubyObject2, n5);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
            ++n;
        }
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yield(ruby.getCurrentContext(), null, rubyClass, rubyClass, false);
        }
        return rubyClass;
    }

    public static RubyStruct newStruct(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyStruct rubyStruct = new RubyStruct(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
        int n = RubyNumeric.fix2int(RubyStruct.getInternalVariable((RubyClass)iRubyObject, "__size__"));
        rubyStruct.values = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            rubyStruct.values[i] = iRubyObject.getRuntime().getNil();
        }
        rubyStruct.callInit(iRubyObjectArray, block);
        return rubyStruct;
    }

    @JRubyMethod(rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        this.modify();
        int n = RubyNumeric.fix2int(RubyStruct.getInternalVariable(this.getMetaClass(), "__size__"));
        if (iRubyObjectArray.length > n) {
            throw this.getRuntime().newArgumentError("struct size differs (" + iRubyObjectArray.length + " for " + n + ")");
        }
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.values[i] = iRubyObjectArray[i];
        }
        return this.getRuntime().getNil();
    }

    public static RubyArray members(IRubyObject iRubyObject, Block block) {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable((RubyClass)iRubyObject, "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        RubyArray rubyArray2 = iRubyObject.getRuntime().newArray(rubyArray.getLength());
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            rubyArray2.append(iRubyObject.getRuntime().newString(rubyArray.eltInternal(i).asJavaString()));
        }
        return rubyArray2;
    }

    @JRubyMethod
    public RubyArray members() {
        return RubyStruct.members(this.classOf(), Block.NULL_BLOCK);
    }

    @JRubyMethod
    public RubyArray select(ThreadContext threadContext, Block block) {
        RubyArray rubyArray = RubyArray.newArray(threadContext.getRuntime());
        for (int i = 0; i < this.values.length; ++i) {
            if (!block.yield(threadContext, this.values[i]).isTrue()) continue;
            rubyArray.append(this.values[i]);
        }
        return rubyArray;
    }

    public IRubyObject set(IRubyObject iRubyObject, int n) {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        this.modify();
        this.values[n] = iRubyObject;
        return this.values[n];
    }

    private RaiseException notStructMemberError(String string) {
        return this.getRuntime().newNameError(string + " is not struct member", string);
    }

    public IRubyObject get(int n) {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        return this.values[n];
    }

    public void copySpecialInstanceVariables(IRubyObject iRubyObject) {
        RubyStruct rubyStruct = (RubyStruct)iRubyObject;
        rubyStruct.values = new IRubyObject[this.values.length];
        System.arraycopy(this.values, 0, rubyStruct.values, 0, this.values.length);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass().getRealClass() != iRubyObject.getMetaClass().getRealClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby ruby = this.getRuntime();
        RubyStruct rubyStruct = (RubyStruct)iRubyObject;
        for (int i = 0; i < this.values.length; ++i) {
            if (RubyStruct.equalInternal(threadContext, this.values[i], rubyStruct.values[i]).isTrue()) continue;
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass() != iRubyObject.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby ruby = this.getRuntime();
        RubyStruct rubyStruct = (RubyStruct)iRubyObject;
        for (int i = 0; i < this.values.length; ++i) {
            if (RubyStruct.eqlInternal(threadContext, this.values[i], rubyStruct.values[i])) continue;
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.inspect();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<struct ").append(this.getMetaClass().getRealClass().getName()).append(' ');
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(rubyArray.eltInternal(i).asJavaString()).append("=");
            stringBuffer.append(this.values[i].callMethod(this.getRuntime().getCurrentContext(), "inspect"));
        }
        stringBuffer.append('>');
        return this.getRuntime().newString(stringBuffer.toString());
    }

    @JRubyMethod(name={"to_a", "values"})
    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    @JRubyMethod(name={"each"}, backtrace=true)
    public IRubyObject each(ThreadContext threadContext, Block block) {
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(threadContext, this.values[i]);
        }
        return this;
    }

    @JRubyMethod(frame=true)
    public IRubyObject each_pair(ThreadContext threadContext, Block block) {
        RubyArray rubyArray = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!rubyArray.isNil()) : "uninitialized struct";
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(threadContext, this.getRuntime().newArrayNoCopy(new IRubyObject[]{rubyArray.eltInternal(i), this.values[i]}));
        }
        return this;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString || iRubyObject instanceof RubySymbol) {
            return this.getByName(iRubyObject.asJavaString());
        }
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = n = n < 0 ? this.values.length + n : n;
        if (n < 0) {
            throw this.getRuntime().newIndexError("offset " + n + " too large for struct (size:" + this.values.length + ")");
        }
        if (n >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + n + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[n];
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject instanceof RubyString || iRubyObject instanceof RubySymbol) {
            return this.setByName(iRubyObject.asJavaString(), iRubyObject2);
        }
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = n = n < 0 ? this.values.length + n : n;
        if (n < 0) {
            throw this.getRuntime().newIndexError("offset " + n + " too large for struct (size:" + this.values.length + ")");
        }
        if (n >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + n + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[n] = iRubyObject2;
        return this.values[n];
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(IRubyObject[] iRubyObjectArray) {
        long l = this.values.length;
        RubyArray rubyArray = this.getRuntime().newArray(iRubyObjectArray.length);
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i] instanceof RubyFixnum) {
                rubyArray.append(this.aref(iRubyObjectArray[i]));
                continue;
            }
            if (iRubyObjectArray[i] instanceof RubyRange) {
                int n;
                long[] lArray = ((RubyRange)iRubyObjectArray[i]).begLen(l, 0);
                if (lArray == null) continue;
                int n2 = (int)lArray[0];
                int n3 = n = (int)lArray[1];
                for (int j = 0; j < n3; ++j) {
                    rubyArray.append(this.aref(this.getRuntime().newFixnum(j + n2)));
                }
                continue;
            }
            rubyArray.append(this.aref(this.getRuntime().newFixnum(RubyNumeric.num2long(iRubyObjectArray[i]))));
        }
        return rubyArray;
    }

    public static void marshalTo(RubyStruct rubyStruct, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyStruct);
        marshalStream.dumpDefaultObjectHeader('S', rubyStruct.getMetaClass());
        List list = ((RubyArray)RubyStruct.getInternalVariable(rubyStruct.classOf(), "__member__")).getList();
        marshalStream.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            RubySymbol rubySymbol = (RubySymbol)list.get(i);
            marshalStream.dumpObject(rubySymbol);
            marshalStream.dumpObject(rubyStruct.values[i]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubySymbol rubySymbol;
        Ruby ruby = unmarshalStream.getRuntime();
        RubyClass rubyClass = RubyStruct.pathToClass(ruby, (rubySymbol = (RubySymbol)unmarshalStream.unmarshalObject()).asJavaString());
        if (rubyClass == null) {
            throw ruby.newNameError("uninitialized constant " + rubySymbol, rubySymbol.asJavaString());
        }
        RubyArray rubyArray = RubyStruct.members(rubyClass, Block.NULL_BLOCK);
        int n = unmarshalStream.unmarshalInt();
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            iRubyObjectArray[i] = ruby.getNil();
        }
        RubyStruct rubyStruct = RubyStruct.newStruct(rubyClass, iRubyObjectArray, Block.NULL_BLOCK);
        unmarshalStream.registerLinkTarget(rubyStruct);
        for (int i = 0; i < n; ++i) {
            IRubyObject iRubyObject = unmarshalStream.unmarshalObject();
            if (!rubyArray.eltInternal(i).toString().equals(iRubyObject.toString())) {
                throw ruby.newTypeError("struct " + rubyClass.getName() + " not compatible (:" + iRubyObject + " for :" + rubyArray.eltInternal(i) + ")");
            }
            rubyStruct.aset(ruby.newFixnum(i), unmarshalStream.unmarshalObject());
        }
        return rubyStruct;
    }

    private static RubyClass pathToClass(Ruby ruby, String string) {
        return (RubyClass)ruby.getClassFromPath(string);
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        RubyStruct rubyStruct = (RubyStruct)iRubyObject;
        this.values = new IRubyObject[rubyStruct.values.length];
        System.arraycopy(rubyStruct.values, 0, this.values, 0, rubyStruct.values.length);
        return this;
    }
}

