/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;

public class RubyString
extends RubyObject {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyString rubyString = ruby.newStringShared(ByteList.EMPTY_BYTELIST);
            rubyString.setMetaClass(rubyClass);
            return rubyString;
        }
    };
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("String", ruby.getObject(), STRING_ALLOCATOR);
        ruby.setString(rubyClass);
        rubyClass.index = 4;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyString;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyString.class);
        rubyClass.includeModule(ruby.getComparable());
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyString.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public final boolean eql(IRubyObject iRubyObject) {
        if (iRubyObject.getMetaClass() == this.getRuntime().getString()) {
            return this.value.equal(((RubyString)iRubyObject).value);
        }
        return super.eql(iRubyObject);
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, CharSequence charSequence) {
        super(ruby, rubyClass);
        assert (charSequence != null);
        this.value = new ByteList(ByteList.plain(charSequence), false);
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, byte[] byArray) {
        super(ruby, rubyClass);
        assert (byArray != null);
        this.value = new ByteList(byArray);
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, ByteList byteList) {
        super(ruby, rubyClass);
        assert (byteList != null);
        this.value = byteList;
    }

    private RubyString(Ruby ruby, RubyClass rubyClass, ByteList byteList, boolean bl) {
        super(ruby, rubyClass, bl);
        assert (byteList != null);
        this.value = byteList;
    }

    public int getNativeTypeIndex() {
        return 4;
    }

    public Class getJavaClass() {
        return String.class;
    }

    public RubyString convertToString() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    public final RubyString strDup() {
        return this.strDup(this.getMetaClass());
    }

    final RubyString strDup(RubyClass rubyClass) {
        this.shareLevel = 2;
        RubyString rubyString = new RubyString(this.getRuntime(), rubyClass, this.value);
        rubyString.shareLevel = 2;
        rubyString.infectBy(this);
        return rubyString;
    }

    public final RubyString makeShared(int n, int n2) {
        if (n2 == 0) {
            RubyString rubyString = RubyString.newEmptyString(this.getRuntime(), this.getMetaClass());
            rubyString.infectBy(this);
            return rubyString;
        }
        if (this.shareLevel == 0) {
            this.shareLevel = 1;
        }
        RubyString rubyString = new RubyString(this.getRuntime(), this.getMetaClass(), this.value.makeShared(n, n2));
        rubyString.shareLevel = 1;
        rubyString.infectBy(this);
        return rubyString;
    }

    private final void modifyCheck() {
        if ((this.flags & 4) != 0) {
            throw this.getRuntime().newFrozenError("string" + this.getMetaClass().getName());
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] byArray, int n) {
        if (this.value.bytes != byArray || this.value.realSize != n) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify(int n) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(n);
            } else {
                this.value.unshare(n);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(n);
        }
        this.value.invalidate();
    }

    private final void view(ByteList byteList) {
        this.modifyCheck();
        this.value = byteList;
        this.shareLevel = 0;
    }

    private final void view(byte[] byArray) {
        this.modifyCheck();
        this.value.replace(byArray);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int n, int n2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(n, n2);
                this.shareLevel = 1;
            } else {
                this.value.view(n, n2);
            }
        } else {
            this.value.view(n, n2);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        return new String(ByteList.plain(byArray, n, n2));
    }

    public static String byteListToString(ByteList byteList) {
        return RubyString.bytesToString(byteList.unsafeBytes(), byteList.begin(), byteList.length());
    }

    public static String bytesToString(byte[] byArray) {
        return RubyString.bytesToString(byArray, 0, byArray.length);
    }

    public static byte[] stringToBytes(String string) {
        return ByteList.plain(string);
    }

    public static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    public static boolean isUpper(int n) {
        return n >= 65 && n <= 90;
    }

    public static boolean isLower(int n) {
        return n >= 97 && n <= 122;
    }

    public static boolean isLetter(int n) {
        return RubyString.isUpper(n) || RubyString.isLower(n);
    }

    public static boolean isAlnum(int n) {
        return RubyString.isUpper(n) || RubyString.isLower(n) || RubyString.isDigit(n);
    }

    public static boolean isPrint(int n) {
        return n >= 32 && n <= 126;
    }

    public RubyString asString() {
        return this;
    }

    public IRubyObject checkStringType() {
        return this;
    }

    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        if (this.getMetaClass().getRealClass() != this.getRuntime().getString()) {
            return this.strDup(this.getRuntime().getString());
        }
        return this;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newFixnum(this.op_cmp((RubyString)iRubyObject));
        }
        if (iRubyObject.respondsTo("to_str") && iRubyObject.respondsTo("<=>") && (iRubyObject2 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", this)) instanceof RubyNumeric) {
            return ((RubyNumeric)iRubyObject2).op_uminus(threadContext);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyString)) {
            if (!iRubyObject.respondsTo("to_str")) {
                return this.getRuntime().getFalse();
            }
            Ruby ruby = this.getRuntime();
            return iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", this).isTrue() ? ruby.getTrue() : ruby.getFalse();
        }
        return this.value.equal(((RubyString)iRubyObject).value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject iRubyObject) {
        RubyString rubyString = iRubyObject.convertToString();
        ByteList byteList = new ByteList(this.value.realSize + rubyString.value.realSize);
        byteList.realSize = this.value.realSize + rubyString.value.realSize;
        System.arraycopy(this.value.bytes, this.value.begin, byteList.bytes, 0, this.value.realSize);
        System.arraycopy(rubyString.value.bytes, rubyString.value.begin, byteList.bytes, this.value.realSize, rubyString.value.realSize);
        RubyString rubyString2 = RubyString.newString(this.getRuntime(), byteList);
        if (this.isTaint() || rubyString.isTaint()) {
            rubyString2.setTaint(true);
        }
        return rubyString2;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(IRubyObject iRubyObject) {
        RubyInteger rubyInteger = iRubyObject.convertToInteger();
        long l = rubyInteger.getLongValue();
        if (l < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (l > 0L && Integer.MAX_VALUE / l < (long)this.value.length()) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        ByteList byteList = new ByteList(this.value.length() * (int)l);
        int n = 0;
        while ((long)n < l) {
            byteList.append(this.value);
            ++n;
        }
        RubyString rubyString = new RubyString(this.getRuntime(), this.getMetaClass(), byteList);
        rubyString.setTaint(this.isTaint());
        return rubyString;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(IRubyObject iRubyObject) {
        RubyString rubyString = Sprintf.sprintf(this.getRuntime(), Locale.US, this.value, iRubyObject);
        rubyString.infectBy(this);
        return rubyString;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RubyString) {
            RubyString rubyString = (RubyString)object;
            if (rubyString.value.equal(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static RubyString objAsString(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return (RubyString)iRubyObject;
        }
        IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s");
        if (!(iRubyObject2 instanceof RubyString)) {
            return (RubyString)iRubyObject.anyToString();
        }
        if (iRubyObject.isTaint()) {
            iRubyObject2.setTaint(true);
        }
        return (RubyString)iRubyObject2;
    }

    public int op_cmp(RubyString rubyString) {
        return this.value.cmp(rubyString.value);
    }

    public String asJavaString() {
        return this.toString();
    }

    public RubyString newString(CharSequence charSequence) {
        return new RubyString(this.getRuntime(), this.getType(), charSequence);
    }

    public RubyString newString(ByteList byteList) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), byteList);
    }

    public static RubyString newString(Ruby ruby, CharSequence charSequence) {
        return new RubyString(ruby, ruby.getString(), charSequence);
    }

    public static RubyString newEmptyString(Ruby ruby) {
        return RubyString.newEmptyString(ruby, ruby.getString());
    }

    public static RubyString newEmptyString(Ruby ruby, RubyClass rubyClass) {
        RubyString rubyString = new RubyString(ruby, rubyClass, ByteList.EMPTY_BYTELIST);
        rubyString.shareLevel = 2;
        return rubyString;
    }

    public static RubyString newUnicodeString(Ruby ruby, String string) {
        try {
            return new RubyString(ruby, ruby.getString(), new ByteList(string.getBytes("UTF8"), false));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new RubyString(ruby, ruby.getString(), string);
        }
    }

    public static RubyString newString(Ruby ruby, RubyClass rubyClass, CharSequence charSequence) {
        return new RubyString(ruby, rubyClass, charSequence);
    }

    public static RubyString newString(Ruby ruby, byte[] byArray) {
        return new RubyString(ruby, ruby.getString(), byArray);
    }

    public static RubyString newString(Ruby ruby, ByteList byteList) {
        return new RubyString(ruby, ruby.getString(), byteList);
    }

    public static RubyString newStringLight(Ruby ruby, ByteList byteList) {
        return new RubyString(ruby, ruby.getString(), byteList, false);
    }

    public static RubyString newStringShared(Ruby ruby, RubyString rubyString) {
        rubyString.shareLevel = 2;
        RubyString rubyString2 = new RubyString(ruby, ruby.getString(), rubyString.value);
        rubyString2.shareLevel = 2;
        return rubyString2;
    }

    public static RubyString newStringShared(Ruby ruby, ByteList byteList) {
        return RubyString.newStringShared(ruby, ruby.getString(), byteList);
    }

    public static RubyString newStringShared(Ruby ruby, RubyClass rubyClass, ByteList byteList) {
        RubyString rubyString = new RubyString(ruby, rubyClass, byteList);
        rubyString.shareLevel = 2;
        return rubyString;
    }

    public static RubyString newString(Ruby ruby, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new RubyString(ruby, ruby.getString(), new ByteList(byArray2, false));
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public RubyString cat(byte[] byArray) {
        this.modify(this.value.realSize + byArray.length);
        System.arraycopy(byArray, 0, this.value.bytes, this.value.begin + this.value.realSize, byArray.length);
        this.value.realSize += byArray.length;
        return this;
    }

    public RubyString cat(byte[] byArray, int n, int n2) {
        this.modify(this.value.realSize + n2);
        System.arraycopy(byArray, n, this.value.bytes, this.value.begin + this.value.realSize, n2);
        this.value.realSize += n2;
        return this;
    }

    public RubyString cat(ByteList byteList) {
        this.modify(this.value.realSize + byteList.realSize);
        System.arraycopy(byteList.bytes, byteList.begin, this.value.bytes, this.value.begin + this.value.realSize, byteList.realSize);
        this.value.realSize += byteList.realSize;
        return this;
    }

    public RubyString cat(byte by) {
        this.modify(this.value.realSize + 1);
        this.value.bytes[this.value.begin + this.value.realSize] = by;
        ++this.value.realSize;
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1)
    public RubyString replace(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        this.modifyCheck();
        RubyString rubyString = RubyString.stringValue(iRubyObject);
        this.shareLevel = 2;
        rubyString.shareLevel = 2;
        this.value = rubyString.value;
        this.infectBy(iRubyObject);
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public RubyString reverse() {
        if (this.value.length() <= 1) {
            return this.strDup();
        }
        ByteList byteList = new ByteList(this.value.length() + 2);
        byteList.realSize = this.value.length();
        int n = this.value.length() - 1;
        int n2 = 0;
        while (n >= 0) {
            byteList.set(n2++, this.value.get(n--));
        }
        RubyString rubyString = new RubyString(this.getRuntime(), this.getMetaClass(), byteList);
        rubyString.infectBy(this);
        return rubyString;
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang() {
        if (this.value.length() > 1) {
            this.modify();
            for (int i = 0; i < this.value.length() / 2; ++i) {
                byte by = (byte)this.value.get(i);
                this.value.set(i, this.value.get(this.value.length() - i - 1));
                this.value.set(this.value.length() - i - 1, by);
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = RubyString.newStringShared(iRubyObject.getRuntime(), ByteList.EMPTY_BYTELIST);
        rubyString.setMetaClass((RubyClass)iRubyObject);
        rubyString.callInit(iRubyObjectArray, block);
        return rubyString;
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length == 1) {
            this.replace(iRubyObjectArray[0]);
        }
        return this;
    }

    @JRubyMethod(name={"casecmp"}, required=1)
    public IRubyObject casecmp(IRubyObject iRubyObject) {
        int n = this.value.caseInsensitiveCmp(RubyString.stringValue((IRubyObject)iRubyObject).value);
        return RubyFixnum.newFixnum(this.getRuntime(), n);
    }

    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyRegexp) {
            return ((RubyRegexp)iRubyObject).op_match(threadContext, this);
        }
        if (iRubyObject instanceof RubyString) {
            throw this.getRuntime().newTypeError("type mismatch: String given");
        }
        return iRubyObject.callMethod(threadContext, "=~", this);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_match2(ThreadContext threadContext) {
        return RubyRegexp.newRegexp(this.getRuntime(), this.value, 0, false).op_match2(threadContext);
    }

    @JRubyMethod(name={"match"}, required=1)
    public IRubyObject match(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.getPattern(iRubyObject, false).callMethod(threadContext, "match", this);
    }

    @JRubyMethod(name={"capitalize"})
    public IRubyObject capitalize() {
        RubyString rubyString = this.strDup();
        rubyString.capitalize_bang();
        return rubyString;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang() {
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int n = this.value.begin;
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        int n3 = byArray[n] & 0xFF;
        if (ASCII.isLower(n3)) {
            byArray[n] = (byte)ASCIIEncoding.asciiToUpper((int)n3);
            bl = true;
        }
        while (++n < n2) {
            n3 = (char)(byArray[n] & 0xFF);
            if (!ASCII.isUpper(n3)) continue;
            byArray[n] = (byte)ASCIIEncoding.asciiToLower((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) >= 0);
        }
        return RubyComparable.op_ge(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) > 0);
        }
        return RubyComparable.op_gt(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) <= 0);
        }
        return RubyComparable.op_le(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)iRubyObject) < 0);
        }
        return RubyComparable.op_lt(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject str_eql_p(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyString)) {
            return this.getRuntime().getFalse();
        }
        RubyString rubyString = (RubyString)iRubyObject;
        return this.value.equal(rubyString.value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"upcase"})
    public RubyString upcase() {
        RubyString rubyString = this.strDup();
        rubyString.upcase_bang();
        return rubyString;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang() {
        int n;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        for (n = this.value.begin; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (!ASCII.isLower(n3)) continue;
            byArray[n] = (byte)ASCIIEncoding.asciiToUpper((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"downcase"})
    public RubyString downcase() {
        RubyString rubyString = this.strDup();
        rubyString.downcase_bang();
        return rubyString;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang() {
        int n;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        for (n = this.value.begin; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (!ASCII.isUpper(n3)) continue;
            byArray[n] = (byte)ASCIIEncoding.asciiToLower((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"swapcase"})
    public RubyString swapcase() {
        RubyString rubyString = this.strDup();
        rubyString.swapcase_bang();
        return rubyString;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang() {
        int n;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl = false;
        for (n = this.value.begin; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (ASCII.isUpper(n3)) {
                byArray[n] = (byte)ASCIIEncoding.asciiToLower((int)n3);
                bl = true;
                continue;
            }
            if (!ASCII.isLower(n3)) continue;
            byArray[n] = (byte)ASCIIEncoding.asciiToUpper((int)n3);
            bl = true;
        }
        if (bl) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dump"})
    public IRubyObject dump() {
        RubyString rubyString = new RubyString(this.getRuntime(), this.getMetaClass(), this.inspectIntoByteList(true));
        rubyString.infectBy(this);
        return rubyString;
    }

    @JRubyMethod(name={"insert"}, required=2)
    public IRubyObject insert(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        ByteList byteList = rubyString.value;
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (n < 0) {
            n += this.value.length() + 1;
        }
        if (n < 0 || n > this.value.length()) {
            throw this.getRuntime().newIndexError("index " + n + " out of range");
        }
        this.modify();
        this.value.unsafeReplace(n, 0, byteList);
        this.infectBy(rubyString);
        return this;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        RubyString rubyString = this.getRuntime().newString(this.inspectIntoByteList(false));
        rubyString.infectBy(this);
        return rubyString;
    }

    private ByteList inspectIntoByteList(boolean bl) {
        Ruby ruby = this.getRuntime();
        Encoding encoding = ruby.getKCode().getEncoding();
        int n = this.value.length();
        ByteList byteList = new ByteList(n + 2 + n / 100);
        byteList.append(34);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.value.get(i) & 0xFF;
            if (!bl && (n2 = encoding.length((byte)n3)) > 1 && i + n2 - 1 < n) {
                byteList.append(this.value, i, n2);
                i += n2 - 1;
                continue;
            }
            if (RubyString.isAlnum(n3)) {
                byteList.append((char)n3);
                continue;
            }
            if (n3 == 34 || n3 == 92) {
                byteList.append(92).append((char)n3);
                continue;
            }
            if (n3 == 35 && this.isEVStr(i, n)) {
                byteList.append(92).append((char)n3);
                continue;
            }
            if (RubyString.isPrint(n3)) {
                byteList.append((char)n3);
                continue;
            }
            if (n3 == 10) {
                byteList.append(92).append(110);
                continue;
            }
            if (n3 == 13) {
                byteList.append(92).append(114);
                continue;
            }
            if (n3 == 9) {
                byteList.append(92).append(116);
                continue;
            }
            if (n3 == 12) {
                byteList.append(92).append(102);
                continue;
            }
            if (n3 == 11) {
                byteList.append(92).append(118);
                continue;
            }
            if (n3 == 7) {
                byteList.append(92).append(97);
                continue;
            }
            if (n3 == 8) {
                byteList.append(92).append(98);
                continue;
            }
            if (n3 == 27) {
                byteList.append(92).append(101);
                continue;
            }
            byteList.append(ByteList.plain(Sprintf.sprintf(ruby, (CharSequence)"\\%03o", n3)));
        }
        byteList.append(34);
        return byteList;
    }

    private boolean isEVStr(int n, int n2) {
        if (n + 1 >= n2) {
            return false;
        }
        int n3 = this.value.get(n + 1) & 0xFF;
        return n3 == 36 || n3 == 64 || n3 == 123;
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.length());
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.isEmpty() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject iRubyObject) {
        this.infectBy(iRubyObject);
        return this.cat(RubyString.stringValue((IRubyObject)iRubyObject).value);
    }

    @JRubyMethod(name={"concat", "<<"}, required=1)
    public RubyString concat(IRubyObject iRubyObject) {
        long l;
        if (iRubyObject instanceof RubyFixnum && (l = ((RubyFixnum)iRubyObject).getLongValue()) >= 0L && l < 256L) {
            return this.cat((byte)l);
        }
        return this.append(iRubyObject);
    }

    @JRubyMethod(name={"crypt"}, required=1)
    public RubyString crypt(IRubyObject iRubyObject) {
        ByteList byteList = RubyString.stringValue(iRubyObject).getByteList();
        if (byteList.realSize < 2) {
            throw this.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        byteList = byteList.makeShared(0, 2);
        RubyString rubyString = RubyString.newStringShared(this.getRuntime(), JavaCrypt.crypt(byteList, this.getByteList()));
        rubyString.infectBy(this);
        rubyString.infectBy(iRubyObject);
        return rubyString;
    }

    public static RubyString stringValue(IRubyObject iRubyObject) {
        return (RubyString)(iRubyObject instanceof RubyString ? iRubyObject : iRubyObject.convertToString());
    }

    @JRubyMethod(name={"sub"}, required=1, optional=1, frame=true)
    public IRubyObject sub(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = this.strDup();
        rubyString.sub_bang(threadContext, iRubyObjectArray, block);
        return rubyString;
    }

    @JRubyMethod(name={"sub!"}, required=1, optional=1, frame=true)
    public IRubyObject sub_bang(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        boolean bl;
        RubyString rubyString = null;
        boolean bl2 = false;
        if (iRubyObjectArray.length == 1 && block.isGiven()) {
            bl = true;
            bl2 = false;
        } else if (iRubyObjectArray.length == 2) {
            rubyString = iRubyObjectArray[1].convertToString();
            bl = false;
            if (rubyString.isTaint()) {
                bl2 = true;
            }
        } else {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + " for 2)");
        }
        RubyRegexp rubyRegexp = this.getPattern(iRubyObjectArray[0], true);
        Regex regex = rubyRegexp.getPattern();
        int n = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, n);
        Frame frame = threadContext.getPreviousFrame();
        if (matcher.search(this.value.begin, n, 0) >= 0) {
            int n2;
            Serializable serializable;
            int n3;
            if (bl) {
                byte[] byArray = this.value.bytes;
                n3 = this.value.realSize;
                serializable = rubyRegexp.updateBackRef(this, frame, matcher);
                serializable.use();
                if (regex.numberOfCaptures() == 0) {
                    rubyString = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
                } else {
                    Region region = matcher.getRegion();
                    rubyString = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(region.beg[0], region.end[0] - region.beg[0])));
                }
                this.modifyCheck(byArray, n3);
                this.frozenCheck();
                frame.setBackRef((IRubyObject)((Object)serializable));
            } else {
                rubyString = rubyRegexp.regsub(rubyString, this, matcher);
                rubyRegexp.updateBackRef(this, frame, matcher);
            }
            if (regex.numberOfCaptures() == 0) {
                n2 = matcher.getBegin();
                n3 = matcher.getEnd() - n2;
            } else {
                serializable = matcher.getRegion();
                n2 = ((Region)serializable).beg[0];
                n3 = ((Region)serializable).end[0] - n2;
            }
            serializable = rubyString.value;
            if (((ByteList)serializable).realSize > n3) {
                this.modify(this.value.realSize + ((ByteList)serializable).realSize - n3);
            } else {
                this.modify();
            }
            if (rubyString.isTaint()) {
                bl2 = true;
            }
            if (((ByteList)serializable).realSize != n3) {
                int n4 = this.value.begin + n2 + n3;
                int n5 = this.value.begin + n2 + ((ByteList)serializable).realSize;
                int n6 = this.value.realSize - n2 - n3;
                System.arraycopy(this.value.bytes, n4, this.value.bytes, n5, n6);
            }
            System.arraycopy(((ByteList)serializable).bytes, ((ByteList)serializable).begin, this.value.bytes, this.value.begin + n2, ((ByteList)serializable).realSize);
            this.value.realSize += ((ByteList)serializable).realSize - n3;
            if (bl2) {
                this.setTaint(true);
            }
            return this;
        }
        frame.setBackRef(this.getRuntime().getNil());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"gsub"}, required=1, optional=1, frame=true)
    public IRubyObject gsub(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.gsub(threadContext, iRubyObjectArray, block, false);
    }

    @JRubyMethod(name={"gsub!"}, required=1, optional=1, frame=true)
    public IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.gsub(threadContext, iRubyObjectArray, block, true);
    }

    private final IRubyObject gsub(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block, boolean bl) {
        int n;
        RubyString rubyString;
        boolean bl2;
        boolean bl3 = false;
        if (iRubyObjectArray.length == 1 && block.isGiven()) {
            bl2 = true;
            rubyString = null;
        } else if (iRubyObjectArray.length == 2) {
            bl2 = false;
            rubyString = iRubyObjectArray[1].convertToString();
            if (rubyString.isTaint()) {
                bl3 = true;
            }
        } else {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + "for 2)");
        }
        RubyRegexp rubyRegexp = this.getPattern(iRubyObjectArray[0], true);
        Regex regex = rubyRegexp.getPattern();
        int n2 = this.value.begin;
        int n3 = n2 + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, n2, n3);
        int n4 = matcher.search(n2, n3, 0);
        Frame frame = threadContext.getPreviousFrame();
        if (n4 < 0) {
            frame.setBackRef(this.getRuntime().getNil());
            return bl ? this.getRuntime().getNil() : this.strDup();
        }
        int n5 = this.value.realSize + 30;
        ByteList byteList = new ByteList(n5);
        byteList.realSize = n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.value.begin;
        int n9 = 0;
        RubyMatchData rubyMatchData = null;
        while (n4 >= 0) {
            RubyString rubyString2;
            int n10;
            int n11;
            Object object;
            if (bl2) {
                object = this.value.bytes;
                n11 = this.value.realSize;
                rubyMatchData = rubyRegexp.updateBackRef(this, frame, matcher);
                rubyMatchData.use();
                if (regex.numberOfCaptures() == 0) {
                    n = matcher.getBegin();
                    n10 = matcher.getEnd();
                    rubyString2 = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(n, n10 - n)));
                } else {
                    Region region = matcher.getRegion();
                    n = region.beg[0];
                    n10 = region.end[0];
                    rubyString2 = RubyString.objAsString(threadContext, block.yield(threadContext, this.substr(n, n10 - n)));
                }
                this.modifyCheck((byte[])object, n11);
                if (bl) {
                    this.frozenCheck();
                }
            } else {
                rubyString2 = rubyRegexp.regsub(rubyString, this, matcher);
                if (regex.numberOfCaptures() == 0) {
                    n = matcher.getBegin();
                    n10 = matcher.getEnd();
                } else {
                    object = matcher.getRegion();
                    n = object.beg[0];
                    n10 = object.end[0];
                }
            }
            if (rubyString2.isTaint()) {
                bl3 = true;
            }
            object = rubyString2.value;
            n11 = n7 - n6 + (n4 - n9) + object.realSize + 3;
            if (n5 < n11) {
                while (n5 < n11) {
                    n5 <<= 1;
                }
                n11 = n7 - n6;
                byteList.realloc(n5);
                byteList.realSize = n5;
                n7 = n6 + n11;
            }
            n11 = n4 - n9;
            System.arraycopy(this.value.bytes, n8, byteList.bytes, n7, n11);
            System.arraycopy(object.bytes, object.begin, byteList.bytes, n7 += n11, object.realSize);
            n7 += object.realSize;
            n9 = n10;
            if (n == n10) {
                if (this.value.realSize <= n10) break;
                n11 = regex.getEncoding().length(this.value.bytes[n2 + n10]);
                System.arraycopy(this.value.bytes, n2 + n10, byteList.bytes, n7, n11);
                n7 += n11;
                n9 = n10 + n11;
            }
            n8 = n2 + n9;
            if (n9 > this.value.realSize) break;
            n4 = matcher.search(n8, n3, 0);
        }
        if (this.value.realSize > n9) {
            n = n7 - n6;
            if (n5 - n < this.value.realSize - n9) {
                n5 = n + this.value.realSize - n9;
                byteList.realloc(n5);
                n7 = n6 + n;
            }
            System.arraycopy(this.value.bytes, n8, byteList.bytes, n7, this.value.realSize - n9);
            n7 += this.value.realSize - n9;
        }
        if (rubyMatchData != null) {
            frame.setBackRef(rubyMatchData);
        } else {
            rubyRegexp.updateBackRef(this, frame, matcher);
        }
        byteList.realSize = n7 - n6;
        if (bl) {
            this.view(byteList);
            if (bl3) {
                this.setTaint(true);
            }
            return this;
        }
        RubyString rubyString3 = new RubyString(this.getRuntime(), this.getMetaClass(), byteList);
        rubyString3.infectBy(this);
        if (bl3) {
            rubyString3.setTaint(true);
        }
        return rubyString3;
    }

    @JRubyMethod(name={"index"}, required=1, optional=1)
    public IRubyObject index(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        int n = iRubyObjectArray.length == 2 ? RubyNumeric.num2int(iRubyObjectArray[1]) : 0;
        IRubyObject iRubyObject = iRubyObjectArray[0];
        if (n < 0 && (n += this.value.realSize) < 0) {
            if (iRubyObject instanceof RubyRegexp) {
                threadContext.getPreviousFrame().setBackRef(this.getRuntime().getNil());
            }
            return this.getRuntime().getNil();
        }
        if (iRubyObject instanceof RubyRegexp) {
            RubyRegexp rubyRegexp = (RubyRegexp)iRubyObject;
            n = rubyRegexp.adjustStartPos(this, n, false);
            n = rubyRegexp.search(threadContext, this, n, false);
        } else {
            if (iRubyObject instanceof RubyFixnum) {
                int n2 = RubyNumeric.fix2int(iRubyObject);
                if (n2 < 0 || n2 > 255) {
                    return this.getRuntime().getNil();
                }
                byte by = (byte)n2;
                byte[] byArray = this.value.bytes;
                int n3 = this.value.begin + this.value.realSize;
                n += this.value.begin;
                while (n < n3) {
                    if (byArray[n] == by) {
                        return RubyFixnum.newFixnum(this.getRuntime(), n - this.value.begin);
                    }
                    ++n;
                }
                return this.getRuntime().getNil();
            }
            if (iRubyObject instanceof RubyString) {
                n = this.strIndex((RubyString)iRubyObject, n);
            } else {
                IRubyObject iRubyObject2 = iRubyObject.checkStringType();
                if (iRubyObject2.isNil()) {
                    throw this.getRuntime().newTypeError("type mismatch: " + iRubyObject.getMetaClass().getName() + " given");
                }
                n = this.strIndex((RubyString)iRubyObject2, n);
            }
        }
        return n == -1 ? this.getRuntime().getNil() : RubyFixnum.newFixnum(this.getRuntime(), n);
    }

    private int strIndex(RubyString rubyString, int n) {
        if (n < 0 && (n += this.value.realSize) < 0) {
            return -1;
        }
        if (this.value.realSize - n < rubyString.value.realSize) {
            return -1;
        }
        if (rubyString.value.realSize == 0) {
            return n;
        }
        return this.value.indexOf(rubyString.value, n);
    }

    @JRubyMethod(name={"rindex"}, required=1, optional=1)
    public IRubyObject rindex(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        int n;
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length == 2) {
            iRubyObject = iRubyObjectArray[0];
            n = RubyNumeric.num2int(iRubyObjectArray[1]);
            if (n < 0 && (n += this.value.realSize) < 0) {
                if (iRubyObject instanceof RubyRegexp) {
                    threadContext.getPreviousFrame().setBackRef(this.getRuntime().getNil());
                }
                return this.getRuntime().getNil();
            }
            if (n > this.value.realSize) {
                n = this.value.realSize;
            }
        } else {
            iRubyObject = iRubyObjectArray[0];
            n = this.value.realSize;
        }
        if (iRubyObject instanceof RubyRegexp) {
            RubyRegexp rubyRegexp = (RubyRegexp)iRubyObject;
            if (rubyRegexp.length() > 0) {
                n = rubyRegexp.adjustStartPos(this, n, true);
                n = rubyRegexp.search(threadContext, this, n, true);
            }
            if (n >= 0) {
                return RubyFixnum.newFixnum(this.getRuntime(), n);
            }
        } else if (iRubyObject instanceof RubyString) {
            if ((n = this.strRindex((RubyString)iRubyObject, n)) >= 0) {
                return RubyFixnum.newFixnum(this.getRuntime(), n);
            }
        } else {
            if (iRubyObject instanceof RubyFixnum) {
                int n2 = RubyNumeric.fix2int(iRubyObject);
                if (n2 < 0 || n2 > 255) {
                    return this.getRuntime().getNil();
                }
                byte by = (byte)n2;
                byte[] byArray = this.value.bytes;
                int n3 = this.value.begin;
                int n4 = n3 + n;
                if (n == this.value.realSize) {
                    if (n == 0) {
                        return this.getRuntime().getNil();
                    }
                    --n4;
                }
                while (n3 <= n4) {
                    if (byArray[n4] == by) {
                        return RubyFixnum.newFixnum(this.getRuntime(), n4 - this.value.begin);
                    }
                    --n4;
                }
                return this.getRuntime().getNil();
            }
            throw this.getRuntime().newTypeError("type mismatch: " + iRubyObject.getMetaClass().getName() + " given");
        }
        return this.getRuntime().getNil();
    }

    private int strRindex(RubyString rubyString, int n) {
        int n2 = rubyString.value.realSize;
        if (this.value.realSize < n2) {
            return -1;
        }
        if (this.value.realSize - n < n2) {
            n = this.value.realSize - n2;
        }
        return this.value.lastIndexOf(rubyString.value, n);
    }

    public IRubyObject substr(int n, int n2) {
        int n3 = this.value.length();
        if (n2 < 0 || n > n3) {
            return this.getRuntime().getNil();
        }
        if (n < 0 && (n += n3) < 0) {
            return this.getRuntime().getNil();
        }
        int n4 = Math.min(n3, n + n2);
        return this.makeShared(n, n4 - n);
    }

    public IRubyObject replace(int n, int n2, RubyString rubyString) {
        if (n + n2 >= this.value.length()) {
            n2 = this.value.length() - n;
        }
        this.modify();
        this.value.unsafeReplace(n, n2, rubyString.value);
        return this.infectBy(rubyString);
    }

    @JRubyMethod(name={"[]", "slice"}, required=1, optional=1)
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 2) {
            if (iRubyObjectArray[0] instanceof RubyRegexp) {
                if (((RubyRegexp)iRubyObjectArray[0]).search(threadContext, this, 0, false) >= 0) {
                    return RubyRegexp.nth_match(RubyNumeric.fix2int(iRubyObjectArray[1]), threadContext.getCurrentFrame().getBackRef());
                }
                return this.getRuntime().getNil();
            }
            return this.substr(RubyNumeric.fix2int(iRubyObjectArray[0]), RubyNumeric.fix2int(iRubyObjectArray[1]));
        }
        if (iRubyObjectArray[0] instanceof RubyRegexp) {
            if (((RubyRegexp)iRubyObjectArray[0]).search(threadContext, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(0, threadContext.getCurrentFrame().getBackRef());
            }
            return this.getRuntime().getNil();
        }
        if (iRubyObjectArray[0] instanceof RubyString) {
            return this.value.indexOf(RubyString.stringValue((IRubyObject)iRubyObjectArray[0]).value) != -1 ? iRubyObjectArray[0] : this.getRuntime().getNil();
        }
        if (iRubyObjectArray[0] instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObjectArray[0]).begLen(this.value.length(), 0);
            return lArray == null ? this.getRuntime().getNil() : this.substr((int)lArray[0], (int)lArray[1]);
        }
        int n = (int)iRubyObjectArray[0].convertToInteger().getLongValue();
        if (n < 0) {
            n += this.value.length();
        }
        if (n < 0 || n >= this.value.length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.value.get(n) & 0xFF);
    }

    private void subpatSet(ThreadContext threadContext, RubyRegexp rubyRegexp, int n, IRubyObject iRubyObject) {
        int n2;
        int n3;
        if (rubyRegexp.search(threadContext, this, 0, false) < 0) {
            throw this.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData rubyMatchData = (RubyMatchData)threadContext.getCurrentFrame().getBackRef();
        if (rubyMatchData.regs == null) {
            if (n >= 1) {
                throw this.getRuntime().newIndexError("index " + n + " out of regexp");
            }
            if (n < 0) {
                if (-n >= 1) {
                    throw this.getRuntime().newIndexError("index " + n + " out of regexp");
                }
                ++n;
            }
            if ((n3 = rubyMatchData.begin) == -1) {
                throw this.getRuntime().newIndexError("regexp group " + n + " not matched");
            }
            n2 = rubyMatchData.end;
        } else {
            if (n >= rubyMatchData.regs.numRegs) {
                throw this.getRuntime().newIndexError("index " + n + " out of regexp");
            }
            if (n < 0) {
                if (-n >= rubyMatchData.regs.numRegs) {
                    throw this.getRuntime().newIndexError("index " + n + " out of regexp");
                }
                n += rubyMatchData.regs.numRegs;
            }
            if ((n3 = rubyMatchData.regs.beg[n]) == -1) {
                throw this.getRuntime().newIndexError("regexp group " + n + " not matched");
            }
            n2 = rubyMatchData.regs.end[n];
        }
        int n4 = n2 - n3;
        this.replace(n3, n4, RubyString.stringValue(iRubyObject));
    }

    @JRubyMethod(name={"[]="}, required=2, optional=1)
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        int n = this.value.length();
        if (iRubyObjectArray.length == 3) {
            if (iRubyObjectArray[0] instanceof RubyRegexp) {
                RubyString rubyString = RubyString.stringValue(iRubyObjectArray[2]);
                int n2 = RubyNumeric.fix2int(iRubyObjectArray[1]);
                this.subpatSet(threadContext, (RubyRegexp)iRubyObjectArray[0], n2, rubyString);
                return rubyString;
            }
            RubyString rubyString = RubyString.stringValue(iRubyObjectArray[2]);
            int n3 = RubyNumeric.fix2int(iRubyObjectArray[0]);
            int n4 = RubyNumeric.fix2int(iRubyObjectArray[1]);
            if (n4 < 0) {
                throw this.getRuntime().newIndexError("negative length");
            }
            if (n3 < 0) {
                n3 += n;
            }
            if (n3 < 0 || n3 > 0 && n3 > n) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (n3 + n4 > n) {
                n4 = n - n3;
            }
            this.replace(n3, n4, rubyString);
            return rubyString;
        }
        if (iRubyObjectArray[0] instanceof RubyFixnum || iRubyObjectArray[0].respondsTo("to_int")) {
            int n5 = RubyNumeric.fix2int(iRubyObjectArray[0]);
            if (n5 < 0) {
                n5 += this.value.length();
            }
            if (n5 < 0 || n5 >= this.value.length()) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (iRubyObjectArray[1] instanceof RubyFixnum) {
                this.modify();
                this.value.set(n5, (byte)RubyNumeric.fix2int(iRubyObjectArray[1]));
            } else {
                this.replace(n5, 1, RubyString.stringValue(iRubyObjectArray[1]));
            }
            return iRubyObjectArray[1];
        }
        if (iRubyObjectArray[0] instanceof RubyRegexp) {
            RubyString rubyString = RubyString.stringValue(iRubyObjectArray[1]);
            this.subpatSet(threadContext, (RubyRegexp)iRubyObjectArray[0], 0, rubyString);
            return rubyString;
        }
        if (iRubyObjectArray[0] instanceof RubyString) {
            RubyString rubyString = RubyString.stringValue(iRubyObjectArray[0]);
            int n6 = this.value.indexOf(rubyString.value);
            if (n6 != -1) {
                this.replace(n6, rubyString.value.length(), RubyString.stringValue(iRubyObjectArray[1]));
            }
            return iRubyObjectArray[1];
        }
        if (iRubyObjectArray[0] instanceof RubyRange) {
            long[] lArray = ((RubyRange)iRubyObjectArray[0]).getBeginLength(this.value.length(), true, true);
            this.replace((int)lArray[0], (int)lArray[1], RubyString.stringValue(iRubyObjectArray[1]));
            return iRubyObjectArray[1];
        }
        throw this.getRuntime().newTypeError("wrong argument type");
    }

    @JRubyMethod(name={"slice!"}, required=1, optional=1)
    public IRubyObject slice_bang(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        int n = iRubyObjectArray.length;
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[n + 1];
        iRubyObjectArray2[0] = iRubyObjectArray[0];
        if (n > 1) {
            iRubyObjectArray2[1] = iRubyObjectArray[1];
        }
        iRubyObjectArray2[n] = this.newString("");
        IRubyObject iRubyObject = this.op_aref(threadContext, iRubyObjectArray);
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        this.op_aset(threadContext, iRubyObjectArray2);
        return iRubyObject;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ() {
        return this.strDup().succ_bang();
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang() {
        int n;
        if (this.value.length() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean bl = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (n = this.value.length() - 1; n >= 0; --n) {
            n3 = this.value.get(n) & 0xFF;
            if (!RubyString.isAlnum(n3)) continue;
            bl = true;
            if (RubyString.isDigit(n3) && n3 < 57 || RubyString.isLower(n3) && n3 < 122 || RubyString.isUpper(n3) && n3 < 90) {
                this.value.set(n, (byte)(n3 + 1));
                n2 = -1;
                break;
            }
            n2 = n;
            int n5 = RubyString.isDigit(n3) ? 49 : (n4 = RubyString.isLower(n3) ? 97 : 65);
            this.value.set(n, (byte)(RubyString.isDigit(n3) ? 48 : (RubyString.isLower(n3) ? 97 : 65)));
        }
        if (!bl) {
            for (n = this.value.length() - 1; n >= 0; --n) {
                n3 = this.value.get(n) & 0xFF;
                if (n3 < 255) {
                    this.value.set(n, (byte)(n3 + 1));
                    n2 = -1;
                    break;
                }
                n2 = n;
                n4 = 1;
                this.value.set(n, 0);
            }
        }
        if (n2 > -1) {
            this.value.insert(n2, (byte)n4);
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.upto(threadContext, iRubyObject, false, block);
    }

    public IRubyObject upto(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl, Block block) {
        RubyString rubyString = this;
        RubyString rubyString2 = RubyString.stringValue(iRubyObject);
        int n = rubyString.op_cmp(rubyString2);
        if (n > 0 || bl && n == 0) {
            return rubyString;
        }
        RubyString rubyString3 = RubyString.stringValue(rubyString2.succ());
        RubyString rubyString4 = rubyString;
        while (!rubyString4.equals(rubyString3)) {
            block.yield(threadContext, rubyString4);
            if (!bl && rubyString4.equals(rubyString2)) break;
            rubyString4 = (RubyString)rubyString4.succ();
            if ((!bl || !rubyString4.equals(rubyString2)) && rubyString4.length().getLongValue() <= rubyString2.length().getLongValue()) continue;
            break;
        }
        return rubyString;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            int n = RubyNumeric.fix2int(iRubyObject);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)n) continue;
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        ByteList byteList = RubyString.stringValue((IRubyObject)iRubyObject).value;
        return this.getRuntime().newBoolean(this.value.indexOf(byteList) != -1);
    }

    @JRubyMethod(name={"to_i"}, optional=1)
    public IRubyObject to_i(IRubyObject[] iRubyObjectArray) {
        long l = iRubyObjectArray.length == 0 ? 10L : iRubyObjectArray[0].convertToInteger().getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)l);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct() {
        int n;
        int n2;
        if (this.isEmpty()) {
            return this.getRuntime().newFixnum(0L);
        }
        int n3 = 8;
        for (n2 = this.value.begin; n2 < this.value.begin + this.value.realSize && ASCII.isSpace(this.value.bytes[n2] & 0xFF); ++n2) {
        }
        int n4 = n = this.value.bytes[n2] == 45 || this.value.bytes[n2] == 43 ? n2 + 1 : n2;
        if (n + 1 < this.value.begin + this.value.realSize && this.value.bytes[n] == 48) {
            if (this.value.bytes[n + 1] == 120 || this.value.bytes[n + 1] == 88) {
                n3 = 16;
            } else if (this.value.bytes[n + 1] == 98 || this.value.bytes[n + 1] == 66) {
                n3 = 2;
            } else if (this.value.bytes[n + 1] == 100 || this.value.bytes[n + 1] == 68) {
                n3 = 10;
            }
        }
        return RubyNumeric.str2inum(this.getRuntime(), this, n3);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 16);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    @JRubyMethod(name={"split"}, optional=2)
    public RubyArray split(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray;
        IRubyObject iRubyObject;
        int n;
        boolean bl;
        int n2;
        if (iRubyObjectArray.length == 2) {
            n2 = RubyNumeric.fix2int(iRubyObjectArray[1]);
            if (n2 <= 0) {
                bl = false;
            } else {
                if (n2 == 1) {
                    return this.value.realSize == 0 ? this.getRuntime().newArray() : this.getRuntime().newArray(this);
                }
                bl = true;
            }
            n = 1;
        } else {
            n = 0;
            n2 = 0;
            bl = false;
        }
        IRubyObject iRubyObject2 = iRubyObject = iRubyObjectArray.length == 0 || iRubyObjectArray[0].isNil() ? null : iRubyObjectArray[0];
        if (iRubyObject == null && (iRubyObject = this.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            rubyArray = this.awkSplit(bl, n2, n);
        } else if (iRubyObject instanceof RubyString && ((RubyString)iRubyObject).value.realSize == 1) {
            RubyString rubyString = (RubyString)iRubyObject;
            rubyArray = rubyString.value.bytes[rubyString.value.begin] == 32 ? this.awkSplit(bl, n2, n) : this.split(threadContext, iRubyObject, bl, n2, n);
        } else {
            rubyArray = this.split(threadContext, iRubyObject, bl, n2, n);
        }
        if (!bl && n2 == 0) {
            while (rubyArray.size() > 0 && ((RubyString)rubyArray.eltInternal((int)(rubyArray.size() - 1))).value.realSize == 0) {
                rubyArray.pop();
            }
        }
        return rubyArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray split(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl, int n, int n2) {
        int n3;
        Ruby ruby = this.getRuntime();
        Regex regex = this.getPattern(iRubyObject, true).getPattern();
        int n4 = n3 = this.value.begin;
        int n5 = 0;
        int n6 = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, n6);
        boolean bl2 = false;
        RubyArray rubyArray = ruby.newArray();
        if (regex.numberOfCaptures() == 0) {
            int n7;
            while ((n7 = matcher.search(n4, n6, 0)) >= 0) {
                block17: {
                    if (n4 == n7 + n3 && matcher.getBegin() == matcher.getEnd()) {
                        if (this.value.realSize == 0) {
                            rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
                            break;
                        }
                        if (bl2) {
                            rubyArray.append(this.substr(n5, regex.getEncoding().length(this.value.bytes[n3 + n5])));
                            n5 = n4 - n3;
                            break block17;
                        } else {
                            n4 = n4 == n6 ? ++n4 : (n4 += regex.getEncoding().length(this.value.bytes[n4]));
                            bl2 = true;
                            continue;
                        }
                    }
                    rubyArray.append(this.substr(n5, n7 - n5));
                    n5 = matcher.getEnd();
                    n4 = n3 + matcher.getEnd();
                }
                bl2 = false;
                if (!bl || n > ++n2) continue;
                break;
            }
        } else {
            int n8;
            while ((n8 = matcher.search(n4, n6, 0)) >= 0) {
                Region region;
                block18: {
                    region = matcher.getRegion();
                    if (n4 == n8 + n3 && region.beg[0] == region.end[0]) {
                        if (this.value.realSize == 0) {
                            rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
                            break;
                        }
                        if (bl2) {
                            rubyArray.append(this.substr(n5, regex.getEncoding().length(this.value.bytes[n3 + n5])));
                            n5 = n4 - n3;
                            break block18;
                        } else {
                            n4 = n4 == n6 ? ++n4 : (n4 += regex.getEncoding().length(this.value.bytes[n4]));
                            bl2 = true;
                            continue;
                        }
                    }
                    rubyArray.append(this.substr(n5, n8 - n5));
                    n5 = n4 = region.end[0];
                    n4 += n3;
                }
                bl2 = false;
                for (int i = 1; i < region.numRegs; ++i) {
                    if (region.beg[i] == -1) continue;
                    if (region.beg[i] == region.end[i]) {
                        rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
                        continue;
                    }
                    rubyArray.append(this.substr(region.beg[i], region.end[i] - region.beg[i]));
                }
                if (!bl || n > ++n2) continue;
            }
        }
        threadContext.getCurrentFrame().setBackRef(ruby.getNil());
        if (this.value.realSize <= 0) return rubyArray;
        if (!bl && this.value.realSize <= n5) {
            if (n >= 0) return rubyArray;
        }
        if (this.value.realSize == n5) {
            rubyArray.append(RubyString.newEmptyString(ruby, this.getMetaClass()));
            return rubyArray;
        }
        rubyArray.append(this.substr(n5, this.value.realSize - n5));
        return rubyArray;
    }

    private RubyArray awkSplit(boolean bl, int n, int n2) {
        int n3;
        RubyArray rubyArray = this.getRuntime().newArray();
        byte[] byArray = this.value.bytes;
        int n4 = n3 + this.value.realSize;
        boolean bl2 = true;
        int n5 = 0;
        n5 = 0;
        int n6 = 0;
        for (n3 = this.value.begin; n3 < n4; ++n3) {
            if (bl2) {
                if (ASCII.isSpace(byArray[n3] & 0xFF)) {
                    ++n5;
                    continue;
                }
                n6 = n5 + 1;
                bl2 = false;
                if (!bl || n > n2) continue;
                break;
            }
            if (ASCII.isSpace(byArray[n3] & 0xFF)) {
                rubyArray.append(this.makeShared(n5, n6 - n5));
                bl2 = true;
                n5 = n6 + 1;
                if (!bl) continue;
                ++n2;
                continue;
            }
            ++n6;
        }
        if (this.value.realSize > 0 && (bl || this.value.realSize > n5 || n < 0)) {
            if (this.value.realSize == n5) {
                rubyArray.append(RubyString.newEmptyString(this.getRuntime(), this.getMetaClass()));
            } else {
                rubyArray.append(this.makeShared(n5, this.value.realSize - n5));
            }
        }
        return rubyArray;
    }

    private final RubyRegexp getPattern(IRubyObject iRubyObject, boolean bl) {
        if (iRubyObject instanceof RubyRegexp) {
            return (RubyRegexp)iRubyObject;
        }
        if (!(iRubyObject instanceof RubyString)) {
            IRubyObject iRubyObject2 = iRubyObject.checkStringType();
            if (iRubyObject2.isNil()) {
                throw this.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected Regexp)");
            }
            iRubyObject = iRubyObject2;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), ((RubyString)iRubyObject).value, 0, bl);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true)
    public IRubyObject scan(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = this.getRuntime();
        Frame frame = threadContext.getPreviousFrame();
        RubyRegexp rubyRegexp = this.getPattern(iRubyObject, true);
        Regex regex = rubyRegexp.getPattern();
        int n = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, n);
        matcher.value = 0;
        if (!block.isGiven()) {
            RubyArray rubyArray = ruby.newArray();
            if (regex.numberOfCaptures() == 0) {
                IRubyObject iRubyObject2;
                while ((iRubyObject2 = this.scanOnceNG(rubyRegexp, matcher, n)) != null) {
                    rubyArray.append(iRubyObject2);
                }
            } else {
                IRubyObject iRubyObject3;
                while ((iRubyObject3 = this.scanOnce(rubyRegexp, matcher, n)) != null) {
                    rubyArray.append(iRubyObject3);
                }
            }
            if (rubyArray.size() > 0) {
                rubyRegexp.updateBackRef(this, frame, matcher);
            } else {
                frame.setBackRef(ruby.getNil());
            }
            return rubyArray;
        }
        byte[] byArray = this.value.bytes;
        int n2 = this.value.realSize;
        IRubyObject iRubyObject4 = null;
        if (regex.numberOfCaptures() == 0) {
            IRubyObject iRubyObject5;
            while ((iRubyObject5 = this.scanOnceNG(rubyRegexp, matcher, n)) != null) {
                iRubyObject4 = rubyRegexp.updateBackRef(this, frame, matcher);
                ((RubyMatchData)iRubyObject4).use();
                block.yield(threadContext, iRubyObject5);
                this.modifyCheck(byArray, n2);
            }
        } else {
            IRubyObject iRubyObject6;
            while ((iRubyObject6 = this.scanOnce(rubyRegexp, matcher, n)) != null) {
                iRubyObject4 = rubyRegexp.updateBackRef(this, frame, matcher);
                ((RubyMatchData)iRubyObject4).use();
                block.yield(threadContext, iRubyObject6);
                this.modifyCheck(byArray, n2);
            }
        }
        frame.setBackRef(iRubyObject4 == null ? ruby.getNil() : iRubyObject4);
        return this;
    }

    private Encoding encodingCheck(RubyRegexp rubyRegexp) {
        return rubyRegexp.getKCode().getEncoding();
    }

    private IRubyObject scanOnceNG(RubyRegexp rubyRegexp, Matcher matcher, int n) {
        if (matcher.search(matcher.value + this.value.begin, n, 0) >= 0) {
            int n2 = matcher.getEnd();
            matcher.value = matcher.getBegin() == n2 ? (this.value.realSize > n2 ? n2 + rubyRegexp.getPattern().getEncoding().length(this.value.bytes[this.value.begin + n2]) : n2 + 1) : n2;
            return this.substr(matcher.getBegin(), n2 - matcher.getBegin()).infectBy(rubyRegexp);
        }
        return null;
    }

    private IRubyObject scanOnce(RubyRegexp rubyRegexp, Matcher matcher, int n) {
        if (matcher.search(matcher.value + this.value.begin, n, 0) >= 0) {
            Region region = matcher.getRegion();
            int n2 = region.end[0];
            matcher.value = region.beg[0] == n2 ? (this.value.realSize > n2 ? n2 + rubyRegexp.getPattern().getEncoding().length(this.value.bytes[this.value.begin + n2]) : n2 + 1) : n2;
            RubyArray rubyArray = this.getRuntime().newArray(region.numRegs);
            for (int i = 1; i < region.numRegs; ++i) {
                int n3 = region.beg[i];
                if (n3 == -1) {
                    rubyArray.append(this.getRuntime().getNil());
                    continue;
                }
                rubyArray.append(this.substr(n3, region.end[i] - n3).infectBy(rubyRegexp));
            }
            return rubyArray;
        }
        return null;
    }

    private final IRubyObject justify(IRubyObject[] iRubyObjectArray, char c) {
        int n;
        byte[] byArray;
        int n2;
        ByteList byteList;
        IRubyObject iRubyObject;
        Ruby ruby = this.getRuntime();
        int n3 = RubyFixnum.num2int(iRubyObjectArray[0]);
        int n4 = 0;
        if (iRubyObjectArray.length == 2) {
            iRubyObject = iRubyObjectArray[1].convertToString();
            byteList = iRubyObject.value;
            n2 = byteList.begin;
            n4 = byteList.realSize;
            if (n4 == 0) {
                throw this.getRuntime().newArgumentError("zero width padding");
            }
            byArray = byteList.bytes;
        } else {
            n2 = RubyString.SPACE_BYTELIST.begin;
            n4 = RubyString.SPACE_BYTELIST.realSize;
            byArray = RubyString.SPACE_BYTELIST.bytes;
            iRubyObject = ruby.getNil();
        }
        if (n3 < 0 || this.value.realSize >= n3) {
            return this.strDup();
        }
        byteList = new ByteList(n3);
        byteList.realSize = n3;
        int n5 = byteList.begin;
        byte[] byArray2 = byteList.bytes;
        if (c != 'l') {
            int n6 = n3 - this.value.realSize;
            n = n5 + (c == 'r' ? n6 : n6 / 2);
            if (n4 <= 1) {
                while (n5 < n) {
                    byArray2[n5++] = byArray[n2];
                }
            } else {
                int n7 = n2;
                while (n5 + n4 <= n) {
                    System.arraycopy(byArray, n2, byArray2, n5, n4);
                    n5 += n4;
                }
                while (n5 < n) {
                    byArray2[n5++] = byArray[n7++];
                }
            }
        }
        System.arraycopy(this.value.bytes, this.value.begin, byArray2, n5, this.value.realSize);
        if (c != 'r') {
            n5 += this.value.realSize;
            n = byteList.begin + n3;
            if (n4 <= 1) {
                while (n5 < n) {
                    byArray2[n5++] = byArray[n2];
                }
            } else {
                while (n5 + n4 <= n) {
                    System.arraycopy(byArray, n2, byArray2, n5, n4);
                    n5 += n4;
                }
                while (n5 < n) {
                    byArray2[n5++] = byArray[n2++];
                }
            }
        }
        RubyString rubyString = new RubyString(ruby, this.getMetaClass(), byteList);
        rubyString.infectBy(this);
        if (n4 > 0) {
            rubyString.infectBy(iRubyObject);
        }
        return rubyString;
    }

    @JRubyMethod(name={"ljust"}, required=1, optional=1)
    public IRubyObject ljust(IRubyObject[] iRubyObjectArray) {
        return this.justify(iRubyObjectArray, 'l');
    }

    @JRubyMethod(name={"rjust"}, required=1, optional=1)
    public IRubyObject rjust(IRubyObject[] iRubyObjectArray) {
        return this.justify(iRubyObjectArray, 'r');
    }

    @JRubyMethod(name={"center"}, required=1, optional=1)
    public IRubyObject center(IRubyObject[] iRubyObjectArray) {
        return this.justify(iRubyObjectArray, 'c');
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop() {
        RubyString rubyString = this.strDup();
        rubyString.chop_bang();
        return rubyString;
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang() {
        int n = this.value.realSize - 1;
        if (n < 0) {
            return this.getRuntime().getNil();
        }
        if (this.value.bytes[this.value.begin + n] == 10 && n > 0 && this.value.bytes[this.value.begin + n - 1] == 13) {
            --n;
        }
        this.view(0, n);
        return this;
    }

    @JRubyMethod(name={"chomp"}, optional=1)
    public RubyString chomp(IRubyObject[] iRubyObjectArray) {
        RubyString rubyString = this.strDup();
        rubyString.chomp_bang(iRubyObjectArray);
        return rubyString;
    }

    @JRubyMethod(name={"chomp!"}, optional=1)
    public IRubyObject chomp_bang(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length == 0) {
            int n = this.value.length();
            if (n == 0) {
                return this.getRuntime().getNil();
            }
            byte[] byArray = this.value.bytes;
            iRubyObject = this.getRuntime().getGlobalVariables().get("$/");
            if (iRubyObject == this.getRuntime().getGlobalVariables().getDefaultSeparator()) {
                int n2 = this.value.realSize;
                int n3 = this.value.begin;
                if (byArray[n3 + n - 1] == 10) {
                    if (--n2 > 0 && byArray[n3 + n2 - 1] == 13) {
                        --n2;
                    }
                    this.view(0, n2);
                } else if (byArray[n3 + n - 1] == 13) {
                    this.view(0, --n2);
                } else {
                    this.modifyCheck();
                    return this.getRuntime().getNil();
                }
                return this;
            }
        } else {
            iRubyObject = iRubyObjectArray[0];
        }
        if (iRubyObject.isNil()) {
            return this.getRuntime().getNil();
        }
        RubyString rubyString = iRubyObject.convertToString();
        int n = this.value.realSize;
        int n4 = this.value.begin;
        if (n == 0) {
            return this.getRuntime().getNil();
        }
        byte[] byArray = this.value.bytes;
        int n5 = rubyString.value.realSize;
        if (n5 == 0) {
            while (n > 0 && byArray[n4 + n - 1] == 10) {
                if (--n <= 0 || byArray[n4 + n - 1] != 13) continue;
                --n;
            }
            if (n < this.value.realSize) {
                this.view(0, n);
                return this;
            }
            return this.getRuntime().getNil();
        }
        if (n5 > n) {
            return this.getRuntime().getNil();
        }
        byte by = rubyString.value.bytes[n5 - 1];
        if (n5 == 1 && by == 10) {
            byArray = this.value.bytes;
            int n6 = this.value.realSize;
            if (byArray[n4 + n - 1] == 10) {
                if (--n6 > 0 && byArray[n4 + n6 - 1] == 13) {
                    --n6;
                }
                this.view(0, n6);
            } else if (byArray[n4 + n - 1] == 13) {
                this.view(0, --n6);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        if (byArray[n4 + n - 1] == by && n5 <= 1 || this.value.endsWith(rubyString.value)) {
            this.view(0, this.value.realSize - n5);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"lstrip"})
    public IRubyObject lstrip() {
        RubyString rubyString = this.strDup();
        rubyString.lstrip_bang();
        return rubyString;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang() {
        int n;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (n = 0; n < this.value.realSize && ASCII.isSpace(this.value.bytes[this.value.begin + n] & 0xFF); ++n) {
        }
        if (n > 0) {
            this.view(n, this.value.realSize - n);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"rstrip"})
    public IRubyObject rstrip() {
        RubyString rubyString = this.strDup();
        rubyString.rstrip_bang();
        return rubyString;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang() {
        int n;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (n = this.value.realSize - 1; n >= 0 && this.value.bytes[this.value.begin + n] == 0; --n) {
        }
        while (n >= 0 && ASCII.isSpace(this.value.bytes[this.value.begin + n] & 0xFF)) {
            --n;
        }
        if (n < this.value.realSize - 1) {
            this.view(0, n + 1);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"strip"})
    public IRubyObject strip() {
        RubyString rubyString = this.strDup();
        rubyString.strip_bang();
        return rubyString;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang() {
        IRubyObject iRubyObject = this.lstrip_bang();
        IRubyObject iRubyObject2 = this.rstrip_bang();
        if (iRubyObject.isNil() && iRubyObject2.isNil()) {
            return iRubyObject;
        }
        return this;
    }

    @JRubyMethod(name={"count"}, required=1, rest=true)
    public IRubyObject count(IRubyObject[] iRubyObjectArray) {
        int n;
        if (iRubyObjectArray.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.value.realSize == 0) {
            return this.getRuntime().newFixnum(0L);
        }
        boolean[] blArray = new boolean[256];
        boolean bl = true;
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            RubyString rubyString = iRubyObjectArray[n].convertToString();
            rubyString.setup_table(blArray, bl);
            bl = false;
        }
        n = this.value.begin;
        int n2 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        int n3 = 0;
        while (n < n2) {
            if (!blArray[byArray[n++] & 0xFF]) continue;
            ++n3;
        }
        return this.getRuntime().newFixnum(n3);
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true)
    public IRubyObject delete(IRubyObject[] iRubyObjectArray) {
        RubyString rubyString = this.strDup();
        rubyString.delete_bang(iRubyObjectArray);
        return rubyString;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true)
    public IRubyObject delete_bang(IRubyObject[] iRubyObjectArray) {
        int n;
        if (iRubyObjectArray.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean[] blArray = new boolean[256];
        boolean bl = true;
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            RubyString rubyString = iRubyObjectArray[n].convertToString();
            rubyString.setup_table(blArray, bl);
            bl = false;
        }
        this.modify();
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        int n2 = n = this.value.begin;
        int n3 = n + this.value.realSize;
        byte[] byArray = this.value.bytes;
        boolean bl2 = false;
        while (n < n3) {
            if (blArray[byArray[n] & 0xFF]) {
                bl2 = true;
            } else {
                byArray[n2++] = byArray[n];
            }
            ++n;
        }
        this.value.realSize = n2 - this.value.begin;
        if (bl2) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"squeeze"}, rest=true)
    public IRubyObject squeeze(IRubyObject[] iRubyObjectArray) {
        RubyString rubyString = this.strDup();
        rubyString.squeeze_bang(iRubyObjectArray);
        return rubyString;
    }

    @JRubyMethod(name={"squeeze!"}, rest=true)
    public IRubyObject squeeze_bang(IRubyObject[] iRubyObjectArray) {
        int n;
        int n2;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        boolean[] blArray = new boolean[256];
        if (iRubyObjectArray.length == 0) {
            for (n2 = 0; n2 < 256; ++n2) {
                blArray[n2] = true;
            }
        } else {
            n2 = 1;
            for (n = 0; n < iRubyObjectArray.length; ++n) {
                RubyString rubyString = iRubyObjectArray[n].convertToString();
                rubyString.setup_table(blArray, n2 != 0);
                n2 = 0;
            }
        }
        this.modify();
        n = n2 = this.value.begin;
        int n3 = n2 + this.value.realSize;
        byte[] byArray = this.value.bytes;
        int n4 = -1;
        while (n2 < n3) {
            int n5;
            if ((n5 = byArray[n2++] & 0xFF) == n4 && blArray[n5]) continue;
            int n6 = n++;
            n4 = n5;
            byArray[n6] = (byte)n4;
        }
        if (n - this.value.begin != this.value.realSize) {
            this.value.realSize = n - this.value.begin;
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"tr"}, required=2)
    public IRubyObject tr(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = this.strDup();
        rubyString.tr_trans(iRubyObject, iRubyObject2, false);
        return rubyString;
    }

    @JRubyMethod(name={"tr!"}, required=2)
    public IRubyObject tr_bang(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.tr_trans(iRubyObject, iRubyObject2, false);
    }

    private final void setup_table(boolean[] blArray, boolean bl) {
        int n;
        int n2;
        boolean[] blArray2 = new boolean[256];
        TR tR = new TR();
        boolean bl2 = false;
        tR.p = this.value.begin;
        tR.pend = this.value.begin + this.value.realSize;
        tR.buf = this.value.bytes;
        tR.max = 0;
        tR.now = 0;
        tR.gen = 0;
        if (this.value.realSize > 1 && this.value.bytes[this.value.begin] == 94) {
            bl2 = true;
            ++tR.p;
        }
        if (bl) {
            for (n2 = 0; n2 < 256; ++n2) {
                blArray[n2] = true;
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            blArray2[n2] = bl2;
        }
        while ((n = this.trnext(tR)) >= 0) {
            blArray2[n & 0xFF] = !bl2;
        }
        for (n2 = 0; n2 < 256; ++n2) {
            blArray[n2] = blArray[n2] && blArray2[n2];
        }
    }

    private final IRubyObject tr_trans(IRubyObject iRubyObject, IRubyObject iRubyObject2, boolean bl) {
        int n;
        int n2;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        ByteList byteList = iRubyObject2.convertToString().value;
        if (byteList.realSize == 0) {
            return this.delete_bang(new IRubyObject[]{iRubyObject});
        }
        ByteList byteList2 = iRubyObject.convertToString().value;
        TR tR = new TR();
        TR tR2 = new TR();
        boolean bl2 = false;
        boolean bl3 = false;
        tR.p = byteList2.begin;
        tR.pend = byteList2.begin + byteList2.realSize;
        tR.buf = byteList2.bytes;
        if (byteList2.realSize >= 2 && byteList2.bytes[byteList2.begin] == 94) {
            bl2 = true;
            ++tR.p;
        }
        tR2.p = byteList.begin;
        tR2.pend = byteList.begin + byteList.realSize;
        tR2.buf = byteList.bytes;
        tR2.gen = 0;
        tR.gen = 0;
        tR2.now = 0;
        tR.now = 0;
        tR2.max = 0;
        tR.max = 0;
        int[] nArray = new int[256];
        if (bl2) {
            for (n2 = 0; n2 < 256; ++n2) {
                nArray[n2] = 1;
            }
            while ((n = this.trnext(tR)) >= 0) {
                nArray[n & 0xFF] = -1;
            }
            while ((n = this.trnext(tR2)) >= 0) {
            }
            for (n2 = 0; n2 < 256; ++n2) {
                if (nArray[n2] < 0) continue;
                nArray[n2] = tR2.now;
            }
        } else {
            for (n2 = 0; n2 < 256; ++n2) {
                nArray[n2] = -1;
            }
            while ((n = this.trnext(tR)) >= 0) {
                n2 = this.trnext(tR2);
                if (n2 == -1) {
                    n2 = tR2.now;
                }
                nArray[n & 0xFF] = n2;
            }
        }
        this.modify();
        int n3 = n2 + this.value.realSize;
        byte[] byArray = this.value.bytes;
        if (bl) {
            int n4 = n2;
            int n5 = -1;
            while (n2 < n3) {
                byte by;
                if ((n = nArray[(by = byArray[n2++]) & 0xFF]) >= 0) {
                    if (n5 == n) continue;
                    n5 = n;
                    byArray[n4++] = (byte)(n & 0xFF);
                    bl3 = true;
                    continue;
                }
                n5 = -1;
                byArray[n4++] = by;
            }
            if (this.value.realSize > n4 - this.value.begin) {
                this.value.realSize = n4 - this.value.begin;
                bl3 = true;
            }
        } else {
            for (n2 = this.value.begin; n2 < n3; ++n2) {
                n = nArray[byArray[n2] & 0xFF];
                if (n < 0) continue;
                byArray[n2] = (byte)(n & 0xFF);
                bl3 = true;
            }
        }
        if (bl3) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    private final int trnext(TR tR) {
        byte[] byArray = tR.buf;
        while (tR.gen == 0) {
            if (tR.p == tR.pend) {
                return -1;
            }
            if (tR.p < tR.pend - 1 && byArray[tR.p] == 92) {
                ++tR.p;
            }
            tR.now = byArray[tR.p++];
            if (tR.p < tR.pend - 1 && byArray[tR.p] == 45) {
                ++tR.p;
                if (tR.p < tR.pend) {
                    if (tR.now > (byArray[tR.p] & 0xFF)) {
                        ++tR.p;
                        continue;
                    }
                    tR.gen = 1;
                    tR.max = byArray[tR.p++] & 0xFF;
                }
            }
            return tR.now & 0xFF;
        }
        if (++tR.now < tR.max) {
            return tR.now & 0xFF;
        }
        tR.gen = 0;
        return tR.max & 0xFF;
    }

    @JRubyMethod(name={"tr_s"}, required=2)
    public IRubyObject tr_s(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = this.strDup();
        rubyString.tr_trans(iRubyObject, iRubyObject2, true);
        return rubyString;
    }

    @JRubyMethod(name={"tr_s!"}, required=2)
    public IRubyObject tr_s_bang(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.tr_trans(iRubyObject, iRubyObject2, true);
    }

    @JRubyMethod(name={"each_line", "each"}, required=0, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString;
        int n = this.value.begin;
        int n2 = n + this.value.realSize;
        int n3 = n;
        int n4 = this.value.realSize;
        IRubyObject iRubyObject = iRubyObjectArray.length == 0 ? this.getRuntime().getGlobalVariables().get("$/") : iRubyObjectArray[0];
        if (iRubyObject.isNil()) {
            block.yield(threadContext, this);
            return this;
        }
        RubyString rubyString2 = RubyString.stringValue(iRubyObject);
        ByteList byteList = rubyString2.value;
        byte[] byArray = this.value.bytes;
        int n5 = byteList.realSize;
        byte by = n5 == 0 ? (byte)10 : byteList.bytes[byteList.begin + n5 - 1];
        int n6 = n;
        n += n5;
        while (n < n2) {
            if (n5 == 0 && byArray[n] == 10) {
                if (byArray[++n] == 10) {
                    while (n < n2 && byArray[n] == 10) {
                        ++n;
                    }
                }
            } else if (n3 < n && byArray[n - 1] == by && (n5 <= 1 || ByteList.memcmp(byteList.bytes, byteList.begin, n5, byArray, n - n5, n5) == 0)) {
                rubyString = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(n6 - n3, n - n6));
                rubyString.infectBy(this);
                block.yield(threadContext, rubyString);
                this.modifyCheck(byArray, n4);
                n6 = n;
            }
            ++n;
        }
        if (n6 != n2) {
            if (n > n2) {
                n = n2;
            }
            rubyString = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(n6 - n3, n - n6));
            rubyString.infectBy(this);
            block.yield(threadContext, rubyString);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public RubyString each_byte(ThreadContext threadContext, Block block) {
        Ruby ruby = this.getRuntime();
        for (int i = 0; i < this.value.length(); ++i) {
            block.yield(threadContext, ruby.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    public RubySymbol intern() {
        String string = this.toString();
        if (string.length() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (string.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.getRuntime().newSymbol(string);
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol to_sym() {
        return this.intern();
    }

    @JRubyMethod(name={"sum"}, optional=1)
    public RubyInteger sum(IRubyObject[] iRubyObjectArray) {
        long l;
        if (iRubyObjectArray.length > 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + " for 1)");
        }
        long l2 = 16L;
        if (iRubyObjectArray.length == 1 && (l = iRubyObjectArray[0].convertToInteger().getLongValue()) > 0L) {
            l2 = l;
        }
        l = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            l += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(l2 == 0L ? l : l % (long)Math.pow(2.0, l2));
    }

    public static RubyString unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubyString rubyString = RubyString.newString(unmarshalStream.getRuntime(), unmarshalStream.unmarshalString());
        unmarshalStream.registerLinkTarget(rubyString);
        return rubyString;
    }

    @JRubyMethod(name={"unpack"}, required=1)
    public RubyArray unpack(IRubyObject iRubyObject) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)iRubyObject).value);
    }

    public void setValue(CharSequence charSequence) {
        this.view(ByteList.plain(charSequence));
    }

    public void setValue(ByteList byteList) {
        this.view(byteList);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, this.value.begin, this.value.realSize, "UTF8");
        }
        catch (Exception exception) {
            throw new RuntimeException("Something's seriously broken with encodings", exception);
        }
    }

    private static final class TR {
        int gen;
        int now;
        int max;
        int p;
        int pend;
        byte[] buf;

        private TR() {
        }
    }

    public static class JavaCrypt {
        private static final int ITERATIONS = 16;
        private static final int[] con_salt = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 0, 0, 0, 0};
        private static final boolean[] shifts2 = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};
        private static final int[][] skb = new int[][]{{0, 16, 0x20000000, 0x20000010, 65536, 65552, 0x20010000, 0x20010010, 2048, 2064, 0x20000800, 536872976, 67584, 67600, 536938496, 536938512, 32, 48, 0x20000020, 0x20000030, 65568, 65584, 0x20010020, 536936496, 2080, 2096, 0x20000820, 536873008, 67616, 67632, 536938528, 536938544, 524288, 524304, 0x20080000, 537395216, 589824, 589840, 0x20090000, 537460752, 526336, 526352, 0x20080800, 537397264, 591872, 591888, 537462784, 537462800, 524320, 524336, 0x20080020, 537395248, 589856, 589872, 0x20090020, 537460784, 526368, 526384, 0x20080820, 537397296, 591904, 591920, 537462816, 537462832}, {0, 0x2000000, 8192, 0x2002000, 0x200000, 0x2200000, 0x202000, 0x2202000, 4, 0x2000004, 8196, 0x2002004, 0x200004, 0x2200004, 0x202004, 0x2202004, 1024, 0x2000400, 9216, 0x2002400, 0x200400, 0x2200400, 0x202400, 0x2202400, 1028, 0x2000404, 9220, 0x2002404, 0x200404, 0x2200404, 0x202404, 0x2202404, 0x10000000, 0x12000000, 0x10002000, 0x12002000, 0x10200000, 0x12200000, 0x10202000, 0x12202000, 0x10000004, 301989892, 268443652, 301998084, 270532612, 304087044, 270540804, 304095236, 0x10000400, 301990912, 268444672, 301999104, 270533632, 304088064, 270541824, 304096256, 0x10000404, 301990916, 268444676, 301999108, 270533636, 304088068, 270541828, 304096260}, {0, 1, 262144, 262145, 0x1000000, 0x1000001, 0x1040000, 0x1040001, 2, 3, 262146, 262147, 0x1000002, 0x1000003, 17039362, 17039363, 512, 513, 262656, 262657, 0x1000200, 0x1000201, 17039872, 17039873, 514, 515, 262658, 262659, 0x1000202, 16777731, 17039874, 17039875, 0x8000000, 0x8000001, 0x8040000, 134479873, 0x9000000, 0x9000001, 0x9040000, 151257089, 0x8000002, 0x8000003, 134479874, 134479875, 0x9000002, 0x9000003, 151257090, 151257091, 0x8000200, 134218241, 134480384, 134480385, 0x9000200, 150995457, 151257600, 151257601, 0x8000202, 134218243, 134480386, 134480387, 0x9000202, 150995459, 151257602, 151257603}, {0, 0x100000, 256, 0x100100, 8, 0x100008, 264, 0x100108, 4096, 0x101000, 4352, 0x101100, 4104, 0x101008, 4360, 0x101108, 0x4000000, 0x4100000, 0x4000100, 0x4100100, 0x4000008, 68157448, 67109128, 68157704, 0x4001000, 0x4101000, 0x4001100, 0x4101100, 67112968, 68161544, 67113224, 68161800, 131072, 0x120000, 131328, 0x120100, 131080, 1179656, 131336, 1179912, 135168, 0x121000, 135424, 0x121100, 135176, 1183752, 135432, 1184008, 0x4020000, 68288512, 67240192, 68288768, 67239944, 68288520, 67240200, 68288776, 67244032, 68292608, 67244288, 68292864, 67244040, 68292616, 67244296, 68292872}, {0, 0x10000000, 65536, 0x10010000, 4, 0x10000004, 65540, 0x10010004, 0x20000000, 0x30000000, 0x20010000, 0x30010000, 0x20000004, 0x30000004, 536936452, 805371908, 0x100000, 0x10100000, 0x110000, 0x10110000, 0x100004, 0x10100004, 0x110004, 0x10110004, 0x20100000, 0x30100000, 0x20110000, 0x30110000, 537919492, 806354948, 537985028, 806420484, 4096, 0x10001000, 69632, 0x10011000, 4100, 0x10001004, 69636, 0x10011004, 0x20001000, 0x30001000, 0x20011000, 0x30011000, 536875012, 805310468, 536940548, 805376004, 0x101000, 0x10101000, 0x111000, 0x10111000, 0x101004, 0x10101004, 0x111004, 0x10111004, 0x20101000, 0x30101000, 0x20111000, 0x30111000, 537923588, 806359044, 537989124, 806424580}, {0, 0x8000000, 8, 0x8000008, 1024, 0x8000400, 1032, 0x8000408, 131072, 0x8020000, 131080, 0x8020008, 132096, 134349824, 132104, 134349832, 1, 0x8000001, 9, 0x8000009, 1025, 134218753, 1033, 134218761, 131073, 134348801, 131081, 134348809, 132097, 134349825, 132105, 134349833, 0x2000000, 0xA000000, 0x2000008, 0xA000008, 0x2000400, 0xA000400, 33555464, 167773192, 0x2020000, 0xA020000, 0x2020008, 167903240, 0x2020400, 167904256, 33686536, 167904264, 0x2000001, 0xA000001, 0x2000009, 0xA000009, 33555457, 167773185, 33555465, 167773193, 0x2020001, 167903233, 0x2020009, 167903241, 33686529, 167904257, 33686537, 167904265}, {0, 256, 524288, 524544, 0x1000000, 0x1000100, 0x1080000, 0x1080100, 16, 272, 524304, 524560, 0x1000010, 0x1000110, 0x1080010, 0x1080110, 0x200000, 0x200100, 0x280000, 2621696, 0x1200000, 0x1200100, 19398656, 19398912, 0x200010, 0x200110, 2621456, 2621712, 0x1200010, 0x1200110, 19398672, 19398928, 512, 768, 524800, 525056, 0x1000200, 0x1000300, 17302016, 17302272, 528, 784, 524816, 525072, 0x1000210, 0x1000310, 17302032, 17302288, 0x200200, 0x200300, 0x280200, 2622208, 0x1200200, 18875136, 19399168, 19399424, 0x200210, 2097936, 2621968, 2622224, 0x1200210, 18875152, 19399184, 19399440}, {0, 0x4000000, 262144, 0x4040000, 2, 0x4000002, 262146, 0x4040002, 8192, 0x4002000, 270336, 0x4042000, 8194, 0x4002002, 270338, 0x4042002, 32, 0x4000020, 262176, 0x4040020, 34, 0x4000022, 262178, 0x4040022, 8224, 0x4002020, 270368, 0x4042020, 8226, 0x4002022, 270370, 0x4042022, 2048, 0x4000800, 264192, 0x4040800, 2050, 67110914, 264194, 67373058, 10240, 67119104, 272384, 67381248, 10242, 67119106, 272386, 67381250, 2080, 67110944, 264224, 67373088, 2082, 67110946, 264226, 67373090, 10272, 67119136, 272416, 67381280, 10274, 67119138, 272418, 67381282}};
        private static final int[][] SPtrans = new int[][]{{0x820200, 131072, -2139095040, -2138963456, 0x800000, -2147352064, -2147352576, -2139095040, -2147352064, 0x820200, 0x820000, -2147483136, -2139094528, 0x800000, 0, -2147352576, 131072, Integer.MIN_VALUE, 0x800200, 131584, -2138963456, 0x820000, -2147483136, 0x800200, Integer.MIN_VALUE, 512, 131584, -2138963968, 512, -2139094528, -2138963968, 0, 0, -2138963456, 0x800200, -2147352576, 0x820200, 131072, -2147483136, 0x800200, -2138963968, 512, 131584, -2139095040, -2147352064, Integer.MIN_VALUE, -2139095040, 0x820000, -2138963456, 131584, 0x820000, -2139094528, 0x800000, -2147483136, -2147352576, 0, 131072, 0x800000, -2139094528, 0x820200, Integer.MIN_VALUE, -2138963968, 512, -2147352064}, {268705796, 0, 270336, 0x10040000, 0x10000004, 8196, 0x10002000, 270336, 8192, 0x10040004, 4, 0x10002000, 262148, 268705792, 0x10040000, 4, 262144, 268443652, 0x10040004, 8192, 270340, 0x10000000, 0, 262148, 268443652, 270340, 268705792, 0x10000004, 0x10000000, 262144, 8196, 268705796, 262148, 268705792, 0x10002000, 270340, 268705796, 262148, 0x10000004, 0, 0x10000000, 8196, 262144, 0x10040004, 8192, 0x10000000, 270340, 268443652, 268705792, 8192, 0, 0x10000004, 4, 268705796, 270336, 0x10040000, 0x10040004, 262144, 8196, 0x10002000, 268443652, 4, 0x10040000, 270336}, {0x41000000, 0x1010040, 64, 0x41000040, 0x40010000, 0x1000000, 0x41000040, 65600, 0x1000040, 65536, 0x1010000, 0x40000000, 0x41010040, 0x40000040, 0x40000000, 0x41010000, 0, 0x40010000, 0x1010040, 64, 0x40000040, 0x41010040, 65536, 0x41000000, 0x41010000, 0x1000040, 0x40010040, 0x1010000, 65600, 0, 0x1000000, 0x40010040, 0x1010040, 64, 0x40000000, 65536, 0x40000040, 0x40010000, 0x1010000, 0x41000040, 0, 0x1010040, 65600, 0x41010000, 0x40010000, 0x1000000, 0x41010040, 0x40000000, 0x40010040, 0x41000000, 0x1000000, 0x41010040, 65536, 0x1000040, 0x41000040, 65600, 0x1000040, 0, 0x41010000, 0x40000040, 0x41000000, 0x40010040, 64, 0x1010000}, {1049602, 0x4000400, 2, 68158466, 0, 0x4100000, 0x4000402, 0x100002, 0x4100400, 0x4000002, 0x4000000, 1026, 0x4000002, 1049602, 0x100000, 0x4000000, 68157442, 0x100400, 1024, 2, 0x100400, 0x4000402, 0x4100000, 1024, 1026, 0, 0x100002, 0x4100400, 0x4000400, 68157442, 68158466, 0x100000, 68157442, 1026, 0x100000, 0x4000002, 0x100400, 0x4000400, 2, 0x4100000, 0x4000402, 0, 1024, 0x100002, 0, 68157442, 0x4100400, 1024, 0x4000000, 68158466, 1049602, 0x100000, 68158466, 2, 0x4000400, 1049602, 0x100002, 0x100400, 0x4100000, 0x4000402, 1026, 0x4000000, 0x4000002, 0x4100400}, {0x2000000, 16384, 256, 33571080, 33570824, 0x2000100, 16648, 0x2004000, 16384, 8, 0x2000008, 16640, 33554696, 33570824, 33571072, 0, 16640, 0x2000000, 16392, 264, 0x2000100, 16648, 0, 0x2000008, 8, 33554696, 33571080, 16392, 0x2004000, 256, 264, 33571072, 33571072, 33554696, 16392, 0x2004000, 16384, 8, 0x2000008, 0x2000100, 0x2000000, 16640, 33571080, 0, 16648, 0x2000000, 256, 16392, 33554696, 256, 0, 33571080, 33570824, 33571072, 264, 16384, 16640, 33570824, 0x2000100, 264, 8, 16648, 0x2004000, 0x2000008}, {0x20000010, 524304, 0, 0x20080800, 524304, 2048, 536872976, 524288, 2064, 537397264, 526336, 0x20000000, 0x20000800, 0x20000010, 0x20080000, 526352, 524288, 536872976, 537395216, 0, 2048, 16, 0x20080800, 537395216, 537397264, 0x20080000, 0x20000000, 2064, 16, 526336, 526352, 0x20000800, 2064, 0x20000000, 0x20000800, 526352, 0x20080800, 524304, 0, 0x20000800, 0x20000000, 2048, 537395216, 524288, 524304, 537397264, 526336, 16, 537397264, 526336, 524288, 536872976, 0x20000010, 0x20080000, 526352, 0, 2048, 0x20000010, 536872976, 0x20080800, 0x20080000, 2064, 16, 537395216}, {4096, 128, 0x400080, 0x400001, 4198529, 4097, 4224, 0, 0x400000, 4194433, 129, 0x401000, 1, 4198528, 0x401000, 129, 4194433, 4096, 4097, 4198529, 0, 0x400080, 0x400001, 4224, 0x401001, 4225, 4198528, 1, 4225, 0x401001, 128, 0x400000, 4225, 0x401000, 0x401001, 129, 4096, 128, 0x400000, 0x401001, 4194433, 4225, 4224, 0, 128, 0x400001, 1, 0x400080, 0, 4194433, 0x400080, 4224, 129, 4096, 4198529, 0x400000, 4198528, 1, 4097, 4198529, 0x400001, 4198528, 0x401000, 4097}, {0x8200020, 0x8208000, 32800, 0, 0x8008000, 0x200020, 0x8200000, 0x8208020, 32, 0x8000000, 0x208000, 32800, 0x208020, 0x8008020, 0x8000020, 0x8200000, 32768, 0x208020, 0x200020, 0x8008000, 0x8208020, 0x8000020, 0, 0x208000, 0x8000000, 0x200000, 0x8008020, 0x8200020, 0x200000, 32768, 0x8208000, 32, 0x200000, 32768, 0x8000020, 0x8208020, 32800, 0x8000000, 0, 0x208000, 0x8200020, 0x8008020, 0x8008000, 0x200020, 0x8208000, 32, 0x200020, 0x8008000, 0x8208020, 0x200000, 0x8200000, 0x8000020, 0x208000, 32800, 0x8008020, 0x8200000, 32, 0x8208000, 0x208020, 0, 0x8000000, 0x8200020, 32768, 0x208020}};
        private static final int[] cov_2char = new int[]{46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

        private static final int byteToUnsigned(byte by) {
            return by & 0xFF;
        }

        private static int fourBytesToInt(byte[] byArray, int n) {
            int n2 = JavaCrypt.byteToUnsigned(byArray[n++]);
            n2 |= JavaCrypt.byteToUnsigned(byArray[n++]) << 8;
            n2 |= JavaCrypt.byteToUnsigned(byArray[n++]) << 16;
            return n2 |= JavaCrypt.byteToUnsigned(byArray[n++]) << 24;
        }

        private static final void intToFourBytes(int n, byte[] byArray, int n2) {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2++] = (byte)(n >>> 16 & 0xFF);
            byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        }

        private static final void PERM_OP(int n, int n2, int n3, int n4, int[] nArray) {
            int n5 = (n >>> n3 ^ n2) & n4;
            nArray[0] = n ^= n5 << n3;
            nArray[1] = n2 ^= n5;
        }

        private static final int HPERM_OP(int n, int n2, int n3) {
            int n4 = (n << 16 - n2 ^ n) & n3;
            n = n ^ n4 ^ n4 >>> 16 - n2;
            return n;
        }

        private static int[] des_set_key(byte[] byArray) {
            int[] nArray = new int[32];
            int n = JavaCrypt.fourBytesToInt(byArray, 0);
            int n2 = JavaCrypt.fourBytesToInt(byArray, 4);
            int[] nArray2 = new int[2];
            JavaCrypt.PERM_OP(n2, n, 4, 0xF0F0F0F, nArray2);
            n2 = nArray2[0];
            n = nArray2[1];
            n = JavaCrypt.HPERM_OP(n, -2, -859045888);
            n2 = JavaCrypt.HPERM_OP(n2, -2, -859045888);
            JavaCrypt.PERM_OP(n2, n, 1, 0x55555555, nArray2);
            n2 = nArray2[0];
            n = nArray2[1];
            JavaCrypt.PERM_OP(n, n2, 8, 0xFF00FF, nArray2);
            n = nArray2[0];
            n2 = nArray2[1];
            JavaCrypt.PERM_OP(n2, n, 1, 0x55555555, nArray2);
            n2 = nArray2[0];
            n = nArray2[1];
            n2 = (n2 & 0xFF) << 16 | n2 & 0xFF00 | (n2 & 0xFF0000) >>> 16 | (n & 0xF0000000) >>> 4;
            n &= 0xFFFFFFF;
            int n3 = 0;
            for (int i = 0; i < 16; ++i) {
                if (shifts2[i]) {
                    n = n >>> 2 | n << 26;
                    n2 = n2 >>> 2 | n2 << 26;
                } else {
                    n = n >>> 1 | n << 27;
                    n2 = n2 >>> 1 | n2 << 27;
                }
                int n4 = skb[0][(n &= 0xFFFFFFF) & 0x3F] | skb[1][n >>> 6 & 3 | n >>> 7 & 0x3C] | skb[2][n >>> 13 & 0xF | n >>> 14 & 0x30] | skb[3][n >>> 20 & 1 | n >>> 21 & 6 | n >>> 22 & 0x38];
                int n5 = skb[4][(n2 &= 0xFFFFFFF) & 0x3F] | skb[5][n2 >>> 7 & 3 | n2 >>> 8 & 0x3C] | skb[6][n2 >>> 15 & 0x3F] | skb[7][n2 >>> 21 & 0xF | n2 >>> 22 & 0x30];
                nArray[n3++] = (n5 << 16 | n4 & 0xFFFF) & 0xFFFFFFFF;
                n4 = n4 >>> 16 | n5 & 0xFFFF0000;
                n4 = n4 << 4 | n4 >>> 28;
                nArray[n3++] = n4 & 0xFFFFFFFF;
            }
            return nArray;
        }

        private static final int D_ENCRYPT(int n, int n2, int n3, int n4, int n5, int[] nArray) {
            int n6 = n2 ^ n2 >>> 16;
            int n7 = n6 & n4;
            n7 = n7 ^ n7 << 16 ^ n2 ^ nArray[n3];
            int n8 = (n6 &= n5) ^ n6 << 16 ^ n2 ^ nArray[n3 + 1];
            n8 = n8 >>> 4 | n8 << 28;
            return n ^= SPtrans[1][n8 & 0x3F] | SPtrans[3][n8 >>> 8 & 0x3F] | SPtrans[5][n8 >>> 16 & 0x3F] | SPtrans[7][n8 >>> 24 & 0x3F] | SPtrans[0][n7 & 0x3F] | SPtrans[2][n7 >>> 8 & 0x3F] | SPtrans[4][n7 >>> 16 & 0x3F] | SPtrans[6][n7 >>> 24 & 0x3F];
        }

        private static final int[] body(int[] nArray, int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < 25; ++i) {
                for (int j = 0; j < 32; j += 4) {
                    n3 = JavaCrypt.D_ENCRYPT(n3, n4, j, n, n2, nArray);
                    n4 = JavaCrypt.D_ENCRYPT(n4, n3, j + 2, n, n2, nArray);
                }
                n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            n5 = n4;
            n4 = n3 >>> 1 | n3 << 31;
            n3 = n5 >>> 1 | n5 << 31;
            int[] nArray2 = new int[2];
            JavaCrypt.PERM_OP(n4 &= 0xFFFFFFFF, n3 &= 0xFFFFFFFF, 1, 0x55555555, nArray2);
            n4 = nArray2[0];
            n3 = nArray2[1];
            JavaCrypt.PERM_OP(n3, n4, 8, 0xFF00FF, nArray2);
            n3 = nArray2[0];
            n4 = nArray2[1];
            JavaCrypt.PERM_OP(n4, n3, 2, 0x33333333, nArray2);
            n4 = nArray2[0];
            n3 = nArray2[1];
            JavaCrypt.PERM_OP(n3, n4, 16, 65535, nArray2);
            n3 = nArray2[0];
            n4 = nArray2[1];
            JavaCrypt.PERM_OP(n4, n3, 4, 0xF0F0F0F, nArray2);
            n4 = nArray2[0];
            n3 = nArray2[1];
            int[] nArray3 = new int[]{n3, n4};
            return nArray3;
        }

        public static final ByteList crypt(ByteList byteList, ByteList byteList2) {
            int n;
            ByteList byteList3 = new ByteList(new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32}, false);
            byte by = byteList.bytes[byteList.begin];
            byte by2 = byteList.bytes[byteList.begin + 1];
            byteList3.set(0, by);
            byteList3.set(1, by2);
            int n2 = con_salt[by & 0x7F];
            int n3 = con_salt[by2 & 0x7F] << 4;
            byte[] byArray = new byte[8];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = 0;
            }
            for (n = 0; n < byArray.length && n < byteList2.length(); ++n) {
                int n4 = byteList2.bytes[byteList2.begin + n] & 0xFF;
                byArray[n] = (byte)(n4 << 1);
            }
            int[] nArray = JavaCrypt.des_set_key(byArray);
            int[] nArray2 = JavaCrypt.body(nArray, n2, n3);
            byte[] byArray2 = new byte[9];
            JavaCrypt.intToFourBytes(nArray2[0], byArray2, 0);
            JavaCrypt.intToFourBytes(nArray2[1], byArray2, 4);
            byArray2[8] = 0;
            int n5 = 0;
            int n6 = 128;
            for (int i = 2; i < 13; ++i) {
                int n7 = 0;
                for (int j = 0; j < 6; ++j) {
                    n7 <<= 1;
                    if ((byArray2[n5] & n6) != 0) {
                        n7 |= 1;
                    }
                    if ((n6 >>>= 1) == 0) {
                        ++n5;
                        n6 = 128;
                    }
                    byteList3.set(i, cov_2char[n7]);
                }
            }
            return byteList3;
        }
    }
}

