/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.encoding.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyRegexp
extends RubyObject
implements ReOptions,
WarnCallback {
    private KCode kcode;
    private Regex pattern;
    private ByteList str;
    private static final byte[] PIPE = new byte[]{124};
    private static final byte[] DASH = new byte[]{45};
    private static final byte[] R_PAREN = new byte[]{41};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] M_CHAR = new byte[]{109};
    private static final byte[] I_CHAR = new byte[]{105};
    private static final byte[] X_CHAR = new byte[]{120};
    private static final int REGEXP_LITERAL_F = 2048;
    private static final int REGEXP_KCODE_DEFAULT = 4096;
    static SoftReference<HashMap<ByteList, Regex>> patternCache = new SoftReference<Object>(null);
    private static ObjectAllocator REGEXP_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyRegexp rubyRegexp = new RubyRegexp(ruby, rubyClass);
            return rubyRegexp;
        }
    };
    private static final int REGEX_QUOTED = 1;
    private static final int EMBEDDABLE = 7;

    public void setLiteral() {
        this.flags |= 0x800;
    }

    public void clearLiteral() {
        this.flags &= 0xFFFFF7FF;
    }

    public boolean isLiteral() {
        return (this.flags & 0x800) != 0;
    }

    public void setKCodeDefault() {
        this.flags |= 0x1000;
    }

    public void clearKCodeDefault() {
        this.flags &= 0xFFFFEFFF;
    }

    public boolean isKCodeDefault() {
        return (this.flags & 0x1000) != 0;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    private static synchronized HashMap<ByteList, Regex> getPatternCache() {
        HashMap<ByteList, Object> hashMap = patternCache.get();
        if (hashMap == null) {
            hashMap = new HashMap(5);
            patternCache = new SoftReference<HashMap<ByteList, Regex>>(hashMap);
        }
        return hashMap;
    }

    public static RubyClass createRegexpClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Regexp", ruby.getObject(), REGEXP_ALLOCATOR);
        ruby.setRegexp(rubyClass);
        rubyClass.index = 9;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyRegexp;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyRegexp.class);
        rubyClass.defineConstant("IGNORECASE", ruby.newFixnum(1L));
        rubyClass.defineConstant("EXTENDED", ruby.newFixnum(2L));
        rubyClass.defineConstant("MULTILINE", ruby.newFixnum(4L));
        rubyClass.defineAnnotatedMethods(RubyRegexp.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    private RubyRegexp(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    private RubyRegexp(Ruby ruby) {
        super(ruby, ruby.getRegexp());
    }

    public static RubyRegexp newRegexp(Ruby ruby, String string, int n) {
        return RubyRegexp.newRegexp(ruby, ByteList.create(string), n);
    }

    public static RubyRegexp newRegexp(Ruby ruby, ByteList byteList, int n) {
        RubyRegexp rubyRegexp = RubyRegexp.newRegexp(ruby, byteList, n, false);
        rubyRegexp.setLiteral();
        return rubyRegexp;
    }

    public static RubyRegexp newRegexp(Ruby ruby, ByteList byteList, int n, boolean bl) {
        RubyRegexp rubyRegexp = new RubyRegexp(ruby);
        rubyRegexp.initialize(byteList, n, bl);
        return rubyRegexp;
    }

    public void warn(String string) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, string, new Object[0]);
    }

    @JRubyMethod(name={"kcode"})
    public IRubyObject kcode() {
        return !this.isKCodeDefault() && this.kcode != null ? this.getRuntime().newString(this.kcode.name()) : this.getRuntime().getNil();
    }

    @Override
    public int getNativeTypeIndex() {
        return 9;
    }

    public Regex getPattern() {
        return this.pattern;
    }

    private void check() {
        if (this.pattern == null || this.str == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        this.check();
        int n = this.pattern.getOptions();
        int n2 = this.str.realSize;
        int n3 = this.str.begin;
        while (n2-- > 0) {
            n = n * 33 + this.str.bytes[n3++];
        }
        n += n >> 5;
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyRegexp)) {
            return this.getRuntime().getFalse();
        }
        RubyRegexp rubyRegexp = (RubyRegexp)iRubyObject;
        this.check();
        rubyRegexp.check();
        if (this.str.equal(rubyRegexp.str) && this.kcode == rubyRegexp.kcode && this.pattern.getOptions() == rubyRegexp.pattern.getOptions()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_match2(ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getLastLine();
        if (!(iRubyObject instanceof RubyString)) {
            threadContext.getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return this.getRuntime().getNil();
        }
        int n = this.search(threadContext, (RubyString)iRubyObject, 0, false);
        if (n < 0) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject eqq(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyString)) {
            iRubyObject = iRubyObject.checkStringType();
        }
        if (iRubyObject.isNil()) {
            threadContext.getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return this.getRuntime().getFalse();
        }
        int n = this.search(threadContext, (RubyString)iRubyObject, 0, false);
        return n < 0 ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    private void initialize(ByteList byteList, int n, boolean bl) {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify regexp");
        }
        this.checkFrozen();
        if (this.isLiteral()) {
            throw this.getRuntime().newSecurityError("can't modify literal regexp");
        }
        this.setKCode(n);
        HashMap<ByteList, Regex> hashMap = RubyRegexp.getPatternCache();
        Regex regex = hashMap.get(byteList);
        if (regex != null && regex.getEncoding() == this.kcode.getEncoding() && regex.getOptions() == (n & 0xF) && (regex.getUserOptions() & 1) != 0 == bl) {
            this.pattern = regex;
        } else {
            if (bl) {
                byteList = RubyRegexp.quote(byteList, this.getRuntime().getKCode());
            }
            this.makeRegexp(byteList, byteList.begin, byteList.realSize, n & 0xF, this.kcode.getEncoding());
            if (bl) {
                this.pattern.setUserOptions(1);
            }
            hashMap.put(byteList, this.pattern);
        }
        this.str = byteList;
    }

    private void makeRegexp(ByteList byteList, int n, int n2, int n3, Encoding encoding) {
        try {
            this.pattern = new Regex(byteList.bytes, n, n + n2, n3, encoding, Syntax.DEFAULT, (WarnCallback)this);
        }
        catch (Exception exception) {
            this.rb_reg_raise(byteList.bytes, n, n2, exception.getMessage(), n3);
        }
    }

    private final void rb_reg_raise(byte[] byArray, int n, int n2, String string, int n3) {
        throw this.getRuntime().newRegexpError(string + ": " + this.rb_reg_desc(byArray, n, n2, n3));
    }

    private final StringBuffer rb_reg_desc(byte[] byArray, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer("/");
        this.rb_reg_expr_str(stringBuffer, byArray, n, n2);
        stringBuffer.append("/");
        if ((n3 & 4) != 0) {
            stringBuffer.append("m");
        }
        if ((n3 & 1) != 0) {
            stringBuffer.append("i");
        }
        if ((n3 & 2) != 0) {
            stringBuffer.append("x");
        }
        if (this.kcode != null && !this.isKCodeDefault()) {
            stringBuffer.append(this.kcode.name().charAt(0));
        }
        return stringBuffer;
    }

    private final void rb_reg_expr_str(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3;
        boolean bl = false;
        int n4 = n + n2;
        Encoding encoding = this.kcode.getEncoding();
        for (n3 = n; n3 < n4; n3 += encoding.length(byArray[n3])) {
            if (byArray[n3] != 47 && (32 == byArray[n3] || !Character.isWhitespace(byArray[n3]) && !Character.isISOControl(byArray[n3]) || encoding.length(byArray[n3]) != 1)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            stringBuffer.append(new ByteList(byArray, n, n2, false).toString());
        } else {
            n3 = 0;
            while (n3 < n4) {
                if (byArray[n3] == 92) {
                    int n5 = encoding.length(byArray[n3 + 1]) + 1;
                    stringBuffer.append(new ByteList(byArray, n3, n5, false).toString());
                    n3 += n5;
                    continue;
                }
                if (byArray[n3] == 47) {
                    stringBuffer.append("\\/");
                } else {
                    if (encoding.length(byArray[n3]) != 1) {
                        stringBuffer.append(new ByteList(byArray, n3, encoding.length(byArray[n3]), false).toString());
                        n3 += encoding.length(byArray[n3]);
                        continue;
                    }
                    if (32 == byArray[n3] || !Character.isWhitespace(byArray[n3]) && !Character.isISOControl(byArray[n3])) {
                        stringBuffer.append((char)(byArray[n3] & 0xFF));
                    } else if (!Character.isWhitespace((char)(byArray[n3] & 0xFF))) {
                        stringBuffer.append('\\');
                        stringBuffer.append(Integer.toString(byArray[n3] & 0xFF, 8));
                    } else {
                        stringBuffer.append((char)(byArray[n3] & 0xFF));
                    }
                }
                ++n3;
            }
        }
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != iRubyObject.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("wrong argument type");
        }
        RubyRegexp rubyRegexp = (RubyRegexp)iRubyObject;
        rubyRegexp.check();
        this.initialize(rubyRegexp.str, rubyRegexp.getOptions(), false);
        return this;
    }

    private int getKcode() {
        if (this.kcode == KCode.NONE) {
            return 16;
        }
        if (this.kcode == KCode.EUC) {
            return 32;
        }
        if (this.kcode == KCode.SJIS) {
            return 48;
        }
        if (this.kcode == KCode.UTF8) {
            return 64;
        }
        return 0;
    }

    private void setKCode(int n) {
        this.clearKCodeDefault();
        switch (n & 0xFFFFFFF0) {
            default: {
                this.setKCodeDefault();
                this.kcode = this.getRuntime().getKCode();
                break;
            }
            case 16: {
                this.kcode = KCode.NONE;
                break;
            }
            case 32: {
                this.kcode = KCode.EUC;
                break;
            }
            case 48: {
                this.kcode = KCode.SJIS;
                break;
            }
            case 64: {
                this.kcode = KCode.UTF8;
            }
        }
    }

    private int getOptions() {
        this.check();
        int n = this.pattern.getOptions() & 7;
        if (!this.isKCodeDefault()) {
            n |= this.getKcode();
        }
        return n;
    }

    @JRubyMethod(name={"initialize"}, optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(IRubyObject[] iRubyObjectArray) {
        ByteList byteList;
        int n = 0;
        if (iRubyObjectArray[0] instanceof RubyRegexp) {
            if (iRubyObjectArray.length > 1) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags" + (iRubyObjectArray.length == 3 ? " and encoding" : "") + " ignored", new Object[0]);
            }
            RubyRegexp rubyRegexp = (RubyRegexp)iRubyObjectArray[0];
            rubyRegexp.check();
            n = rubyRegexp.pattern.getOptions() & 0xF;
            if (!rubyRegexp.isKCodeDefault() && rubyRegexp.kcode != null && rubyRegexp.kcode != KCode.NIL) {
                if (rubyRegexp.kcode == KCode.NONE) {
                    n |= 0x10;
                } else if (rubyRegexp.kcode == KCode.EUC) {
                    n |= 0x20;
                } else if (rubyRegexp.kcode == KCode.SJIS) {
                    n |= 0x30;
                } else if (rubyRegexp.kcode == KCode.UTF8) {
                    n |= 0x40;
                }
            }
            byteList = rubyRegexp.str;
        } else {
            if (iRubyObjectArray.length >= 2) {
                if (iRubyObjectArray[1] instanceof RubyFixnum) {
                    n = RubyNumeric.fix2int(iRubyObjectArray[1]);
                } else if (iRubyObjectArray[1].isTrue()) {
                    n = 1;
                }
            }
            if (iRubyObjectArray.length == 3 && !iRubyObjectArray[2].isNil()) {
                ByteList byteList2 = iRubyObjectArray[2].convertToString().getByteList();
                char c = byteList2.length() > 0 ? byteList2.charAt(0) : (char)'\u0000';
                n &= 0xFFFFFF8F;
                switch (c) {
                    case 'N': 
                    case 'n': {
                        n |= 0x10;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        n |= 0x20;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        n |= 0x30;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        n |= 0x40;
                        break;
                    }
                }
            }
            byteList = iRubyObjectArray[0].convertToString().getByteList();
        }
        this.initialize(byteList, n, false);
        return this;
    }

    @JRubyMethod(name={"new", "compile"}, required=1, optional=2, meta=true)
    public static RubyRegexp newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        RubyRegexp rubyRegexp = (RubyRegexp)rubyClass.allocate();
        rubyRegexp.callInit(iRubyObjectArray, Block.NULL_BLOCK);
        return rubyRegexp;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject options() {
        return this.getRuntime().newFixnum(this.getOptions());
    }

    public int search(ThreadContext threadContext, RubyString rubyString, int n, boolean bl) {
        Ruby ruby = this.getRuntime();
        Frame frame = threadContext.getCurrentFrame();
        ByteList byteList = rubyString.getByteList();
        if (n > byteList.realSize || n < 0) {
            frame.setBackRef(ruby.getNil());
            return -1;
        }
        this.check();
        int n2 = bl ? -n : byteList.realSize - n;
        Matcher matcher = this.pattern.matcher(byteList.bytes, byteList.begin, byteList.begin + byteList.realSize);
        int n3 = matcher.search(byteList.begin + n, byteList.begin + n + n2, 0);
        if (n3 < 0) {
            frame.setBackRef(ruby.getNil());
            return n3;
        }
        this.updateBackRef(rubyString, frame, matcher);
        return n3;
    }

    final RubyMatchData updateBackRef(RubyString rubyString, Frame frame, Matcher matcher) {
        RubyMatchData rubyMatchData;
        IRubyObject iRubyObject = frame.getBackRef();
        if (iRubyObject == null || iRubyObject.isNil() || ((RubyMatchData)iRubyObject).used()) {
            rubyMatchData = new RubyMatchData(this.getRuntime());
        } else {
            rubyMatchData = (RubyMatchData)iRubyObject;
            if (this.getRuntime().getSafeLevel() >= 3) {
                rubyMatchData.setTaint(true);
            } else {
                rubyMatchData.setTaint(false);
            }
        }
        rubyMatchData.regs = matcher.getRegion();
        rubyMatchData.begin = matcher.getBegin();
        rubyMatchData.end = matcher.getEnd();
        rubyMatchData.str = (RubyString)rubyString.strDup().freeze();
        rubyMatchData.pattern = this.pattern;
        frame.setBackRef(rubyMatchData);
        rubyMatchData.infectBy(this);
        rubyMatchData.infectBy(rubyString);
        return rubyMatchData;
    }

    @Override
    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            threadContext.getCurrentFrame().setBackRef(this.getRuntime().getNil());
            return iRubyObject;
        }
        int n = this.search(threadContext, iRubyObject.convertToString(), 0, false);
        if (n < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), n);
    }

    @JRubyMethod(name={"match"}, required=1)
    public IRubyObject match_m(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.op_match(threadContext, iRubyObject).isNil()) {
            return this.getRuntime().getNil();
        }
        IRubyObject iRubyObject2 = threadContext.getCurrentFrame().getBackRef();
        if (iRubyObject2 instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject2).use();
        }
        return iRubyObject2;
    }

    public RubyString regsub(RubyString rubyString, RubyString rubyString2, Matcher matcher) {
        Region region = matcher.getRegion();
        int n = matcher.getBegin();
        int n2 = matcher.getEnd();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        ByteList byteList = rubyString.getByteList();
        ByteList byteList2 = rubyString2.getByteList();
        int n6 = byteList.length();
        RubyString rubyString3 = null;
        Encoding encoding = this.kcode.getEncoding();
        block8: while (n3 < n6) {
            char c;
            int n7 = n3;
            if (encoding.length((byte)(c = byteList.charAt(n3++))) != 1) {
                n3 += encoding.length((byte)c) - 1;
                continue;
            }
            if (c != '\\' || n3 == n6) continue;
            if (rubyString3 == null) {
                rubyString3 = RubyString.newString(this.getRuntime(), new ByteList(n7 - n4));
            }
            rubyString3.cat(byteList.bytes, byteList.begin + n4, n7 - n4);
            c = byteList.charAt(n3++);
            n4 = n3;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n5 = c - 48;
                    break;
                }
                case '&': {
                    n5 = 0;
                    break;
                }
                case '`': {
                    int n8 = region == null ? n : region.beg[0];
                    rubyString3.cat(byteList2.bytes, byteList2.begin, n8);
                    continue block8;
                }
                case '\'': {
                    int n9 = region == null ? n2 : region.end[0];
                    rubyString3.cat(byteList2.bytes, byteList2.begin + n9, rubyString2.getByteList().realSize - n9);
                    continue block8;
                }
                case '+': {
                    if (region == null) {
                        if (n != -1) break;
                        n5 = 0;
                        continue block8;
                    }
                    for (n5 = region.numRegs - 1; region.beg[n5] == -1 && n5 > 0; --n5) {
                    }
                    if (n5 != 0) break;
                    continue block8;
                }
                case '\\': {
                    rubyString3.cat(byteList.bytes, n3 - 1, 1);
                    continue block8;
                }
                default: {
                    rubyString3.cat(byteList.bytes, n3 - 2, 2);
                    continue block8;
                }
            }
            if (region != null) {
                if (n5 < 0 || n5 >= region.numRegs || region.beg[n5] == -1) continue;
                rubyString3.cat(byteList2.bytes, byteList2.begin + region.beg[n5], region.end[n5] - region.beg[n5]);
                continue;
            }
            if (n5 != 0 || n == -1) continue;
            rubyString3.cat(byteList2.bytes, byteList2.begin + n, n2 - n);
        }
        if (n4 < n6) {
            if (rubyString3 == null) {
                rubyString3 = RubyString.newString(this.getRuntime(), byteList.makeShared(n4, n6 - n4));
            } else {
                rubyString3.cat(byteList.bytes, byteList.begin + n4, n6 - n4);
            }
        }
        if (rubyString3 == null) {
            return rubyString;
        }
        return rubyString3;
    }

    final int adjustStartPos(RubyString rubyString, int n, boolean bl) {
        this.check();
        ByteList byteList = rubyString.getByteList();
        return this.pattern.adjustStartPosition(byteList.bytes, byteList.begin, byteList.realSize, n, bl);
    }

    @JRubyMethod(name={"casefold?"})
    public IRubyObject casefold_p() {
        this.check();
        if ((this.pattern.getOptions() & 1) != 0) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source() {
        this.check();
        RubyString rubyString = RubyString.newStringShared(this.getRuntime(), this.str);
        if (this.isTaint()) {
            rubyString.taint();
        }
        return rubyString;
    }

    final int length() {
        return this.str.realSize;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        this.check();
        return this.getRuntime().newString(ByteList.create(this.rb_reg_desc(this.str.bytes, this.str.begin, this.str.realSize, this.pattern.getOptions()).toString()));
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        RubyString rubyString = this.getRuntime().newString("(?");
        this.check();
        int n = this.pattern.getOptions();
        int n2 = this.str.begin;
        int n3 = this.str.realSize;
        byte[] byArray = this.str.bytes;
        while (n3 >= 4 && byArray[n2] == 40 && byArray[n2 + 1] == 63) {
            boolean bl = true;
            n2 += 2;
            if ((n3 -= 2) > 0) {
                do {
                    if (byArray[n2] == 109) {
                        n |= 4;
                    } else if (byArray[n2] == 105) {
                        n |= 1;
                    } else {
                        if (byArray[n2] != 120) break;
                        n |= 2;
                    }
                    ++n2;
                } while (--n3 > 0);
            }
            if (n3 > 1 && byArray[n2] == 45) {
                ++n2;
                --n3;
                do {
                    if (byArray[n2] == 109) {
                        n &= 0xFFFFFFFB;
                    } else if (byArray[n2] == 105) {
                        n &= 0xFFFFFFFE;
                    } else {
                        if (byArray[n2] != 120) break;
                        n &= 0xFFFFFFFD;
                    }
                    ++n2;
                } while (--n3 > 0);
            }
            if (byArray[n2] == 41) {
                --n3;
                ++n2;
                continue;
            }
            if (byArray[n2] == 58 && byArray[n2 + n3 - 1] == 41) {
                try {
                    Regex regex = new Regex(byArray, ++n2, n3 -= 2, 0, this.kcode.getEncoding(), Syntax.DEFAULT);
                    bl = false;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            if (!bl) break;
            n = this.pattern.getOptions();
            n2 = this.str.begin;
            n3 = this.str.realSize;
            break;
        }
        if ((n & 4) != 0) {
            rubyString.cat(M_CHAR);
        }
        if ((n & 1) != 0) {
            rubyString.cat(I_CHAR);
        }
        if ((n & 2) != 0) {
            rubyString.cat(X_CHAR);
        }
        if ((n & 7) != 7) {
            rubyString.cat(DASH);
            if ((n & 4) == 0) {
                rubyString.cat(M_CHAR);
            }
            if ((n & 1) == 0) {
                rubyString.cat(I_CHAR);
            }
            if ((n & 2) == 0) {
                rubyString.cat(X_CHAR);
            }
        }
        rubyString.cat(COLON);
        this.rb_reg_expr_str(rubyString, n2, n3);
        rubyString.cat(R_PAREN);
        rubyString.infectBy(this);
        return rubyString;
    }

    private final boolean ISPRINT(byte by) {
        return this.ISPRINT((char)(by & 0xFF));
    }

    private final boolean ISPRINT(char c) {
        return ' ' == c || !Character.isWhitespace(c) && !Character.isISOControl(c);
    }

    private final void rb_reg_expr_str(RubyString rubyString, int n, int n2) {
        int n3;
        int n4 = n2;
        boolean bl = false;
        for (n3 = n; n3 < n4; n3 += this.kcode.getEncoding().length(this.str.bytes[n3])) {
            if (this.str.bytes[n3] != 47 && (this.ISPRINT(this.str.bytes[n3]) || this.kcode.getEncoding().length(this.str.bytes[n3]) != 1)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            rubyString.cat(this.str.bytes, n, n2);
        } else {
            n3 = n;
            while (n3 < n4) {
                int n5;
                if (this.str.bytes[n3] == 92) {
                    n5 = this.kcode.getEncoding().length(this.str.bytes[n3 + 1]) + 1;
                    rubyString.cat(this.str.bytes, n3, n5);
                    n3 += n5;
                    continue;
                }
                if (this.str.bytes[n3] == 47) {
                    n5 = 92;
                    rubyString.cat((byte)n5);
                    rubyString.cat(this.str.bytes, n3, 1);
                } else {
                    if (this.kcode.getEncoding().length(this.str.bytes[n3]) != 1) {
                        rubyString.cat(this.str.bytes, n3, this.kcode.getEncoding().length(this.str.bytes[n3]));
                        n3 += this.kcode.getEncoding().length(this.str.bytes[n3]);
                        continue;
                    }
                    if (this.ISPRINT(this.str.bytes[n3])) {
                        rubyString.cat(this.str.bytes, n3, 1);
                    } else if (!Character.isWhitespace(this.str.bytes[n3])) {
                        rubyString.cat(ByteList.create(Integer.toString(this.str.bytes[n3] & 0xFF, 8)));
                    } else {
                        rubyString.cat(this.str.bytes, n3, 1);
                    }
                }
                ++n3;
            }
        }
    }

    @JRubyMethod(name={"quote", "escape"}, required=1, optional=1, meta=true)
    public static RubyString quote(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObjectArray.length == 2 ? iRubyObjectArray[1] : null;
        IRubyObject iRubyObject3 = iRubyObjectArray[0];
        KCode kCode = iRubyObject.getRuntime().getKCode();
        if (iRubyObject2 != null && !iRubyObject2.isNil()) {
            kCode = KCode.create(iRubyObject.getRuntime(), iRubyObject2.toString());
        }
        RubyString rubyString = iRubyObject3.convertToString();
        RubyString rubyString2 = RubyString.newString(iRubyObject.getRuntime(), RubyRegexp.quote(rubyString.getByteList(), kCode));
        rubyString2.infectBy(rubyString);
        return rubyString2;
    }

    /*
     * Unable to fully structure code
     */
    public static ByteList quote(ByteList var0, KCode var1_1) {
        block15: {
            var2_2 = var0;
            var3_3 = 0;
            var4_4 = var2_2.begin;
            var6_5 = var4_4 + var2_2.length();
            var7_6 = var1_1.getEncoding();
            while (var4_4 < var6_5) {
                block16: {
                    var5_7 = (char)(var2_2.bytes[var4_4] & 255);
                    if (var7_6.length((byte)var5_7) == 1) break block16;
                    var8_8 = var7_6.length((byte)var5_7);
                    while (var8_8-- > 0 && var4_4 < var6_5) {
                        ++var4_4;
                    }
                    --var4_4;
                    ** GOTO lbl-1000
                }
                switch (var5_7) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '#': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        break block15;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        ++var4_4;
                        break;
                    }
                }
            }
            return var2_2;
        }
        var8_9 = new ByteList(var6_5 * 2);
        System.arraycopy(var2_2.bytes, var2_2.begin, var8_9.bytes, var8_9.begin, var4_4 - var2_2.begin);
        var3_3 += var4_4 - var2_2.begin;
        while (var4_4 < var6_5) {
            block18: {
                block17: {
                    var5_7 = (char)(var2_2.bytes[var4_4] & 255);
                    if (var7_6.length((byte)var5_7) == 1) break block17;
                    var9_10 = var7_6.length((byte)var5_7);
                    while (var9_10-- > 0 && var4_4 < var6_5) {
                        var8_9.bytes[var3_3++] = var2_2.bytes[var4_4++];
                    }
                    --var4_4;
                    break block18;
                }
                switch (var5_7) {
                    case '#': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        var8_9.bytes[var3_3++] = 92;
                        ** GOTO lbl62
                    }
                    case ' ': {
                        var8_9.bytes[var3_3++] = 92;
                        var8_9.bytes[var3_3++] = 32;
                        break;
                    }
                    case '\t': {
                        var8_9.bytes[var3_3++] = 92;
                        var8_9.bytes[var3_3++] = 116;
                        break;
                    }
                    case '\n': {
                        var8_9.bytes[var3_3++] = 92;
                        var8_9.bytes[var3_3++] = 110;
                        break;
                    }
                    case '\r': {
                        var8_9.bytes[var3_3++] = 92;
                        var8_9.bytes[var3_3++] = 114;
                        break;
                    }
                    case '\f': {
                        var8_9.bytes[var3_3++] = 92;
                        var8_9.bytes[var3_3++] = 102;
                        break;
                    }
lbl62:
                    // 2 sources

                    default: {
                        var8_9.bytes[var3_3++] = (byte)var5_7;
                    }
                }
            }
            ++var4_4;
        }
        var8_9.realSize = var3_3;
        return var8_9;
    }

    public static IRubyObject nth_match(int n, IRubyObject iRubyObject) {
        int n2;
        int n3;
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        RubyMatchData rubyMatchData = (RubyMatchData)iRubyObject;
        if (rubyMatchData.regs == null) {
            if (n >= 1) {
                return iRubyObject.getRuntime().getNil();
            }
            if (n < 0 && ++n <= 0) {
                return iRubyObject.getRuntime().getNil();
            }
            n3 = rubyMatchData.begin;
            n2 = rubyMatchData.end;
        } else {
            if (n >= rubyMatchData.regs.numRegs) {
                return iRubyObject.getRuntime().getNil();
            }
            if (n < 0 && (n += rubyMatchData.regs.numRegs) <= 0) {
                return iRubyObject.getRuntime().getNil();
            }
            n3 = rubyMatchData.regs.beg[n];
            n2 = rubyMatchData.regs.end[n];
        }
        if (n3 == -1) {
            return iRubyObject.getRuntime().getNil();
        }
        RubyString rubyString = rubyMatchData.str.makeShared(n3, n2 - n3);
        rubyString.infectBy(iRubyObject);
        return rubyString;
    }

    public static IRubyObject last_match(IRubyObject iRubyObject) {
        return RubyRegexp.nth_match(0, iRubyObject);
    }

    @JRubyMethod(name={"last_match"}, optional=1, meta=true)
    public static IRubyObject last_match_s(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1) {
            return RubyRegexp.nth_match(RubyNumeric.fix2int(iRubyObjectArray[0]), threadContext.getCurrentFrame().getBackRef());
        }
        IRubyObject iRubyObject2 = threadContext.getCurrentFrame().getBackRef();
        if (iRubyObject2 instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject2).use();
        }
        return iRubyObject2;
    }

    public static IRubyObject match_pre(IRubyObject iRubyObject) {
        int n;
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        RubyMatchData rubyMatchData = (RubyMatchData)iRubyObject;
        int n2 = n = rubyMatchData.regs == null ? rubyMatchData.begin : rubyMatchData.regs.beg[0];
        if (n == -1) {
            iRubyObject.getRuntime().getNil();
        }
        RubyString rubyString = rubyMatchData.str.makeShared(0, n);
        rubyString.infectBy(iRubyObject);
        return rubyString;
    }

    public static IRubyObject match_post(IRubyObject iRubyObject) {
        int n;
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        RubyMatchData rubyMatchData = (RubyMatchData)iRubyObject;
        if (rubyMatchData.regs == null) {
            if (rubyMatchData.begin == -1) {
                return iRubyObject.getRuntime().getNil();
            }
            n = rubyMatchData.end;
        } else {
            if (rubyMatchData.regs.beg[0] == -1) {
                return iRubyObject.getRuntime().getNil();
            }
            n = rubyMatchData.regs.end[0];
        }
        RubyString rubyString = rubyMatchData.str.makeShared(n, rubyMatchData.str.getByteList().realSize - n);
        rubyString.infectBy(iRubyObject);
        return rubyString;
    }

    public static IRubyObject match_last(IRubyObject iRubyObject) {
        int n;
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        RubyMatchData rubyMatchData = (RubyMatchData)iRubyObject;
        if (rubyMatchData.regs == null || rubyMatchData.regs.beg[0] == -1) {
            return iRubyObject.getRuntime().getNil();
        }
        for (n = rubyMatchData.regs.numRegs - 1; rubyMatchData.regs.beg[n] == -1 && n > 0; --n) {
        }
        if (n == 0) {
            return iRubyObject.getRuntime().getNil();
        }
        return RubyRegexp.nth_match(n, iRubyObject);
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            return RubyRegexp.newRegexp(iRubyObject.getRuntime(), ByteList.create("(?!)"), 0, false);
        }
        if (iRubyObjectArray.length == 1) {
            IRubyObject iRubyObject2 = TypeConverter.convertToTypeWithCheck(iRubyObjectArray[0], iRubyObject.getRuntime().getRegexp(), 0, "to_regexp");
            if (!iRubyObject2.isNil()) {
                return iRubyObject2;
            }
            return RubyRegexp.newRegexp(iRubyObject.getRuntime(), RubyRegexp.quote(iRubyObject, iRubyObjectArray).getByteList(), 0, false);
        }
        KCode kCode = null;
        IRubyObject iRubyObject3 = iRubyObject.getRuntime().getNil();
        RubyString rubyString = iRubyObject.getRuntime().newString("");
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[3];
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            IRubyObject iRubyObject4;
            if (0 < i) {
                rubyString.cat(PIPE);
            }
            if (!(iRubyObject4 = TypeConverter.convertToTypeWithCheck(iRubyObjectArray[i], iRubyObject.getRuntime().getRegexp(), 0, "to_regexp")).isNil()) {
                if (!((RubyRegexp)iRubyObject4).isKCodeDefault()) {
                    if (kCode == null) {
                        iRubyObject3 = iRubyObject4;
                        kCode = ((RubyRegexp)iRubyObject4).kcode;
                    } else if (((RubyRegexp)iRubyObject4).kcode != kCode) {
                        IRubyObject iRubyObject5 = iRubyObject3.inspect();
                        IRubyObject iRubyObject6 = iRubyObject4.inspect();
                        throw iRubyObject.getRuntime().newArgumentError("mixed kcode " + iRubyObject5 + " and " + iRubyObject6);
                    }
                }
                iRubyObject4 = ((RubyRegexp)iRubyObject4).to_s();
            } else {
                iRubyObject4 = RubyRegexp.quote(iRubyObject, new IRubyObject[]{iRubyObjectArray[i]});
            }
            rubyString.append(iRubyObject4);
        }
        iRubyObjectArray2[0] = rubyString;
        iRubyObjectArray2[1] = iRubyObject.getRuntime().getNil();
        if (kCode == null) {
            iRubyObjectArray2[2] = iRubyObject.getRuntime().getNil();
        } else if (kCode == KCode.NONE) {
            iRubyObjectArray2[2] = iRubyObject.getRuntime().newString("n");
        } else if (kCode == KCode.EUC) {
            iRubyObjectArray2[2] = iRubyObject.getRuntime().newString("e");
        } else if (kCode == KCode.SJIS) {
            iRubyObjectArray2[2] = iRubyObject.getRuntime().newString("s");
        } else if (kCode == KCode.UTF8) {
            iRubyObjectArray2[2] = iRubyObject.getRuntime().newString("u");
        }
        return iRubyObject.callMethod(threadContext, "new", iRubyObjectArray2);
    }

    public static RubyRegexp unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubyRegexp rubyRegexp = RubyRegexp.newRegexp(unmarshalStream.getRuntime(), unmarshalStream.unmarshalString(), unmarshalStream.unmarshalInt(), false);
        unmarshalStream.registerLinkTarget(rubyRegexp);
        return rubyRegexp;
    }

    public static void marshalTo(RubyRegexp rubyRegexp, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyRegexp);
        marshalStream.writeString(new String(rubyRegexp.str.bytes, rubyRegexp.str.begin, rubyRegexp.str.realSize));
        marshalStream.writeInt(rubyRegexp.pattern.getOptions() & 7);
    }
}

