/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    Regex pattern;
    public static final int MATCH_BUSY = 64;

    public static RubyClass createMatchDataClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("MatchData", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setMatchData(rubyClass);
        ruby.defineGlobalConstant("MatchingData", rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyMatchData;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyMatchData.class);
        rubyClass.getMetaClass().undefineMethod("new");
        rubyClass.defineAnnotatedMethods(RubyMatchData.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public RubyMatchData(Ruby ruby) {
        super(ruby, ruby.getMatchData());
    }

    public final void use() {
        this.flags |= 0x40;
    }

    public final boolean used() {
        return (this.flags & 0x40) != 0;
    }

    private RubyArray match_array(int n) {
        if (this.regs == null) {
            if (n != 0) {
                return this.getRuntime().newEmptyArray();
            }
            if (this.begin == -1) {
                return this.getRuntime().newArray(this.getRuntime().getNil());
            }
            RubyString rubyString = this.str.makeShared(this.begin, this.end - this.begin);
            if (this.isTaint()) {
                rubyString.setTaint(true);
            }
            return this.getRuntime().newArray(rubyString);
        }
        RubyArray rubyArray = this.getRuntime().newArray(this.regs.numRegs - n);
        for (int i = n; i < this.regs.numRegs; ++i) {
            if (this.regs.beg[i] == -1) {
                rubyArray.append(this.getRuntime().getNil());
                continue;
            }
            RubyString rubyString = this.str.makeShared(this.regs.beg[i], this.regs.end[i] - this.regs.beg[i]);
            if (this.isTaint()) {
                rubyString.setTaint(true);
            }
            rubyArray.append(rubyString);
        }
        return rubyArray;
    }

    public IRubyObject group(long l) {
        return RubyRegexp.nth_match((int)l, this);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.anyToString();
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.match_array(0);
    }

    @JRubyMethod(name={"values_at"}, required=1, rest=true)
    public IRubyObject values_at(IRubyObject[] iRubyObjectArray) {
        return this.to_a().values_at(iRubyObjectArray);
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(ThreadContext threadContext, Block block) {
        return block.yield(threadContext, this.to_a());
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures() {
        return this.match_array(1);
    }

    private int nameToBackrefNumber(RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        try {
            return this.pattern.nameToBackrefNumber(byteList.bytes, byteList.begin, byteList.begin + byteList.realSize, this.regs);
        }
        catch (JOniException jOniException) {
            throw this.getRuntime().newIndexError(jOniException.getMessage());
        }
    }

    @JRubyMethod(name={"[]"}, required=1, optional=1)
    public IRubyObject op_aref(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray.length == 2 ? iRubyObjectArray[1] : null;
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        if (iRubyObject == null || iRubyObject.isNil()) {
            if (iRubyObject2 instanceof RubyFixnum) {
                int n = RubyNumeric.fix2int(iRubyObject2);
                if (n >= 0) {
                    return RubyRegexp.nth_match(n, this);
                }
            } else {
                RubyString rubyString;
                if (iRubyObject2 instanceof RubySymbol) {
                    rubyString = (RubyString)((RubySymbol)iRubyObject2).id2name();
                } else if (iRubyObject2 instanceof RubyString) {
                    rubyString = (RubyString)iRubyObject2;
                } else {
                    return this.to_a().aref(iRubyObjectArray);
                }
                return RubyRegexp.nth_match(this.nameToBackrefNumber(rubyString), this);
            }
        }
        return this.to_a().aref(iRubyObjectArray);
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.regs == null ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.newFixnum(this.getRuntime(), this.regs.numRegs);
    }

    @JRubyMethod(name={"begin"}, required=1)
    public IRubyObject begin(IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int(iRubyObject);
        if (this.regs == null) {
            if (n != 0) {
                throw this.getRuntime().newIndexError("index " + n + " out of matches");
            }
            if (this.begin < 0) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.begin);
        }
        if (n < 0 || this.regs.numRegs <= n) {
            throw this.getRuntime().newIndexError("index " + n + " out of matches");
        }
        if (this.regs.beg[n] < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.regs.beg[n]);
    }

    @JRubyMethod(name={"end"}, required=1)
    public IRubyObject end(IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int(iRubyObject);
        if (this.regs == null) {
            if (n != 0) {
                throw this.getRuntime().newIndexError("index " + n + " out of matches");
            }
            if (this.end < 0) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.end);
        }
        if (n < 0 || this.regs.numRegs <= n) {
            throw this.getRuntime().newIndexError("index " + n + " out of matches");
        }
        if (this.regs.end[n] < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.regs.end[n]);
    }

    @JRubyMethod(name={"offset"}, required=1)
    public IRubyObject offset(IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int(iRubyObject);
        Ruby ruby = this.getRuntime();
        if (this.regs == null) {
            if (n != 0) {
                throw this.getRuntime().newIndexError("index " + n + " out of matches");
            }
            if (this.begin < 0) {
                return ruby.newArray(ruby.getNil(), ruby.getNil());
            }
            return ruby.newArray(RubyFixnum.newFixnum(ruby, this.begin), RubyFixnum.newFixnum(ruby, this.end));
        }
        if (n < 0 || this.regs.numRegs <= n) {
            throw ruby.newIndexError("index " + n + " out of matches");
        }
        if (this.regs.beg[n] < 0) {
            return ruby.newArray(ruby.getNil(), ruby.getNil());
        }
        return ruby.newArray(RubyFixnum.newFixnum(ruby, this.regs.beg[n]), RubyFixnum.newFixnum(ruby, this.regs.end[n]));
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match() {
        RubyString rubyString;
        if (this.regs == null) {
            if (this.begin == -1) {
                return this.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(0, this.begin);
        } else {
            if (this.regs.beg[0] == -1) {
                return this.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(0, this.regs.beg[0]);
        }
        if (this.isTaint()) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match() {
        RubyString rubyString;
        if (this.regs == null) {
            if (this.begin == -1) {
                return this.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(this.end, this.str.getByteList().length() - this.end);
        } else {
            if (this.regs.beg[0] == -1) {
                return this.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(this.regs.end[0], this.str.getByteList().length() - this.regs.end[0]);
        }
        if (this.isTaint()) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        IRubyObject iRubyObject = RubyRegexp.last_match(this);
        if (iRubyObject.isNil()) {
            iRubyObject = RubyString.newEmptyString(this.getRuntime());
        }
        if (this.isTaint()) {
            iRubyObject.setTaint(true);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        return this.str;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        if (this.getMetaClass() != iRubyObject.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyMatchData rubyMatchData = (RubyMatchData)iRubyObject;
        this.str = rubyMatchData.str;
        this.regs = rubyMatchData.regs;
        return this;
    }
}

