/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyInteger
extends RubyNumeric {
    public static RubyClass createIntegerClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Integer", ruby.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setInteger(rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyInteger;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyInteger.class);
        rubyClass.getSingletonClass().undefineMethod("new");
        rubyClass.includeModule(ruby.getPrecision());
        rubyClass.defineAnnotatedMethods(RubyInteger.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public RubyInteger(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyInteger(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, rubyClass, bl);
    }

    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = this.getRuntime();
        if (this instanceof RubyFixnum && iRubyObject instanceof RubyFixnum) {
            long l;
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
            long l2 = rubyFixnum.getLongValue();
            for (long i = l = this.getLongValue(); i <= l2; ++i) {
                block.yield(threadContext, RubyFixnum.newFixnum(ruby, i));
            }
        } else {
            RubyNumeric rubyNumeric = this;
            while (!rubyNumeric.callMethod(threadContext, MethodIndex.OP_GT, ">", iRubyObject).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(ruby));
            }
        }
        return this;
    }

    @JRubyMethod(name={"downto"}, required=1, frame=true)
    public IRubyObject downto(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this instanceof RubyFixnum && iRubyObject instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
            long l = rubyFixnum.getLongValue();
            for (long i = this.getLongValue(); i >= l; --i) {
                block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            RubyNumeric rubyNumeric = this;
            while (!rubyNumeric.callMethod(threadContext, MethodIndex.OP_LT, "<", iRubyObject).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_MINUS, "-", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    @JRubyMethod(name={"times"}, frame=true)
    public IRubyObject times(ThreadContext threadContext, Block block) {
        if (this instanceof RubyFixnum) {
            long l = this.getLongValue();
            for (long i = 0L; i < l; ++i) {
                block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            RubyNumeric rubyNumeric = RubyFixnum.zero(this.getRuntime());
            while (rubyNumeric.callMethod(threadContext, MethodIndex.OP_LT, "<", this).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext threadContext) {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw this.getRuntime().newRangeError(this.toString() + " out of char range");
        }
        return this.getRuntime().newString(new String(new char[]{(char)this.getLongValue()}));
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "round", "truncate"})
    public RubyInteger to_i() {
        return this;
    }

    @JRubyMethod(name={"induced_from"}, meta=true, required=1)
    public static IRubyObject induced_from(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum) {
            return iRubyObject2;
        }
        if (iRubyObject2 instanceof RubyFloat) {
            return iRubyObject2.callMethod(threadContext, MethodIndex.TO_I, "to_i");
        }
        throw iRubyObject.getRuntime().newTypeError("failed to convert " + iRubyObject2.getMetaClass().getName() + " into Integer");
    }
}

