/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyIconv
extends RubyObject {
    private static final String IGNORE = "//ignore";
    private CharsetDecoder fromEncoding;
    private CharsetEncoder toEncoding;
    private static final ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyIconv(ruby, rubyClass);
        }
    };

    public RubyIconv(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static void createIconv(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Iconv", ruby.getObject(), ICONV_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyIconv.class);
        RubyModule rubyModule = rubyClass.defineModuleUnder("Failure");
        RubyClass rubyClass2 = ruby.fastGetClass("ArgumentError");
        String[] stringArray = new String[]{"IllegalSequence", "InvalidCharacter", "InvalidEncoding", "OutOfRange", "BrokenLibrary"};
        for (int i = 0; i < stringArray.length; ++i) {
            RubyClass rubyClass3 = rubyClass.defineClassUnder(stringArray[i], rubyClass2, RubyFailure.ICONV_FAILURE_ALLOCATOR);
            rubyClass3.defineAnnotatedMethods(RubyFailure.class);
            rubyClass3.includeModule(rubyModule);
        }
    }

    private static String getCharset(String string) {
        int n = string.indexOf("//");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static boolean isIgnore(String string) {
        return string.toLowerCase().indexOf(IGNORE) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyIconv rubyIconv = (RubyIconv)ruby.fastGetClass("Iconv").newInstance(threadContext, new IRubyObject[]{iRubyObject2, iRubyObject3}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return rubyIconv;
        }
        IRubyObject iRubyObject4 = ruby.getNil();
        try {
            iRubyObject4 = block.yield(threadContext, rubyIconv);
            Object var9_8 = null;
            rubyIconv.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            rubyIconv.close();
            throw throwable;
        }
        return iRubyObject4;
    }

    @JRubyMethod(name={"initialize"}, required=2, frame=true)
    public IRubyObject initialize(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = this.getRuntime();
        if (!iRubyObject.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject.getMetaClass() + " into String");
        }
        if (!iRubyObject2.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject2.getMetaClass() + " into String");
        }
        String string = iRubyObject.convertToString().toString();
        String string2 = iRubyObject2.convertToString().toString();
        try {
            this.fromEncoding = Charset.forName(RubyIconv.getCharset(string2)).newDecoder();
            this.toEncoding = Charset.forName(RubyIconv.getCharset(string)).newEncoder();
            if (!RubyIconv.isIgnore(string2)) {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            if (!RubyIconv.isIgnore(string)) {
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw ruby.newArgumentError("invalid encoding");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw ruby.newArgumentError("invalid encoding");
        }
        catch (Exception exception) {
            throw ruby.newSystemCallError(exception.toString());
        }
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.toEncoding = null;
        this.fromEncoding = null;
        return this.getRuntime().newString("");
    }

    @JRubyMethod(name={"iconv"}, required=1, optional=2)
    public IRubyObject iconv(IRubyObject[] iRubyObjectArray) {
        Ruby ruby = this.getRuntime();
        iRubyObjectArray = Arity.scanArgs(ruby, iRubyObjectArray, 1, 2);
        int n = 0;
        int n2 = -1;
        if (iRubyObjectArray[0].isNil()) {
            this.fromEncoding.reset();
            this.toEncoding.reset();
            return ruby.newString("");
        }
        if (!iRubyObjectArray[0].respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObjectArray[0].getMetaClass() + " into String");
        }
        if (!iRubyObjectArray[1].isNil()) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1]);
        }
        if (!iRubyObjectArray[2].isNil()) {
            n2 = RubyNumeric.fix2int(iRubyObjectArray[2]);
        }
        IRubyObject iRubyObject = this._iconv(iRubyObjectArray[0].convertToString(), n, n2);
        return iRubyObject;
    }

    private IRubyObject _iconv(RubyString rubyString, int n, int n2) {
        Object object;
        ByteList byteList = rubyString.getByteList();
        if (n < 0) {
            n += byteList.length();
        }
        if (n2 < 0) {
            n2 += 1 + byteList.length();
        } else if (n2 > byteList.length()) {
            n2 = byteList.length();
        }
        if (n < 0 || n2 < n) {
            return this.getRuntime().newString();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin() + n, n2 - n);
        try {
            object = this.fromEncoding.decode(byteBuffer);
            byteBuffer = this.toEncoding.encode((CharBuffer)object);
        }
        catch (MalformedInputException malformedInputException) {
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
        }
        catch (CharacterCodingException characterCodingException) {
            throw this.getRuntime().newInvalidEncoding("invalid sequence");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        object = byteBuffer.array();
        return this.getRuntime().newString(new ByteList((byte[])object, 0, byteBuffer.limit()));
    }

    @JRubyMethod(name={"iconv"}, required=2, optional=1, meta=true)
    public static IRubyObject iconv(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyIconv.convertWithArgs(iRubyObject, iRubyObjectArray, "iconv");
    }

    @JRubyMethod(name={"conv"}, required=3, rest=true, meta=true)
    public static IRubyObject conv(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyIconv.convertWithArgs(iRubyObject, iRubyObjectArray, "conv").join(threadContext, iRubyObject.getRuntime().newString(""));
    }

    public static RubyArray convertWithArgs(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, String string) {
        String string2 = iRubyObjectArray[1].convertToString().toString();
        String string3 = iRubyObjectArray[0].convertToString().toString();
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        for (int i = 2; i < iRubyObjectArray.length; ++i) {
            rubyArray.append(RubyIconv.convert2(string2, string3, iRubyObjectArray[i].convertToString()));
        }
        return rubyArray;
    }

    private static IRubyObject convert2(String string, String string2, RubyString rubyString) {
        if (string.equals(string2)) {
            return rubyString;
        }
        try {
            ByteList byteList = rubyString.getByteList();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            CharsetDecoder charsetDecoder = Charset.forName(RubyIconv.getCharset(string)).newDecoder();
            if (!RubyIconv.isIgnore(string)) {
                charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            CharsetEncoder charsetEncoder = Charset.forName(RubyIconv.getCharset(string2)).newEncoder();
            if (!RubyIconv.isIgnore(string2)) {
                charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            byteBuffer = charsetEncoder.encode(charBuffer);
            byte[] byArray = byteBuffer.array();
            return RubyString.newString(rubyString.getRuntime(), new ByteList(byArray, 0, byteBuffer.limit()));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw rubyString.getRuntime().newInvalidEncoding("invalid encoding");
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return rubyString.getRuntime().getNil();
    }

    public static class RubyFailure
    extends RubyException {
        private IRubyObject success;
        private IRubyObject failed;
        protected static final ObjectAllocator ICONV_FAILURE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new RubyFailure(ruby, rubyClass);
            }
        };

        public static RubyFailure newInstance(Ruby ruby, RubyClass rubyClass, String string) {
            return new RubyFailure(ruby, rubyClass, string);
        }

        protected RubyFailure(Ruby ruby, RubyClass rubyClass) {
            this(ruby, rubyClass, null);
        }

        public RubyFailure(Ruby ruby, RubyClass rubyClass, String string) {
            super(ruby, rubyClass, string);
        }

        @JRubyMethod(name={"initialize"}, required=1, optional=2, frame=true)
        public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
            super.initialize(iRubyObjectArray, block);
            this.success = iRubyObjectArray.length >= 2 ? iRubyObjectArray[1] : this.getRuntime().getNil();
            this.failed = iRubyObjectArray.length == 3 ? iRubyObjectArray[2] : this.getRuntime().getNil();
            return this;
        }

        @JRubyMethod(name={"success"})
        public IRubyObject success() {
            return this.success;
        }

        @JRubyMethod(name={"failed"})
        public IRubyObject failed() {
            return this.failed;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            RubyClass rubyClass = this.getMetaClass();
            StringBuffer stringBuffer = new StringBuffer("#<");
            stringBuffer.append(rubyClass.getName()).append(": ").append(this.success.inspect().toString());
            stringBuffer.append(", ").append(this.failed.inspect().toString()).append(">");
            return this.getRuntime().newString(stringBuffer.toString());
        }
    }
}

