/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Comparator;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class RubyEnumerable {
    public static RubyModule createEnumerableModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Enumerable");
        ruby.setEnumerable(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyEnumerable.class);
        return rubyModule;
    }

    public static IRubyObject callEach(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, BlockCallback blockCallback) {
        return iRubyObject.callMethod(threadContext, "each", IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(iRubyObject, ruby.getEnumerable(), Arity.noArguments(), blockCallback, threadContext));
    }

    @JRubyMethod(name={"to_a", "entries"})
    public static IRubyObject to_a(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        return rubyArray;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public static IRubyObject sort(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        rubyArray.sort_bang(block);
        return rubyArray;
    }

    @JRubyMethod(name={"sort_by"}, frame=true)
    public static IRubyObject sort_by(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        int n;
        final Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject instanceof RubyArray) {
            RubyArray rubyArray = (RubyArray)iRubyObject;
            final IRubyObject[][] iRubyObjectArray = new IRubyObject[rubyArray.size()][2];
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
                int i = 0;

                public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray2, Block block2) {
                    iRubyObjectArray[this.i][0] = iRubyObjectArray2[0];
                    iRubyObjectArray[this.i++][1] = block.yield(threadContext, iRubyObjectArray2[0]);
                    return ruby.getNil();
                }
            });
            Arrays.sort(iRubyObjectArray, new Comparator<IRubyObject[]>(){

                @Override
                public int compare(IRubyObject[] iRubyObjectArray, IRubyObject[] iRubyObjectArray2) {
                    return RubyFixnum.fix2int(iRubyObjectArray[1].callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray2[1]));
                }
            });
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[rubyArray.size()];
            for (int i = 0; i < iRubyObjectArray2.length; ++i) {
                iRubyObjectArray2[i] = iRubyObjectArray[i][0];
            }
            return ruby.newArrayNoCopy(iRubyObjectArray2);
        }
        RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        IRubyObject[][] iRubyObjectArray = new IRubyObject[rubyArray.size()][2];
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            IRubyObject iRubyObject2;
            iRubyObjectArray[n][0] = iRubyObject2 = rubyArray.eltInternal(n);
            iRubyObjectArray[n][1] = block.yield(threadContext, iRubyObject2);
        }
        Arrays.sort(iRubyObjectArray, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] iRubyObjectArray, IRubyObject[] iRubyObjectArray2) {
                return RubyFixnum.fix2int(iRubyObjectArray[1].callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray2[1]));
            }
        });
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            rubyArray.eltInternalSet(n, iRubyObjectArray[n][0]);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"grep"}, required=1, frame=true)
    public static IRubyObject grep(final ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject iRubyObject2, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                    if (iRubyObject2.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObjectArray[0]).isTrue()) {
                        rubyArray.append(block.yield(threadContext, iRubyObjectArray[0]));
                    }
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block) {
                    if (iRubyObject2.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObjectArray[0]).isTrue()) {
                        rubyArray.append(iRubyObjectArray[0]);
                    }
                    return ruby.getNil();
                }
            });
        }
        return rubyArray;
    }

    @JRubyMethod(name={"detect", "find"}, optional=1, frame=true)
    public static IRubyObject detect(final ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray2 = new IRubyObject[]{null};
        IRubyObject iRubyObject2 = null;
        if (iRubyObjectArray.length == 1) {
            iRubyObject2 = iRubyObjectArray[0];
        }
        try {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                    if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                        iRubyObjectArray2[0] = iRubyObjectArray[0];
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ruby.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            return iRubyObjectArray2[0];
        }
        return iRubyObject2 != null ? iRubyObject2.callMethod(threadContext, "call") : ruby.getNil();
    }

    @JRubyMethod(name={"select", "find_all"}, frame=true)
    public static IRubyObject select(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                    rubyArray.append(iRubyObjectArray[0]);
                }
                return ruby.getNil();
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public static IRubyObject reject(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                if (!block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                    rubyArray.append(iRubyObjectArray[0]);
                }
                return ruby.getNil();
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"collect", "map"}, frame=true)
    public static IRubyObject collect(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                    rubyArray.append(block.yield(threadContext, iRubyObjectArray[0]));
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"inject"}, optional=1, frame=true)
    public static IRubyObject inject(final ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray2 = new IRubyObject[]{null};
        if (iRubyObjectArray.length == 1) {
            iRubyObjectArray2[0] = iRubyObjectArray[0];
        }
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                iRubyObjectArray2[0] = iRubyObjectArray2[0] == null ? iRubyObjectArray[0] : block.yield(threadContext, ruby.newArray(iRubyObjectArray2[0], iRubyObjectArray[0]), null, null, true);
                return ruby.getNil();
            }
        });
        return iRubyObjectArray2[0] == null ? ruby.getNil() : iRubyObjectArray2[0];
    }

    @JRubyMethod(name={"partition"}, frame=true)
    public static IRubyObject partition(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        final RubyArray rubyArray2 = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block2) {
                if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                    rubyArray.append(iRubyObjectArray[0]);
                } else {
                    rubyArray2.append(iRubyObjectArray[0]);
                }
                return ruby.getNil();
            }
        });
        return ruby.newArray(rubyArray, rubyArray2);
    }

    @JRubyMethod(name={"each_with_index"}, frame=true)
    public static IRubyObject each_with_index(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        iRubyObject.callMethod(threadContext, "each", IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(iRubyObject, iRubyObject.getRuntime().getEnumerable(), Arity.noArguments(), new EachWithIndex(threadContext, block), threadContext));
        return iRubyObject;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1, frame=true)
    public static IRubyObject include_p(final ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject iRubyObject2) {
        final Ruby ruby = iRubyObject.getRuntime();
        try {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext2, IRubyObject[] iRubyObjectArray, Block block) {
                    if (RubyObject.equalInternal(threadContext, iRubyObject2, iRubyObjectArray[0]).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ruby.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"max"}, frame=true)
    public static IRubyObject max(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray = new IRubyObject[]{null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block2) {
                    if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, block.yield(threadContext, ruby.newArray(iRubyObjectArray2[0], iRubyObjectArray[0])), iRubyObjectArray2[0], iRubyObjectArray[0]) > 0) {
                        iRubyObjectArray[0] = iRubyObjectArray2[0];
                    }
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block) {
                    if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, iRubyObjectArray2[0].callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray[0]), iRubyObjectArray2[0], iRubyObjectArray[0]) > 0) {
                        iRubyObjectArray[0] = iRubyObjectArray2[0];
                    }
                    return ruby.getNil();
                }
            });
        }
        return iRubyObjectArray[0] == null ? ruby.getNil() : iRubyObjectArray[0];
    }

    @JRubyMethod(name={"min"}, frame=true)
    public static IRubyObject min(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray = new IRubyObject[]{null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block2) {
                    if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, block.yield(threadContext, ruby.newArray(iRubyObjectArray2[0], iRubyObjectArray[0])), iRubyObjectArray2[0], iRubyObjectArray[0]) < 0) {
                        iRubyObjectArray[0] = iRubyObjectArray2[0];
                    }
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block) {
                    if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, iRubyObjectArray2[0].callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray[0]), iRubyObjectArray2[0], iRubyObjectArray[0]) < 0) {
                        iRubyObjectArray[0] = iRubyObjectArray2[0];
                    }
                    return ruby.getNil();
                }
            });
        }
        return iRubyObjectArray[0] == null ? ruby.getNil() : iRubyObjectArray[0];
    }

    @JRubyMethod(name={"all?"}, frame=true)
    public static IRubyObject all_p(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                        if (!block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                        if (!iRubyObjectArray[0].isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump specialJump) {
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod(name={"any?"}, frame=true)
    public static IRubyObject any_p(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                        if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                        if (iRubyObjectArray[0].isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump specialJump) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"zip"}, rest=true, frame=true)
    public static IRubyObject zip(ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject[] iRubyObjectArray, final Block block) {
        int n;
        final Ruby ruby = iRubyObject.getRuntime();
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            iRubyObjectArray[n] = TypeConverter.convertToType(iRubyObjectArray[n], ruby.getArray(), MethodIndex.TO_A, "to_a");
        }
        n = iRubyObjectArray.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
                int ix = 0;

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block2) {
                    RubyArray rubyArray = ruby.newArray(n);
                    rubyArray.append(iRubyObjectArray2[0]);
                    int n2 = iRubyObjectArray.length;
                    for (int i = 0; i < n2; ++i) {
                        rubyArray.append(((RubyArray)iRubyObjectArray[i]).entry(this.ix));
                    }
                    block.yield(threadContext, rubyArray);
                    ++this.ix;
                    return ruby.getNil();
                }
            });
            return ruby.getNil();
        }
        final RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
            int ix = 0;

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block) {
                RubyArray rubyArray2 = ruby.newArray(n);
                rubyArray2.append(iRubyObjectArray2[0]);
                int n2 = iRubyObjectArray.length;
                for (int i = 0; i < n2; ++i) {
                    rubyArray2.append(((RubyArray)iRubyObjectArray[i]).entry(this.ix));
                }
                rubyArray.append(rubyArray2);
                ++this.ix;
                return ruby.getNil();
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"group_by"}, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject group_by(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyHash rubyHash = new RubyHash(ruby);
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                IRubyObject iRubyObject = block.yield(threadContext, iRubyObjectArray[0]);
                IRubyObject iRubyObject2 = rubyHash.fastARef(iRubyObject);
                if (iRubyObject2 == null) {
                    iRubyObject2 = ruby.newArray();
                    rubyHash.fastASet(iRubyObject, iRubyObject2);
                }
                iRubyObject2.callMethod(threadContext, MethodIndex.OP_LSHIFT, "<<", iRubyObjectArray[0]);
                return ruby.getNil();
            }
        });
        return rubyHash;
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private Ruby runtime;
        private RubyArray result;

        public AppendBlockCallback(Ruby ruby, RubyArray rubyArray) {
            this.runtime = ruby;
            this.result = rubyArray;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            this.result.append(iRubyObjectArray[0]);
            return this.runtime.getNil();
        }
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext threadContext, Block block) {
            this.block = block;
            this.runtime = threadContext.getRuntime();
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            this.block.yield(threadContext, this.runtime.newArray(iRubyObjectArray[0], this.runtime.newFixnum(this.index++)));
            return this.runtime.getNil();
        }
    }
}

