/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.collections.WeakHashSet;

public class RubyClass
extends RubyModule {
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyClass rubyClass2 = new RubyClass(ruby);
            rubyClass2.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return rubyClass2;
        }
    };
    private final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby ruby, Object object, RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
            IRubyObject iRubyObject = (IRubyObject)object;
            marshalStream.registerLinkTarget(iRubyObject);
            marshalStream.dumpVariables(iRubyObject.getVariableList());
        }

        public Object unmarshalFrom(Ruby ruby, RubyClass rubyClass, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject iRubyObject = rubyClass.allocate();
            unmarshalStream.registerLinkTarget(iRubyObject);
            unmarshalStream.defaultVariablesUnmarshal(iRubyObject);
            return iRubyObject;
        }
    };

    public static void createClassClass(Ruby ruby, RubyClass rubyClass) {
        rubyClass.index = 13;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyClass;
            }
        };
        rubyClass.undefineMethod("module_function");
        rubyClass.undefineMethod("append_features");
        rubyClass.undefineMethod("extend_object");
        rubyClass.defineAnnotatedMethods(RubyClass.class);
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator objectAllocator) {
        this.allocator = objectAllocator;
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject iRubyObject = this.allocator.allocate(this.runtime, this);
        if (iRubyObject.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return iRubyObject;
    }

    public int getNativeTypeIndex() {
        return 13;
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby ruby, String string, RubyClass rubyClass, ObjectAllocator objectAllocator) {
        RubyClass rubyClass2;
        if (rubyClass == null) {
            rubyClass2 = new RubyClass(ruby);
            rubyClass2.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            rubyClass2 = new RubyClass(ruby, rubyClass);
        }
        rubyClass2.setAllocator(objectAllocator);
        rubyClass2.setBaseName(string);
        return rubyClass2;
    }

    protected RubyClass(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, ruby.getClassClass(), bl);
        this.runtime = ruby;
        this.superClass = rubyClass;
    }

    protected RubyClass(Ruby ruby) {
        super(ruby, ruby.getClassClass());
        this.runtime = ruby;
        this.index = 13;
    }

    protected RubyClass(Ruby ruby, RubyClass rubyClass) {
        this(ruby);
        this.superClass = rubyClass;
        this.marshal = rubyClass.marshal;
        rubyClass.addSubclass(this);
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass) {
        if (rubyClass == ruby.getClassClass()) {
            throw ruby.newTypeError("can't make subclass of Class");
        }
        if (rubyClass.isSingleton()) {
            throw ruby.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(ruby, rubyClass);
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass, String string, ObjectAllocator objectAllocator, RubyModule rubyModule, boolean bl) {
        RubyClass rubyClass2 = RubyClass.newClass(ruby, rubyClass);
        rubyClass2.setBaseName(string);
        rubyClass2.setAllocator(objectAllocator);
        rubyClass2.makeMetaClass(rubyClass.getMetaClass());
        if (bl) {
            rubyClass2.setParent(rubyModule);
        }
        rubyModule.setConstant(string, rubyClass2);
        rubyClass2.inherit(rubyClass);
        return rubyClass2;
    }

    public RubyClass makeMetaClass(RubyClass rubyClass) {
        if (this.isSingleton()) {
            MetaClass metaClass = new MetaClass(this.getRuntime(), rubyClass);
            this.setMetaClass(metaClass);
            metaClass.setAttached(this);
            metaClass.setMetaClass(metaClass);
            metaClass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return metaClass;
        }
        return super.makeMetaClass(rubyClass);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, int n, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        if (threadContext.getRuntime().hasEventHooks()) {
            return this.invoke(threadContext, iRubyObject, string, iRubyObjectArray, callType, block);
        }
        return this.dispatcher.callMethod(threadContext, iRubyObject, this, n, string, iRubyObjectArray, callType, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        assert (iRubyObjectArray != null);
        DynamicMethod dynamicMethod = null;
        dynamicMethod = this.searchMethod(string);
        if (dynamicMethod.isUndefined() || !string.equals("method_missing") && !dynamicMethod.isCallableFrom(threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, threadContext.getFrameSelf(), callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObjectArray, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        DynamicMethod dynamicMethod = null;
        dynamicMethod = this.searchMethod(string);
        if (dynamicMethod.isUndefined() || !string.equals("method_missing") && !dynamicMethod.isCallableFrom(threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, new IRubyObject[]{iRubyObject2}, threadContext.getFrameSelf(), callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, block);
    }

    public IRubyObject invokeInherited(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = "inherited";
        DynamicMethod dynamicMethod = this.getMetaClass().searchMethod(string);
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{iRubyObject2};
        if (dynamicMethod.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this.getMetaClass(), string, iRubyObjectArray, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true)
    public IRubyObject newInstance(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject = this.allocate();
        iRubyObject.callMethod(threadContext, "initialize", iRubyObjectArray, block);
        return iRubyObject;
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        if (this.superClass != null) {
            System.out.println(this.classId);
            throw this.getRuntime().newTypeError("already initialized class");
        }
        if (iRubyObjectArray.length == 0) {
            iRubyObject = this.getRuntime().getObject();
        } else {
            iRubyObject = iRubyObjectArray[0];
            RubyClass.checkInheritable(iRubyObject);
        }
        IRubyObject iRubyObject2 = iRubyObject;
        this.superClass = iRubyObject2;
        this.allocator = ((RubyClass)iRubyObject2).allocator;
        this.makeMetaClass(((RubyObject)iRubyObject2).getMetaClass());
        this.marshal = ((RubyClass)iRubyObject2).marshal;
        ((RubyClass)iRubyObject2).addSubclass(this);
        super.initialize(block);
        this.inherit((RubyClass)iRubyObject2);
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this.superClass != null) {
            throw this.runtime.newTypeError("already initialized class");
        }
        if (iRubyObject instanceof MetaClass) {
            throw this.getRuntime().newTypeError("can't copy singleton class");
        }
        super.initialize_copy(iRubyObject);
        this.allocator = ((RubyClass)iRubyObject).allocator;
        return this;
    }

    public IRubyObject subclasses(IRubyObject[] iRubyObjectArray) {
        boolean bl = false;
        if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyBoolean) {
                bl = iRubyObjectArray[0].isTrue();
            } else {
                this.getRuntime().newTypeError(iRubyObjectArray[0], this.getRuntime().fastGetClass("Boolean"));
            }
        }
        return RubyArray.newArray(this.getRuntime(), this.subclasses(bl)).freeze();
    }

    public Collection subclasses(boolean bl) {
        if (this.subclasses != null) {
            ArrayList<RubyClass> arrayList = new ArrayList<RubyClass>(this.subclasses);
            if (bl) {
                for (RubyClass rubyClass : this.subclasses) {
                    arrayList.addAll(rubyClass.subclasses(bl));
                }
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void addSubclass(RubyClass rubyClass) {
        if (this.subclasses == null) {
            this.subclasses = new WeakHashSet<RubyClass>();
        }
        this.subclasses.add(rubyClass);
    }

    public Ruby getClassRuntime() {
        return this.runtime;
    }

    public RubyClass getRealClass() {
        return this;
    }

    @JRubyMethod(name={"inherited"}, required=1)
    public IRubyObject inherited(IRubyObject iRubyObject) {
        return this.getRuntime().getNil();
    }

    public void inherit(RubyClass rubyClass) {
        if (rubyClass == null) {
            rubyClass = this.getRuntime().getObject();
        }
        rubyClass.invokeInherited(this.getRuntime().getCurrentContext(), rubyClass, this);
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass() {
        RubyClass rubyClass = this.superClass;
        if (rubyClass == null) {
            throw this.runtime.newTypeError("uninitialized class");
        }
        if (this.isSingleton()) {
            rubyClass = this.metaClass;
        }
        while (rubyClass != null && rubyClass.isIncluded()) {
            rubyClass = rubyClass.superClass;
        }
        return rubyClass != null ? rubyClass : this.getRuntime().getNil();
    }

    public static void checkInheritable(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyClass)) {
            throw iRubyObject.getRuntime().newTypeError("superclass must be a Class (" + iRubyObject.getMetaClass() + " given)");
        }
        if (((RubyClass)iRubyObject).isSingleton()) {
            throw iRubyObject.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal objectMarshal) {
        this.marshal = objectMarshal;
    }

    public final void marshal(Object object, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.getRuntime(), object, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.getRuntime(), this, unmarshalStream);
    }

    public static void marshalTo(RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyClass);
        marshalStream.writeString(MarshalStream.getPathFromClass(rubyClass));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        String string = RubyString.byteListToString(unmarshalStream.unmarshalString());
        RubyClass rubyClass = UnmarshalStream.getClassFromPath(unmarshalStream.getRuntime(), string);
        unmarshalStream.registerLinkTarget(rubyClass);
        return rubyClass;
    }
}

