/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile {
    public static void setCurrentLineNumber(IRubyObject iRubyObject, int n) {
        ArgsFileData.getDataFrom((IRubyObject)iRubyObject).currentLineNumber = n;
    }

    public static void initArgsFile(Ruby ruby) {
        RubyObject rubyObject = new RubyObject(ruby, ruby.getObject());
        ruby.getEnumerable().extend_object(rubyObject);
        ruby.defineReadonlyVariable("$<", rubyObject);
        ruby.defineGlobalConstant("ARGF", rubyObject);
        RubyClass rubyClass = rubyObject.getMetaClass();
        rubyClass.defineAnnotatedMethods(RubyArgsFile.class);
        ruby.defineReadonlyVariable("$FILENAME", ruby.newString("-"));
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (!argsFileData.startedProcessing && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)argsFileData.currentFile).fileno();
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (!argsFileData.startedProcessing && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream");
        }
        return argsFileData.currentFile;
    }

    public static IRubyObject internalGets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            return iRubyObject.getRuntime().getNil();
        }
        IRubyObject iRubyObject2 = argsFileData.currentFile.callMethod(threadContext, "gets", iRubyObjectArray);
        while (iRubyObject2 instanceof RubyNil) {
            argsFileData.currentFile.callMethod(threadContext, "close");
            if (!argsFileData.nextArgsFile(threadContext)) {
                argsFileData.currentFile = null;
                return iRubyObject2;
            }
            iRubyObject2 = argsFileData.currentFile.callMethod(threadContext, "gets", iRubyObjectArray);
        }
        ++argsFileData.currentLineNumber;
        iRubyObject.getRuntime().getGlobalVariables().set("$.", iRubyObject.getRuntime().newFixnum(argsFileData.currentLineNumber));
        return iRubyObject2;
    }

    @JRubyMethod(name={"gets"}, optional=1, frame=true)
    public static IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = RubyArgsFile.internalGets(threadContext, iRubyObject, iRubyObjectArray);
        if (!iRubyObject2.isNil()) {
            threadContext.getCurrentFrame().setLastLine(iRubyObject2);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"readline"}, optional=1, frame=true)
    public static IRubyObject readline(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = RubyArgsFile.gets(threadContext, iRubyObject, iRubyObjectArray);
        if (iRubyObject2.isNil()) {
            throw iRubyObject.getRuntime().newEOFError();
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"readlines"}, optional=1, frame=true)
    public static RubyArray readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2;
        IRubyObject[] iRubyObjectArray2;
        if (iRubyObjectArray.length > 0) {
            if (!iRubyObject.getRuntime().getNilClass().isInstance(iRubyObjectArray[0]) && !iRubyObject.getRuntime().getString().isInstance(iRubyObjectArray[0])) {
                throw iRubyObject.getRuntime().newTypeError(iRubyObjectArray[0], iRubyObject.getRuntime().getString());
            }
            iRubyObjectArray2 = new IRubyObject[]{iRubyObjectArray[0]};
        } else {
            iRubyObjectArray2 = IRubyObject.NULL_ARRAY;
        }
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        while (!(iRubyObject2 = RubyArgsFile.internalGets(threadContext, iRubyObject, iRubyObjectArray2)).isNil()) {
            rubyArray.append(iRubyObject2);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public static IRubyObject each_byte(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2;
        while (!(iRubyObject2 = RubyArgsFile.getc(threadContext, iRubyObject)).isNil()) {
            block.yield(threadContext, iRubyObject2);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"each_line"}, alias={"each"}, optional=1, frame=true)
    public static IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2 = RubyArgsFile.internalGets(threadContext, iRubyObject, iRubyObjectArray);
        while (!iRubyObject2.isNil()) {
            block.yield(threadContext, iRubyObject2);
            iRubyObject2 = RubyArgsFile.internalGets(threadContext, iRubyObject, iRubyObjectArray);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            return iRubyObject.getRuntime().getNil();
        }
        return argsFileData.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        argsFileData.currentFile = null;
        return iRubyObject;
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            return iRubyObject;
        }
        argsFileData.currentFile = null;
        argsFileData.currentLineNumber = 0;
        return iRubyObject;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            return iRubyObject;
        }
        return ((RubyIO)argsFileData.currentFile).closed_p();
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)argsFileData.currentFile).binmode();
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(ArgsFileData.getDataFrom((IRubyObject)iRubyObject).currentLineNumber);
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)argsFileData.currentFile).pos();
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream to rewind");
        }
        return ((RubyIO)argsFileData.currentFile).rewind();
    }

    @JRubyMethod(name={"eof", "eof?"})
    public static IRubyObject eof(ThreadContext threadContext, IRubyObject iRubyObject) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile != null && !argsFileData.nextArgsFile(threadContext)) {
            return iRubyObject.getRuntime().getTrue();
        }
        return ((RubyIO)argsFileData.currentFile).eof_p();
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream to set position");
        }
        return ((RubyIO)argsFileData.currentFile).pos_set(iRubyObject2);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
            throw iRubyObject.getRuntime().newArgumentError("no stream to seek");
        }
        return ((RubyIO)argsFileData.currentFile).seek(iRubyObjectArray);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public static IRubyObject set_lineno(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        argsFileData.currentLineNumber = RubyNumeric.fix2int(iRubyObject2);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = RubyArgsFile.getc(threadContext, iRubyObject);
        if (iRubyObject2.isNil()) {
            throw iRubyObject.getRuntime().newEOFError();
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        while (true) {
            if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
                return iRubyObject.getRuntime().getNil();
            }
            iRubyObject2 = !(argsFileData.currentFile instanceof RubyFile) ? argsFileData.currentFile.callMethod(threadContext, "getc") : ((RubyIO)argsFileData.currentFile).getc();
            if (!iRubyObject2.isNil()) break;
            argsFileData.currentFile = null;
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2;
        IRubyObject iRubyObject3;
        ArgsFileData argsFileData = ArgsFileData.getDataFrom(iRubyObject);
        long l = 0L;
        if (iRubyObjectArray.length > 0) {
            iRubyObject3 = iRubyObjectArray[0];
            iRubyObject2 = iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : iRubyObject.getRuntime().getNil();
        } else {
            iRubyObject3 = iRubyObject.getRuntime().getNil();
            iRubyObject2 = iRubyObject.getRuntime().getNil();
        }
        if (!iRubyObject3.isNil()) {
            l = RubyNumeric.num2long(iRubyObject3);
        }
        if (!iRubyObject2.isNil()) {
            iRubyObject2 = iRubyObject2.convertToString();
            ((RubyString)iRubyObject2).modify();
            ((RubyString)iRubyObject2).getByteList().length(0);
            iRubyObjectArray[1] = iRubyObject.getRuntime().getNil();
        }
        while (true) {
            if (argsFileData.currentFile == null && !argsFileData.nextArgsFile(threadContext)) {
                return iRubyObject2;
            }
            IRubyObject iRubyObject4 = !(argsFileData.currentFile instanceof RubyIO) ? argsFileData.currentFile.callMethod(threadContext, "read", iRubyObjectArray) : ((RubyIO)argsFileData.currentFile).read(iRubyObjectArray);
            if (iRubyObject2.isNil()) {
                iRubyObject2 = iRubyObject4;
            } else if (!iRubyObject4.isNil()) {
                ((RubyString)iRubyObject2).append(iRubyObject4);
            }
            if (iRubyObject4.isNil() || iRubyObject3.isNil()) {
                argsFileData.currentFile = null;
                continue;
            }
            if (iRubyObjectArray.length < 1 || (long)((RubyString)iRubyObject2).getByteList().length() >= l) break;
            iRubyObjectArray[0] = iRubyObject.getRuntime().newFixnum(l -= (long)((RubyString)iRubyObject2).getByteList().length());
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static RubyString filename(IRubyObject iRubyObject) {
        return (RubyString)iRubyObject.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newString("ARGF");
    }

    private static final class ArgsFileData {
        private Ruby runtime;
        public IRubyObject currentFile;
        public int currentLineNumber;
        public boolean startedProcessing = false;
        public boolean finishedProcessing = false;

        public ArgsFileData(Ruby ruby) {
            this.runtime = ruby;
        }

        public boolean nextArgsFile(ThreadContext threadContext) {
            if (this.finishedProcessing) {
                return false;
            }
            RubyArray rubyArray = (RubyArray)this.runtime.getGlobalVariables().get("$*");
            if (rubyArray.getLength() == 0) {
                if (!this.startedProcessing) {
                    this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                    ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                    this.currentLineNumber = 0;
                    this.startedProcessing = true;
                    return true;
                }
                this.finishedProcessing = true;
                return false;
            }
            String string = rubyArray.shift().toString();
            ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(string));
            this.currentFile = string.equals("-") ? this.runtime.getGlobalVariables().get("$stdin") : RubyFile.open(threadContext, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(string)}, Block.NULL_BLOCK);
            this.startedProcessing = true;
            return true;
        }

        public static ArgsFileData getDataFrom(IRubyObject iRubyObject) {
            ArgsFileData argsFileData = (ArgsFileData)iRubyObject.dataGetStruct();
            if (argsFileData == null) {
                argsFileData = new ArgsFileData(iRubyObject.getRuntime());
                iRubyObject.dataWrapStruct(argsFileData);
            }
            return argsFileData;
        }
    }
}

